<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/intervention_alerts/class/intervention_alerts.class.php');
dol_include_once('/btp/material/intervention_systematic/class/intervention_systematic.class.php');
dol_include_once('/btp/material/machine/class/machine.class.php');
dol_include_once('/btp/lib/machine.lib.php');

$form 		= new Form($db);
$intervention_alerts   = new intervention_alerts($db);
$intervention_systematic     = new intervention_systematic($db);
$machine     = new machine($db);
$procedures  = array('1' => 'procedure 1', '2' => 'procedure 2' );

$var = false;
$filter = '';
$td_travaux =  array(1 => 'Travaux 1', 2 => 'Travaux 2' );
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$id 	  = GETPOST('id','int');
$iid 	  = GETPOST('iid', 'int');
$search_time_elapsed      		= GETPOST('search_time_elapsed');
$search_inter_syst      		= GETPOST('search_inter_syst');
$search_kmh_made    		= GETPOST('search_kmh_made');
$search_decision    		= GETPOST('search_decision');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_time_elapsed      		= '';
$search_date_start      		= '';
$search_kmh_made    		= '';
$search_decision    		= '';
}
$filter .= (!empty($search_time_elapsed) && $search_time_elapsed != -1) ? " AND time_elapsed = ". $db->escape($search_time_elapsed): "";
$filter .= " AND inter_syst_id = ".$iid;
$filter .= (!empty($search_kmh_made) && $search_kmh_made != -1) ? " AND kmh_made = ".$db->escape($search_kmh_made):"";
$filter .= (!empty($search_decision) && $search_decision != -1) ? " AND decision = '".$db->escape($search_decision)."'\n" : "";


$getintervention_alertss = $intervention_alerts->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getintervention_alertss == '-1') {
    print_fiche_titre($langs->trans('ListOfintervention_alerts'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$intervention_alerts->error);
    exit();
}
if ($id > 0) {
	$intervention_alerts->fetch($id);
	llxHeader('', $langs->trans('intervention_alerts'));
		print_fiche_titre($langs->trans("intervention_alerts"));
	$intervention_systematic->fetch($iid);
	$machine->fetch($intervention_systematic->machine_id);
	$head  		= material_prepare_head($machine);
	dol_fiche_head($head, 'intervention_systematic', $langs->trans('intervention_systematic'), 0, '');
	//print_fiche_titre($langs->trans("intervention"));

	$intervent  = intervention_sys_prepare_head($intervention_systematic);

	dol_fiche_head($intervent, 'intervention_alerts', $langs->trans("intervention_alerts"), 0, '');


	print '<table class="border" width="100%">';
		// time_elapsed
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("time_elapsed").'</td>';
	print '<td colspan="2">'. $intervention_alerts->time_elapsed .'</td></tr>';
	// engin
	/*print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("intervention_systematic").'</td>';
	$intervention_systematic->fetch($intervention_alerts->inter_syst_id);
	print '<td colspan="2">'. $intervention_systematic->getNomUrl(1) .'</td></tr>';*/
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("decision").'</td>';
	print '<td colspan="2">'. $intervention_alerts->decision.'</td></tr>';
	// chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("kmh_made").'</td>';
	print '<td colspan="2">'. $intervention_alerts->kmh_made .'</td></tr>';
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?iid='. $iid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&iid='.$iid.'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'&iid='.$iid.'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';
	print '</div>';
	if ($action == 'delete') {
           print $form->formconfirm("card.php?id=".$id."&iid=".$iid, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
        }
}
else {

 // Both test are required to be compatible with all browsers

llxHeader('', $langs->trans('intervention_alerts'));
//print_fiche_titre($langs->trans("ListOfintervention_alerts"));
	$intervention_systematic->fetch($iid);
	$machine->fetch($intervention_systematic->machine_id);
	$head = material_prepare_head($machine);
	dol_fiche_head($head, 'intervention_systematic', $langs->trans('intervention_systematic'), 0, '');
	//print_fiche_titre($langs->trans("intervention"));

	$intervent  = intervention_sys_prepare_head($intervention_systematic);

	dol_fiche_head($intervent, 'intervention_alerts', $langs->trans("ListOfintervention_alerts"), 0, '');
	$moreparam = '&iid='.$iid;
   	
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<input name="iid" value="'. $iid .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("ref"),$_SERVER["PHP_SELF"],"rowid", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("time_elapsed"),$_SERVER["PHP_SELF"],"time_elapsed", '',$moreparam,'align="center"',$sortfield,$sortorder);
	//print_liste_field_titre($langs->trans("intervention_systematic"),$_SERVER["PHP_SELF"],"inter_syst_id", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("kmh_made"), $_SERVER["PHP_SELF"], 'kmh_made', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("decision"), $_SERVER["PHP_SELF"], 'decision', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';

	// id
	print '<td class="liste_titre" colspan="1" align="center">';
	print '</td>';
	// time_elapsed
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="number" min="0" size="14" name="search_time_elapsed" value="'.$search_time_elapsed.'">';
	print '</td>';

	// type
	/*print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_inter_syst', $intervention_systematic->getMats(), $search_inter_syst, 1, 0, 0, 'required="required"');
	print '</td>';*/

	// kmh_made
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="number" min="0" size="14" name="search_kmh_made" value="'.$search_kmh_made.'">';
	print '</td>';

	// decision
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" name="search_decision" value="'.$search_decision.'">';
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($intervention_alerts->rows)) {
		//$createdBy = new User($db);
		foreach($intervention_alerts->rows as $obj) {
			  $time_elapsed 				= $obj->time_elapsed ;
			 // $intervention_systematic->fetch($obj->inter_syst_id) ;
			  $kmh_made         			= $obj->kmh_made ;
			  $decision         			= $obj->decision ;
			  
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $intervention_alerts->getNomUrl(1,  $obj->id,$iid, $obj->id);
			print '</td>';
			 
			print '<td align="center">'. $time_elapsed .'</td>';
			//print '<td align="center">'. $intervention_systematic->getNomUrl(1) .'</td>';
			print '<td align="center">'. $kmh_made .'</td>';
			print '<td align="center">'. $decision .'</td>';
			
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&iid='.$iid.'" class="butAction">'.$langs->trans('Addintervention_alerts').'</a>';
		print '</div>';


}

llxFooter();

$db->close();


?>