<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/defects/class/Defects.class.php');
dol_include_once('/btp/material/defect_machine/class/defect_machine.class.php');
dol_include_once('/btp/material/machine/class/machine.class.php');
dol_include_once('/btp/lib/machine.lib.php');

$form 		= new Form($db);
$defect 	  = new Defects($db);
$defect_machine 	  = new defect_machine($db);
$machine 	  = new machine($db);
$var = false;
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "";
$search_ref      			= GETPOST('search_ref');
$search_nom      	= GETPOST('search_nom');
$action  = GETPOST('action', 'alpha');
$id 	  = GETPOST('id','int');
$did 	  = GETPOST('did','int');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref      			= "";
	$search_nom      	= "";
}
//llxHeader(array(), $langs->trans('list_defect'),'','','','',$morejs,$morecss,0,0);
$filter='';
$filter .= (!empty($search_ref) && $search_ref != -1) ? " and  rowid = ". $db->escape((int)$search_ref) ."\n" : "";
$filter .= (!empty($search_nom) && $search_nom != -1) ? " AND name = '".$db->escape($search_nom)."'\n" : "";
$defect->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter, $id);
if ($id > 0) {
	//$event->fetch($id);
	llxHeader('', $langs->trans('list_defect'));
	print_fiche_titre($langs->trans("defects"));
	//dol_fiche_head('', 'events', $langs->trans("event"), 0, '');
	$defect_machine->fetch($did);
	$machine->fetch($defect_machine->machine_id);
	$head  		= material_prepare_head($machine);
	dol_fiche_head($head, 'defect_machine', $langs->trans('defect_machine'), 0, '');
	$defects  = defect_prepare_head($defect_machine);
	dol_fiche_head($defects, 'defects', $langs->trans("defects"), 0, '');

	$defect->fetch($id);

	
	print '<table class="border" width="100%">';
	// Ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Refe").'</td>';
	print '<td colspan="2">'. $defect->rowid .'</td></tr>';
	//Nom
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Name").'</td>';
	print '<td colspan="2">'. $defect->name .'</td></tr>';
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?did='. $did .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&did='.$did.'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'&did='.$did.'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';
	print '</div>';


 if ($action == 'delete') {
                        print $form->formconfirm("card.php?id=".$id."&did=".$did, $langs->trans("TitleDeleteT"),$langs->trans("ConfirmDeleteT"),"confirm_delete", '', 0, 1);

                }

	
}
else {

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref      			= "";
	$search_nom      	= "";
	
}

llxHeader('', $langs->trans('list_defect'));
//$listevents = $event->findAll();
	//dol_fiche_head($defect, 'defects', $langs->trans("list_defect"), 0, '');
	$defect_machine->fetch($did);
	$machine->fetch($defect_machine->machine_id);
	$head  		= material_prepare_head($machine);
	dol_fiche_head($head, 'defect_machine', $langs->trans('defect_machine'), 0, '');
	$defects  = defect_prepare_head($defect_machine);
	dol_fiche_head($defects, 'defects', $langs->trans("defects"), 0, '');
	$moreparam = '&did='.$did;
	
	$card="card.php";

	print '<form method="GET" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Refe"),$_SERVER["PHP_SELF"], "rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Name"),$_SERVER["PHP_SELF"],"name", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('', $_SERVER["PHP_SELF"], '', $moreparam, '', 'align="center"', $sortfield, $sortorder);
	print "</tr>\n";
	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';
	// name
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_nom" value="'.$search_nom.'">';
	print '</td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";
	// Lines
	if (count($defect->rows)) {
		foreach($defect->rows as $line) {
			$var = !$var;
			$rowid 				= $line->rowid;
			$name 		        = $line->name;
			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
				print $defect->getNomUrl(1,  $line->rowid,$did, $line->rowid);
			print '</td>';
			print '<td align="center">'. $name .'</td>';
			
			print '</tr>'."\n";
		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}
	    print '</table>';
	    print '</form>';
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&did='.$did.'" class="butAction">'.$langs->trans('ajoutdefect').'</a>';
		print '</div>';
}	

llxFooter();
$db->close();
?>
