<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/const_diposals_affect/class/const_diposals_affect.class.php');
dol_include_once('/btp/material/const_site_diposals/class/const_site_diposals.class.php');
dol_include_once('/btp/settings/unit_type/class/unitType.class.php');
include_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

$produit   = new product($db);
// Get parameters
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$now       = $now->format('Y-m-d');
$form       = new Form($db);
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$const_diposals_affect = new const_diposals_affect($db);

    if (!$error) {
          $const_diposals_affect->ref            = trim(GETPOST('ref_'));
          $const_diposals_affect->designation            = trim(GETPOST('designation_'));
          $const_diposals_affect->qty            = trim(GETPOST('qty_'));
          $const_diposals_affect->price            = trim(GETPOST('price_'));
          $const_diposals_affect->product_id   = trim(GETPOST('product_id_'));
          $const_diposals_affect->unit_type_id     = trim(GETPOST('unit_type_id_'));
          $const_diposals_affect->const_disposal_id  = trim(GETPOST('const_disposal_id_'));
          $const_diposals_affect->created_by     = $user->id;
            //if(!$const_diposals_affect->check_mat($const_diposals_affect->mat)){
                    $const_diposals_affectID = $const_diposals_affect->create();
            
                    // If no SQL error we redirect to the request card
                    if ($const_diposals_affectID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php');
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$const_diposals_affect->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$const_diposals_affect->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->btp->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $const_diposals_affect_id = (int) GETPOST('const_diposals_affect_id', 'int');

    if (!$const_diposals_affect_id || $const_diposals_affect_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $const_diposals_affect = new const_diposals_affect($db);
    $const_diposals_affect->fetch($const_diposals_affect_id);

   // $canedit = ($user->rights->btp->write || $user->rights->btp->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        $designation = '';
        $data = array(
          'designation'  =>trim(GETPOST('designation_')),
          'ref'    =>trim(GETPOST('ref_')),
          'qty'  =>trim(GETPOST('qty_')),
          'price'  =>trim(GETPOST('price_')),
          'product_id' =>trim(GETPOST('product_id_')),
          'unit_type_id' =>trim(GETPOST('unit_type_id_')),
          'const_disposal_id'  =>trim(GETPOST('const_disposal_id_')),
          'updated_at'    =>$now
        );

		$getconst_diposals_affectID = $const_diposals_affect->update($const_diposals_affect_id, $data);
        
                if ($getconst_diposals_affectID > 0) {
                    header('Location: ./index.php?id='.$const_diposals_affect_id);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $const_diposals_affect_id .'&action=edit&error=SQL_Create&msg='.$const_diposals_affect->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();

	$event  = new const_diposals_affect($db);
	//$canedit = ($user->rights->btp->write_all || $user->rights->btp->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php');
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$const_diposals_affect     = new const_diposals_affect($db);
$const_site_diposals     = new const_site_diposals($db);
$unit_type     = new UnitType($db);

$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('const_diposals_affect'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addconst_diposals_affect'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

         //réference
        print '<tr><td class="fieldrequired">'.$langs->trans("ref").'</td><td>';
        print '<input type="text" value="" name="ref_" required="required" />';
        print '</td></tr>';

        //designation
        print '<tr><td class="fieldrequired">'.$langs->trans("designation").'</td><td>';
        print '<input type="text" name="designation_" required="required" /> ';
        print '</td></tr>';

        //produit
        print '<tr><td>'.$langs->trans("product").'</td><td>'; 
        print $form->select_produits_list(null,'product_id_', 0, 30, 0, '', 0, -1);//finished=2
        print '</td></tr>';
       
        //unité 
        print '<tr><td>'.$langs->trans("unit_type").'</td><td>'; 
        $mark_const_diposals_affects = $unit_type->getNames();
        print $form->selectarray('unit_type_id_', $mark_const_diposals_affects,(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';


        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" min="0" value="" name="qty_" required="required" />';
        print '</td></tr>';

        //prix  
        print '<tr><td class="fieldrequired">'.$langs->trans("price").'</td><td>';
        print '<input type="number" value="" step="0.01" min="0" name="price_" required="required" />';
        print '</td></tr>';


        //Chantier arrengement 
        print '<tr><td>'.$langs->trans("const_site_diposals").'</td><td>'; 
        $const_sites = $const_site_diposals->getNames();
        print $form->selectarray('const_disposal_id_', $const_sites,(GETPOST('const_disposal_id_') ? GETPOST('const_disposal_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        
        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createconst_diposals_affect") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $const_diposals_affect->fetch($id);

			//$canedit = ($user->rights->btp->delete || $user->rights->btp->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEnddesignationP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {
                if ($action == 'delete') {
                    $const_diposals_affect->fetch($id);
    print_fiche_titre($langs->trans("const_diposals_affect"));

print '<table class="border" width="100%">';
    // ref
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ref").'</td>';
    print '<td colspan="2">'. $const_diposals_affect->ref .'</td></tr>';
    // date
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("designation").'</td>';
    print '<td colspan="2">'. $const_diposals_affect->designation .'</td></tr>';
    // quantité
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("qty").'</td>';
    print '<td colspan="2">'. $const_diposals_affect->qty .'</td></tr>';
    // prix
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("price").'</td>';
    print '<td colspan="2">'. $const_diposals_affect->price .'</td></tr>';
    // lubricant
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("product").'</td>';
    $produit->fetch($const_diposals_affect->product_id);
    print '<td colspan="2">'. $produit->getNomUrl(1) .'</td></tr>';
    // unité
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("unit_type").'</td>';
    $unit_type->fetch($const_diposals_affect->unit_type_id);
    print '<td colspan="2">'. $unit_type->getNomUrl(1) .'</td></tr>';
    //chantier
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("const_site_diposals").'</td>';
    $const_site_diposals->fetch($const_diposals_affect->const_disposal_id);
    print '<td colspan="2">'. $const_site_diposals->getNomUrl(1) .'</td></tr>';
    
    print '</table>';
                        print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'const_diposals_affects', $langs->trans("const_diposals_affect"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="const_diposals_affect_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';

        //réference
        print '<tr><td class="fieldrequired">'.$langs->trans("ref").'</td><td>';
        print '<input type="text" value="'.$const_diposals_affect->ref.'" name="ref_" required="required" />';
        print '</td></tr>';


        //designation
        print '<tr><td class="fieldrequired">'.$langs->trans("designation").'</td><td>';
        print '<input type="text" value="'.$const_diposals_affect->designation.'" name="designation_" required="required" /> ';
        print '</td></tr>';
            

        //produit
        print '<tr><td>'.$langs->trans("product").'</td><td>'; 
        print $form->select_produits_list($const_diposals_affect->product_id,'product_id_', 0, 30, 0, '', 0, -1);//finished=2
        print '</td></tr>';

        //Engin 
        print '<tr><td>'.$langs->trans("unit_type").'</td><td>'; 
        $mark_const_diposals_affects = $unit_type->getNames();
        print $form->selectarray('unit_type_id_', $mark_const_diposals_affects,(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : $const_diposals_affect->unit_type_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" min="0" value="'.$const_diposals_affect->qty.'" name="qty_" required="required" />';
        print '</td></tr>';

        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("price").'</td><td>';
        print '<input type="number" step="0.01" min="0" value="'.$const_diposals_affect->price.'" name="price_" required="required" />';
        print '</td></tr>';


        //Chantier arrengement
        print '<tr><td>'.$langs->trans("const_site_diposals").'</td><td>'; 
        $const_sites =  $const_site_diposals->getNames();
        print $form->selectarray('const_disposal_id_', $const_sites,(GETPOST('const_disposal_id_') ? GETPOST('const_disposal_id_') : $const_diposals_affect->const_disposal_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

       


                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->btp->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>