<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/amortization/class/amortization.class.php');
dol_include_once('/btp/material/machine/class/machine.class.php');
require_once DOL_DOCUMENT_ROOT.'/societe/class/societe.class.php';
dol_include_once('/btp/lib/machine.lib.php');

$societe     = new Societe($db);
// Get parameters
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$mid      = GETPOST('mid', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$now       = $now->format('Y-m-d');
$form       = new Form($db);
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$amortization = new amortization($db);

    if (!$error) {
        if (isset($_POST['date_start_']) && !empty($_POST['date_start_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['date_start_']);
            $amortization->date_start         = $ety.'-'.$etm.'-'.$etd ;
        }
          $amortization->amount            = trim(GETPOST('amount_'));
          $amortization->duration            = trim(GETPOST('duration_'));
          $amortization->machine_id            = (int)$mid;
          $amortization->tva     = trim(GETPOST('tva_'));
          $amortization->supplier_id  = trim(GETPOST('supplier_id_'));
          $amortization->created_by     = $user->id;
            //if(!$amortization->check_mat($amortization->mat)){
                    $amortizationID = $amortization->create();
            
                    // If no SQL error we redirect to the request card
                    if ($amortizationID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php?mid='.$mid);
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$amortization->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$amortization->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->btp->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $amortization_id = (int) GETPOST('amortization_id', 'int');

    if (!$amortization_id || $amortization_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $amortization = new amortization($db);
    $amortization->fetch($amortization_id);

   // $canedit = ($user->rights->btp->write || $user->rights->btp->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        $date_start = '';
        if (isset($_POST['date_start_']) && !empty($_POST['date_start_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['date_start_']);
            $date_start         = $ety.'-'.$etm.'-'.$etd ;
        }
        $data = array(
          'date_start'  =>$date_start,
          'amount'    =>trim(GETPOST('amount_')),
          'duration'    =>trim(GETPOST('duration_')),
          'machine_id'    =>(int)$mid,
          'tva' =>trim(GETPOST('tva_')),
          'supplier_id'  =>trim(GETPOST('supplier_id_'))
        );

		$getamortizationID = $amortization->update($amortization_id, $data);
        
                if ($getamortizationID > 0) {
                    header('Location: ./index.php?id='.$amortization_id.'&mid='.$mid);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $amortization_id .'&action=edit&error=SQL_Create&msg='.$amortization->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();

	$event  = new amortization($db);
	//$canedit = ($user->rights->btp->write_all || $user->rights->btp->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php?mid='.$mid);
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$amortization     = new amortization($db);
$machine     = new machine($db);

$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('amortization'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("amortization"));
    $machine->fetch($mid);
        $head = material_prepare_head($machine);
        dol_fiche_head($head, 'amortization', $langs->trans('amortization'), 0, '');
         $html .= '<table class="border" width="100%">';
        $html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
        $html .= '<td colspan="2">'. $machine->code .'</td></tr>';
        $html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
        $html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
    $html .= '</table><br />';
    echo $html;

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addamortization'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?mid='.$mid.'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';



       //date start
        print '<tr><td class="fieldrequired">'.$langs->trans("date_start").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="date_start_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //amount
        print '<tr><td class="fieldrequired">'.$langs->trans("amount").'</td><td>';
        print '<input type="number" value="" step="0.01" min="0" name="amount_" required="required" />';
        print '</td></tr>';

        //duration
        print '<tr><td class="fieldrequired">'.$langs->trans("duration").'</td><td>';
        print '<input type="number" value="" name="duration_" required="required" />';
        print '</td></tr>';

        //engin
       /* print '<tr><td class="fieldrequired">'.$langs->trans("machine").'</td><td>';
         $machines = $machine->getMats();
        print $form->selectarray('machine_id_', $machines,(GETPOST('machine_id_') ? GETPOST('machine_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';*/

        
        //chantier 
        print '<tr><td>'.$langs->trans("tva").'</td><td>'; 
        print '<input type="number" value="" name="tva_" required="required" />';
        print '</td></tr>';

        //fournisseur 
        print '<tr><td>'.$langs->trans("supplier").'</td><td>'; 
        print  $form->select_thirdparty(null,"supplier_id_",'s.fournisseur=1');
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createamortization") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $amortization->fetch($id);

			//$canedit = ($user->rights->btp->delete || $user->rights->btp->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEnddate_startP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'amortizations', $langs->trans("amortization"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'&mid='.$mid.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="amortization_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';



        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("date_start").'</td><td>';
        print '<input type="text" value="'.dol_print_date($amortization->date_start,'day').'" class="datepicker" autocomplete="off"  name="date_start_" required="required" readonly="readonly" /> ';
        print '</td></tr>';


        //amount
        print '<tr><td class="fieldrequired">'.$langs->trans("amount").'</td><td>';
        print '<input type="number" step="0.01" min="0" value="'.$amortization->amount.'" name="amount_" required="required" />';
        print '</td></tr>';

        //duration
        print '<tr><td class="fieldrequired">'.$langs->trans("duration").'</td><td>';
        print '<input type="number" value="'.$amortization->duration.'" name="duration_" required="required" />';
        print '</td></tr>';

        //engin
        /*print '<tr><td class="fieldrequired">'.$langs->trans("machine").'</td><td>';
         $machines = $machine->getMats();
        print $form->selectarray('machine_id_', $machines,(GETPOST('machine_id_') ? GETPOST('machine_id_') : $amortization->machine_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';*/

        //chantier 
        print '<tr><td>'.$langs->trans("tva").'</td><td>'; 
        print '<input type="number" value="'.$amortization->tva.'" name="tva_" required="required" />';
        print '</td></tr>';


        //fournisseur 
        print '<tr><td>'.$langs->trans("supplier").'</td><td>'; 
        print  $form->select_thirdparty($amortization->supplier_id,"supplier_id_",'s.fournisseur=1');
        print '</td></tr>';



                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->btp->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>