<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/admin_materials/class/admin_materials.class.php');
dol_include_once('/btp/material/machine/class/machine.class.php');
dol_include_once('/btp/settings/procedures/class/Procedures.class.php');
dol_include_once('/btp/lib/machine.lib.php');


$form 		= new Form($db);
$admin_materials   = new admin_materials($db);
$machine     = new machine($db);
$procedures     = new Procedures($db);


$var = false;
$filter = '';
$td_travaux =  array(1 => 'Travaux 1', 2 => 'Travaux 2' );
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$mid 	  = GETPOST('mid', 'int');
$id 	  = GETPOST('id','int');
$search_num      		= GETPOST('search_num');
$search_date_start      		= "";
if (GETPOST('search_date_start') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_date_start'));
    $search_date_start         = $ety.'-'.$etm.'-'.$etd ;
}
$search_date_end      		= "";
if (GETPOST('search_date_end') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_date_end'));
    $search_date_end         = $ety.'-'.$etm.'-'.$etd ;
}
$search_amount    		= GETPOST('search_amount');
$search_machine    		= GETPOST('search_machine');
$search_alert    		= GETPOST('search_alert');
$search_procedure    		= GETPOST('search_procedure');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_num      		= '';
$search_date_start      		= '';
$search_date_end    		= '';
$search_amount    		= '';
$search_machine    		= '';
$search_alert    		= '';
$search_procedure    		= '';
}
$filter .= (!empty($search_num) && $search_num != -1) ? " AND num = ". $db->escape($search_num): "";
$filter .= (!empty($search_date_start) && $search_date_start != -1) ? " AND date_start = '".$db->escape($search_date_start)."'\n" :"";
$filter .= (!empty($search_date_end) && $search_date_end != -1) ? " AND date_end = '".$db->escape($search_date_end)."'\n" :"";
$filter .= (!empty($search_amount) && $search_amount != -1) ? " AND amount = ".$db->escape($search_amount):"";
$filter .= " AND machine_id = ".$mid;
$filter .= (!empty($search_alert) && $search_alert != -1) ? " AND alert = ".$db->escape($search_alert) : "";
$filter .= (!empty($search_procedure) && $search_procedure != -1) ? " AND procedure_id = ".$db->escape($search_procedure) : "";


$getadmin_materialss = $admin_materials->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getadmin_materialss == '-1') {
    print_fiche_titre($langs->trans('ListOfadmin_materials'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$admin_materials->error);
    exit();
}
if ($id > 0) {
	$admin_materials->fetch($id);
	//llxHeader('', $langs->trans('admin_materials'));
	//print_fiche_titre($langs->trans("admin_materials"));
	$machine->fetch($mid);
	llxHeader('', $langs->trans('admin_materials'));
	print_fiche_titre($langs->trans("admin_materials"));
	$head  		= material_prepare_head($machine);
	dol_fiche_head($head, 'admin_materials', $langs->trans('admin_materials'), 1, '');
	$html .= '<table class="border" width="100%">';
	$html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
        $html .= '<td colspan="2">'. $machine->code .'</td></tr>';
        $html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
        $html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
    $html .= '</table><br />';
    echo $html;
   	print_fiche_titre($langs->trans("admin_materials"));

	print '<table class="border" width="100%">';
	// num
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("num").'</td>';
	print '<td colspan="2">'. $admin_materials->num .'</td></tr>';
	// amount
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("amount").'</td>';
	print '<td colspan="2">'. $admin_materials->amount .'</td></tr>';
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("date_start").'</td>';
	print '<td colspan="2">'. dol_print_date($admin_materials->date_start,'day') .'</td></tr>';
	// date_end
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("date_end").'</td>';
	print '<td colspan="2">'. dol_print_date($admin_materials->date_end,'day') .'</td></tr>';
	// engin
	/*print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine").'</td>';
	$machine->fetch($admin_materials->machine_id);
	print '<td colspan="2">'. $machine->getNomUrl(1) .'</td></tr>';*/
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("note").'</td>';
	print '<td colspan="2">'. $admin_materials->note.'</td></tr>';
	// chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("alert").'</td>';
	print '<td colspan="2">'. $admin_materials->alert .'</td></tr>';
	//travaux
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("procedure").'</td>';
	$procedures->fetch($admin_materials->procedure_id);
	print '<td colspan="2">'. $procedures->getNomUrl(1) .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&mid='.$mid.'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'&mid='.$mid.'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';
	print '</div>';
	if ($action == 'delete') {
                    print $form->formconfirm("card.php?id=".$id."&mid=".$mid, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }
}
else {

 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader('', $langs->trans('admin_materials'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("ListOfadmin_materials"));
	$machine->fetch($mid);
	$head = material_prepare_head($machine);
   	dol_fiche_head($head, 'admin_materials', $langs->trans('ListOfadmin_materials'), 1, '');
   	$moreparam = '&mid='.$mid;
   	$html .= '<table class="border" width="100%">';
	$html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
        $html .= '<td colspan="2">'. $machine->code .'</td></tr>';
        $html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
        $html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
    $html .= '</table><br />';
    echo $html;


	//dol_fiche_head('', 'admin_materials', $langs->trans("ListOfadmin_materials"), 1, '');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<input name="mid" value="'. $mid .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("num"), $_SERVER["PHP_SELF"], 'num', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("date_start"), $_SERVER["PHP_SELF"], 'date_start', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("date_end"),$_SERVER["PHP_SELF"],"date_end", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("amount"),$_SERVER["PHP_SELF"],"amount", '',$moreparam,'align="center"',$sortfield,$sortorder);
	//print_liste_field_titre($langs->trans("machine"),$_SERVER["PHP_SELF"],"machine_id", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("alert"), $_SERVER["PHP_SELF"], 'alert', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("note"), $_SERVER["PHP_SELF"], 'note', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("procedure"), $_SERVER["PHP_SELF"], 'procedure_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// num
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_num" value="'.$search_num.'">';
	print '</td>';
	//date_start
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_date_start,'day').'" class="datepicker" autocomplete="off"  name="search_date_start"  readonly="readonly" /> ';
    print '</td>';
    //date_end
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_date_end,'day').'" class="datepicker" autocomplete="off"  name="search_date_end"  readonly="readonly" /> ';
    print '</td>';
	// amount
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0" name="search_amount" value="'.$search_amount.'">';
	print '</td>';
	// engin
	/*print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_machine', $machine->getMats(), $search_machine, 1, 0, 0, 'required="required"');
	print '</td>';*/
	// alert
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_alert" value="'.$search_alert.'">';
	print '</td>';
	//note
	print '<td class="liste_titre" colspan="1" align="center">';
	print '</td>';
	// procedure
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_procedure', $procedures->getNames(), $search_procedure, 1, 0, 0, 'required="required"');
	print '</td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($admin_materials->rows)) {
		//$createdBy = new User($db);
		foreach($admin_materials->rows as $obj) {
			  $num 				= $obj->num ;
			  $amount 				= $obj->amount ;
			  $date_start 			= dol_print_date($obj->date_start,'day') ;
			  $date_end 			= dol_print_date($obj->date_end,'day') ;
			  //$machine->fetch($obj->machine_id) ;
			  $alert         			= $obj->alert ;
			  $note         			= $obj->note ;
			  $procedures->fetch($obj->procedure_id);
	
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $admin_materials->getNomUrl(1,  $obj->id,$mid, $num);
			print '</td>';
			 
			print '<td align="center">'. $date_start .'</td>';
			print '<td align="center">'. $date_end .'</td>';
			print '<td align="center">'. $amount .'</td>';
			//print '<td align="center">'. $machine->getNomUrl(1) .'</td>';
			print '<td align="center">'. $alert .'</td>';
			print '<td align="center">'. $note .'</td>';
			print '<td align="center">'. $procedures->getNomUrl(1) .'</td>';

			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&mid='.$mid.'" class="butAction">'.$langs->trans('Addadmin_materials').'</a>';
		print '</div>';


}

llxFooter();

$db->close();


?>