<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/work_supplies/index.php
 * \ingroup    list
 * \brief      List of work_supplies
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
dol_include_once('/btp/market/work_supplies/class/work_supplies.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/market/works/class/works.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

// Protection if external user
if (!$user) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$wid 	  = GETPOST('wid','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

if (!$wid)
	die("ID de travaux n'existe pas!");

$search_ref       		 = GETPOST('search_ref');
$search_product 		 = GETPOST('search_product');
$search_transport        = GETPOST('search_transport');
$search_qty_product      = GETPOST('search_qty_product');
$search_handling		 = GETPOST('search_handling');
$search_charge_supplment = GETPOST('search_charge_supplment');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   	 	= "";
	$search_transport   = "";
	$search_product 	= "";
    $search_qty_product = "";
	$search_handling	= "";
	$search_charge_supplment= "";
}

/**
 * Actions
 */

// None

/**
 * View
 */

$object  = new MarketWorkSupplies($db);
$works   = new MarketWorks($db);
$market  = new Market($db);
$fuser 	 = new User($db);
$productObj = new Product($db);

llxHeader(array(), $langs->trans('Supplies'), '', '', '', '', array('/btp/js/btp.js'));

// Filter
$filter .= (!empty($search_ref)) ? " AND rowid = ". $db->escape((int)$search_ref) : "";
$filter .= (isset($search_qty_product) && !empty($search_qty_product)) ? " AND qty_product = ". $db->escape((int)$search_qty_product) : '';
$filter .= isset($search_handling) && !empty($search_handling) ? " AND handling = '". $db->escape($search_handling) ."'" : '';
$filter .= (!empty($search_product) && $search_product != -1) ? " AND fk_product = ". $db->escape((int)$search_product) : "";
$filter .= (!empty($search_transport)) ? " AND transport = '". $db->escape($search_transport) ."'" : "";
$filter .= (!empty($search_charge_supplment)) ? " AND charges_supplement = '". $db->escape($search_charge_supplment) ."'" : "";

/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$getwork_supplies = $object->fetchAll($wid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getwork_supplies == '-1') {
    print_fiche_titre($langs->trans('Supplies'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;
$num  = count($object->lines);
$form = new FormChild($db);

// fetch works and market objects
$works->fetch($wid);
$market->fetch($works->fk_market);

if ($id > 0) {
	$object->fetch($id);

	print_barre_liste($langs->trans("Supplies"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$work_suppliesHead  = market_works_prepare_head($works);
	dol_fiche_head($work_suppliesHead, 'work_supplies', $langs->trans("Supplies"), 0, 'submunu');

	// echo $market->getMarketHeader($wid);

	$productObj->fetch($object->fk_product);
	$qty_product 	= $object->qty_product ? $object->qty_product : '';
	$charge_supplment= $object->charges_supplement ? number_format($object->charges_supplement,  2, ",", " ") : '';
	$transport		= $object->transport ? $object->transport : '';
	$handling		= $object->handling ? $object->handling : '';

	print '<table class="border" width="100%">';
	// Product
	print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Supply").'</td>';
	print '<td colspan="2">'. $productObj->getNomUrl('1') .'</td></tr>';

	// quantity
	print '<tr><td class="fieldrequired">'.$langs->trans("Quantity").'</td>';
	print '<td colspan="2">'. $qty_product .'</td></tr>';

	// Transport
	print '<tr><td class="">'.$langs->trans("Transport").'</td>';
	print '<td colspan="2">'. $transport .'</td></tr>';

	// Handling
	print '<tr><td class="">'.$langs->trans("Handling").'</td>';
	print '<td colspan="2">'. $handling .'</td></tr>';

	// ChargesSupplement
	print '<tr><td class="">'.$langs->trans("ChargesSupplement").'</td>';
	print '<td colspan="2">'. $charge_supplment .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';

	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?wid='. $wid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	if ($user->id/* && $user->rights->btp->write_all*/) {
		print '<a href="./card.php?action=edit&id='. $id .'&wid='. $wid .'" class="butAction">'.$langs->trans('Modify').'</a>';

		// if ($user->rights->btp->delete)	{
        	print '<a href="./index.php?id='.$id.'&action=delete&wid='. $wid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
        // }
		if ($action == 'delete') {
            // if($user->rights->btp->delete) {
            print $form->formconfirm("./card.php?wid=".$wid."&id=".$id, $langs->trans("TitleDeleteSupply"), $langs->trans("ConfirmDeleteSupply"), "confirm_delete", '', 0, 1);
                // }
        }
	}
	print '</div>';
}
else {
	print_barre_liste($langs->trans("Supplies"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	
	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$work_suppliesHead  = market_works_prepare_head($works);
	dol_fiche_head($work_suppliesHead, 'work_supplies', $langs->trans("Supplies"), 0, 'submunu');

	// echo $market->getMarketHeader($wid);

	$moreparam = '&wid='.$wid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="wid" value="'. $wid .'" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Supply"),$_SERVER["PHP_SELF"], "fk_product", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Transport"), $_SERVER["PHP_SELF"], 'transport', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Quantity"),$_SERVER["PHP_SELF"], 'qty_product', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Handling"), $_SERVER["PHP_SELF"],'handling','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("ChargesSupplement"), $_SERVER["PHP_SELF"],'charges_supplement','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'" />';
	print '</td>';

    print '<td class="liste_titre" align="center">';
    print $form->select_produits_list($search_product, "search_product", 0, 30, 0, '', 0, -1);//finished=2
    print '</td>';

	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="30" type="text" name="search_transport" value="'.dol_escape_htmltag($search_transport).'" />';
	print '</td>';

	print '<td class="liste_titre" align="center"><input class="flat center" type="text" size="14" name="search_qty_product" value="'.$search_qty_product.'"></td>';

	print '<td class="liste_titre" align="center"><input class="flat center" type="text" size="20" name="search_handling" value="'.$search_handling.'"></td>';

	print '<td class="liste_titre" align="center"><input class=" center" type="text" size="14" name="search_charge_supplment" value="'.$search_charge_supplment.'"></td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";

	// Lines
	if (count($object->lines)) {
		foreach ($object->lines as $line) {
			$var = !$var;
			$productObj->fetch($line->fk_product);
			$handling	= $line->handling ? $line->handling : '';
			$qty_product= $line->qty_product ? $line->qty_product : '';
			$transport	= $line->transport ? $line->transport : '';
			$charges_supplement	= $line->charges_supplement ? $line->charges_supplement : '';

			print '<tr '.$bc[$var].'>';
			print '<td align="left">';

			print $object->getNomUrl(1,  $line->id, $line->fk_td_work);
			print '</td>';
			print '<td align="center">'. $productObj->getNomUrl(1, 'stock') .'</td>';
			print '<td align="center">'. $transport .'</td>';
			print '<td align="center">'. $qty_product .'</td>';
			print '<td align="center">'. $handling .'</td>';
			print '<td align="center">'. $charges_supplement .'</td>';
			print '<td>&nbsp;</td>';
			print '</tr>';
		}
	} else {
		print '<tr>';
	    print '<td colspan="7" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	if ($user->id /*&& $user->rights->btp->write*/) {
		// $exceedingCls = $totalExceedingDays ? 'red' : 'green';
		print '<tr>';
	    print '<td colspan="7" '.$bc[false].'">';

		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&wid='. $wid .'" class="butAction">'.$langs->trans('AddSupply').'</a>';
		
		print '</div>';
	    print '</td></tr>';
	}

	print '</table>';
	print '</form>';
}

llxFooter();

$db->close();

?>