<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/work_employees/index.php
 * \ingroup    list
 * \brief      List of work_employees
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
dol_include_once('/btp/market/work_employees/class/work_employees.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/market/works/class/works.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

dol_include_once('/btp/settings/unit_type/class/unitType.class.php');

// Protection if external user
if (!$user) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$wid 	  = GETPOST('wid','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

if (!$wid)
	die("ID de travaux n'existe pas!");

$search_ref       	= GETPOST('search_ref');
$search_user 		= GETPOST('search_user');
$search_unit_type   = GETPOST('search_unit_type');
$search_qty      	= GETPOST('search_qty');
$search_employee_num= GETPOST('search_employee_num');
$search_unit_cost 	= GETPOST('search_unit_cost');
$search_cnss 		= GETPOST('search_cnss');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   	 	= "";
	$search_unit_type   = "";
	$search_user 		= "";
    $search_qty 		= "";
	$search_employee_num= "";
	$search_unit_cost	= "";
	$search_cnss		= "";
}

/**
 * Actions
 */

// None

/**
 * View
 */

$object  = new MarketWorkEmployees($db);
$works   = new MarketWorks($db);
$market  = new Market($db);
$fuser 	 = new User($db);
$unitType= new unitType($db);

llxHeader(array(), $langs->trans('Employees'), '', '', '', '', array('/btp/js/btp.js'));

print '<link rel="stylesheet" href= "'.dol_buildpath('/btp/css/fontawesome.css',2).'">';

// Filter
$filter .= (!empty($search_ref)) ? " AND rowid = ". $db->escape((int)$search_ref) : "";
$filter .= (!empty($search_user) && $search_user != -1) ? " AND fk_user = ". $db->escape((int)$search_user) : "";
$filter .= (!empty($search_unit_type) && $search_unit_type != -1) ? " AND fk_unit_type = ". $db->escape((int)$search_unit_type) : "";
$filter .= (isset($search_qty) && !empty($search_qty)) ? " AND qty = ". $db->escape((int)$search_qty) : '';
$filter .= isset($search_employee_num) && !empty($search_employee_num) ? " AND employee_num = ". $db->escape((int)$search_employee_num) : '';
$filter .= (!empty($search_unit_cost)) ? " AND unit_cost = ". $db->escape((float)$search_unit_cost) : "";
$filter .= (!empty($search_cnss)) ? " AND cnss = '". $db->escape($search_cnss) ."'" : "";

/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$getwork_employees = $object->fetchAll($wid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getwork_employees == '-1') {
    print_fiche_titre($langs->trans('Employees'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;
$num  = count($object->lines);
$form = new FormChild($db);

// fetch works and market objects
$works->fetch($wid);
$market->fetch($works->fk_market);

if ($id > 0) {
	$object->fetch($id);

	print_barre_liste($langs->trans("Employees"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$work_employeesHead  = market_works_prepare_head($works);
	dol_fiche_head($work_employeesHead, 'work_employees', $langs->trans("Employees"), 0, 'submunu');

	// echo $market->getMarketHeader($wid);

	$fuser->fetch($object->fk_user);
	$unitType->fetch($object->fk_unit_type);
	$qty 		= $object->qty ? $object->qty : '';
	$unit_cost 	= $object->unit_cost ? number_format($object->unit_cost,  2, ",", " ") : '';
	$employee_num= $object->employee_num ? $object->employee_num : '';
	$cnss		= $object->cnss ? $object->cnss : '';

	print '<table class="border" width="100%">';
	// User
	print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Responsible").'</td>';
	print '<td colspan="2">'. $fuser->getNomUrl('1') .'</td></tr>';

	// Unit type
	print '<tr><td class="fieldrequired">'.$langs->trans("UnitType").'</td>';
	print '<td colspan="2">'. $unitType->getNomUrl(1, $unitType->rowid, $unitType->name) .'</td></tr>';

	print '<tr><td class="fieldrequired">'.$langs->trans("UnitCost").'</td>';
	print '<td colspan="2">'. $unit_cost .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';

	print '<tr><td class="fieldrequired">'.$langs->trans("Quantity").'</td>';
	print '<td colspan="2">'. $qty .'</td></tr>';

	// Employee num
	print '<tr><td class="">'.$langs->trans("EmployeeNum").'</td>';
	print '<td colspan="2">'. $employee_num .'</td></tr>';

	// cnss
	print '<tr><td class="">'.$langs->trans("CNSS").'</td>';
	print '<td colspan="2">'. $cnss .'</td></tr>';

	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?wid='. $wid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	if ($user->id/* && $user->rights->btp->write_all*/) {
		print '<a href="./card.php?action=edit&id='. $id .'&wid='. $wid .'" class="butAction">'.$langs->trans('Modify').'</a>';

		// if ($user->rights->btp->delete)	{
        	print '<a href="./index.php?id='.$id.'&action=delete&wid='. $wid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
        // }
		if ($action == 'delete') {
            // if($user->rights->btp->delete) {
            print $form->formconfirm("./card.php?wid=".$wid."&id=".$id, $langs->trans("TitleDeleteEmployee"), $langs->trans("ConfirmDeleteEmployee"), "confirm_delete", '', 0, 1);
                // }
        }
	}
	print '</div>';
}
else {
	print_barre_liste($langs->trans("Employees"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	
	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$work_employeesHead  = market_works_prepare_head($works);
	dol_fiche_head($work_employeesHead, 'work_employees', $langs->trans("Employees"), 0, 'submunu');

	// echo $market->getMarketHeader($wid);

	$moreparam = '&wid='.$wid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="wid" value="'. $wid .'" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Responsible"),$_SERVER["PHP_SELF"], "fk_user", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("UnitType"), $_SERVER["PHP_SELF"], 'fk_unit_type', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("EmployeeNum"),$_SERVER["PHP_SELF"], 'employee_num', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("UnitCost"), $_SERVER["PHP_SELF"],'unit_cost','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Quantity"), $_SERVER["PHP_SELF"],'qty','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("CNSS"), $_SERVER["PHP_SELF"],'cnss','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'" />';
	print '</td>';

    print '<td class="liste_titre" align="center">';
	print $form->select_dolusers($search_user,"search_user",1,"",0,'','',0,32);
    print '</td>';

	print '<td class="liste_titre" align="center">';
    print $form->selectarray("search_unit_type", $unitType->getNames(), $search_unit_type, 1);
	print '</td>';

	print '<td class="liste_titre" align="center"><input class="flat center" type="number" size="14" name="search_employee_num" value="'.$search_employee_num.'" min="1" /></td>';

	print '<td class="liste_titre" align="center"><input class="flat center" type="text" size="20" name="search_unit_cost" value="'.$search_unit_cost.'"></td>';

	print '<td class="liste_titre" align="center"><input class=" center" type="number" size="14" name="search_qty" value="'.$search_qty.'" min="1" /></td>';

	print '<td class="liste_titre" align="center"><input class=" center" type="text" size="14" name="search_cnss" value="'.$search_cnss.'"></td>';
	
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";

	// Lines
	if (count($object->lines)) {
		foreach ($object->lines as $line) {
			$var = !$var;
			$fuser->fetch($db->escape($line->fk_user));
			$unitType->fetch($line->fk_unit_type);
			
			$employee_num	= $line->employee_num ? $line->employee_num : '';
			$unit_cost		= $line->unit_cost ? number_format($line->unit_cost,  2, ",", " ") : '';
			$qty 			= $line->qty ? $line->qty : '';
			$cnss			= $line->cnss ? $line->cnss : '';

			print '<tr '.$bc[$var].'>';
			print '<td align="left">';
				print $object->getNomUrl(1,  $line->id, $line->fk_td_work);
			print '</td>';
			print '<td align="center">'. $fuser->getNomUrl('1') .'</td>';
			print '<td align="center">'. $unitType->getNomUrl(1, $unitType->rowid, $unitType->name) .'</td>';
			print '<td align="center">'. $employee_num .'</td>';
			print '<td align="center">'. $unit_cost .' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $cnss .'</td>';
			print '<td>&nbsp;</td>';
			print '</tr>';
		}
	} else {
		print '<tr>';
	    print '<td colspan="8" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	if ($user->id /*&& $user->rights->btp->write*/) {
		// $exceedingCls = $totalExceedingDays ? 'red' : 'green';
		print '<tr>';
	    print '<td colspan="8" '.$bc[false].'">';

		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&wid='. $wid .'" class="butAction">'.$langs->trans('AddEmployee').'</a>';
		
		print '</div>';
	    print '</td></tr>';
	}

	print '</table>';
	print '</form>';
}

llxFooter();

$db->close();

?>