<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
dol_include_once('/btp/market/work_advancement/class/work_advancement.class.php');
dol_include_once('/btp/market/construction_site/class/construction_site.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/market/works/class/works.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');


// Protection if external user
if (!$user) accessforbidden();

$var 	= false;
$filter = '';
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$id 	  = GETPOST('id','int');
$wid 	  = GETPOST('wid','int');
$action	  = GETPOST('action', 'alpha');

if (!$wid)
	die("ID de travaux n'existe pas!");

$search_qty      	= GETPOST('search_qty', 'int');
$search_datec      	= GETPOST('search_datec');
$search_const_site  = GETPOST('search_const_site', 'int');
$search_ref    		= GETPOST('search_ref', 'int');

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref       = '';
	$search_qty       = '';
	$search_datec     = '';
	$search_const_site= '';
}

if (isset($search_datec) && !empty($search_datec)) {
    $filter .= " AND datec = '". $db->escape(Tools::convertDateTo($search_datec, 'sql'))."'";
}

$filter .= (!empty($search_qty) && $search_qty != -1) ? " AND qty = ".$db->escape((int)$search_qty) : "";
$filter .= (!empty($search_const_site) && $search_const_site != -1) ? " AND const_site_id = ".$db->escape((int)$search_const_site) : "";
$filter .= (!empty($search_ref) && $search_ref != -1) ? " AND rowid = ".$db->escape((int)$search_ref) : "";

$form 			 = new FormChild($db);
$workAdvancement = new WorkAdvancement($db);
$constructionSite= new ConstructionSite($db);
$works   		 = new MarketWorks($db);
$market  		 = new Market($db);

llxHeader(array(), $langs->trans('work_advances'), '', '', '', '', array('/btp/js/btp.js'));

$getwork_advancess = $workAdvancement->fetchAll($wid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getwork_advancess == '-1') {
    print_fiche_titre($langs->trans('ListOfwork_advances'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$workAdvancement->error);
    exit();
}

// fetch works and market objects
$works->fetch($wid);
$market->fetch($works->fk_market);

if ($id > 0) {
	$workAdvancement->fetch($id);

	print_barre_liste($langs->trans("work_advances"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$head  = market_works_prepare_head($works);
	dol_fiche_head($head, 'work_advancement', $langs->trans("work_advances"), 0, 'submunu');

	$constructionSite->fetch($workAdvancement->const_site_id);

	print '<table class="border" width="100%">';
	// qty
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("qty").'</td>';
	print '<td colspan="2">'. $workAdvancement->qty .'</td></tr>';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
	print '<td colspan="2">'. dol_print_date($workAdvancement->datec,'day') .'</td></tr>';
	// chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("const_site").'</td>';
	print '<td colspan="2">';
	print $constructionSite->getNomUrl(1, $constructionSite->id, $constructionSite->name, $constructionSite->market_id);
	print '</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?wid='.$wid.'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&wid='.$wid.'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '<a href="./index.php?action=delete&id='. $id .'&wid='.$wid.'"  class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';
	print '</div>';

	if ($action == 'delete')
        print $form->formconfirm("./card.php?wid=".$wid."&id=".$id, $langs->trans("TitleDelete"), $langs->trans("ConfirmDelete"), "confirm_delete", '', 0, 1);
}
else {
	print_barre_liste($langs->trans("work_advances"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$head  = market_works_prepare_head($works);
	dol_fiche_head($head, 'work_advancement', $langs->trans("work_advances"), 0, 'submunu');

	// echo $market->getMarketHeader($wid);

	$moreparam = '&wid='.$wid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="wid" value="'. $wid .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"), $_SERVER["PHP_SELF"], 'rowid', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("datec"), $_SERVER["PHP_SELF"], 'datec', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("qty"),$_SERVER["PHP_SELF"],"qty", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("const_site"), $_SERVER["PHP_SELF"], 'const_site_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	//datec
	print '<td class="liste_titre" align="center">';
    print '<input type="text" value="'.$search_ref .'" class="flat" name="search_ref" /> ';
    print '</td>';

	//datec
	print '<td class="liste_titre" align="center">';
    print '<input type="text" value="'.$search_datec.'" class="datepicker" autocomplete="off"  name="search_datec"  readonly="readonly" /> ';
    print '</td>';
	// qty
	print '<td class="liste_titre" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_qty" value="'.$search_qty.'">';
	print '</td>';
	// const_site
	print '<td class="liste_titre" align="center">';
	print $form->selectarray('search_const_site', $constructionSite->getNames($works->fk_market), $search_const_site, 1, 0, 0, 'required="required"');
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($workAdvancement->rows)) {
		foreach($workAdvancement->rows as $obj) {
			$qty 		= $obj->qty;
			$datec 		= dol_print_date($obj->datec,'day');
			$constructionSite->fetch($obj->const_site_id);
		
			print '<tr '.$bc[$var].'>';
			print '<td align="left"">';
				print $workAdvancement->getNomUrl(1,  $obj->id, null, $obj->td_work_id);
			print '</td>';

			print '<td align="center">'. $datec .'</td>';
			 
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">';
				print $constructionSite->getNomUrl(1, $constructionSite->id, $constructionSite->name, $constructionSite->market_id);
			print'</td>';

			print '<td>&nbsp;</td>';
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./card.php?action=add&wid='. $wid .'" class="butAction">'.$langs->trans('Addwork_advances').'</a>';
	print '</div>';
}

llxFooter();

$db->close();


?>