<?php
/* Copyright (C) Yassine Belkaid y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/market/work_coefficients/class/work_coefficients.class.php
 * \ingroup work_coefficients
 * \brief   This file is work_coefficients CRUD class file
 *
 */

dol_include_once('/btp/db/nxdb.class.php');

class WorkAdvancement extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();

  	public $datec;
  	public $qty;
  	public $const_site_id ;
  	public $td_work_id	 ;
  	public $created_by ;
  	public $created_at ;
  	public $updated_at ;
  	public $rows = array();

  	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'work_advances';
	/**
	 * @var string Name of table without pgeneral_fee_marcheix where object is stored
	 */
	public $table_element = 'work_advances';

	public $now;
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = date('Y-m-d');//$this->now->format('Y-m-d');
		$this->updated_at= $this->now;
		return 1;
	}


	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id = null, $ref = null, $wid)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : $id;
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/market/work_advancement/index.php?id='. $id.'&wid='. $wid,1) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->datec= $this->datec ? $this->db->escape($this->datec): null;
		$this->qty = $this->qty ? $this->db->escape($this->qty): null;
		$this->const_site_id = $this->const_site_id ? $this->db->escape($this->const_site_id): null;
		$this->td_work_id	= $this->td_work_id ? $this->db->escape($this->td_work_id): null;
		$this->created_by = $this->created_by ? $this->db->escape($this->created_by): null;
		$this->created_at = $this->now;
		
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'work_advances' . ' (datec,qty,';
		$sql .= 'const_site_id,td_work_id,created_by,created_at,updated_at) ';
		$sql .= 'VALUES ("'.$this->datec.'", '.$this->qty.','. $this->const_site_id.', ';
		$sql .=	$this->td_work_id.', '.$this->created_by.',"'.$this->created_at.'","'. $this->updated_at .'")';

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error work_advances ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
			die();
			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $fk_td_work = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'work_advances';
		
		if (null !== $fk_td_work) {
			$sql .= ' WHERE td_work_id = ' . $fk_td_work;
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->datec 			= $this->db->jdate($obj->datec); ;
			  $this->qty 			= $obj->qty ;
			  $this->id 			= $obj->rowid ;
			  $this->const_site_id 	= $obj->const_site_id ;
			  $this->td_work_id	= $obj->td_work_id ;
			  $this->created_by 	= $obj->created_by ;
			  $this->created_at 	= $this->db->jdate($obj->created_at);

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($wid = null, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $ignore_id = false)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'work_advances';

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4) .' AND td_work_id = '. $wid;
		} else {
			if (!$ignore_id)
				$sql .= ' WHERE td_work_id = '. $wid;
		}

		$this->rows = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$qty = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				  $line->id 			= $obj->rowid;
				  $line->datec 			= $this->db->jdate($obj->datec); ;
				  $line->qty 			= $obj->qty ;
				  $line->const_site_id 	= $obj->const_site_id ;
				  $line->td_work_id		= $obj->td_work_id ;
				  $line->created_by 	= $obj->created_by ;
				  $line->created_at 	= $this->db->jdate($obj->created_at);
				$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $qty;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}



	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'work_advances' . ' SET updated_at = "'. $this->now .'",';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = rtrim($sql, ',');
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'work_advances' .' WHERE rowid = ' . (int)$id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	public function getStatData($wid = false, $market_id = 0)
    {
    	global $langs;
    	$this->fetchAll(($wid ?: null), '', '', 0, 0, '', ($wid ? false : true));
    	
    	$object 		= new stdClass();
    	$object->number = (!$wid && $market_id ? 0 : count($this->rows));
    	$object->cost 	= false;
    	$object->label 	= $langs->trans('work_advances');
    	$object->url 	= (int)$wid ? dol_buildpath('/btp/market/work_advancement/index.php?wid='.$wid.'&mid=',1). $market_id : '';

    	return $object;
    }
}
?>