<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
dol_include_once('/btp/market/work_advancement/class/work_advancement.class.php');
dol_include_once('/btp/market/construction_site/class/construction_site.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/market/works/class/works.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');


// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$wid      = GETPOST('wid','int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$wid)
    die("ID de travaux n'existe pas!");

$error 	= false;
$form            = new FormChild($db);
$workAdvancement = new WorkAdvancement($db);
$constructionSite= new ConstructionSite($db);
$works           = new MarketWorks($db);
$market          = new Market($db);

if ($action == 'create' && $request_method === 'POST' && !empty($_POST['wid'])) {
    $datec         = trim($_POST['datec_']);
    $qty           = (int)trim($_POST['qty_']);
    $const_site_id = (int)trim($_POST['const_site_id_']);
    $wid           = (int)trim($_POST['wid']);

    if ($wid <= 0 || $qty <= 0 || $const_site_id <= 0 || empty($datec)) {
        header('Location: ./card.php?action=add&wid='.$wid);
        die();
    }

    $workAdvancement->datec          = Tools::convertDateTo($datec, 'sql');
    $workAdvancement->qty            = $qty;
    $workAdvancement->const_site_id  = $const_site_id;
    $workAdvancement->td_work_id     = $wid;
    $workAdvancement->created_by     = $user->id;
    
    $workAdvancementID = $workAdvancement->create();

    // If no SQL error we redirect to the request card
    if ($workAdvancementID > 0) {
        header('Location: index.php?wid='.$wid.'&id='.$workAdvancementID);
        exit;
    } else {
        // Otherwise we display the request form with the SQL error message
        header('Location: card.php?action=request&wid='.$wid.'&error=SQL_Create&msg='.$workAdvancement->error);
        exit;
    }
}

if ($action == 'update' && $request_method === 'POST' && !empty($_POST['id']) && !empty($_POST['wid'])) {
    // If no right to modify a request
    /*if (!$user->rights->btp->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    // $canedit = ($user->rights->btp->write || $user->rights->btp->write_all);
    $canedit = true ; 

    // If this is the requestor or has read/write rights
    if ($canedit) {

        $datec         = trim($_POST['datec_']);
        $qty           = (int)trim($_POST['qty_']);
        $const_site_id = (int)trim($_POST['const_site_id_']);
        $wid           = (int)trim($_POST['wid']);
        $id            = (int)trim($_POST['id']);

        if ($wid <= 0 || $id <= 0 || $qty <= 0 || $const_site_id <= 0 || empty($datec)) {
            header('Location: ./index.php?wid='.$wid);
            die();
        }

        $data = array(
            'datec'           => Tools::convertDateTo($datec, 'sql'),
            'qty'             => $qty,
            'const_site_id'   => $const_site_id,
        );

		$getwork_advancesID = $workAdvancement->update($id, $data);
        
        if ($getwork_advancesID > 0) {
            header('Location: ./index.php?id='.$id.'&wid='.$wid);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: ./card.php?id='. $id .'&wid='. $wid .'&action=edit&error=SQL_Create&msg='.$workAdvancement->error);
            exit;
        }
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$canedit = ($user->rights->btp->write_all || $user->rights->btp->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$workAdvancement->delete($id);
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		header('Location: index.php?wid='.$wid);
		exit;
	}
	else {
		
        header('Location: index.php?wid='.$wid);
        exit;
	}
}

/*
 * View
 */
$morejs  = array("/btp/js/btp.js");
$morecss = array();

// fetch works and market objects
$works->fetch($wid);
$market->fetch($works->fk_market);

llxHeader(array(), $langs->trans('work_advances'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        $head  = market_prepare_head($market);
        dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

        $head  = market_works_prepare_head($works);
        dol_fiche_head($head, 'work_advancement', $langs->trans("work_advances"), 0, 'submunu');
       
        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="wid" value="'. $wid .'" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

       //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //quantité
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" min="1" value="" name="qty_" required="required" />';
        print '</td></tr>';

        // Construction siye
        print '<tr><td class="fieldrequired">'.$langs->trans("const_site").'</td><td>'; 
        $const_sites = $constructionSite->getNames($works->fk_market);
        print $form->selectarray('const_site_id_', $const_sites,(GETPOST('const_site_id_') ? GETPOST('const_site_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Creatework_advances") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $workAdvancement->fetch($id);

             $head  = market_prepare_head($market);
            dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

            $head  = market_works_prepare_head($works);
            dol_fiche_head($head, 'work_advancement', $langs->trans("work_advances"), 0, 'submunu');

			//$canedit = ($user->rights->btp->delete || $user->rights->btp->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

        if ($action == 'edit') {
            $edit = true;
            print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
            print '<input type="hidden" name="action" value="update" />'."\n";
            print '<input type="hidden" name="id" value="'.$id.'" />'."\n";
            print '<input type="hidden" name="wid" value="'.$wid.'" />'."\n";

            print '<table class="border" width="100%">';
            print '<tbody>';

            //date
            print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
            print '<input type="text" value="'.dol_print_date($workAdvancement->datec,'day').'" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
            print '</td></tr>';

            //quantité
            print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
            print '<input type="number" min="0" value="'.$workAdvancement->qty.'" name="qty_" required="required" />';
            print '</td></tr>';

            //Construction site 
            print '<tr><td class="fieldrequired">'.$langs->trans("const_site").'</td><td>'; 
            $const_sites = $constructionSite->getNames($works->fk_market);
            print $form->selectarray('const_site_id_', $const_sites,(GETPOST('const_site_id_') ? GETPOST('const_site_id_') : $workAdvancement->const_site_id), 0, 0, 0, 'required="required"');
            print '</td></tr>';

            print '</tbody>';
            print '</table>';

            print '<div class="center">';
            print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
            print '&nbsp; &nbsp; ';
            print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
            print '</div>';
            print '</table>';
            }

            dol_fiche_end();

            if (!$edit) {
	            print '<div class="tabsAction">';

                // Boutons d'actions
                //if ($canedit) {
                    print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                //}

                // If draft
               // if ($user->rights->btp->delete)	{
                	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
               // }

                print '</div>';
            }

    } else {
            
            print '<div class="tabBar">';
            print $langs->trans('ErrorUserViewSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>