<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/notifications/index.php
 * \ingroup    notifications
 * \brief      List of notifications
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
//dol_include_once('/btp/nc_under_modules/marches/marche/class/marche.class.php');
dol_include_once('/btp/market/notifications/class/notification.class.php');
//dol_include_once('/btp/nc_under_modules/marches/lib/marches.lib.php');
dol_include_once('/btp/market/market/class/market.class.php');

dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/core/class/html.form.class.php');

$langs->load('users');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$mid && $request_method !== 'POST')
	die('ID marche n\'existe pas!');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$error 	= false;
$object = new Notifications_two($db);
//$marche = new Marches($db);
$market=new Market($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {

    $action='request';
	// If no right to create a request
   /* if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
	    $notif_date	= '';
	    $mid 		= trim(GETPOST('mid', 'int'));
	    $ref 		= trim(GETPOST('ref'));
	    $subject 	= trim(GETPOST('subject'));

	    if (!$mid || !$ref)
			return;

		if (isset($_POST['notif_date']) && !empty($_POST['notif_date'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['notif_date']);
	        $notif_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    $object->fk_created_by	= $user->id;
	    $object->fk_marche  	= $mid;
	    $object->ref 		 	= $ref;
	    $object->subject 	 	= $subject;
	    $object->notif_date 	= $notif_date;

		$getNotif = $object->create();

		if ($getNotif) {
		    header('Location: ./index.php?id='. $getNotif .'&mid='.$mid);
		    die();
		} else {
			header('Location: ./index.php?mid='.$mid);
		    die();
		}
    //}
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['mid'] > 0 && $request_method === 'POST') {

	 /*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
    	$notif_date	= '';
	    $mid 		= trim(GETPOST('mid', 'int'));
	    $id  		= trim(GETPOST('id', 'int'));
	    $ref 		= trim(GETPOST('ref'));
	    $subject 	= trim(GETPOST('subject'));

	   	if (!$mid || !$ref)
			return;

		if (isset($_POST['notif_date']) && !empty($_POST['notif_date'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['notif_date']);
	        $notif_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    $data = array(
	    	'ref' 		=> $ref,
	    	'subject' 	=> $subject,
	    	'notif_date'=> $notif_date
	    );

		$object->update($id, $data);
		header('Location: ./index.php?id='. $id .'&mid='.$mid);
	    die();
	//}

	$action = "edit";
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' /*&& $user->rights->btp->delete*/) {
	$error = 0;
	$mid = GETPOST('mid', 'int');
	$id = GETPOST('id', 'int');
	
	if (!$mid || !$id)
		return;

	$db->begin();

	$canedit = true;/* ($user->rights->btp->write_all || $user->rights->btp->delete);*/

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $object->id = (int) $id;
		$object->delete();
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
		header('Location: ./index.php?leftmenu=btp&mid='.$mid);
		exit;
	} else {
		$db->rollback();
        header('Location: ./index.php?leftmenu=btp&mid='.$mid);
        exit;
	}
}

$form = new Form($db);

llxHeader(array(), $langs->trans('ListOfNotifications'),'','','','',array('/btp/js/marches.js'),array(),0,0);
print_fiche_titre($langs->trans('AddNotif'), '', 'title_project.png'); 

$market->fetch($mid);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	/*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[] = $langs->trans('CantCreateMarche');
    } else {*/
	 	
	 /*	$marche->fetch($mid);
		$
		head = marches_prepare_head($marche);
		dol_fiche_head($head, 'notifications', $langs->trans('Addnotifications'), 0, '');
		echo $marche->getMarketHeader();
*/		$head  = market_prepare_head($market);
	
		dol_fiche_head($head, 'notifications', $langs->trans('Addnotifications'), 0, '');
	

		echo $market->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="fieldrequired" width="400px">'.$langs->trans("Ref").'</td><td>';
        print '<input type="text" class="" value="" name="ref" required="required" />';
        print '</td></tr>';

        print '<tr><td>'.$langs->trans("NotifDate").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="notif_date" /></td></tr>';

        print '<tr><td>'.$langs->trans("Subject").'</td><td>';
        print ' <textarea cols="49" rows="6" name="subject"></textarea>';
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateNotif") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
   // }
} else {
	if ($id > 0 && $mid > 0) {

	//$head_btm = phase_notification_prepare_head($market);

//echo $market->getMarketHeader($mid);
	
		$object->fetch($id);
		$market->fetch($mid);
		$head  = market_prepare_head($market);

        $canedit = true ;/*($user->rights->btp->delete || $user->rights->btp->write_all);*/

		if ($canedit) {
            if ($action == 'delete') {
                //if($user->rights->btp->delete) {
                    print $form->formconfirm("./card.php?mid=".$mid."&id=".$id, $langs->trans("TitleDeleteNotif"),$langs->trans("ConfirmDeleteNotif"),"confirm_delete", '', 0, 1);
               // }
            }

			if ($action == 'edit' || $action == 'delete') {
				dol_fiche_head($head, 'notifications', $langs->trans('AddNotif'), 0, '');
				echo $market->getMarketHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$ref 		 = $object->ref ?: '';
				$notif_date	 = $object->notif_date ? dol_print_date($object->notif_date, 'day'): '';
				$subject 	 = $object->subject ?: '';

		        print '<table class="border" width="100%">';
		        print '<tbody>';

			    print '<tr><td class="fieldrequired" width="400px">'.$langs->trans("Ref").'</td><td>';
			    print '<input type="text" class="" value="'. $ref .'" name="ref" required="required" />';
			    print '</td></tr>';

			    print '<tr><td>'.$langs->trans("NotifDate").'</td><td>';
			    print '<input type="text" class="datepicker" autocomplete="off"  value="'. $notif_date .'" name="notif_date" /></td></tr>';

			    print '<tr><td>'.$langs->trans("Subject").'</td><td>';
			    print ' <textarea cols="49" rows="6" name="subject">'. $subject .'</textarea>';
			    print '</td></tr>';

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                    //if ($user->rights->btp->delete)	{
                    	print '<a href="./card.php?id='.$id.'&action=delete&mid='. $mid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';

                    //}
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
