<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/market/market_factures/class/market_factures.class.php');
dol_include_once('/btp/market/market/imputationchantier/class/imputationchantier.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';

// Protection if external user
if (!$user) accessforbidden();

$var 		= false;
$filter 	= '';
$sortfield 	= GETPOST("sortfield",'alpha');
$sortorder 	= GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action	 = GETPOST('action');
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id','int');

if (!$mid)
	die('ID marché n\'existe pas!');


$facture 		  = new Facture($db);

$MarketFactures = new MarketFactures($db);
$market 		  = new Market($db);
$fuser 			  = new User($db);
$form 			  = new Form($db);
$imputationchantier= new imputationchantier($db);

$search_facture      	= GETPOST('search_facture');
$search_amount      = GETPOST('search_amount');
$search_adress    	= GETPOST('search_adress');
$search_tel    		= GETPOST('search_tel');
$search_market    	= GETPOST('search_market');
$search_head_site   = GETPOST('search_head_site');
$search_pointer    	= GETPOST('search_pointer');

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_facture      	= '';
	$filter      	= '';
}

$filter .= (!empty($search_facture) && $search_facture != -1) ? " AND facture_id = '". $db->escape($search_facture)."'\n" : "";
$getmarket_facturess = $MarketFactures->fetchAll($mid, $sortorder, $sortfield, "", $offset, $filter);

// Si erreur SQL
if ($getmarket_facturess == '-1') {
    print_fiche_titre($langs->trans('ListOfmarket_factures'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$MarketFactures->error);
    exit();
}

llxHeader('', $langs->trans('market_factures'));
$market->fetch($mid);

if ($id > 0) {
	$MarketFactures->fetch($id);

	print_barre_liste($langs->trans("market_factures"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, '', 'title_project.png');
	
	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'Factures', $langs->trans("Factures"), 0, '');

	// $head = market_market_factures_prepare_head($MarketFactures);
	// dol_fiche_head($head, '', $langs->trans("const_site_diposals"), 0, '');

	echo $market->getMarketHeader();

	print '<table class="border" width="100%">';
	// Ref
	print '<tr><td width="25%" class="">'.$langs->trans("Réf.").'</td>';
	print '<td colspan="2">';
	print $MarketFactures->id;
	print '</td></tr>';
	// Facture
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Facture").'</td>';
	print '<td colspan="2">';
	$facture->fetch($MarketFactures->facture_id);
	print $facture->getNomUrl(1,  $MarketFactures->facture_id,"","","");
	print '</td></tr>';
	
	print '</table>';
	// print '<br>';
	print '<div style="text-align: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&mid='. $mid .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a class="butAction" href="./index.php?action=delete&id='. $id .'&mid='. $mid .'">'.$langs->trans('Delete').'</a>';

	print '</div>';

    if ($action == 'delete')
		print $form->formconfirm("card.php?id=".$id."&mid=".$mid, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
}
else {
	print_barre_liste($langs->trans("market_factures"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, '', 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'Factures', $langs->trans("Factures"), 0, '');

	dol_fiche_head('', 'Factures', $langs->trans(""), 1, 'submunu');

	echo $market->getMarketHeader($mid);
	$moreparam = '&mid='.$mid;
	
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="mid" value="'. $mid .'" />';
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Réf."),$_SERVER["PHP_SELF"],"rowid", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Facture"),$_SERVER["PHP_SELF"],"facture_id", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Montant TTC"),$_SERVER["PHP_SELF"],"", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';

	// rowid
	print '<td class="liste_titre" colspan="1" align="center">';
	print '</td>';

	// nom facture
	print '<td class="liste_titre" colspan="1" align="center">';
	print $MarketFactures->select_with_filter($search_facture,'search_facture',1,"rowid","facnumber","","",true);
	print '</td>';

	// Montant TTC
	print '<td class="liste_titre" colspan="1" align="left">';
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($MarketFactures->rows)) {
		//$createdBy = new User($db);
		$tot_ttc = 0;
		// print_r($MarketFactures->rows);
		// echo $MarketFactures->rows[8]->facture_id;
		// die();
		foreach($MarketFactures->rows as $obj) {
			print '<tr '.$bc[$var].'>';
			print '<td align="center" style ="white-space: nowrap;" class="nomchantierwidth">';
				print $MarketFactures->getNomUrl(1, $obj->id, $obj->id, $obj->market_id);
			print '</td>';
			$facture->fetch($obj->facture_id);
			print '<td align="center" style ="white-space: nowrap;" class="nomchantierwidth">';
			print $facture->getNomUrl(1, $obj->facture_id, "", "", "");
			print '</td>';
			print '<td align="center" style ="white-space: nowrap;" class="nomchantierwidth">';
			print number_format($facture->total_ttc,  2, ",", " ");
			$tot_ttc += $facture->total_ttc;
			print '</td>';
			print '<td><div style="float: right; margin-top: 8px;">';
			// print '<a href="./index.php?action=delete&id='. $obj->id .'&mid='. $obj->market_id .'">'.$langs->trans('Delete').'</a>';
			print '</div></td>';

			print '</tr>'."\n";

		}
		print '<tr class="liste_titre ">';
		print '<td align="center" colspan="2">';
		print "<b>Total</b>";
		print '</td>';
		print '<td align="center" style ="white-space: nowrap;" class="nomchantierwidth">';
		print "<b>".number_format($tot_ttc,  2, ",", " ")."</b>";
		print '</td>';
		print '<td><div style="float: right; margin-top: 8px;">';
		// print '<a href="./index.php?action=delete&id='. $obj->id .'&mid='. $obj->market_id .'">'.$langs->trans('Delete').'</a>';
		print '</div></td>';

		print '</tr>'."\n";
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';

	// print '<br>';
	print '<div style="text-align: right; margin-top: 8px;">';
	print '<a href="./card.php?action=add&mid='. $mid .'" class="butAction">'.$langs->trans('AddMarketFactures').'</a>';
	print '</div>';
}

llxFooter();

$db->close();


?>