<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/market/market_factures/class/market_factures.class.php');
dol_include_once('/btp/market/market/imputationchantier/class/imputationchantier.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');


// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$fuser   = new User($db);
$action  = GETPOST('action', 'alpha');
$id      = GETPOST('id', 'int');
$mid     = GETPOST('mid', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$mid && $request_method !== 'POST')
    die('ID marché n\'existe pas!');

$now 	= new \DateTime('now');
$now    = $now->format('Y-m-d');
$form   = new Form($db);
$error 	= false;
$MarketFactures = new MarketFactures($db);
$market           = new Market($db);
$imputationchantier= new imputationchantier($db);

if ($action == 'create' && $request_method === 'POST' && !empty($_POST['market_id_'])) {
    $facture_id     = trim(GETPOST('facture_id_'));
    $market_id      = (int)trim(GETPOST('market_id_'));

    if (empty($facture_id)) {
        header("Location: card.php?action=add&mid=".$market_id."&msg=Remplir tous les champs");
        die();
    }

    if (!$error) {
        $MarketFactures->facture_id          = $facture_id;
        $MarketFactures->market_id          = $market_id;
        $MarketFacturesID = $MarketFactures->create();
    
        // If no SQL error we redirect to the request card
        if ($MarketFacturesID > 0) {
            //header('Location: index.php?id='.$getMarcheID);
            header('Location: index.php?id='.$MarketFacturesID.'&mid='.$market_id);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: card.php?action=request&error=SQL_Create&msg='.$MarketFactures->error);
            exit;
        }
    }
}

if ($action == 'update' && $request_method === 'POST' && (!empty($_POST['id']) && !empty($_POST['market_id_']))) {
    // If no right to modify a request
    /*if (!$fuser->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $facture_id    = (int)trim(GETPOST('facture_id_'));
    $market_id     = (int)trim(GETPOST('market_id_'));
    $id            = (int)trim(GETPOST('id'));

    if ($id <= 0 || $facture_id <= 0 ) {
        header("Location: index.php?mid=".$market_id);
        die();
    }

    // If this is the requestor or has read/write rights
    $data = array(
      'facture_id'  => $facture_id,
      'market_id'    => $market_id,
    );

	$getMarketFacturesID = $MarketFactures->update($id, $data);

    if ($getMarketFacturesID > 0) {
        header('Location: ./index.php?id='.$id.'&mid='.$market_id);
        exit;
    } else {
        // Otherwise we display the request form with the SQL error message
        header('Location: ./card.php?id='. $id .'&action=edit&error=SQL_Create&msg='.$MarketFactures->error);
        exit;
    } 
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;
	//$canedit = ($fuser->rights->marches->write_all || $fuser->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$MarketFactures->delete($id);
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		header('Location: index.php?mid='.$mid);
		exit;
	}
	else {
        header('Location: index.php?mid='.$mid);
        exit;
	}
}

/*
 * View
 */
$market->fetch($mid);

$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('MarketFactures'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($fuser->rights->marches->write) || empty($fuser->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('AddMarketFactures'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        $head  = market_prepare_head($market);
        dol_fiche_head($head, 'Factures', $langs->trans("Factures"), 0, '');

        echo $market->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="market_id_" value="'. $mid .'" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        // Facture
        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Facture").'</td><td>';
        print $MarketFactures->select_with_filter(0,'facture_id_',1,"rowid","facnumber","","required");
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("CreateMarketFactures") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $MarketFactures->fetch($id);

			//$canedit = ($fuser->rights->marches->delete || $fuser->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndnameP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {
        $MarketFactures->fetch($id);
        $head  = market_prepare_head($market);
        dol_fiche_head($head, 'Factures', $langs->trans("Factures"), 0, '');

        echo $market->getMarketHeader();

        if ($action == 'edit') {
            $edit = true;
            print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
            print '<input type="hidden" name="action" value="update" />'."\n";
            print '<input type="hidden" name="id" value="'.$id.'" />'."\n";
            print '<input type="hidden" name="market_id_" value="'. $mid .'" />'."\n";

            print '<table class="border" width="100%">';
            print '<tbody>';

            // Facture
            print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Facture").'</td><td>';
            print $MarketFactures->select_with_filter($MarketFactures->facture_id,'facture_id_',0,"rowid","facnumber",$id,"required");
            print '</td></tr>';

            print '</tbody>';
            print '</table>';

            print '<div class="center">';
            print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
            print '&nbsp; &nbsp; ';
            print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
            print '</div>';
            print '</table>';
        }

        dol_fiche_end();

        if (!$edit) {
            print '<div class="tabsAction">';

            // Boutons d'actions
            //if ($canedit) {
                print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
            //}

            // If draft
           // if ($fuser->rights->marches->delete)	{
            	print '<a href="index.php?id='.$id.'&mid='. $mid .'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
           // }

            print '</div>';
        }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>