<?php
/* Copyright (C) Yassine Belkaid  y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/marekt/market_commandes/market_commandes.class.php
 * \ingroup btp
 * \brief   This file is market_commandes CRUD class file
 *
 */

dol_include_once('/btp/db/nxdb.class.php');

class MarketCommandes extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();

	
	public $market_id;
	public $commande_id;
	public $commande_type;
	public $rows = array();
	public $now;

	public $table_element = 'market_commandes';
	public $element = 'market_commandes';

	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = date('Y-m-d');//$this->now->format('Y-m-d');
		$this->updated_at = $this->now;
		return 1;
	}

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="ref",$id='',$attr='',$list=false,$type_cmnd=""){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    if ($conf->use_javascript_ajax)
	    {
	        include_once DOL_DOCUMENT_ROOT . '/core/lib/ajax.lib.php';
	        $comboenhancement = ajax_combobox('select_'.$id);
	        $moreforfilter.=$comboenhancement;
	        $nodatarole=($comboenhancement?' data-role="none"':'');
	    }

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$cmnd_table = "commande";
    	// echo $type_cmnd;
	    if($type_cmnd == "Fournisseurs")
	    	$cmnd_table = "commande_fournisseur";

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.$cmnd_table." WHERE fk_statut > 0 ";
    	if ($list == false) {
	    	$sql .= "AND rowid NOT IN (SELECT commande_id FROM ".MAIN_DB_PREFIX."market_commandes where commande_type = '".$type_cmnd."'";
	    	if ($selected>0)
	    		$sql .= " and rowid != ".$id;
    		$sql .= ")";
    	}
		//echo $sql."<br>";
    	// die($sql);
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

	function liste_chantier_array($market_id='')
    {
        global $conf;

        $projects = array();

        $sql = "SELECT rowid, name";
        $sql.= " FROM " . MAIN_DB_PREFIX .$this->table_element;
        if (! empty($market_id)) $sql.= " WHERE market_id = " . $market_id;

        // echo $sql;
        // die();
        $resql = $this->db->query($sql);
        if ($resql)
        {
            $nump = $this->db->num_rows($resql);

            if ($nump)
            {
                $i = 0;
                while ($i < $nump)
                {
                    $obj = $this->db->fetch_object($resql);

                    $projects[$obj->rowid] = $obj->name;
                    $i++;
                }
            }
            return $projects;
        }
        else
        {
            print $this->db->lasterror();
        }
    }

	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0, $id, $ref, $mid, $type_cmnd)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/market/market_commandes/index.php?id='. $id .'&mid='. $mid .'&type_cmnd='.$type_cmnd,1).'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip nowrap_cls">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        if ($setRef != "") {
        	$result = $link."<div class='icon-empty_folder mainvmenu'></div>  ".$setRef.$linkend;
        }else{
        	$result = "-";
        }
        return $result;
    }

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
	  	$this->market_id = $this->market_id ? $this->db->escape($this->market_id): null;
	  	$this->commande_id	= $this->commande_id ? $this->db->escape($this->commande_id): null;
	  	$this->commande_type	= $this->commande_type ? $this->db->escape($this->commande_type): null;
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'market_commandes' . ' (market_id,commande_id,commande_type) ';
		$sql .= 'VALUES ('.$this->market_id.', '.$this->commande_id.', "'.$this->commande_type.'")';

		// die($sql);

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error market_commandes ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
			die();
			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $market_id = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'market_commandes';
		
		if (null !== $market_id) {
			$sql .= ' WHERE market_id = '. (int)$market_id;
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->id 			= $obj->rowid;
			  $this->market_id 	    = $obj->market_id;
			  $this->commande_id		= $obj->commande_id;
			  $this->commande_type		= $obj->commande_type;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($mid = null, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $exculded_id = null, $ignore_id = false,$client_fournisseur="")
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'market_commandes ';

		// if (null !== $mid) {
		// 	$sql .= 'WHERE market_id = '. (int)$mid;
		// }

		// if (!empty($filter)) {
		// 	$sql .= 'WHERE '. $filter;
		// }
		
		if (null !== $mid) {
			$sql .= 'WHERE market_id = '. (int)$mid;
			if (!empty($filter))
				$sql .= " ".$filter;
		}else{
			if(!empty($filter))
				$sql .= ' WHERE '. $filter;
		}
		
		if (null !== $exculded_id) {
			$sql .= " AND rowid <> ". (int)$exculded_id;
		}

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}
		 if(!empty($limit)){
         $sql.= " limit  ".$limit ;
		}
		// die($sql);
		$this->rows = array();
		$resql 		= $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->id 			= $obj->rowid;
				$line->market_id 	= $obj->market_id ;
				$line->commande_id	= $obj->commande_id ;
				$line->commande_type	= $obj->commande_type ;
				$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}



	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'market_commandes SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = rtrim($sql, ',');
		$sql .= ' WHERE rowid = ' . $id;

		// die($sql);

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'market_commandes' .' WHERE rowid = ' . (int)$id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	public function getNames($mid = null, $exculded_id = null)
    {
    	$this->fetchAll($mid, '', '', 0, 0, '', $exculded_id);
    	$names = array();

    	if (count($this->rows))
    	foreach ($this->rows as $key => $line) {
			$names[$line->id] = $line->name;    		
    	}

    	return $names;
    }

}

?>