<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

dol_include_once('/btp/market/market/imputationchantier/class/imputationchantier.class.php');
// Protection if external user
if (!$user) accessforbidden();
$langs->load('users');
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$tasktab   = GETPOST("tasktab",'int');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;

$filter = '';

if (! $sortfield) $sortfield = "";
if (! $sortorder) $sortorder = "";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$action   = GETPOST('action','alpha');
$id 	  = GETPOST('id','int');

$search_mois = GETPOST('search_mois');
$search_annee = GETPOST('search_annee');
$search_nom = GETPOST('search_nom');
$search_projet = GETPOST('search_projet');
/**
 * Actions
 */

// None

/**
 * View
 */
$imputationchantier = new imputationchantier($db);
$user_array=new User($db);
$param='';

$group="";
// Filter
$filter .= (isset($search_mois) && !empty($search_mois)) ? " and p.month_point =". $db->escape($search_mois) ."" : "";

$param .= (isset($search_mois) && !empty($search_mois)) ?"&search_mois=".$search_mois."" : "";

$filter .= (!empty($search_annee) && $search_annee != -1) ? " and p.year_point =".$db->escape($search_annee) : "";
$param .= (isset($search_annee) && !empty($search_annee)) ?"&search_annee=".$search_annee."" : "";
$filter .= (isset($search_nom) && !empty($search_nom)) ? " and CONCAT( u.lastname,'', u.firstname ) LIKE  '%". $db->escape($search_nom) ."%'" : "";
$param .= (isset($search_nom) && !empty($search_nom)) ? "$search_nom=".$search_nom : "";
$filter .= (!empty($search_projet) && $search_projet != -1) ? " and p.fk_chantier =".$db->escape($search_projet) : "";
$param .= (!empty($search_projet) && $search_projet != -1) ? "$search_projet =".$search_projet : "";

/*************************************
 * Fin des filtres de recherche
*************************************/
// Récupération de l'ID de l'utilisateur
$limit= $conf->liste_limit;
$getresults=$imputationchantier->fetchAll($sortorder, $sortfield, $limit + 1, $offset, $filter,'','');
if (!empty($getresults)  && $action == "xsl" ) {
$filename="Situation_salaires.xls";
      dol_include_once('/btp/rh/imputationchantier/tpl/statusSalary_xsl.php');
 die();
 
}
llxHeader(array(), $langs->trans('statusSalary'),'','','','',array('/btp/js/btp.js'));
// Si erreur SQL
// Show table of vacations
$var 		= true;
$num 		= count($imputationchantier->rows);
$form 		= new Form($db);
$formother 	= new FormOther($db);
$chantier = new Project($db);
	print_barre_liste($langs->trans("statusSalary"), $page, $_SERVER["PHP_SELF"],$param, $sortfield, $sortorder, "", $num,"", 'title_project.png');
              print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_mois" value="'. $search_mois .'" type="hidden" />';
print '<input name="search_annee" value="'. $search_annee .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
print '<input name="search_nom" value="'. $search_nom .'" type="hidden" />';
print '<input name="search_projet" value="'. $search_projet .'" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';     
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<table class="liste"" width="100%;">';


	print "<tr class=\"liste_titre\">";
	
   
		print '<td  colspan="10" align="center" style="padding: 18px 15px !important;">';

print $langs->trans('User');
print ' <input class="butAction" type="text" name="search_nom" value="'.$search_nom.'" style="
    width: 100px;">';
print $langs->trans('mount');
	print '<select class="butAction" name="search_mois" class="liste_titre" ><option></option>';
	$select="";
		for ($i=1; $i <13 ; $i++) { 
			if($i==$search_mois){
				$select="selected=selected";
			}
			print "<option value=".$i." ".$select.">$i</option>";
			$select="";
		}
	print '</select>';
	
	print $langs->trans('Year');
    
	print"<select class='butAction' name='search_annee'><option></option>";
		$selec="";
		for ($i=2000; $i <2041 ; $i++) { 
			if($i==$search_annee){
				$selec="selected=selected";
			}
			print "<option value=".$i." ".$selec.">$i</option>";
			$selec="";
		}
	print '</select>';
	


	 	print '<div style="float: right;">';

        // Boutons d'actions
        print '<input style="margin: 1px !important;" type="submit" class="butAction" value="'. $langs->trans('Search') .'">';
        
        print '</div>';
		print $langs->trans("Chantier")."<select name='search_projet' ><option></option>";
  foreach ($chantier->liste_array() as $key => $line) {
  	     if($key==$search_projet){
  		print '<option value="'.$key.'" selected>'.$line.'</option>'
  	;}else{

		print '<option value="'.$key.'">'.$line.'</option>';
  }	
  }
print '</select>';

	print'</td></tr>';

	print "<tr class=\"liste_titre\">";
	
	print_liste_field_titre($langs->trans("Names"),$_SERVER["PHP_SELF"], "", '', '', 'align="center"');
	print_liste_field_titre($langs->trans("Qualif"),$_SERVER["PHP_SELF"],"", '','','align="center"');
    
	print_liste_field_titre($langs->trans("SalaryJour"),$_SERVER["PHP_SELF"],"", '','','align="center"');
	print_liste_field_titre($langs->trans("nbjour"), $_SERVER["PHP_SELF"], '', '', '', 'align="center"');
	print_liste_field_titre($langs->trans("salaryBrut"),$_SERVER["PHP_SELF"], '', '', '', 'align="center"');
	print_liste_field_titre($langs->trans("avance"),$_SERVER["PHP_SELF"], '', '', '','align="center"');
	print_liste_field_titre($langs->trans("SalaryNet"),$_SERVER["PHP_SELF"], '', '', '', 'align="center"');
	print_liste_field_titre($langs->trans("Signature"),$_SERVER["PHP_SELF"],"","",'','align="center"');
	
	print "</tr>\n";


	// Lines
	 
	if (!empty($imputationchantier->rows)) {
          $totalnet=0;
      
		foreach($imputationchantier->rows as $line) {
			$var = !$var;

			$monthpoint	= $line->month_point;
			$yearpoint = $line->year_point ;
			if (!$filter) {
					$filter .= " and p.month_point =".$line->month_point;
			    	$filter .= " and p.year_point =".$line->year_point;
			    	$filter .= " and p.fk_chantier =".$line->fk_chantier;
			}
			
            $user_array->fetch($line->fk_user);
			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="15%" style="white-space: nowrap">';
				print $user_array->getNomUrl($line->fk_user);
			print '</td>';
	
			print '<td align="center">'. $user_array->job .'</td>';
			
			print '<td align="center">'.number_format($user_array->salary,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			$val=$imputationchantier->fetchStatus($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter,'',' and p.type="J" and p.fk_user='.$line->fk_user);
			print '<td align="center">'. number_format($val,  2, ",", " ") .'</td>';
			if($user_array->salary>200){
				$salbrut=$user_array->salary;
			  }
			else{
				$salbrut=($user_array->salary*$val);
			}
			print '<td align="center">'. number_format($salbrut,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td>';

			$valeur=$imputationchantier->fetchStatus($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter,'',' and p.type="AV" and p.fk_user='.$line->fk_user);
			print '<td align="center">'. number_format($valeur,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			$salnet=$salbrut-$valeur;
			print '<td align="center">'.number_format($salnet,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
		  	print '<td align="center"></td>';
			print '</tr>';
           $totalnet=$totalnet+$salnet;
           $filter='';
		} 
		print '<tr>';
	    print '<td colspan="2" align="center"><b>'.$langs->trans('totals').'</b></td>';
	    print '<td></td>';
	    print '<td></td>';
	    print '<td></td>';
	    print '<td></td>';
	    print '<td align="center"><b>'.number_format($totalnet,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</b></td>';
	    print '</tr>';  

	}else
	{
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	
	}
	print '</table>';
	print '</form>';

llxFooter();

$db->close();

?>