<?php
/* Copyright (C) 2016 Yassine Belkaid <y.belkaid@nextconcept.ma>
*
*/

/**
* \file       appeloffres/index.php
* \ingroup    list
* \brief      List of groupements
*/


$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/market/groupement/class/groupement.class.php');

dol_include_once('/btp/class/tender.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
require_once DOL_DOCUMENT_ROOT.'/contact/class/contact.class.php';
dol_include_once('/btp/lib/btpgroupement.lib.php');

$langs->load('users');
// Protection if external user
if (!$user) accessforbidden();

$var    = false;
$filter   = '';
$sortfield  = GETPOST("sortfield",'alpha');
$sortorder  = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action');

$id    = GETPOST('id','int');
$groupement     = new groupement($db);
$socstatic=new Societe($db);
$types=[0 =>"Solidaire", 1=>"Conjoint"];

/*if (!$mid)
die('ID marché n\'existe pas!');
*/



$form         = new Form($db);
$search_march = GETPOST('search_march');
$search_datef= GETPOST('search_datef');
$search_datec     = GETPOST('search_datec');
$search_obj     = GETPOST('search_obj');
$search_type    = GETPOST('search_type','int');

$search_city     = GETPOST('search_city');
$maitreov     = GETPOST('maitreov');







// Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_datec      = "";
$search_march = "";
$search_datef= "";
$search_obj    = "";
$search_city    = "";
$search_type    = "";
$maitreov  = "";


}
if($search_datec){
list($etd, $etm, $ety) = explode("/", $search_datec);

$search_datec=$ety.'-'.$etm.'-'.$etd ;    
}
if($search_datef){
list($etdd, $etmm, $etyy) = explode("/", $search_datef);

$search_datef=$etyy.'-'.$etmm.'-'.$etdd ;    
}
$filter="";

$filter.= (!empty($search_datec) && $search_datec!=-1)?" and  g.dateStart = '".$db->escape($search_datec)."'":"";
$filter.= (!empty($search_datef) && $search_datef!=-1)?" and g.dateFin= '".$db->escape($search_datef)."'":"";
$filter.= (!empty($search_obj) && $search_obj!=-1)?" and g.subject like '%".$db->escape($search_obj)."%'":"";

$filter.= (!empty($search_march) && $search_march!=-1)?" and g.idmarche ='".$db->escape($search_march)."'":"";

$filter.= (!empty($search_city) && $search_city!=-1)?" and g.city ='".$db->escape($search_city)."'":"";
$filter.= (!empty($maitreov) && $maitreov!=-1)?" and s.rowid ='".$db->escape($maitreov)."'":"";
$filter.= ($search_type!="" && $search_type!=-1)?" and g.type ='".$db->escape($search_type)."'":"";
 $getMarchesList=$groupement->fetchAll($filter);
if (!empty($getMarchesList)  && $action == "xsl" ) {
$filename="groupement.xls";
      dol_include_once('/btp/market/groupement/tpl/groupement_xsl.php');
 die();
 
}
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/groupement.js");

$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('work_advances'),'','','','',$morejs,$morecss,0,0);

print '<link rel="stylesheet" href= "'.dol_buildpath('/btp/css/fontawesome.css',2).'">';

if ($id > 0) {
    $group    = new groupement($db);
    $group->fetchgroup($id);
    $title = $langs->trans("Detailgroup");
    print_fiche_titre($title,'','');
    $head = groupement_prepare_head($group);
    dol_fiche_head($head, 'contractFile', $langs->trans("ContractFile"), 0, '');


    print '<table class="border" width="100%" id="rechargement">';
    // Ref

    print '<tr >';
    print '<th  class="fieldrequired">'.$langs->trans("refMarket").'</th>';
    print '<th  class="fieldrequired">'.$langs->trans("City").'</th>';
    print '<th  class="fieldrequired">'.$langs->trans("Subject").'</th>';
    print '<th  class="fieldrequired">'.$langs->trans("ContDateEtab").'</th>';
    print '<th  class="fieldrequired">'.$langs->trans("DtProvi").'</th>';
    print '<th  class="fieldrequired">'.$langs->trans("AmountTtc").'</th>';
    print '<th   class="fieldrequired">'.$langs->trans("type").'</th>';

    print '<th  class="fieldrequired">'.$langs->trans("groupement").'</th>';
    print '<th  class="fieldrequired">'.$langs->trans("contactofgroup").'</th>';


    print '<th   class="fieldrequired">'.$langs->trans("lot").'</th>';



    print '</tr>';


    print '<tr  class="ligne">';

    $market = new Market($db);
    $tenders    = new Tender($db);
    $socstatic = new Societe($db);

    $market->fetch($group->idmarche);
    $groupement->fetchbyidsoc($id);  

    $count =count($groupement->rows);
    $fullSubject = str_replace(array("\r\n", "\n"), "", nl2br(strip_tags($group->subject)));
    $subject = substr($group->subject, 0, 100);
    $subject = strlen($group->subject) > 100 ? $subject.'...' : $subject;

    print '<td align="left"  rowspan="'.  $count.'" >'.  $market->getNomUrl(1,  $group->idmarche,$market->code).'</td>';
    print '<td align="center"  rowspan="'.  $count.'" >'.  $group->city.'</td>';
    print '<td align="center"  rowspan="'.  $count.'" ><span class="classfortooltip" title="'. $fullSubject .'">'.  $subject.'</span></td>';
    print '<td align="center"  rowspan="'.  $count.'" >'.  dol_print_date($group->dateStart, 'day').'</td>';
    print '<td align="center"  rowspan="'.  $count.'" >'.  dol_print_date($group->dateFin, 'day').'</td>';
    print '<td align="center"  rowspan="'.  $count.'" >'.  number_format($group->amount,  2, ",", " ").'</td>';
    print '<td align="center"  rowspan="'.  $count.'" >'.   $types[$group->type].'</td>';
    // print_r($groupement->rows);
    if ($count) {
        $i = 0;
        foreach($groupement->rows as $li ) {
            if($li->fk_idsoc > 0){
                if($i > 0) print '<tr id="'.$i.'" class="ligne">';

                $socs= new Societe($db);
                $contactstatic=new Contact($db);
                $contactstatic->fetch($li->contact);
                $soc = '';
                    $socs->fetch($li->fk_idsoc);
                    $soc = $socs->getNomUrl(1);

                print '<td align="center" id="td1">'.$soc .'</td>';
                print '<td align="center" id="td2">'.dol_trunc($contactstatic->firstname,20).' ' .dol_trunc($contactstatic->lastname,20).'</td>';
                print '<td align="center" id="td3">'.$li->lot .'</td>';

                print '<input type="hidden"  name="idgroupsoc" id ="idgroupsoc" value="'. $li->rowid .'" />'; 
                print '<input type="hidden"  name="id" id ="rid" value="'. $id .'" />';    
                print '<input id="url" type="hidden" name="url" value="'. $dolibarr_main_url_root.'" />'."\n"; 

                print '</tr>';
                $i++;
            }
            // print '<tr id="'.$i.'" class="ligne">'; 
        }
    }



    print '</table>';
    print '<br>';
    print '</table>';
    print '<div align="right">'; 
    print '<input id="url" type="hidden" name="url" value="'. $dolibarr_main_url_root.'" />'."\n"; 
    print '<input id="mid" type="hidden" name="mid" value="'. $mid.'" />'."\n"; 


    print '</div>';
    print '<br>';
    print '<div style="float: right; margin-top: 8px;">';
    print '<a href="./index.php" class="butAction">'.$langs->trans('Cancel').'</a>';

    print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
    print '<a class="butAction" href="./index.php?action=delete&id='. $id .'">'.$langs->trans('Delete').'</a>';

    print '</div>';
    print '</form>';
    if ($action == 'delete')
    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
}
else {
            print_barre_liste($langs->trans("ListOfgroup"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

  print '<div style="float: right; margin-bottom: 6px;">';
      print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addg').'</a>';
      print '</div>';
      print '<div style="float: right; ">';
       print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_march" value="'. $search_march .'" type="hidden" />';
print '<input name="search_datef" value="'. $search_datef .'" type="hidden" />';
print '<input name="search_datec" value="'. $search_datec .'" type="hidden" />';
print '<input name="search_obj" value="'. $search_obj .'" type="hidden" />';
print '<input name="search_type" value="'. $search_type .'" type="hidden" />';
print '<input name="search_city" value="'. $search_city .'" type="hidden" />';
print '<input name="maitreov" value="'. $maitreov .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';

        print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
       print '</form>'."\n";
        print '</div>'; 
            print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
            print '<input name="id" value="'. $id .'" type="hidden" />';
            print '<table class="noborder" width="100%;">';
            print "<tr class=\"liste_titre\">";

            print_liste_field_titre($langs->trans("refMarket"),$_SERVER["PHP_SELF"],"name", '',$moreparam,'align="center"',$sortfield,$sortorder);

            print_liste_field_titre($langs->trans("ThirdPartyMarket"), $_SERVER["PHP_SELF"], 'idmarche', '', $moreparam, 'align="center"', $sortfield, $sortorder);

            print_liste_field_titre($langs->trans("Subject"), $_SERVER["PHP_SELF"], 'subject', '', $moreparam, 'align="center"', $sortfield, $sortorder);

            print_liste_field_titre($langs->trans("groupement"), $_SERVER["PHP_SELF"], 'amount', '', $moreparam, 'align="center"', $sortfield, $sortorder);
            print_liste_field_titre($langs->trans("City"), $_SERVER["PHP_SELF"], 'city', '', '', 'align="center"', $sortfield, $sortorder);
            print_liste_field_titre($langs->trans("StartDate"),$_SERVER["PHP_SELF"], 'dateStart', '', '', 'align="center"', $sortfield, $sortorder);
            print_liste_field_titre($langs->trans("DtProvi"),$_SERVER["PHP_SELF"], 'dateFin', '', '', 'align="center"', $sortfield, $sortorder);
            print_liste_field_titre($langs->trans("Amount"),$_SERVER["PHP_SELF"], 'amount', '', '', 'align="center"', $sortfield, $sortorder);
             print_liste_field_titre($langs->trans("Type"),$_SERVER["PHP_SELF"], 'type', '', '', 'align="center"', $sortfield, $sortorder);
            print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
            print "</tr>\n";

            // FILTRES
            print '<tr class="liste_titre nc_filtrage_tr">';
            // name
            print '<td class="liste_titre" colspan="1" align="center">';
            $market = new Market($db);

            print $form->selectarray('search_march',$market->getNames2(), $search_march, 1, 0, 0, 'required="required"');
            print '</td>';
            print '<td class="liste_titre" colspan="1" align="center">';              
       
                 $filteronlist='';
            if (! empty($conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST)) $filteronlist=$conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST;
            $text=$form->select_thirdparty_list(GETPOST('socid','int'),'maitreov',$filteronlist,1,1,0, array(),'',0, 0, 'maxwidth200');
            if (empty($conf->global->PROJECT_CAN_ALWAYS_LINK_TO_ALL_SUPPLIERS) && empty($conf->dol_use_jmobile))
            {
                $texthelp=$langs->trans("IfNeedToUseOhterObjectKeepEmpty");
                print $form->textwithtooltip($text.' '.img_help(),$texthelp,1);
            }
            else print $text;
         

            print '</td>';
            print '<td class="liste_titre" colspan="1" align="center">';

            print '<input type="text"   name=" search_obj"  value="'.$search_obj.'" /> ';
            print '</td>';
            print '<td class="liste_titre" colspan="1" width="150px" align="center">';
            print '</td>';
            print '<td class="liste_titre" colspan="1" align="center">';
            print '<input type="text"   name=" search_city" value="'.$search_city.'" /> ';

            print '</td>';
            // amount
            print '<td class="liste_titre" olspan="1" align="center">';
            print '<input type="text" class="datepickers"  name="search_datec" required="required"  readonly="readonly" value="'.$search_datec.'" /> ';

            print '</td>';
            // adress
            print '<td class="liste_titre" colspan="1" align="center">';
            print '<input type="text" class="datepickerf"  name="search_datef" required="required"  readonly="readonly" value="'.$search_datef.'" /> ';
            print '</td>';
             print '<td class="liste_titre" colspan="1" align="center">';
            print '</td>';
             print '<td class="liste_titre" colspan="1" align="center">';
          

            print $form->selectarray('search_type',$types, $search_type, 1, 0, 0, 'required="required"');
            print '</td>';
            // ACTION
            print '<td align="right">';
            print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
            print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
            print '</td>';

            print "</tr>\n";


           


            if ( $groupement->rows && count($groupement->rows) >0 ) {

            foreach($groupement->rows as $line) {
            $var = !$var;

            $socstatic->id=$line->rowid;
            $city=$line->city;
            $amount=$line->amount;
            $dateStart=$line->dateStart;
            $dateFin=$line->dateFin;
            $type=$line->type;
            $fullSubject = str_replace(array("\r\n", "\n"), "", nl2br(strip_tags($line->subject)));
            $subject = substr($line->subject, 0, 70);
            $subject = strlen($line->subject) > 70 ? $subject.'...' : $subject;

            print '<tr '.$bc[$var].'>';
            print '<td align="left" >';
            $market = new Market($db);
            $tenders    = new Tender($db);
            $socstatic = new Societe($db);

            $market->fetch($line->idmarche);
            $tenders->fetch($market->fk_tender);
            $socstatic->fetch($tenders->fk_third_party);

            print $groupement->getNomUrl(1,  $line->rowid, $market->code );

            print '</td>';
            $groupt     = new groupement($db);

            $groupt->fetchbyidsoc($line->rowid);
            $idsoc= ''; 

            print '<td align="center">'.  $socstatic->getNomUrl(1) .'</td>';
            print '<td align="left"><span class="classfortooltip" title="'. $fullSubject .'">'.  $subject .'</span></td>';
            if ($groupt->rows && count($groupt->rows) >0 ) {
                foreach($groupt->rows as $li ) {
                    $socs= new Societe($db);
                    $socs->fetch($li->fk_idsoc);

                    $soc = '';
                    if($li->fk_idsoc > 0){
                        $soc =$socs->getNomUrl(1);
                        $idsoc.=$soc."<br>" ;
                    }

                }
            }

            print '<td align="left">'.  $idsoc .'</td>';
            print '<td align="center">'.  $city .'</td>';
            print '<td align="center">'.  dol_print_date($dateStart, 'day') .'</td>';
            print '<td align="center">'.  dol_print_date($dateFin, 'day') .'</td>';
            print '<td align="center" class="montant_td">'.  number_format($amount,  2, ",", " ") .'</td>';
            print '<td align="center">'.  ($type ? ' Conjoint' : ' Solidaire') .'</td>';

            print '<td></td>';
            print '</tr>';


            }


            }


          else {
          print '<tr>';
          print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
          print '</tr>';
          }
      print '</table>';
      print '</form>';


    
}

llxFooter();

$db->close();


?>
