<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/executions/index.php
 * \ingroup    list
 * \brief      List of executions related to given mid
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/market/executions/class/execution.class.php');
dol_include_once('/btp/market/paymentmanagement/class/paymentmanagement.class.php');

$langs->load('users');
$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page 	   = GETPOST("page",'int');
$page 	   = is_numeric($page) ? $page : 0;
$page 	   = $page == -1 ? 0 : $page;
$filter    = '';
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";

$offset  = $conf->liste_limit * $page;
$pageprev= $page - 1;
$pagenext= $page + 1;
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id', 'int');
$action	 = GETPOST('action', 'alpha');
$confirm = GETPOST('confirm', 'alpha');

if (!$mid)
	die('ID marché n\'existe pas!');

$object = new Executions($db);
$marche = new Market($db);
$account= new Account($db);
$form   = new Form($db);

/**
 * Actions
 */

// None

/**
 * View
 */

$morejs  = array("/btp/js/marches.js", "/btp/js/payment.js");
llxHeader(array(), $langs->trans('ExecutionFile'),'','','','',$morejs,array(),0,0);
print '<script>var main_dir = "'. $dolibarr_main_url_root .'"</script>';

// Récupération de l'ID de l'utilisateur
$getexecutions = $object->fetchAll($mid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, '');

// Si erreur SQL
if ($getexecutions == '-1') {
    print_fiche_titre($langs->trans('ExecutionFile'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

if ($id) {
	$object->fetch($id);
} else {
	$object->fetch(0, $mid);
	$id = $object->id;
}

$marche->fetch($mid);
	print_fiche_titre($langs->trans('ExecutionFile'), '', 'title_project.png');
$title = $langs->trans("ExecutionFile");
$head  = market_prepare_head($marche);
dol_fiche_head($head, 'execution', $langs->trans('ExecutionPhase'), 0, '');

$head_btm = phase_execution_prepare_head($marche);
dol_fiche_head($head_btm, 'executions', $title, 0, 'submunu');
echo $marche->getMarketHeader();

$ref 		= '';
$amount 	= 0;
$start_date = '';
$months 	= 0;
$days 		= 0;
$end_date 	= '';
$status 	= 0;

if ($id) {
	if ($object->fk_bank)
		$account->fetch($object->fk_bank);
	$amount 	= ($object->amount != '0.00' ? $object->amount : 0);
	$ref	  	= $object->ref ? $object->ref : '';
	$start_date	= $object->start_date ? dol_print_date($object->start_date, 'day') : '';
	$sig_date	= $object->sig_date ? dol_print_date($object->sig_date, 'day') : '';
	$deposit_date= $object->deposit_date ? dol_print_date($object->deposit_date, 'day') : '';
	$months	  	= $object->months ? $object->months : 0;
	$days	  	= $object->days ? $object->days : 0;
	$end_date 	= $start_date ? Tools::getEndDatFromDays($start_date, $months, $days)->format('d/m/Y') : '';
	$status	  	= $object->statut ? $object->statut : 0;
}

print_barre_liste($langs->trans("DelaySection"), '', '', '', '', '', "", 0, 0, 'title.gif');
print '<table class="border" width="100%">';
print '<tbody>';
print '<tr><td width="25%">'.$langs->trans("CommenceDate").'</td><td>';
  	if ($id) {
		print '<span class="start_date_static">'. $start_date .'</span>';
		print '<input id="start_date" name="start_date" class="datepicker hidden" type="text" required="required"   value="'. $start_date .'" />';
  	} else {
		print '<span class="start_date_static hidden"></span>';
		print '<input id="start_date" name="start_date" class="datepicker" autocomplete="off"  type="text" required="required"   />';
	}
print '</td></tr>';
print '<tr><td class="">'.$langs->trans("ExecutionDelay").'</td><td>';
  if ($id) {
  	print '<div class="mon_day"><span class="months_static">'.$months.' </span> '. $langs->trans("Months").' &nbsp;&nbsp;<span class="days_static">'.$days.' </span> '. $langs->trans("Days") .'</div>';
  	print '<div class="mon_day_inp hidden"><input id="months" name="months" type="number" min="0" required="required" value="'. $months .'" /> '. $langs->trans('Months').' &nbsp;&nbsp;&nbsp;<input id="days" name="days" type="number" min="0" value="'. $days .'" /> '. $langs->trans('Days');  	
  } else {
  	print '<div class="mon_day hidden"><span class="months_static"></span> '. $langs->trans("Months").' &nbsp;&nbsp;<span class="days_static"></span> '. $langs->trans("Days") .'</div>';
  	print '<div class="mon_day_inp"><input id="months" name="months" type="number" min="0" required="required" value="0" /> '. $langs->trans('Months').' &nbsp;&nbsp;&nbsp;<input id="days" name="days"  min="0" type="number" value="0" /> '. $langs->trans('Days');
  } 
print '</td></tr>';
print '<tr><td class="">'.$langs->trans("EndDateProvisional").'</td><td>';
print '<span class="end_date_static">'. $end_date .'</span>';
print '</td></tr>';
print '<tr><td colspan="2" align="center">';
if ($id)
	print '<a id="addExeTime" data-exec-id="'. $id .'" data-oper="2" data-mid="'. $mid .'" href="javascript:void(0);" class="butAction">'.$langs->trans('Modify').'</a>';
else
	print '<a id="addExeTime" data-exec-id="0" data-oper="1" data-mid="'. $mid .'" href="javascript:void(0);" class="butAction">'.$langs->trans('Add').'</a>';
print '</td></tr>';

print '</tbody>';
print '</table><br />';

$checkedMan  = ($id && $status == 2 ? 'checked="checked"' : ''); 
$checkedAuto = ($id && $status == 1 ? 'checked="checked"' : '');
$checkedZero = '';
$rgOpac 	 = '';

if ($status == 0) {
	$checkedZero = 'checked="checked"';
	$rgOpac 	 = $autoOpac = ' opacity:0.5;';
	$checkedMan  = $checkedAuto = '';
} else if ($status == 1) {
	$checkedZero = '';
	$rgOpac 	 = ' opacity:0.5;';
} else if ($status == 2) {
	$checkedZero = '';
	$autoOpac 	 = ' opacity:0.5;';
}

$addBtnTitle = ($id ? 'Modify' : 'Add');
$addBtn 	 = 'addManualRG';
$updateData	 = ($id ? 1 : 0);
// $widthPercentage = (!empty($amount) ? '100' : '50');
$widthPercentage = '50';

print '<table class="" width="100%">';
print '<tbody>';
	print '<tr><td width="'. $widthPercentage .'%" align="left">';
		print_barre_liste($langs->trans("GRSection"), '', '', '', '', '', "", 0, 0, 'title_accountancy.png');
	'</td>';

	// if (empty($amount))
		print '<td width="50%" align="left"><label for="zero"><input class="sel-rg-type" id="zero" type="radio" name="statut" value="0" '. $checkedZero .' /> '. $langs->trans("Aucune retenue de garanti") .'</label></td>';
	print '</tr>';

	print '<tr><td width="'. $widthPercentage .'%" align="center"><label for="manual"><input class="sel-rg-type" id="manual" type="radio" name="statut" value="2" '. $checkedMan .' /> '. $langs->trans("Manual") .'</label></td>';

	// if (empty($amount))
		print '<td width="50%" align="center"><label for="auto"><input class="sel-rg-type" id="auto" type="radio" name="statut" value="1" '. $checkedAuto .' /> '. $langs->trans("Auto") .'</label></td>';

	print '</tr>';
	print '<tr><td valign="top" class="rg-left-side" width="'. $widthPercentage .'%" style="'. $rgOpac .'">';
	print '<table class="border" width="100%">';
	print '<tr><td colspan="2" align="left"> <h3>- '. $langs->trans("RG") .'</h3></td></tr>';
	
	print '<tr><td width="35%">'.$langs->trans("Ref").'</td><td>'; 
	if ($id) {
		print '<span class="static_ref">'. $ref .'</span>';
		print '<div class="ref_inp hidden"><input id="ref" name="ref" type="text" value="'. $ref .'" /></div>';
	} else {
		print '<span class="static_ref hidden"></span>';
		print '<div class="ref_inp"><input id="ref" name="ref" type="text" /></div>';
	}
	print '</td></tr>';
	
	print '<tr><td class="">'.$langs->trans("Amount").'</td><td>';
	if ($id) {
		print '<span class="static_amount">'. number_format($amount,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</span>';
		print '<div class="amount_inp hidden"><input id="amount" name="amount" type="text" value="'. $amount .'" /></div>';
	} else {
		print '<span class="static_amount hidden"></span>';
		print '<div class="amount_inp"><input id="amount" name="amount" type="text" /></div>';
	} 
	print '</td></tr>';

	if ($id) {
		print '<tr><td>'.$langs->trans("CreatedBy").'</td><td>';
		$user->fetch($object->fk_created_by);
		print $user->getNomUrl(1);
		print '</td></tr>';
	}

	print '<tr><td class="">'.$langs->trans("Bank").'</td><td>';
	if ($id) {
		if ($account->id) {
			print '<div class="static_account">';
			print $account->getNomUrl(1) . ($account->number ? " <span class='bank_number'>&nbsp;&nbsp;( <b><u>". $account->number ."</u></b> )</span>" : "<span class='bank_number'></span>").'</div>';
		} else {
			print '<div class="static_account"></div>';
		}
		print '<div class="account_inp hidden">';
        print $form->select_comptes($object->fk_bank, 'bank_',0,'',1, '') . " <span class='bank_number'></span>";
		print '</div>';
	} else {
		print '<div class="static_account hidden"></div>';
		print '<div class="account_inp">';
        print $form->select_comptes(0, 'bank_',0,'',1, '') . " <span class='bank_number'></span>";
		print '</div>';
	}
	print '</td></tr>';

	print '<tr><td>'.$langs->trans("SigDate").'</td><td>';
	  	if ($id) {
			print '<span class="sig_date_static">'. $sig_date .'</span>';
			print '<input id="sig_date" name="sig_date" class="datepicker hidden" type="text" readonly="readonly" value="'. $sig_date .'" />';
	  	} else {
			print '<span class="sig_date_static hidden"></span>';
			print '<input id="sig_date" name="sig_date" class="datepicker" autocomplete="off"  type="text" readonly="readonly" />';
		}
	print '</td></tr>';

	print '<tr><td>'.$langs->trans("DepositDate").'</td><td>';
	  	if ($id) {
			print '<span class="deposit_date_static">'. $deposit_date .'</span>';
			print '<input id="deposit_date" name="deposit_date" class="datepicker hidden" type="text" required="required"  readonly="readonly" value="'. $deposit_date .'" />';
	  	} else {
			print '<span class="deposit_date_static hidden"></span>';
			print '<input id="deposit_date" name="deposit_date" class="datepicker" autocomplete="off"  type="text" required="required"  readonly="readonly" />';
		}
	print '</td></tr>';

	print '<tr><td colspan="2" align="center"><a id="'. $addBtn .'" data-id="'. ($id ?: 0) .'" data-mid="'. $mid .'" href="javascript:void(0);" data-update="'. $updateData .'" class="butAction">'.$langs->trans($addBtnTitle).'</a></td></tr>';
	print '</table></td>';

	// if (empty($amount)) {
		print '<td valign="top" class="rg-right-side" width="50%" style="'. $autoOpac .'">';

		$getRGTotal 		= 0;
		$budget = $marche->final_amount ?: $marche->init_amount;
		$marketAmountTtc  = Tools::getTva($budget,$marche->tva)['amount_ttc'];
		$rgCeillingAmount = Tools::getTva($marketAmountTtc, 7)['tva'];
		// $rgCeillingAmount 	= ($marche->budget*7)/100;
		// Right
		print '<table class="border" width="100%">';
		print '<tr><td colspan="3" align="left"> <h3>- '. $langs->trans("MTRG") .' : <span id="auto_rg_total">'. number_format($rgCeillingAmount,  2, ",", " ") .'</span></h3></td></tr>';
		
		print '<tr>';
			print '<td align="center">'.$langs->trans("AttachmentNum").'</td>';
			print '<td align="center">'.$langs->trans("AttachDateTTC").'</td>';
			print '<td align="center">'.$langs->trans("RGMT").'</td>';
		print '</tr>';

		$payments 	 = new PaymentManagement($db);
		$getPayments = $payments->fetchAll($mid, 'ASC', 'rowid');

		if ($getPayments && count($payments->lines)) {
			$payments 		  = $payments->lines;
			$reachedCeilling  = false;

			foreach ($payments as $key => $payment) {
				$payment_amount = Tools::getTva($payment->amount,$marche->tva)['amount_ttc'];
				// $payment_amount = $payment->amount;
				$rg_amount  	= ($payment_amount*10)/100;
				$getRGTotal 	+= $rg_amount;
				$attachNum 		= ($key+1);

				if (false !== $reachedCeilling)
					$rg_amount = 0;

				if ($getRGTotal > $rgCeillingAmount && false === $reachedCeilling) {
					$rg_amount 		 = $rg_amount-($getRGTotal-$rgCeillingAmount);
					$reachedCeilling = true;
				}

				print '<tr>';
					print '<td align="center">'. $attachNum .'</td>';
					print '<td align="center">'. number_format($payment_amount,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
					print '<td align="center">'. number_format($rg_amount,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
				print '</tr>';
			}
		}
		
		print '</table>';
		print '<script type="text/javascript">var rg_total = "'. number_format($rgCeillingAmount,  2, ",", " ") .'";</script>';
		print '</td>';
	// }

print '</tr></tbody>';
print '</table><br />';

print '<table width="100%"><tr>';
print '<td align="center"><a id="updateStatus" data-id="'. ($id ?: 0) .'" href="javascript:void(0);" data-update="'. $updateData .'" class="butAction">'.$langs->trans('Modifier le statut').'</a></td>';
print '</tr></table>';

llxFooter();

$db->close();

?>