<?php
dol_include_once('/btp/db/nxdb.class.php');

class devisfacture extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */

	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'devisfacture';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'devisfacture';
	public $errors = array();
	public $numero;
	public $montant;
	public $soustrai_id;
	public $datec;
	public $rows = array();
	public $now;
    public $rowid;

	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		return 1;
	}

	public function create()
	{
		global $conf;
		
 		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->montant	= $this->montant ? $this->db->escape($this->montant): null;
	
		$this->datec = $this->datec ? $this->db->escape($this->datec): null;

		$this->numero = $this->numero ? $this->db->escape($this->numero): null;
		$this->soustrai_id = $this->soustrai_id ? $this->db->escape($this->soustrai_id): null;
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . '(soustrai_id,numero,datec,montant) VALUES (';
		$sql .= '"'.$this->soustrai_id.'",'.$this->numero.',"'.$this->datec.'","'.$this->montant.'")';

		// echo $sql."<br>";
		$this->db->begin();
		$resql = $this->db->query($sql);
		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error Evenement ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
			die();
			
			return -1;
		} else {
			$this->db->commit();
		return $this->getLasInsrtedId();
		}
	}
public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 					 = $this->db->fetch_object($resql);
				$this->id 				 = $obj->rowid;
				$this->numero		 = $obj->numero;
				$this->montant	 = $obj->montant;
				$this->soustrai_id	 = $obj->soustrai_id;
					$this->datec= $obj->datec;
			}
			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function getNomUrl($withpicto = 0,  $id = null,$id_mark=null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : $this->montant;
        $id  	= ($id  ?: $this->id);
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/market/devisfacture/index.php?id='. $id .'&soustr_id='.$id_mark,1).'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }
	
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE  rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE  rowid = ' . $id;
		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	////////////////////////////////////////////////search
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $id = '')
	{
		global $conf;
		
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .$this->table_element;
		if (!empty($id)) {
		$sql .= " WHERE soustrai_id=".$id.' ';
		}

		if (!empty($filter)) {
		$sql .= $filter;
		}

	if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->rows = array();
		$resql 		 = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
 
			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->id 		 = $obj->rowid;
				$line->montant 	 = $obj->montant;
				$line->numero  = $obj->numero;
				$line->soustrai_id  = $obj->soustrai_id;

					$line->datec= $obj->datec;
			
				$this->rows[] 		 = $line;
			}
			$this->db->free($resql);
			return $num;
		} else {
			echo 'erreur';

			die();
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}
public function getNames()
	    {
	    	$this->fetchAll();
	    	$names = array();

	    	if (count($this->rows))
	    	foreach ($this->rows as $key => $line) {
				$names[$line->rowid] = $line->montant;    		
	    	}

	    	return $names;
	    }
    public function getName($id)
    {
    	$sql = 'SELECT montant FROM ' . MAIN_DB_PREFIX . $this->table_element.' WHERE rowid='.$id;
    	$resql = $this->db->query($sql);
    	$name = '';
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$name = $obj->montant;
			}
			$this->db->free($resql);
    	}

    	return $name;
    }

    

	/**
     * Load indicators for dashboard (this->nbtodo and this->nbtodolate)
     *
     * @param	User	$user   Objet user
     * @return WorkboardResponse|int <0 if KO, WorkboardResponse if OK
     */
     public function getAvanceHeader($en_id = null,$mark_id=null,$type,$date,$de)
    {
    	global $langs;
        
		// echo $this->marketDropDown($this->id);
    	$html = '<table class="border" width="100%">';
		$html .= '<tr><td width="25%">'.$langs->trans("Ref").'</td>';
		$html .= '<td colspan="2">'. $this->rowid .'</td></tr>';
		$html .= '<tr><td width="25%">'.$langs->trans("montant").'</td>';
		$html .= '<td colspan="2">'. $de .'</td></tr>';
		$html .= '<tr><td width="25%">'.$langs->trans("type").'</td>';
		$html .= '<td colspan="2">'. $type.'</td></tr>';
		$html .= '<tr><td width="25%">'.$langs->trans("Date").'</td>';
		$html .= '<td colspan="2">'.dol_print_date($date,'day').'</td></tr>';
		$html .= '</table><br />';

		return $html;
    }












public function fetchType($id = '',$mid=null)
	{
		global $conf;
		
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .'bon_entrees';
		$sql .= ' WHERE date_bonde_id in(select rowid from ' . MAIN_DB_PREFIX .'date_bonde';
		$sql .= ' WHERE entree_id in(select rowid from ' . MAIN_DB_PREFIX .'avance ';
		$sql .= ' WHERE numero='.$id.'';
		if (!empty($mid)) {
		$sql .= ' and soustrai_id='.$mid.'))';
		}
		die($sql);
		$this->rows = array();
		$resql 		 = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
 
			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->rowid 		 = $obj->rowid;
				$line->montant 	 = $obj->montant;
				$line->numero  = $obj->numero;
				$this->rows[] 		 = $line;
			}
			$this->db->free($resql);
			return $num;
		} else {
			echo 'erreur';

			die();
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}}
		 public function getStatData($market_id = false)
    {
    	global $langs;
 

    	$this->fetchAll('','',0,0,'',$market_id ? : null,null);

    	$object 		= new stdClass();
    	$object->number = count($this->rows);
    	$object->cost 	= false;
    	$object->label 	= $langs->trans('Avance');
    	$object->url 	= (int)$market_id ? dol_buildpath('/btp/market/avance/index.php?soustrai_id='.(int)$market_id,1) : '';

    	return $object;
    }
	

















}
