<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       market/count_advance/index.php
 * \ingroup    list
 * \brief      List of count_advance related to given market
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/btp/market/count_advance/class/count_advance.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php';
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';

// Protection if external user
if (!$user) accessforbidden();

$langs->load('users');

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');
$mid 	  = GETPOST('mid', 'int');
$id 	  = GETPOST('id', 'int');

if (!$mid)
	die('ID de marché n\'existe pas!');

$search_ref  	   	= trim($_GET['search_ref']);
$search_type  		= trim($_GET['search_type']);
$search_amount_ttc 	= trim($_GET['search_amount_ttc']);
$search_date_start 	= trim($_GET['search_date_start']);
$search_observation	= trim($_GET['search_observation']);
$search_settlement_date= trim($_GET['search_date_end']);

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref 	  		= "";
	$search_type 			= "";
	$search_amount_ttc 		= "";
    $search_date_start 		= "";
    $search_observation 	= "";
    $search_settlement_date = "";
}

/**
 * Actions
 */

/**
 * View
 */
$count_advance = new CountAdvance($db);
$market   = new Market($db);
$filter   = '';

// Filter
$filter .= !empty($search_ref) ? " AND num = '". $db->escape($search_ref) ."'" : "";
$filter .= !empty($search_observation) ? " AND observation LIKE '%". $db->escape($search_observation)."%'" : "";
$filter .= !empty($search_type) ? " AND type = '". $db->escape($search_type)."'" : "";
$filter .= !empty($search_amount_ttc) ? " AND amount_ttc = ". (float)$db->escape($search_amount_ttc) : "";
if (isset($search_date_start) && !empty($search_date_start))
	$filter .=  " AND date_start = '". $db->escape(Tools::convertDateTo($search_date_start, 'sql'))  ."'";
if (isset($search_settlement_date) && !empty($search_settlement_date))
$filter .=  " AND settlement_date = '". $db->escape(Tools::convertDateTo($search_settlement_date, 'sql'))  ."'";

/*************************************
 * Fin des filtres de recherche
*************************************/
$mainTitle = $langs->trans('DCount').'/'.$langs->trans('Advance');
llxHeader(array(), $mainTitle, '', '', '', '', array('/btp/js/btp.js'));

$getCountAdvance = $count_advance->fetchAll($mid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getCountAdvance == '-1') {
    print_fiche_titre($mainTitle, '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$count_advance->error);
    exit();
}

// Show table of vacations
$var  = true;
$num  = count($count_advance->lines);
$form = new FormChild($db);

if ($id) {
	$count_advance->fetch($id, $mid);
	$market->fetch($mid);
	$object 	= $count_advance;
	$head  		= market_prepare_head($market);

	print_barre_liste($mainTitle, $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	dol_fiche_head($head, 'count_advance', $mainTitle, 0, '');

	echo $market->getMarketHeader();

	$bank  		= new Account($db);
	$bank->fetch($count_advance->fk_bank);
	$createdBy  = new User($db);
	$createdBy->fetch($db->escape($count_advance->fk_createdby));
	$ref 		= $count_advance->num ? $count_advance->num : '';
	$type 		= $count_advance->type ? $count_advance->type : '';
	$stage 		= $count_advance->stage ? $count_advance->stage : '';
	$observation= $count_advance->observation ? $count_advance->observation : '';
	$amount_ttc = $count_advance->amount_ttc ? number_format($count_advance->amount_ttc,  2, ",", " ") : '';
	$date_start	= $count_advance->date_start ? dol_print_date($count_advance->date_start, 'day') : '';
	$settlement_date= $count_advance->settlement_date ? dol_print_date($count_advance->settlement_date, 'day') : '';

	print '<table class="border" width="100%">';
	print '<tr><td width="25%">'.$langs->trans("Ref").'</td>';
	print '<td colspan="2">'. $ref .'</td></tr>';

	print '<tr><td>'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $createdBy->getNomUrl('1') .'</td></tr>';
	// Bank
	print '<tr><td>'.$langs->trans("Bank").'</td>';
	print '<td colspan="2">'. $bank->getNomUrl(1) . ($bank->number ? " &nbsp;&nbsp;( <b><u>". $bank->number ."</u></b> )" : "") .'</td></tr>';

	print '<tr><td>'. $langs->trans("Amount") .' TTC</td>';
	print '<td colspan="2">'. $amount_ttc .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';

	print '<tr><td>'.$langs->trans("ReleaseDate").'</td>';
	print '<td colspan="2">'. $date_start .'</td></tr>';

	print '<tr><td>'.$langs->trans("SettlementDate").'</td>';
	print '<td colspan="2">'. $settlement_date .'</td></tr>';

	print '<tr><td>'.$langs->trans("Type").'</td>';
	print '<td colspan="2">'. $type .'</td></tr>';

	print '<tr><td>'.$langs->trans("Stage").'</td>';
	print '<td colspan="2">'. $stage .'</td></tr>';

	print '<tr><td>'.$langs->trans("Observation").'</td>';
	print '<td colspan="2">'. $observation .'</td></tr>';
	
	print '</table>';

	// if ($user->id && $user->rights->btp->write_all) {
		print '<div class="tabsAction">';
            // Boutons d'actions
			print '<a href="./card.php?action=edit&mid='. $mid .'&id='. $count_advance->id .'" class="butAction">'.$langs->trans('Modify').'</a>';
        	print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
            
            // If draft
            // if ($user->rights->btp->delete)	{
            	print '<a href="./index.php?mid='.$count_advance->fk_market.'&action=delete&id='. $count_advance->id .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
        	
        	if($action == 'delete')
        		 print $form->formconfirm("./card.php?mid=".$mid."&id=".$id, $langs->trans("DeleteCountAdvance"),$langs->trans("ConfirmDeleteCountAdvance"),"confirm_delete", '', 0, 1);
            // }
        print '</div>';
	// }
}
else {
	$market->fetch($mid);
	$head = market_prepare_head($market);

	print_barre_liste($mainTitle, $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

   	dol_fiche_head($head, 'count_advance', $mainTitle, 1, '');
   	$moreparam = 'mid='.$mid;

	echo $market->getMarketHeader();

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">';
	print '<input type="hidden" name="mid" value="'. $mid .'" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "num", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Observation"),$_SERVER["PHP_SELF"],"observation", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Type"),$_SERVER["PHP_SELF"],"type", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Amount"),$_SERVER["PHP_SELF"],"amount_ttc","", $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("ReleaseDate"), $_SERVER["PHP_SELF"], 'date_start', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("SettlementDate"), $_SERVER["PHP_SELF"], 'settlement_date', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';

    print '<td class="liste_titre" align="center"><input class="flat center" size="30" type="text" name="search_observation" value="'.dol_escape_htmltag($search_observation).'">';
    // print $form->select_dolusers($search_type,"search_type",1,"",0,'','',0,32);
    print '</td>';

	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center" type="text" size="20" name="search_type" value="'.dol_escape_htmltag($search_type).'"></td>';

	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="20" type="text" name="search_amount_ttc" value="'.dol_escape_htmltag($search_amount_ttc).'">';
	print '</td>';

	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center datepicker" type="text" size="20" name="search_date_start" value="'. dol_escape_htmltag($search_date_start) .'"></td>';

	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center datepicker" type="text" size="20" name="search_date_end" value="'. dol_escape_htmltag($search_settlement_date) .'"></td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($count_advance->lines)) {
				foreach($count_advance->lines as $line) {
			$var = !$var;
			
			$amount_ttc	= $line->amount_ttc ? number_format($line->amount_ttc,  2, ",", " ") : '';
			$date_start = $line->date_start ? dol_print_date($line->date_start, 'day'): '';
			$settlement_date = $line->settlement_date ? dol_print_date($line->settlement_date, 'day'): '';
			$ref 	= $line->num ? $line->num   : '';
			$type 	= $line->type ? $line->type : '';

			$observ 	 = '';
			$fullobserv = '';
			if (null !== $line->observation) {
				$fullobserv = str_replace(array("\r\n", "\n"), "", nl2br(strip_tags($line->observation)));
				$observ = substr($line->observation, 0, 100);
				$observ = strlen($line->observation) > 100 ? $observ.'...' : $observ;
			}

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="260px">';
			print $count_advance->getNomUrl(1, $line->id, $line->fk_market, $ref);
			print '</td>';
			print '<td align="center"><span class="classfortooltip" title="'. $fullobserv .'">'.$observ.'</span></td>';
			print '<td align="center">'. $type .'</td>';
			print '<td align="center">'. $amount_ttc .'</td>';
			print '<td align="center">'. $date_start .'</td>';
			print '<td align="center">'. $settlement_date .'</td>';
			print '<td></td>';
			print '</tr>';
		}
	}
	else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';

	// if ($user->id && $user->rights->btp->write) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&mid='. $mid .'" class="butAction">'.$langs->trans('AddCountAdvance').'</a>';
		print '</div>';
	// }
}

llxFooter();

$db->close();

?>