<?php
/* Copyright (C) 2016   Yassine Belkaid     y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    marches/po_managementpackingslip/po_managementpackingslip.class.php
 * \ingroup marches
 * \brief   This file is marches CRUD class file
 *
 */
dol_include_once('/btp/db/nxdb.class.php');

/**
 * Class marches
 *
 * Management packing slip class
 */
class paimentsoustraitance extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see marches::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'paimentsoustraitance';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'paimentsoustraitance';

	/**
	 * @var int ID
	 */
	public $rowid;
	public $remarque;
	public $paie;
    public $fk_btpcontrat;
	public $now;
	public $lines = array();
 
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at = $this->now;
		$this->statut 	= 0;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
	global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->remarque	  = $this->remarque ?: null;
		$this->paie	  = $this->paie ?: null;
		$this->fk_btpcontrat 		  = $this->fk_btpcontrat ? (int)$this->db->escape($this->fk_btpcontrat) : null;

		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (remarque, paie,fk_btpcontrat) VALUES ("'.$this->remarque.'", '.$this->paie.','.$this->fk_btpcontrat.')';
		//die($sql);
		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->error 	= 'Error Packing slip ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $num num
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $cont_id = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT  * FROM ' . MAIN_DB_PREFIX . $this->table_element ;
		$sql .= ' WHERE rowid = ' . (int)$id;
		

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			  	  = $this->db->fetch_object($resql);
				$this->rowid 		  	  = $obj->rowid;
				$this->remarque  = $obj->remarque;
				$this->paie 	  = $obj->paie;
				$this->fk_btpcontrat 	  = $obj->fk_btpcontrat;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	

public function fetchcontra($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

	$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element ;

		
			$sql .= ' WHERE fk_btpcontrat = '. $id;
	

		$resql = $this->db->query($sql);
		die($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 					 = $this->db->fetch_object($resql);
				$this->id 				 = $obj->rowid;
				$this->fk_btpcontrat 	= $obj->fk_btpcontrat;
				$this->remarque			 = $obj->remarque;
				$this->paie 			 = $obj->paie;
				
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function fetchbyidcontr($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);
	$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element ;

		
			$sql .= ' WHERE fk_btpcontrat = '. $id;
	
$this->db->begin();
		$resql = $this->db->query($sql);
		if($resql){
			$numrows = $this->db->num_rows($resql);
			if($numrows){
				while ($obj = $this->db->fetch_object($resql)) {
					$line = new stdClass;
                    $line->rowid 			 = $obj->rowid;
					$line->remarque 				 = $obj->remarque;
				$line->fk_btpcontrat			 = $obj->fk_btpcontrat;
				$line->paie 			 = $obj->paie;
				
					$this->rows[] = $line;
				}
				return $this->rows;
			}
			return false;
		}
		return false;
	}
	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data = array())
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0 || !count($data))
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET ';

		if (count($data) && is_array($data)) {
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : "'". $this->db->escape(trim($val)) ."'";
				$sql .= '`'. $key. '` = '. $val .',';
			}
		} else 
			return;

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . (int) $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			die($this->error);
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . (int) $id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0, $id, $poid)
    {
        global $langs;

        $result	= '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $id;

        $link 	 = '<a href="'.dol_buildpath('/btp/nc_under_modules/marches/po_managementpackingslip/index.php?id='. $id .'&poid='. $poid,1) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$label.$linkend;
        return $result;
    }

}
