<?php
/* Copyright (C) Yassine Belkaid y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/market/consumptions_supplies/class/consumptions_supplies.class.php
 * \ingroup consumptions_supplies
 * \brief   This file is consumptions_supplies CRUD class file
 *
 */

dol_include_once('/btp/db/nxdb.class.php');

class ConsumptionsSupplies extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();

	public $datec;
	public $num;
	public $qty;
	public $product_id 	;
	public $unit_type_id ;
	public $const_site_id	 ;
	public $created_by ;
	public $created_at ;
	public $updated_at ;
	public $rows = array();

	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'consumptions_supplies';
	/**
	 * @var string Name of table without pgeneral_fee_marcheix where object is stored
	 */
	public $table_element = 'consumptions_supplies';

	public $now;
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = date('Y-m-d');//$this->now->format('Y-m-d');
		$this->updated_at= $this->now;
		return 1;
	}


	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id = null, $ref = null, $cid)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/market/consumptions_supplies/index.php?id='. $id .'&cid='.$cid,1).'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->datec= $this->datec ? $this->db->escape($this->datec): null;
		$this->num = $this->num ? $this->db->escape($this->num): null;
		$this->qty = $this->qty ? $this->db->escape($this->qty): null;
		$this->product_id = $this->product_id ? $this->db->escape($this->product_id): null;
		$this->unit_type_id = $this->unit_type_id ? $this->db->escape($this->unit_type_id): null;
		$this->const_site_id	= $this->const_site_id ? $this->db->escape($this->const_site_id): null;
		$this->created_by = $this->created_by ? $this->db->escape($this->created_by): null;
		$this->created_at = $this->now;
		
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'consumptions_supplies' . ' (datec,num,qty,';
		$sql .= 'product_id,unit_type_id,const_site_id,created_by,created_at,updated_at) ';
		$sql .= 'VALUES ("'.$this->datec.'",'.$this->num.', ';
		$sql .=	 $this->qty.','.$this->product_id.', '.$this->unit_type_id.', ';
		$sql .=	 $this->const_site_id.', '.$this->created_by.',"'.$this->created_at.'","'. $this->updated_at .'")';
		
		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error consumptions_supplies ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
			die();
			return -1;
		} else {
			$this->db->commit();
		
			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'consumptions_supplies';
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->datec 			= $this->db->jdate($obj->datec);
			  $this->num 			= $obj->num ;
			  $this->id 			= $obj->rowid ;
			  $this->qty            = $obj->qty ;
			  $this->product_id   = $obj->product_id ;
			  $this->unit_type_id 	= $obj->unit_type_id ;
			  $this->const_site_id	= $obj->const_site_id ;
			  $this->created_by 	= $obj->created_by ;
			  $this->created_at 	= $this->db->jdate($obj->created_at);

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($cid = null, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $ignore_id = false)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$ignore_id)
			$sql = 'SELECT s.*, p.price, p.price_base_type, p.tva_tx FROM '. MAIN_DB_PREFIX . 'consumptions_supplies s, '. MAIN_DB_PREFIX .'product p WHERE const_site_id = '. (int)$cid .' AND s.product_id = p.rowid';
		else
			$sql = 'SELECT s.*, p.price, p.price_base_type, p.tva_tx FROM '. MAIN_DB_PREFIX . 'consumptions_supplies s, '. MAIN_DB_PREFIX .'product p WHERE s.product_id = p.rowid';

		if (!empty($filter)) {
			$sql .= $filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->rows = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				  $line->id 			= $obj->rowid;
				  $line->datec 			= $this->db->jdate($obj->datec);
				  $line->num 			= $obj->num ;
				  $line->qty            = $obj->qty ;
				  $line->product_id 	= $obj->product_id ;
				  $line->unit_type_id 	= $obj->unit_type_id ;
				  $line->const_site_id	= $obj->const_site_id ;
				  $line->price			= $obj->price;
				  $line->created_by 	= $obj->created_by ;
				  $line->created_at 	= $this->db->jdate($obj->created_at);
				$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}



	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'consumptions_supplies' . ' SET  `updated_at` = "'. $this->updated_at .'",';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = rtrim($sql, ',');
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'consumptions_supplies' .' WHERE rowid = ' . (int)$id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	public function getStatData($cid = false, $market_id = 0)
    {
    	global $langs;
    	$this->fetchAll(($cid ?: null), '', '', 0, 0, '', ($cid ? false : true));
    	$countAmount = 0;

    	foreach ($this->rows as $key => $obj)
    		$countAmount += ($obj->price*$obj->qty);

    	$object 		= new stdClass();
    	$object->number = (!$cid && $market_id ? 0 : count($this->rows));
    	$object->cost 	= (!$cid && $market_id ? 0 : $countAmount);
    	$object->label 	= $langs->trans('ConsumptionsSupplies');
    	$object->url 	= (int)$cid ? dol_buildpath('/btp/market/consumptions_supplies/index.php?cid='. $cid .'&mid=',1). $market_id : '';

    	return $object;
    }
}
?>