<?php
/* Copyright (C) 2016   Yassine Belkaid <y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
dol_include_once('/btp/market/consumptions_supplies/class/consumptions_supplies.class.php');
dol_include_once('/btp/market/construction_site/class/construction_site.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

dol_include_once('/btp/settings/unit_type/class/unitType.class.php');
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$cid     = GETPOST('cid','int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$cid)
    die('ID chantier n\'existe pas!');

$error 	= false;
$form                 = new FormChild($db);
$consumptionsSupplies = new ConsumptionsSupplies($db);
$constructionSite     = new ConstructionSite($db);
$market               = new Market($db);
$unitType             = new unitType($db);
$product              = new product($db);

if ($action == 'create' && $request_method === 'POST' && !empty($_POST['cid'])) {
	
    $cid          = (int)trim($_POST['cid']);
    $product_id   = (int)trim($_POST['product_id_']);
    $unit_type_id = (int)trim($_POST['unit_type_id_']);
    $qty          = (int)trim($_POST['qty_']);
    $num          = (int)trim($_POST['num_']);
    $datec        = trim($_POST['datec_']);

    if ($cid <= 0 || $product_id <= 0 || $unit_type_id <= 0 || $qty <= 0 || $num <= 0 || empty($datec)) {
        header("Location: card.php?action=add&cid=".$cid."&msg=Remplir tous les champs");
        die();
    }
    
    $consumptionsSupplies->datec          = Tools::convertDateTo($datec, 'sql');
    $consumptionsSupplies->num            = $num;
    $consumptionsSupplies->qty            = $qty;
    $consumptionsSupplies->product_id     = $product_id;
    $consumptionsSupplies->unit_type_id   = $unit_type_id;
    $consumptionsSupplies->const_site_id  = $cid;
    $consumptionsSupplies->created_by     = $user->id;

    $consumptionsSuppliesID = $consumptionsSupplies->create();

    // If no SQL error we redirect to the request card
    if ($consumptionsSuppliesID > 0) {
        header('Location: index.php?id='.$consumptionsSuppliesID.'&cid='.$cid);
        exit;
    } else {
        // Otherwise we display the request form with the SQL error message
        header('Location: card.php?action=request&cid='.$cid.'&error=SQL_Create&msg='.$consumptionsSupplies->error);
        exit;
    }
}

if ($action == 'update' && $request_method === 'POST' && !empty($_POST['cid']) && !empty($_POST['id'])) {
    // If no right to modify a request
    /*if (!$user->rights->btp->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/
    // $canedit = ($user->rights->btp->write || $user->rights->btp->write_all);
    $canedit = true ; 

    // If this is the requestor or has read/write rights
    if ($canedit) {

        $cid          = (int)trim($_POST['cid']);
        $id           = (int)trim($_POST['id']);
        $product_id   = (int)trim($_POST['product_id_']);
        $unit_type_id = (int)trim($_POST['unit_type_id_']);
        $qty          = (int)trim($_POST['qty_']);
        $num          = (int)trim($_POST['num_']);
        $datec        = trim($_POST['datec_']);

         if ($cid <= 0 || $product_id <= 0 || $unit_type_id <= 0 || $qty <= 0 || $num <= 0 || empty($datec)) {
            header("Location: index.php?cid=".$cid."&msg=Remplir tous les champs");
            die();
        }

        $data = array(
          'datec'         => Tools::convertDateTo($datec, 'sql'),
          'num'           => $num,
          'qty'           => $qty,
          'product_id'    => $product_id,
          'unit_type_id'  => $unit_type_id,
        );

		$getconsumptions_suppliesID = $consumptionsSupplies->update($id, $data);
        
        if ($getconsumptions_suppliesID > 0) {
            header('Location: ./index.php?id='.$id.'&cid='.$cid);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: ./card.php?id='.$id.'&cid='. $cid .'&action=edit&error=SQL_Create&msg='.$consumptionsSupplies->error);
            exit;
        }
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	if ($id <= 0)
        die('Missing id');

	//$canedit = ($user->rights->btp->write_all || $user->rights->btp->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$consumptionsSupplies->delete($id);
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php?cid='.$cid);
		exit;
	}
	else {
        header('Location: index.php?leftmenu=marches&cid='.$cid);
        exit;
	}
}

/*
 * View
 */
$morejs  = array("/btp/js/btp.js");
$morecss = array();

llxHeader(array(), $langs->trans('consumptions_supplies'),'','','','',$morejs,$morecss,0,0);

// Fetch both market and construction site
$constructionSite->fetch($cid);
$market->fetch($constructionSite->market_id);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        $head = market_prepare_head($market);
        dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

        $head = market_construction_site_prepare_head($constructionSite);
        dol_fiche_head($head, 'consumptions_supplies', $langs->trans("consumptions_supplies"), 0, 'submunu2');

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="cid" value="'.$cid.'" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

         //Numéro
        print '<tr><td class="fieldrequired">'.$langs->trans("num").'</td><td>';
        print '<input type="text" value="" name="num_" required="required" />';
        print '</td></tr>';

        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //produit
        print '<tr><td>'.$langs->trans("Supply").'</td><td>'; 
        print $form->select_produits_list(null,'product_id_', 0, 30, 0, '', 0, -1);//finished=2
        // print $form->select_produits_list(null,'product_id_', 0, 30, 0, '', 0, 2);
        print '</td></tr>';
       
        //unité 
        print '<tr><td>'.$langs->trans("unit_type").'</td><td>'; 
        print $form->selectarray('unit_type_id_', $unitType->getNames(),(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" value="" min="1" name="qty_" required="required" />';
        print '</td></tr>';
        
        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createconsumptions_supplies") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $consumptionsSupplies->fetch($id);
             $head = market_prepare_head($market);
            dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

            $head = market_construction_site_prepare_head($constructionSite);
            dol_fiche_head($head, 'consumptions_supplies', $langs->trans("consumptions_supplies"), 0, 'submunu2');

			//$canedit = ($user->rights->btp->delete || $user->rights->btp->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

    if ($action == 'edit') {
        $edit = true;
        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
        print '<input type="hidden" name="action" value="update" />'."\n";
        print '<input type="hidden" name="id" value="'.$id.'" />'."\n";
        print '<input type="hidden" name="cid" value="'.$cid.'" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        //Numéro
        print '<tr><td class="fieldrequired">'.$langs->trans("num").'</td><td>';
        print '<input type="text" value="'.$consumptionsSupplies->num.'" name="num_" required="required" />';
        print '</td></tr>';

        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" value="'.dol_print_date($consumptionsSupplies->datec,'day').'" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //produit
        print '<tr><td>'.$langs->trans("Supply").'</td><td>'; 
        // print $form->select_produits_list($consumptionsSupplies->product_id,'product_id_', 0, 30, 0, '', 0, 2);
        print $form->select_produits_list($consumptionsSupplies->product_id,'product_id_', 0, 30, 0, '', 0, -1);//finished=2
        print '</td></tr>';

        //Engin 
        print '<tr><td>'.$langs->trans("unit_type").'</td><td>'; 
        $mark_consumptions_suppliess = $unitType->getNames();
        print $form->selectarray('unit_type_id_', $mark_consumptions_suppliess,(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : $consumptionsSupplies->unit_type_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" min="0" value="'.$consumptionsSupplies->qty.'" name="qty_" required="required" />';
        print '</td></tr>';
       print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</table>';
    }

    dol_fiche_end();

        if (!$edit) {
            print '<div class="tabsAction">';

            // Boutons d'actions
            //if ($canedit) {
                print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
            //}
            print '</div>';
        }
} else {        
        print '<div class="tabBar">';
        print $langs->trans('ErrorUserViewSC');
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
}

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>