<?php
/* Copyright (C) Yassine Belkaid  y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/marekt/construction_site_arrangement/construction_site_arrangement.class.php
 * \ingroup btp
 * \brief   This file is construction_site_arrangement CRUD class file
 *
 */

dol_include_once('/btp/db/nxdb.class.php');

class ConstructionSiteArrangement extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();

  	public $datec;
  	public $num;
  	public $const_site_destin_id;
  	public $const_site_sender_id;
  	public $created_by ;
  	public $created_at ;
  	public $updated_at ;
  	public $rows = array();

  	public $table_element = 'const_site_diposals';
	public $element 	  = 'const_site_diposals';

	public $now;
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = date('Y-m-d');
	  	$this->updated_at= $this->now;
		return 1;
	}

	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id = null, $ref = null, $cid)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/market/construction_site_arrangement/index.php?id='. $id .'&cid='. $cid,1) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
	  $this->datec 	= $this->datec ? $this->db->escape($this->datec): null;
	  $this->num 	= $this->num ? $this->db->escape($this->num): null;
	  $this->const_site_destin_id = $this->const_site_destin_id ? $this->db->escape((int)$this->const_site_destin_id): 0;
	  $this->const_site_sender_id	= $this->const_site_sender_id ? $this->db->escape((int)$this->const_site_sender_id): 0;
	  $this->created_by = $this->created_by ? $this->db->escape((int)$this->created_by): 0;
	  $this->created_at = $this->now;

	// Insert request
	$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'const_site_diposals' . ' (datec,num,';
	$sql .= 'const_site_destin_id,const_site_sender_id,created_by,created_at,updated_at) ';
	$sql .= 'VALUES ("'.$this->datec.'", '.$this->num.', ';
	$sql .=	 $this->const_site_destin_id.', '.$this->const_site_sender_id.', '.$this->created_by.',"'.$this->created_at.'",NULL)';
	// echo $sql."<br>";

	$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error const_site_diposals ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
			die();
			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'const_site_diposals';
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->datec 			= $this->db->jdate($obj->datec);
			  $this->num 			= $obj->num;
			  $this->id 			= $obj->rowid;
			  $this->const_site_destin_id 	= $obj->const_site_destin_id;
			  $this->const_site_sender_id	= $obj->const_site_sender_id;
			  $this->created_by 	= $obj->created_by;
			  $this->created_at 	= $this->db->jdate($obj->created_at);

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($cid = null, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $ignore_id = false)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$ignore_id)
			$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'const_site_diposals WHERE const_site_sender_id = '. (int)$cid;
		else
			$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'const_site_diposals';

		if (!empty($filter)) {
			$sql .= $filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->rows = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->id 			= $obj->rowid;
				$line->datec 		= $this->db->jdate($obj->datec);
				$line->num 			= $obj->num;
				$line->const_site_destin_id = $obj->const_site_destin_id;
				$line->const_site_sender_id	= $obj->const_site_sender_id;
				$line->created_by 	= $obj->created_by;
				$line->created_at 	= $this->db->jdate($obj->created_at);
				$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'const_site_diposals' . ' SET `updated_at` = "'. $this->updated_at .'",';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql = rtrim($sql, ',');
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'const_site_diposals' .' WHERE rowid = ' . (int)$id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	public function getNames()
    {
    	$this->fetchAll();
    	$names = array();

    	if (count($this->rows))
    	foreach ($this->rows as $key => $line) {
			$names[$line->id] = $line->num;    		
    	}

    	return $names;
    }

    public function getName($id)
    {
    	$sql = 'SELECT num FROM ' . MAIN_DB_PREFIX . 'const_site_diposals WHERE rowid='.$id;
    	$resql = $this->db->query($sql);
    	$name = '';
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$name = $obj->num;
			}
			$this->db->free($resql);
    	}

    	return $name;
    }

    public function getStatData($cid = false, $market_id = 0)
    {
    	global $langs;
    	$this->fetchAll(($cid ?: null), '', '', 0, 0, '', ($cid ? false : true));

    	$object 		= new stdClass();
    	$object->number = (!$cid && $market_id ? 0 : count($this->rows));
    	$object->cost 	= false;
    	$object->label 	= $langs->trans('ConstSiteDiposals');
    	$object->url 	= ($cid && $market_id) ? dol_buildpath('/btp/market/construction_site_arrangement/index.php?cid='. (int)$cid . '&mid='. (int)$market_id,1) : '';

    	return $object;
    }
}
?>