<?php
/* Copyright (C) 2016   Yassine Belkaid <y.belkaid@nextconc
 */

/**
 * \file       bpt/market/construction_disposal_affect/index.php
 * \ingroup    list
 * \brief      List of construction_disposal_affect
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
dol_include_once('/btp/market/construction_disposal_affect/class/construction_disposal_affect.class.php');
dol_include_once('/btp/market/construction_site_arrangement/class/construction_site_arrangement.class.php');
dol_include_once('/btp/market/construction_site/class/construction_site.class.php');
dol_include_once('/btp/settings/unit_type/class/unitType.class.php');
include_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');


// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$action  = GETPOST('action', 'alpha');
$id      = GETPOST('id', 'int');
$caid 	 = GETPOST('caid', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];
$error 	= false;

$form                           = new FormChild($db);
$constructionArrangementAffect  = new ConstructionArrangementAffect($db);
$constructionSiteArrangement    = new ConstructionSiteArrangement($db);
$constructionSite               = new ConstructionSite($db);
$market                         = new Market($db);
$unitType                       = new UnitType($db);
$produit                        = new product($db);

if ($action == 'create' && $request_method === 'POST' && !empty($_POST['caid'])) {
    $ref         = trim($_POST['ref_']);
    $designation = trim($_POST['designation_']);
    $product_id  = (int)trim($_POST['product_id_']);
    $unit_type_id= (int)trim($_POST['unit_type_id_']);
    $qty         = (int)trim($_POST['qty_']);
    $price       = (float)trim($_POST['price_']);
    $caid        = (int)trim($_POST['caid']);

    if ($caid <= 0 || empty($ref) || empty($designation) || $product_id <= 0
         || $unit_type_id <= 0 || $qty <= 0 || $price <= 0) {
        header("Location: card.php?action=add&caid=".$caid."&msg=Remplir tous les champs");
        die();
    }

    $constructionArrangementAffect->ref            = $ref;
    $constructionArrangementAffect->designation    = $designation;
    $constructionArrangementAffect->qty            = $qty;
    $constructionArrangementAffect->price          = $price;
    $constructionArrangementAffect->product_id     = $product_id;
    $constructionArrangementAffect->unit_type_id   = $unit_type_id;
    $constructionArrangementAffect->const_disposal_id= $caid;
    $constructionArrangementAffect->created_by     = $user->id;

    $constructionArrangementAffectID = $constructionArrangementAffect->create();

    // If no SQL error we redirect to the request card
    if ($constructionArrangementAffectID > 0) {
        //header('Location: index.php?id='.$getMarcheID);
        header('Location: index.php?id='.$constructionArrangementAffectID.'&caid='.$caid);
        exit;
    } else {
        // Otherwise we display the request form with the SQL error message
        header('Location: card.php?action=request&caid='. $caid .'&error=SQL_Create&msg='.$constructionArrangementAffect->error);
        exit;
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->btp->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

   // $canedit = ($user->rights->btp->write || $user->rights->btp->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        $ref         = trim($_POST['ref_']);
        $designation = trim($_POST['designation_']);
        $product_id  = (int)trim($_POST['product_id_']);
        $unit_type_id= (int)trim($_POST['unit_type_id_']);
        $qty         = (int)trim($_POST['qty_']);
        $price       = (float)trim($_POST['price_']);
        $caid        = (int)trim($_POST['caid']);
        $id          = (int)trim($_POST['id']);

        if ($caid <= 0 || $id <= 0 || empty($ref) || empty($designation) || $product_id <= 0
             || $unit_type_id <= 0 || $qty <= 0 || $price <= 0) {
            header("Location: index.php?caid=".$caid);
            die();
        }

        $data = array(
          'designation'     => $designation,
          'ref'             => $ref,
          'qty'             => $qty ,
          'price'           => $price,
          'product_id'      => $product_id,
          'unit_type_id'    => $unit_type_id,
        );

		$getId = $constructionArrangementAffect->update($id, $data);
        
        if ($getId > 0) {
            header('Location: ./index.php?id='.$getId.'&caid='.$caid);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: ./card.php?id='. $getId .'&action=edit&error=SQL_Create&msg='.$constructionArrangementAffect->error.'&caid='.$caid);
            exit;
        } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$canedit = ($user->rights->btp->write_all || $user->rights->btp->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$constructionArrangementAffect->delete($id);
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		header('Location: index.php?caid='.$caid);
		exit;
	}
	else {
        header('Location: index.php?caid='.$caid);
        exit;
	}
}

/*
 * View
 */
$morejs  = array("/btp/js/btp.js");
$morecss = array();

// Fetch both market and construction site
$constructionSiteArrangement->fetch($caid);
$constructionSite->fetch($constructionSiteArrangement->const_site_sender_id);
$market->fetch($constructionSite->market_id);

llxHeader(array(), $langs->trans('const_diposals_affect'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        $head = market_prepare_head($market);
        dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

        $head = market_construction_site_prepare_head($constructionSite);
        dol_fiche_head($head, 'construction_site_arrangement', $langs->trans("const_site_diposals"), 0, 'submunu');

        $head = market_construction_site_arrangement_prepare_head($constructionSiteArrangement);
        dol_fiche_head($head, 'construction_disposal_affect', $langs->trans("ListOfconst_diposals_affect"), 0, 'submunu1');
        
        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="caid" value="'. $caid .'" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

         //réference
        print '<tr><td class="fieldrequired">'.$langs->trans("ref").'</td><td>';
        print '<input type="text" value="" name="ref_" required="required" />';
        print '</td></tr>';

        //designation
        print '<tr><td class="fieldrequired">'.$langs->trans("designation").'</td><td>';
        print '<input type="text" name="designation_" required="required" /> ';
        print '</td></tr>';

        //produit
        print '<tr><td class="fieldrequired">'.$langs->trans("Supply").'</td><td>'; 
        print $form->select_produits_list(null,'product_id_', 0, 30, 0, '', 0, -1);//finished=2
        print '</td></tr>';
       
        //unité 
        print '<tr><td class="fieldrequired">'.$langs->trans("unit_type").'</td><td>'; 
        $mark_const_diposals_affects = $unitType->getNames();
        print $form->selectarray('unit_type_id_', $mark_const_diposals_affects,(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" min="1" value="" name="qty_" required="required" />';
        print '</td></tr>';

        //prix  
        print '<tr><td class="fieldrequired">'.$langs->trans("price").'</td><td>';
        print '<input type="text" value="" name="price_" required="required" /> '.$langs->getCurrencySymbol($conf->currency);
        print '</td></tr>';
        
        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createconst_diposals_affect") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $constructionArrangementAffect->fetch($id);

            $head = market_prepare_head($market);
            dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

            $head = market_construction_site_prepare_head($constructionSite);
            dol_fiche_head($head, 'construction_site_arrangement', $langs->trans("const_site_diposals"), 0, 'submunu');

            $head = market_construction_site_arrangement_prepare_head($constructionSiteArrangement);
            dol_fiche_head($head, 'construction_disposal_affect', $langs->trans("ListOfconst_diposals_affect"), 0, 'submunu2');

			//$canedit = ($user->rights->btp->delete || $user->rights->btp->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEnddesignationP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {

        if ($action == 'edit') {
            $edit = true;
            print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
            print '<input type="hidden" name="action" value="update" />'."\n";
            print '<input type="hidden" name="id" value="'.$id.'" />'."\n";
            print '<input type="hidden" name="caid" value="'.$caid.'" />'."\n";

            print '<table class="border" width="100%">';
            print '<tbody>';

            //réference
            print '<tr><td class="fieldrequired">'.$langs->trans("ref").'</td><td>';
            print '<input type="text" value="'.$constructionArrangementAffect->ref.'" name="ref_" required="required" />';
            print '</td></tr>';

            //designation
            print '<tr><td class="fieldrequired">'.$langs->trans("designation").'</td><td>';
            print '<input type="text" value="'.$constructionArrangementAffect->designation.'" name="designation_" required="required" /> ';
            print '</td></tr>';

            //produit
            print '<tr><td class="fieldrequired">'.$langs->trans("product").'</td><td>';
            print $form->select_produits_list($constructionArrangementAffect->product_id,'product_id_', 0, 30, 0, '', 0, -1);//finished=2
            print '</td></tr>';

            //unit type 
            print '<tr><td class="fieldrequired">'.$langs->trans("unit_type").'</td><td>'; 
            $unitType = $unitType->getNames();
            print $form->selectarray('unit_type_id_', $unitType,(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : $constructionArrangementAffect->unit_type_id), 0, 0, 0, 'required="required"');
            print '</td></tr>';

            //Quantité  
            print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
            print '<input type="number" min="0" value="'.$constructionArrangementAffect->qty.'" name="qty_" required="required" />';
            print '</td></tr>';

            //Price
            print '<tr><td class="fieldrequired">'.$langs->trans("price").'</td><td>';
            print '<input type="number" value="'.$constructionArrangementAffect->price.'" name="price_" required="required" /> '.$langs->getCurrencySymbol($conf->currency);
            print '</td></tr>';

            print '</tbody>';
            print '</table>';

            print '<div class="center">';
            print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
            print '&nbsp; &nbsp; ';
            print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
            print '</div>';
            print '</table>';
        }

        dol_fiche_end();

        if (!$edit) {
            print '<div class="tabsAction">';

            // Boutons d'actions
            //if ($canedit) {
                print '<a href="card.php?id='.$_GET['id'].'caid='.$caid.'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
            //}

            // If draft
           // if ($user->rights->btp->delete)	{
            	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
           // }

            print '</div>';
        }

} else {
        
        print '<div class="tabBar">';
        print $langs->trans('ErrorUserViewSC');
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
 }
}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>