<?php 
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/bails/card.php
 *		\ingroup    bails
 *		\brief      Gestion des bails
 */

$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/market/bails/class/bail.class.php');
dol_include_once('/btp/market/provisionalbail/class/provisionalbail.class.php');
dol_include_once('/btp/lib/btp.lib.php');
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
dol_include_once('/btp/market/bordereau_prix/class/documentprix.class.php');
dol_include_once('/btp/market/sous_traitance/class/sous_traitance.class.php');
// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$soustr_id 	 = GETPOST('soustr_id', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$soustr_id && $request_method !== 'POST')
	die('ID sous_traitance n\'existe pas!');

$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0)  $socid = $user->societe_id;

$error 	= false;
$object = new documentprix($db);
$sous_traitance = new sous_traitance($db);


if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action='request';
    // If no right to create a request
/*    if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
	   $object_date='';
	    $soustr_id 	  = trim(GETPOST('soustr_id', 'int'));
	    $amount   = (float)trim(GETPOST('amount'));
	    $subject 	  = trim(GETPOST('subject'));
	    $market 	  = trim(GETPOST('market'));
	    $date_prix = trim($_POST['date_prix']);

	    if (!$soustr_id || $soustr_id <= 0 || !$amount || !$date_prix)
	    	die($amount);

	    if (isset($_POST['date_prix']) && !empty($_POST['date_prix'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['date_prix']);
	        $object_date = $ety.'-'.$etm.'-'.$etd;
	    }

	   
	    $object->fk_created_by 	= $user->id;
	    $object->fk_soustrai 	 	= $soustr_id;
	    $object->market 	 	= $market;
	    $object->date_prix 	 	= $object_date;
		$object->montant 	 	= $amount;
	    $object->subject 			= $subject;
		$getdocId = $object->create();

	    // If no SQL error we redirect to the request card
	    header('Location: ./index.php?soustr_id='.$soustr_id.'&id='.$getdocId);
	    die();
 //   }
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['soustr_id'] > 0 && $request_method === 'POST') {
    $action = 'edit';
	// If no right to create a request
  /*  if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
	   	$object_date= '';
	    $soustr_id 	  = (int)trim(GETPOST('soustr_id', 'int'));
	    $id 	  = (int)trim(GETPOST('id', 'int'));
	    $amount   = (float)trim(GETPOST('amount'));
	    $subject 	  = trim(GETPOST('subject'));
	    $market 	  = trim(GETPOST('market'));
	   
	    if (!$soustr_id || $soustr_id <= 0 || !$amount || !$market)
	    	return;

	    if (isset($_POST['date_prix']) && !empty($_POST['date_prix'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['date_prix']);
	        $object_date = $ety.'-'.$etm.'-'.$etd;
	    }

	 
	    $data = array(
		    'fk_soustrai' 	 	 => $soustr_id,
			'date_prix' 	 => $object_date,
			'market' 	 	 => $market,
			'subject' 	 => $subject,
			'montant' 	 	 => $amount,
		 );

		$object->update($id, $data);

    	header('Location: ./index.php?soustr_id='.$soustr_id.'&id='.$id);
        die();
	//}
}

$form 	 = new Form($db);
	
	


llxHeader(array(), $langs->trans('Bails'),'','','','',array("/btp/js/marches.js"),array(),0,0);
$def = $langs->trans("Definit");

if (empty($soustr_id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché

   /* if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[] = $langs->trans('CantCreate');
    } else {*/
        // Formulaire de concurrents
$sous_traitance->fetch($soustr_id);
    $title = $langs->trans("PriceDocuments");
    $head  = soustraitance_prepare_head($sous_traitance);
    dol_fiche_head($head, 'priceDocuments', $langs->trans('PriceDocuments'), 0, '');
    echo $sous_traitance->getTraitanceHeader($sous_traitance);
  
        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="soustr_id" value="'. $soustr_id .'" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

       
        
        print '<tr><td class="fieldrequired">'.$langs->trans("SubjectBDPE").'</td><td>';
        print '<textarea  name="subject" required="required" /></textarea></td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("DateBDPE"). '</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="date_prix" required="required" /></td></tr>';

         print '<tr><td class="fieldrequired">'.$langs->trans("marketNum").'</td><td>';
        print '<input type="text"  value="" name="market" required="required" /></td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("AmountTTC").'</td><td>';
        print '<input type="number" step="0.01" value="" name="amount" required="required" /></td></tr>';

        

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CrBordre") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    //}
} else {
	if ($id > 0 && $soustr_id > 0) {
		$object->fetch($id);
		$sous_traitance->fetch($soustr_id);
    $title = $langs->trans("PriceDocuments");
    $head  = soustraitance_prepare_head($sous_traitance);
    dol_fiche_head($head, 'priceDocuments', $langs->trans('PriceDocuments'), 0, '');
 	   	$canedit =true;/* ($user->rights->btp->delete || $user->rights->btp->write_all);*/

		if ($canedit) {
            if ($action == 'delete') {
                die("Can not delete this bail");
            }

			if ($action == 'edit' || $action == 'delete') {
				
				 echo $sous_traitance->getTraitanceHeader($sous_traitance);
  
		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="soustr_id" value="'. $soustr_id .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$amount 	= $object->montant ?: '';
				$date_prix	= $object->date_prix ? dol_print_date($object->date_prix, 'day') : '';
				$sig_date	= $object->sig_date ? dol_print_date($object->sig_date, 'day') : '';
				$deposit_date= $object->deposit_date ? dol_print_date($object->deposit_date, 'day') : '';
				$number = '';
               

		        print '<table class="border" width="100%">';
		        print '<tbody>';

		      
		        
		        print '<tr><td class="fieldrequired">'.$langs->trans("SubjectBDPE").'</td><td>';
		        print '<textarea "  value="'. $object->subject .'" name="subject" required="required" >'.$object->subject.'</textarea></td></tr>';




		        print '<tr><td class="fieldrequired">'.$langs->trans("DateBDPE").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $date_prix .'" name="date_prix" required="required" /></td></tr>';
           print '<tr><td class="fieldrequired">'.$langs->trans("marketNum").'</td><td>';
		        print '<input type="text"  value="'. $object->market .'" name="market" required="required" /></td></tr>';

		          print '<tr><td width="20%" class="fieldrequired">'.$langs->trans("AmountTTC").'</td><td>';
		        print '<input type="number" step="0.01" value="'. $amount .'" name="amount" required="required" /></td></tr>';


		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                print '</div>';

		        print '</form>';
			}
        }
	}
}



llxFooter();

$db->close();

?>