<?php
/* Copyright (C) Yassine Belkaid y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/market/market.class.php
 * \ingroup market
 * \brief   This file is market CRUD class file
 *
 */

dol_include_once('/btp/db/nxdb.class.php');
dol_include_once('/btp/executions/class/execution.class.php');
dol_include_once('/btp/lib/tools.lib.php');


/**
 * Class market
 *
 * Contract Management class
 */
class Attachments extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see market::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'attachments';
	/**
	 * @var string Name of table without pref_marketix where object is stored
	 */
	public $table_element = 'attachments';

	/**
	 * @var int ID
	 */
	public $id;
	public $ref;
	public $fk_createdby;
	public $attach_date;
	public $qty;
	public $fk_count;
	public $fk_metre;
	public $created_at;
	public $updated_at;
	public $now;
	public $lines = array();
	public $winner = array();
 
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at= $this->now;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
			
        
		$this->fk_createdby = $this->fk_createdby ?: null;
		$this->fk_metre 	= $this->fk_metre ?: null;
		$this->created_at 	= $this->now;
		$this->ref		= $this->ref ? $this->db->escape($this->ref) : '';
		$this->qty	= $this->qty ? $this->db->escape($this->qty) : 0;
		$this->attach_date	= $this->attach_date ? $this->db->escape($this->attach_date) : '';
		$this->fk_count	= $this->fk_count ? $this->db->escape($this->fk_count) : 0;
		
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (fk_metre,fk_createdby,ref, created_at, updated_at,qty,attach_date,fk_count) VALUES (';		
		$sql .= '"'.$this->fk_metre.'", '.$this->fk_createdby.', "'.$this->ref.'", "'.$this->created_at.'", "'.$this->updated_at.'","'.$this->qty.'", "'.$this->attach_date.'","'.$this->fk_count.'")';
              
		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->error = 'Error header ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id          Id object
	 * @param string $fk_tender   Tender ID
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id=null, $fk_metre = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);
		// $extras = 'm.*';
		// $fields = (null === $fk_tender ? $extras : '*');

		$sql = 'SELECT  * FROM ' . MAIN_DB_PREFIX . $this->table_element ;

		if (null !== $fk_metre) {
			$sql .= ' WHERE fk_metre = ' . (int)$fk_metre;
		} else {
			$sql .= ' WHERE  rowid = ' . (int)$id;
		}

		

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj 					 = $this->db->fetch_object($resql);
				$this->id 				 = $obj->rowid;
				

		$this->fk_createdby = $obj->fk_createdby ;
		$this->fk_metre 	= $obj->fk_metre ;
		$this->ref		= $obj->ref;
		$this->qty	= $obj->qty ;
		$this->attach_date	=$this->db->jdate($obj->attach_date)  ;
		$this->fk_count	= $obj->fk_count ;
		
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($mid,$sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		
		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4) .' AND fk_metre = '. $mid;
		} else {
			$sql .= ' WHERE fk_metre = '. $mid;
		}
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
                $line->id 				 = $obj->rowid;
		        $line->fk_createdby = $obj->fk_createdby ;
		        $line->fk_metre 	= $obj->fk_metre ;
		        $line->ref		= $obj->ref;
		        $line->qty	= $obj->qty ;
		        $line->attach_date	=$this->db->jdate($obj->attach_date);
		        $line->fk_count	= $obj->fk_count ;
                $line->updated_at 	 = $this->db->jdate($obj->updated_at);
				$line->created_at 	 = $this->db->jdate($obj->created_at);
				$this->lines[] 		 = $line;
			}

			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	

	
	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id)
			return false;

		if (count($data) && is_array($data)) {
			// Update request
			$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET';

			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $this->db->escape($val) .'"';
				$sql .= ' `'. $key. '` = '. $val .',';
			}

			$sql  = substr($sql, 0, -1);
			$sql .= ' WHERE rowid = ' . (int)$id;

			$this->db->begin();

			$resql = $this->db->query($sql);

			if (!$resql) {
				$this->db->rollback();
				
				$this->error = 'Error ' . $this->db->lasterror();
				$this->errors[] = $this->error;
				dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

				return -1;
			} else {
				$this->db->commit();

				return 1;
			}
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	
	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    /*public function getNomUrl($withpicto=0,  $id = null, $ref_market = null)
    {
        global $langs;

        $result	= '';
        $setRef	= '';

        $setRef = (null !== $ref_market) ? $ref_market : '';
        $id  	= ($id  ?: '');
        $subject  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/market/attachments/index.php?id='. $id,1) .'" title="'.dol_escape_htmltag($subject, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($subject, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }*/

    

	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'attachments' .' WHERE rowid = ' . $id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

    public function getNomUrl($withpicto=0,  $id, $wid = null, $ref_market = null)
    {
        global $langs;

        $result	= '';
        $settransport	= '';
        $setRef = (null !== $ref_market) ? $ref_market : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $id;

        $link 	 = '<a href="'.dol_buildpath('/btp/market/attachments/index.php?id='. $id .'&metre_id='. $wid,1) .'" class="classfortooltip" title="'. $label .'">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }




}
