<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       market/market/card.php
 * \ingroup    market
 * \brief      markets CRUD
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

dol_include_once('/btp/market/work_metres/class/work_metres.class.php');
dol_include_once('/btp/market/attachments/class/attachments.class.php');
dol_include_once('/btp/market/works/class/works.class.php');
dol_include_once('/btp/market/count_advance/class/count_advance.class.php');


// Protection if external user
if (!$user) accessforbidden();

$langs->load('users');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id      = GETPOST('id', 'int');
$metre_id     = GETPOST('metre_id', 'int');

$error 	= false;
$attachements = new Attachments($db);
$metre=new MarketWorkMetres($db);
$works=new MarketWorks($db);
$market=new Market($db);

$request_method = $_SERVER['REQUEST_METHOD'];

if ($action == 'create' && $request_method === 'POST') {
    // If no right to update a request
    /*if (empty($user->rights->markets->write) || empty($user->rights->markets->write_all)) {
        $error = true;
        setEventMessage($langs->trans('CantCreate'));
        $action='edit';
    }*/

    $fk_createdby     = $user->id;
     $ref        = trim($_POST['refs']);
     $count           = (int)trim($_POST['count']);
    $qty           = trim($_POST['qty']);
    $metreid           = $_POST['metreid'];
     $dates=$_POST['adate'];
   
   

    if (!$error) {
       
            $attachements->fk_createdby  = $user->id;
            $attachements->fk_metre     = $metreid;
            $attachements->fk_count = $count;
            $attachements->ref  = $ref;
            $attachements->qty  = $qty;
            echo $count; 
                    if (!$metreid || $ref=="" || $qty<=0  || $count<=0) {
            header('Location:./card.php?action=add&metre_id='. $metreid);
            return;
        }
      $attachements->attach_date       = Tools::convertDateTo($dates, 'sql');;
            
        $created = $attachements->create();
        
        if ($created) {
          header('Location: ./index.php?metre_id='.$metreid);
          } else {
            header('Location:./card.php?action=add&metre_id='. $metreid);
        }
        
        die();
    }
}

if ($action == 'update' && $request_method === 'POST') {
	// If no right to update a request
    /*if (empty($user->rights->markets->write) || empty($user->rights->markets->write_all)) {
    	$error = true;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='edit';
    }*/

    $metre_id     = (int)$_POST['metre_id'];
    $attach_id     = (int)$_POST['attach_id'];
    $refs    = trim($_POST['refs']);
    $qty        = (int)trim($_POST['qty']);
    $count            =(int) trim($_POST['count']);
    $dates            =trim($_POST['dates']);
   
             if (!$metre_id  || !$attach_id || $refs=="" || $qty<=0  || !$dates || $count<=0) {
            header('Location: ./index.php?metre_id='.$metre_id);
            return;
        }
    if (!$error) {
        $data = array(
    		"fk_metre"     => $metre_id,
            "ref"          => $refs,
            "qty"       => $qty,
            "fk_count"           => $count,
             'attach_date'       => Tools::convertDateTo($dates, 'sql'),
        );

    	$upated = $attachements->update($attach_id, $data);
    	
    	if ($upated) {
	    	  header('Location: ./index.php?metre_id='.$metre_id.'&id='.$attach_id);
      die();
    	} else {
    		header("Location: ./index.php?metre_id=".$metre_id."&id=". $attach_id."&error=SQL_Create&msg=". $attachments->error);
	    	die();
    	}
    }
}

if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' /*&& $user->rights->btp->delete*/) {
    $error=0;

    $db->begin();

    $canDelete = true;/*($user->rights->btp->write_all || $user->rights->btp->delete);*/

    // Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
    if ($canDelete) {
        $attachements->delete((int)$id);
    }
    else {
        $error = $langs->trans('ErrorCantDelete');
    }

    header('Location: index.php?metre_id='.$metre_id);
    
    if (!$error) {
        $db->commit();
        exit;
    }
    else {
        $db->rollback();
        header('Location: index.php?metre_id='.$metre_id);
        exit;
    }
}

/*
 * View
 */

$form    = new Form($db);
$morejs  = array("/btp/js/btp.js");
$morecss = array();
$metre = new MarketWorkMetres($db);

llxHeader(array(), $langs->trans('ListOfMarkets'),'','','','',$morejs,$morecss,0,0);

if ($action == 'add' || $action == 'create') {
    // Si l'utilisateur n'a pas le droit de créer un marché
   /* if (empty($user->rights->markets->write) || empty($user->rights->markets->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Si il y a une erreur
      
$metre->fetch($metre_id);
$works->fetch($metre->fk_td_work);
$market->fetch($works->fk_market);

$head  = market_prepare_head($market);
    dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

    $work_metresHead  = market_works_prepare_head($works);
    dol_fiche_head($work_metresHead, 'work_metres', $langs->trans("Metres"), 0, 'submunu');
    
    $work_Head  = market_works_metre_prepare_head($metre);
        dol_fiche_head($work_Head,'attachments', $langs->trans("Attachments"), 0, 'submunu2');




        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">';
        print '<input type="hidden" name="action" value="create" />';
         print '<input type="hidden" name="metreid" value="'.$metre_id.'" />';

        print '<table class="border" width="100%">';
        print '<tbody>';

      
    print '<tr><td>'.$langs->trans("Reference attachment").'</td><td>';
        print '<input type="text" class="flat" name="refs"  required ="required" /></td></tr>';
    
    
    print '<tr><td class="">'.$langs->trans("Compte d'avancement").'</td><td>';
     print '<select name="count"  class="flat"  width="20px" required ="required" id="nomer"/>';
     
      $cht=new CountAdvance($db);
      $arr=array();
      $arr=$cht->getCountsAdv($works->fk_market);
      print '<option value=""></option>';
        if (count($arr)) {
         foreach($arr as $key => $row) {
       print '<option  value="'.$key.'">'.$row.'</option>';
    
        }
    }
    print '</select>';
    print '</td></tr>';
    // quantity
    print '<tr><td class="fieldrequired">'.$langs->trans("Quantity").'</td>';
    print '<td><input type="number" class="flat" name="qty"  required ="required" min="1" /></td></tr>';
    
    
    // date
    print '<tr><td class="">'.$langs->trans("Date").'</td>';
    print '<td><input class="flat center datepicker" type="text" required ="required" size="20" name="adate" "></td></tr>';
      print '</tbody>';
        print '</table><br />';

        print '<div align="right">';
        // Boutons d'actions
        print '<input type="submit" class="butAction" value="'. $langs->trans('AddAttachment') .'">';
        print '</div>';

        dol_fiche_end();
    // }
}
else if ($id || $action == 'edit' || $action == 'update') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->markets->write) || empty($user->rights->markets->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'cantDelete' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'markerN' :
                    $errors[] = $langs->trans('MarketNError');
                    break;
                case 'markerL' :
                    $errors[] = $langs->trans('MarketLError');
                    break;
                case 'markerD' :
                    $errors[] = $langs->trans('MarketDError');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

		$canedit = true;/*($user->rights->markets->delete || $user->rights->markets->write_all);*/
        
        if ($canedit) {

            
$obj=new Attachments($db);
$metre->fetch($metre_id);
$works->fetch($metre->fk_td_work);
$market->fetch($works->fk_market);
$obj->fetch($id);
$head  = market_prepare_head($market);
    dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

    $work_metresHead  = market_works_prepare_head($works);
    dol_fiche_head($work_metresHead, 'work_metres', $langs->trans("Metres"), 0, 'submunu');
    
    $work_Head  = market_works_metre_prepare_head($metre);
 dol_fiche_head($work_Head,'attachments', $langs->trans("Attachments"), 0, 'submunu1');
    


            if ($action == 'edit') {
                $edit = true;
                print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">';
                print '<input type="hidden" name="action" value="update" />';
                print '<input type="hidden" name="metre_id" value="'.$metre_id.'" />';  
                print '<input type="hidden" name="attach_id" value="'.$id.'" />';

                print '<table class="border" width="100%">';
                print '<tbody>';

                print '<tr><td>'.$langs->trans("Ref").'</td><td>';
                print '<input type="text" class="flat" name="refs" required="required" value="'. $obj->ref .'" /></td></tr>';

                print '<tr><td>'.$langs->trans("DCount/Advance").'</td><td>';
        


         print '<select name="count"  required="required" width="20px"  id="nomer"/>';
      $pselect="";
      $cht=new CountAdvance($db);
      $arr=array();
      $arr=$cht->getCountsAdv($works->fk_market);

      print '<option value=""></option>';
        if (count($arr)) {
         foreach($arr as $key => $row) {
            if($obj->fk_count){
                if($key==$obj->fk_count){
               $pselect="selected=selected";
                }
           }
       print '<option  value="'.$key.'" '.$pselect.'>'.$row.'</option>';
      $pselect="";
        }
    }
    print '</select>';
    print '</td></tr>';
                print '<tr><td valign="top" class="fieldrequired">'.$langs->trans("Quantity").'</td><td>';
               
                      print '<input type="number" class="flat" name="qty" required="required" value="'. $obj->qty .'" required="required" min="1"/></td></tr>';
                       print '<tr><td valign="top" class="fieldrequired">'.$langs->trans("Date").'</td>';
               
                      print '<td class="flat" colspan="1" ><input class="flat center datepicker"  required="required" type="text" size="20" name="dates" value="'. dol_print_date($obj->attach_date,'day') .'"></td></tr>';

                print '</tbody>';
                print '</table><br />';

                print '<div class="center">';
                // Boutons d'actions
                print '<input type="submit" class="butAction" value="'. $langs->trans('Modify') .'">';

                print '</div>';
            }

            dol_fiche_end();

        }
    // }
}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>
