<?php
/* Copyright (C) Yassine Belkaid y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/market/market.class.php
 * \ingroup market
 * \brief   This file is market CRUD class file
 *
 */

dol_include_once('/btp/db/nxdb.class.php');
// dol_include_once('/btp/executions/class/execution.class.php';
dol_include_once('/btp/lib/tools.lib.php');


/**
 * Class market
 *
 * Contract Management class
 */
class AttachmentHeader extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see market::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'attachment_header';
	/**
	 * @var string Name of table without pref_marketix where object is stored
	 */
	public $table_element = 'attachment_header';

	/**
	 * @var int ID
	 */

	public $id;
	public $ref;
	public $fk_createdby;
	public $fk_attachment;
	public $fk_country;
	public $fk_third_party;
	public $diverse;
	public $signatories;
	
	public $created_at;
	public $updated_at;

	public $now;
	public $lines = array();
	public $tender = array();
	public $approval = array();
	public $winner = array();
 
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at= $this->now;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
			
		$this->fk_createdby = $this->fk_createdby ?: null;
		$this->fk_attachment 	= $this->fk_attachment ?: null;
		$this->created_at 	= $this->now;
		$this->fk_third_party		= $this->fk_third_party ? $this->db->escape($this->fk_third_party) : '';
		$this->fk_country		= $this->fk_country ? $this->db->escape($this->fk_country) : '';
		$this->signatories	= $this->signatories ? $this->db->escape($this->signatories) : 0;
		$this->diverse	= $this->diverse ? $this->db->escape($this->diverse) : 0;
		
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (fk_third_party,fk_attachment,diverse,signatories,fk_country,fk_createdby, created_at, updated_at) VALUES (';		
		$sql .= '"'.$this->fk_third_party.'", '.$this->fk_attachment.', "'.$this->diverse.'","'.$this->signatories.'","'.$this->fk_country.'","'.$this->fk_createdby.'", "'.$this->created_at.'", "'.$this->updated_at.'")';
       
		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->error = 'Error header ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id          Id object
	 * @param string $fk_tender   Tender ID
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id=null, $fk_attachment = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);
		// $extras = 'm.*';
		// $fields = (null === $fk_tender ? $extras : '*');

		$sql = 'SELECT  * FROM ' . MAIN_DB_PREFIX . $this->table_element ;

		if (null !== $fk_attachment) {
			$sql .= ' WHERE fk_attachment = ' . (int)$fk_attachment;
		} else {
			$sql .= ' WHERE  rowid = ' . (int)$id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
     	$obj 					 = $this->db->fetch_object($resql);
		$this->fk_createdby = $obj->fk_createdby ;
		$this->fk_attachment 	= $obj->fk_attachment;
		$this->fk_third_party		= $obj->fk_third_party ;
		$this->fk_country		= $obj->fk_country;
		$this->signatories	= $obj->signatories;
		$this->diverse	= $obj->diverse ;
		$this->id 				 = $obj->rowid;
		$this->fk_createdby 	 = $obj->fk_createdby;
		$this->updated_at 		 = $this->db->jdate($obj->updated_at);
		$this->created_at 		 = $this->db->jdate($obj->created_at);
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($mid,$sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		
		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4) .' AND fk_attachment = '. $mid;
		} else {
			$sql .= ' WHERE fk_attachment = '. $mid;
		}
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
	    $line->fk_createdby = $obj->fk_createdby;
		$line->fk_attachment 	= $obj->fk_attachment;
		$line->fk_third_party		= $obj->fk_third_party ;
		$line->fk_country		= $obj->fk_country;
		$line->signatories	= $obj->signatories;
		$line->diverse	= $obj->diverse ;
		$line->id 				 = $obj->rowid;
		$line->fk_createdby 	 = $obj->fk_createdby;
		$line->updated_at 		 = $this->db->jdate($obj->updated_at);
		$line->created_at 		 = $this->db->jdate($obj->created_at);
		$line->id 			 	 = $obj->rowid;
				$this->lines[] 		 = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	



	

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id)
			return false;

		if (count($data) && is_array($data)) {
			// Update request
			$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET';

			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $this->db->escape($val) .'"';
				$sql .= ' `'. $key. '` = '. $val .',';
			}

			$sql  = substr($sql, 0, -1);
			$sql .= ' WHERE rowid = ' . (int)$id;

			$this->db->begin();

			$resql = $this->db->query($sql);

			if (!$resql) {
				$this->db->rollback();
				
				$this->error = 'Error ' . $this->db->lasterror();
				$this->errors[] = $this->error;
				dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

				return -1;
			} else {
				$this->db->commit();

				return 1;
			}
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	
	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto=0,  $id = null, $ref_market = null)
    {
        global $langs;

        $result	= '';
        $setRef	= '';

        $setRef = (null !== $ref_market) ? $ref_market : '';
        $id  	= ($id  ?: '');
        $subject  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/market/attachment_header/index.php?id='. $id,1) .'" title="'.dol_escape_htmltag($subject, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($subject, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

  
    
}
