<?php
/* Copyright (C) 2016 Yassine Belkaid  <y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

/**
 *  Return array head with list of tabs to view object informations
 *
 *  @param	Object	$object         marches
 *  @return array           		head
 */
function market_prepare_head($object, $hideOtherTabs = false)
{
	global $langs, $conf, $user;
	$langs->load('marches');

	$h 	  = 0;
	$head = array();
	$conf->global->MAIN_MAXTABS_IN_CARD = 7;

	// print_r($conf->global);
	// die();
    $head[$h][0] = dol_buildpath('/btp/market/market/index.php?id='.$object->id,1);
    $head[$h][1] = $langs->trans("MarketFile");
    $head[$h][2] = 'market';
    $h++;
    ?>
    <style type="text/css">
    	#id-right>.fiche>.tabs {
		    background: #e6e6e9;
		}
    	#id-right>.fiche>.tabBar>.tabs {
        	background: #f2f2f2;
    		font-size: 11.45px;
		}
    </style>
    <?php
    if (false === $hideOtherTabs) {

    	
	    $head[$h][0] = dol_buildpath('/btp/market/construction_site/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("const_site");
		$head[$h][2] = 'construction_site';
		$h++;
		
	    $head[$h][0] = dol_buildpath('/btp/market/works/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("Works");
		$head[$h][2] = 'works';
		$h++;

		$head[$h][0] = dol_buildpath('/btp/market/notifications/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans('NotificationsPhase');
		$head[$h][2] = 'notifications';
		$h++;

		$head[$h][0] = dol_buildpath('/btp/market/executions/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans('ExecutionPhase');
		$head[$h][2] = 'execution';
		$h++;

		/*$head[$h][0] = dol_buildpath('/btp/market/payments/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("Payments");
		$head[$h][2] = 'payments';
		$h++;

		$head[$h][0] = dol_buildpath('/btp/market/count_advance/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans('DCount').'/'.$langs->trans('Advance');
		$head[$h][2] = 'count_advance';
		$h++;*/

		$head[$h][0] = dol_buildpath('/btp/market/documentmanagement/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans('MarketDocuments');
		$head[$h][2] = 'documentmanagement';
		$h++;

		$head[$h][0] = dol_buildpath('/btp/market/recap/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("RecapMarket");
		$head[$h][2] = 'recap';
		$h++;

		// print '<div id="moretabsorder">';
		
		$head[$h][0] = dol_buildpath('/btp/market/stakeholders/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("Stakeholders");
		$head[$h][2] = 'stakeholders';
		$h++;

		$head[$h][0] = dol_buildpath('/btp/market/managementpackingslip/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("ManagementPackingSlip");
		$head[$h][2] = 'managementpackingslip';
		$h++;

		/*$head[$h][0] = dol_buildpath('/btp/market/social_charges/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("SocialCharges");
		$head[$h][2] = 'social_charges';
		$h++;

		$head[$h][0] = dol_buildpath('/btp/market/bail/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans('DefinitiveBail');
		$head[$h][2] = 'bail';
		$h++;*/

		$head[$h][0] = dol_buildpath('/btp/market/market/stock_market.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("Stock");
	    $head[$h][2] = 'Stock';
		$h++;
		$head[$h][0] = dol_buildpath('/btp/market/entrees/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("Entrees");
	    $head[$h][2] = 'Entrees';
		$h++;

		$head[$h][0] = dol_buildpath('/btp/market/market_devis/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("Devis");
	    $head[$h][2] = 'Devis';
		$h++;
		$head[$h][0] = dol_buildpath('/btp/market/market_factures/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("Factures");
	    $head[$h][2] = 'Factures';
		$h++;
		$head[$h][0] = dol_buildpath('/btp/market/market_commandes/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("Commandes");
	    $head[$h][2] = 'Commandes';
		$h++;
		
		$head[$h][0] = dol_buildpath('/btp/market/market_oeuvrechantiers/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("Main d'œuvre");
	 	$head[$h][2] = 'Main d\'œuvre';
		$h++;
    	// print '</div>';

    }

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'markets');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'markets','remove');

	?>
	<style type="text/css">.tabTitle{display: none;}</style>
	<?php
	return $head;
}


function soustraitance_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

    $head[$h][0] = dol_buildpath('/btp/market/sous_traitance/index.php?id='.$object->id,1);
    $head[$h][1] = $langs->trans("SoustriatanceFile");
    $head[$h][2] = 'contractFile';
    $h++;

	$head[$h][0] = dol_buildpath('/btp/market/contract/index.php?soustr_id='.$object->id,1);
	$head[$h][1] = $langs->trans('BordreCont');
	$head[$h][2] = 'bordreCont';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/bordereau_prix/index.php?soustr_id='.$object->id,1);
	$head[$h][1] = $langs->trans('PriceDocuments');
	$head[$h][2] = 'priceDocuments';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/avance/index.php?soustr_id='.$object->id,1);
	$head[$h][1] = $langs->trans("Avance");
	$head[$h][2] = 'avance';
	$h++;

	
	$head[$h][0] = dol_buildpath('/btp/market/devisfacture/index.php?soustr_id='.$object->id,1);
	$head[$h][1] = $langs->trans("DF");
	$head[$h][2] = 'devis';
	$h++;
	$head[$h][0] = dol_buildpath('/btp/market/docsoustrait/index.php?soustr_id='.$object->id,1);
	$head[$h][1] = $langs->trans("Document");
	$head[$h][2] = 'doc';
	$h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'marches');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'marches','remove');

	return $head;
}


function phase_notification_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/market/bails/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('Bails');
	$head[$h][2] = 'bails';
	$h++;
	
	$head[$h][0] = dol_buildpath('/btp/market/certificates/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('Certificates');
	$head[$h][2] = 'certificates';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/demandes/index.php?type=2&mid='.$object->id,1);
	$head[$h][1] = $langs->trans('demandes');
	$head[$h][2] = 'demandes';
	$h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'marches');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'marches','remove');

	return $head;
}


function market_works_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/market/work_supplies/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('Supplies');
	$head[$h][2] = 'work_supplies';
	$h++;
	
	$head[$h][0] = dol_buildpath('/btp/market/work_employees/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('Employees');
	$head[$h][2] = 'work_employees';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/work_equipments/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('Equipments');
	$head[$h][2] = 'work_equipments';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/work_yields/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('Yields');
	$head[$h][2] = 'work_yields';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/work_coefficients/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('Coefficients');
	$head[$h][2] = 'work_coefficients';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/work_metres/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('Metres');
	$head[$h][2] = 'work_metres';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/work_subcontracting/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('SubContracting');
	$head[$h][2] = 'work_subcontracting';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/work_delays/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('Delays');
	$head[$h][2] = 'work_delays';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/work_advancement/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('Advance');
	$head[$h][2] = 'work_advancement';
	$h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'marketworks');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'marketworks','remove');

	return $head;
}

/**
 * Prepare array with list of tabs
 *
 * @param   Object	$object		Object related to tabs
 * @return  array				Array of tabs to show
 */
function tender_prepare_head($object)
{
	global $langs, $conf, $user;
	$h = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/list.php?id='.$object->id,1);
	$head[$h][1] = $langs->trans("tender");
	$head[$h][2] = 'tender';
	$h++;

	/* //date : 25/11/2016
	   // par : SOUIEH Laghdaf
	   // cause : duplication de caution provisoir dsans demandes
	$head[$h][0] = dol_buildpath('/btp/tender/releases/index.php?td='.$object->id,1);
	$head[$h][1] = $langs->trans("Releases");
	$head[$h][2] = 'releases';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/tender/interimbail/index.php?td='.$object->id,1);
	$head[$h][1] = $langs->trans("InterimBail");
	$head[$h][2] = 'interimbail';
	$h++;*/

	$head[$h][0] = dol_buildpath('/btp/market/demandes/index.php?type=1&mid='.$object->id,1);
	$head[$h][1] = $langs->trans('demandes');
	$head[$h][2] = 'demandes';
	$h++;

	complete_head_from_modules($conf,$langs,$object,$head,$h,'tender');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'tender','remove');
	
	return $head;
}

function market_works_metre_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/market/metre_headers/index.php?metre_id='.$object->id,1);
	$head[$h][1] = $langs->trans('Headers');
	$head[$h][2] = 'metre_headers';
	$h++;
	

	$head[$h][0] = dol_buildpath('/btp/market/metre_workparts/index.php?metre_id='.$object->id,1);
	$head[$h][1] = $langs->trans('Workparts');
	$head[$h][2] = 'metre_workparts';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/attachments/index.php?metre_id='.$object->id,1);
	$head[$h][1] = $langs->trans('Attachments');
	$head[$h][2] = 'attachments';
	$h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab

    complete_head_from_modules($conf,$langs,$object,$head,$h,'marketworks');
	complete_head_from_modules($conf,$langs,$object,$head,$h,'marketworks','remove');

	return $head;
}

function market_works_metre_attachment_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/market/attachment_header/index.php?attach_id='.$object->id,1);
	$head[$h][1] = $langs->trans('Headers');
	$head[$h][2] = 'attachment_header';
	$h++;
    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'marketworks');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'marketworks','remove');

	return $head;
}

function market_construction_site_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/market/construction_site/index.php?id='.$object->id,1).'&mid='.$object->market_id;
	$head[$h][1] = $langs->trans('Général');
	$head[$h][2] = 'generaltabs';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/construction_site_arrangement/index.php?cid='.$object->id,1);
	$head[$h][1] = $langs->trans('const_site_diposals');
	$head[$h][2] = 'construction_site_arrangement';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/work_advancement_noslip/index.php?cid='.$object->id,1);
	$head[$h][1] = $langs->trans('AdvancementNoSlip');
	$head[$h][2] = 'work_advancement_noslip';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/consumptions_supplies/index.php?cid='.$object->id,1);
	$head[$h][1] = $langs->trans('consumptions_supplies');
	$head[$h][2] = 'consumptions_supplies';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/stock_const/index.php?cid='.$object->id,1);
	$head[$h][1] = $langs->trans('stock_const');
	$head[$h][2] = 'stock_const';
	$h++;

    complete_head_from_modules($conf,$langs,$object,$head,$h,'marketconstructionsite');
	complete_head_from_modules($conf,$langs,$object,$head,$h,'marketconstructionsite','remove');

	return $head;
}

function market_construction_site_arrangement_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/market/construction_disposal_affect/index.php?caid='.$object->id,1);
	$head[$h][1] = $langs->trans('const_diposals_affect');
	$head[$h][2] = 'construction_disposal_affect';
	$h++;

    complete_head_from_modules($conf,$langs,$object,$head,$h,'marketconstructionsitearrangement');
	complete_head_from_modules($conf,$langs,$object,$head,$h,'marketconstructionsitearrangement','remove');

	return $head;
}

function phase_execution_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/market/executions/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('ExecutionFile');
	$head[$h][2] = 'executions';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/delaymanagement/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('DelayManagement');
	$head[$h][2] = 'delaymanagement';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/paymentmanagement/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('PaymentManagement');
	$head[$h][2] = 'paymentmanagement';
	$h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'btp');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'btp','remove');

	return $head;
}

function marche_documents_prepare_head($object)
{
	global $langs, $conf, $user;
	$h 	  = 0;
	$head = array();

	// $conf->global->MAIN_MAXTABS_IN_CARD = 99;
	$head[$h][0] = dol_buildpath('/btp/market/documentmanagement/list.php?mid='.$object->id,1).'&type=1';
	$head[$h][1] = $langs->trans("PvImplantation");
	$head[$h][2] = 'pv_implantation';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/documentmanagement/list.php?mid='.$object->id,1).'&type=2';
	$head[$h][1] = $langs->trans("TechnicalMemory");
	$head[$h][2] = 'technical_memory';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/documentmanagement/list.php?mid='.$object->id,1).'&type=3';
	$head[$h][1] = $langs->trans("OS");
	$head[$h][2] = 'os';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/documentmanagement/list.php?mid='.$object->id,1).'&type=4';
	$head[$h][1] = $langs->trans("PvSiteMonitoring");
	$head[$h][2] = 'pv_site_monitoring';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/documentmanagement/list.php?mid='.$object->id,1).'&type=5';
	$head[$h][1] = $langs->trans("ReportEndWork");
	$head[$h][2] = 'report_end_work';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/documentmanagement/list.php?mid='.$object->id,1).'&type=6';
	$head[$h][1] = $langs->trans("DailyReport");
	$head[$h][2] = 'daily_report';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/documentmanagement/list.php?mid='.$object->id,1).'&type=7';
	$head[$h][1] = $langs->trans("CasingCertificates");
	$head[$h][2] = 'casing_certificates';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/documentmanagement/list.php?mid='.$object->id,1).'&type=8';
	$head[$h][1] = $langs->trans("CertificateOfOrigin");
	$head[$h][2] = 'certificate_of_origin';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/documentmanagement/list.php?mid='.$object->id,1).'&type=9';
	$head[$h][1] = $langs->trans("PurchaseInvoices");
	$head[$h][2] = 'purchase_invoices';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/documentmanagement/list.php?mid='.$object->id,1).'&type=99';
	$head[$h][1] = $langs->trans("TechnicalFile");
	$head[$h][2] = 'technical_file';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/documentmanagement/list.php?mid='.$object->id,1).'&type=13';
	$head[$h][1] = $langs->trans("MarektSlip");
	$head[$h][2] = 'market_slip';
	$h++;

	complete_head_from_modules($conf,$langs,$object,$head,$h, 'marche');

	return $head;
}

function phase_notification_demandes_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

$head[$h][0] = dol_buildpath('/btp/market/demandes/index.php?type=2&mid='.$object->id,1);
	$head[$h][1] = $langs->trans('final');
	$head[$h][2] = 'final';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/demandes/index.php?type=3&mid='.$object->id,1);
	$head[$h][1] = $langs->trans('backGrante');
	$head[$h][2] = 'backGrante';
	$h++;
    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'marches');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'marches','remove');

	return $head;
}

function tender_demandes_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/market/demandes/index.php?type=1&mid='.$object->id,1);
	$head[$h][1] = $langs->trans('provisional');
	$head[$h][2] = 'provisional';
	$h++;
	

	$head[$h][0] = dol_buildpath('/btp/market/demandes/declaration/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('declaration');
	$head[$h][2] = 'declaration';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/demandes/engagement/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('engagement');
	$head[$h][2] = 'engagement';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/demandes/couverture/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('couverture');
	$head[$h][2] = 'couverture';
	$h++;
    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'tender');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'tender','remove');

	return $head;
}


function print_barre_liste2($titre, $page, $file, $options='', $sortfield='', $sortorder='', $center='', $num=-1, $totalnboflines=0, $picto='title_generic.png', $pictoisfullpath=0, $morehtml='',$offset)
{
	global $conf,$langs;

	if ($picto == 'setup') $picto='title_setup.png';
	if (($conf->browser->name == 'ie') && $picto=='title_generic.png') $picto='title.gif';

	if (($num >= $offset) || ($num == -1))
	{
		$nextpage = 1;
	}
	else
	{
		$nextpage = 0;
	}

	print "\n";
	print "<!-- Begin title '".$titre."' -->\n";
	print '<table width="100%" border="0" class="notopnoleftnoright" style="margin-bottom: 6px;"><tr>';

	// Left
	if ($picto && $titre) print '<td class="nobordernopadding hideonsmartphone" width="40" align="left" valign="middle">'.img_picto('', $picto, '', $pictoisfullpath).'</td>';
	print '<td class="nobordernopadding"><div class="titre">'.$titre.'</div></td>';

	// Center
	if ($center)
	{
		print '<td class="nobordernopadding" align="left" valign="middle">'.$center.'</td>';
	}

	// Right
	print '<td class="nobordernopadding" align="right" valign="middle">';
	if ($sortfield) $options .= "&amp;sortfield=".$sortfield;
	if ($sortorder) $options .= "&amp;sortorder=".$sortorder;
	// Show navigation bar
	$pagelist = '';
	if ($page > 0 || $num >= $offset)
	{
		if ($totalnboflines)	// If we know total nb of lines
		{
			$maxnbofpage=(empty($conf->dol_optimize_smallscreen) ? 6 : 3);		// nb before and after selected page + ... + first or last

			$nbpages=ceil($totalnboflines/$offset);
			$cpt=($page-$maxnbofpage);
			if ($cpt < 0) { $cpt=0; }

			if ($cpt>=1)
			{
				$pagelist.= '<li'.(empty($conf->dol_use_jmobile)?' class="pagination"':'').'><a '.(empty($conf->dol_use_jmobile)?'':'data-role="button" ').'href="'.$file.'?page=0'.$options.'&amp;sortfield='.$sortfield.'&amp;sortorder='.$sortorder.'">1</a></li>';
				if ($cpt > 2) $pagelist.='<li'.(empty($conf->dol_use_jmobile)?' class="pagination"':'').'><span '.(empty($conf->dol_use_jmobile)?'class="inactive"':'data-role="button"').'>...</span></li>';
				else if ($cpt == 2) $pagelist.='<li'.(empty($conf->dol_use_jmobile)?' class="pagination"':'').'><a '.(empty($conf->dol_use_jmobile)?'':'data-role="button" ').'href="'.$file.'?page=1'.$options.'&amp;sortfield='.$sortfield.'&amp;sortorder='.$sortorder.'">2</a></li>';
			}
			
			do
			{
				if ($cpt==$page)
				{
					$pagelist.= '<li'.(empty($conf->dol_use_jmobile)?' class="pagination"':'').'><span '.(empty($conf->dol_use_jmobile)?'class="active"':'data-role="button"').'>'.($page+1).'</span></li>';
				}
				else
				{
					$pagelist.= '<li'.(empty($conf->dol_use_jmobile)?' class="pagination"':'').'><a '.(empty($conf->dol_use_jmobile)?'':'data-role="button" ').'href="'.$file.'?page='.$cpt.$options.'&amp;sortfield='.$sortfield.'&amp;sortorder='.$sortorder.'">'.($cpt+1).'</a></li>';
				}
				$cpt++;
			}
			while ($cpt < $nbpages && $cpt<=$page+$maxnbofpage);
			
			if ($cpt<$nbpages)
			{
				if ($cpt<$nbpages-2) $pagelist.= '<li'.(empty($conf->dol_use_jmobile)?' class="pagination"':'').'><span '.(empty($conf->dol_use_jmobile)?'class="inactive"':'data-role="button"').'>...</span></li>';
				else if ($cpt == $nbpages-2) $pagelist.= '<li'.(empty($conf->dol_use_jmobile)?' class="pagination"':'').'><a '.(empty($conf->dol_use_jmobile)?'':'data-role="button" ').'href="'.$file.'?page='.($nbpages-2).$options.'&amp;sortfield='.$sortfield.'&amp;sortorder='.$sortorder.'">'.($nbpages - 1).'</a></li>';
				$pagelist.= '<li'.(empty($conf->dol_use_jmobile)?' class="pagination"':'').'><a '.(empty($conf->dol_use_jmobile)?'':'data-role="button" ').'href="'.$file.'?page='.($nbpages-1).$options.'&amp;sortfield='.$sortfield.'&amp;sortorder='.$sortorder.'">'.$nbpages.'</a></li>';
			}
		}
		else
		{
			$pagelist.= '<li'.(empty($conf->dol_use_jmobile)?' class="pagination"':'').'><span '.(empty($conf->dol_use_jmobile)?'class="active"':'data-role="button"').'>'.($page+1)."</li>";
		}
	}
	print_fleche_navigation($page,$file,$options,$nextpage,$pagelist,$morehtml);		// output the div and ul for previous/last completed with page numbers into $pagelist
	print '</td>';

	print '</tr></table>'."\n";
	print "<!-- End title -->\n\n";
}
