<?php
/* Copyright (C) 2016 Yassine Belkaid  <y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

/**
 *  Return array head with list of tabs to view object informations
 *
 *  @param	Object	$object         marches
 *  @return array           		head
 */
function market_prepare_head($object, $hideOtherTabs = false)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

    $head[$h][0] = dol_buildpath('/btp/market/market/index.php?id='.$object->id,1);
    $head[$h][1] = $langs->trans("MarketFile");
    $head[$h][2] = 'market';
    $h++;

    if (false === $hideOtherTabs) {
	    $head[$h][0] = dol_buildpath('/btp/market/construction_site/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("const_site");
		$head[$h][2] = 'construction_site';
		$h++;
		
	    $head[$h][0] = dol_buildpath('/btp/market/works/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("Works");
		$head[$h][2] = 'works';
		$h++;

		$head[$h][0] = dol_buildpath('/btp/market/delays/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans('Delays');
		$head[$h][2] = 'delays';
		$h++;

		$head[$h][0] = dol_buildpath('/btp/market/payments/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("Payments");
		$head[$h][2] = 'payments';
		$h++;

		$head[$h][0] = dol_buildpath('/btp/market/count_advance/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans('DCount').'/'.$langs->trans('Advance');
		$head[$h][2] = 'count_advance';
		$h++;

		$head[$h][0] = dol_buildpath('/btp/market/stakeholders/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("Stakeholders");
		$head[$h][2] = 'stakeholders';
		$h++;

		$head[$h][0] = dol_buildpath('/btp/market/social_charges/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("SocialCharges");
		$head[$h][2] = 'social_charges';
		$h++;

		$head[$h][0] = dol_buildpath('/btp/market/bail/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans('DefinitiveBail');
		$head[$h][2] = 'bail';
		$h++;

		$head[$h][0] = dol_buildpath('/btp/market/market/stock_market.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("Stock");
	    $head[$h][2] = 'Stock';
		$h++;
		$head[$h][0] = dol_buildpath('/btp/market/entrees/index.php?mid='.$object->id,1);
		$head[$h][1] = $langs->trans("Entrees");
	    $head[$h][2] = 'Entrees';
		$h++;
    }

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'markets');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'markets','remove');

	return $head;
}

function market_works_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/market/work_supplies/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('Supplies');
	$head[$h][2] = 'work_supplies';
	$h++;
	
	$head[$h][0] = dol_buildpath('/btp/market/work_employees/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('Employees');
	$head[$h][2] = 'work_employees';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/work_equipments/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('Equipments');
	$head[$h][2] = 'work_equipments';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/work_yields/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('Yields');
	$head[$h][2] = 'work_yields';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/work_coefficients/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('Coefficients');
	$head[$h][2] = 'work_coefficients';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/work_metres/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('Metres');
	$head[$h][2] = 'work_metres';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/work_subcontracting/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('SubContracting');
	$head[$h][2] = 'work_subcontracting';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/work_delays/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('Delays');
	$head[$h][2] = 'work_delays';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/work_advancement/index.php?wid='.$object->id,1);
	$head[$h][1] = $langs->trans('Advance');
	$head[$h][2] = 'work_advancement';
	$h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'marketworks');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'marketworks','remove');

	return $head;
}

/**
 * Prepare array with list of tabs
 *
 * @param   Object	$object		Object related to tabs
 * @return  array				Array of tabs to show
 */
function tender_prepare_head($object)
{
	global $langs, $conf, $user;
	$h = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/list.php?id='.$object->id,1);
	$head[$h][1] = $langs->trans("tender");
	$head[$h][2] = 'tender';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/tender/releases/index.php?td='.$object->id,1);
	$head[$h][1] = $langs->trans("Releases");
	$head[$h][2] = 'releases';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/tender/interimbail/index.php?td='.$object->id,1);
	$head[$h][1] = $langs->trans("InterimBail");
	$head[$h][2] = 'interimbail';
	$h++;

	complete_head_from_modules($conf,$langs,$object,$head,$h,'tender');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'tender','remove');
	
	return $head;
}

function market_works_metre_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/market/metre_headers/index.php?metre_id='.$object->id,1);
	$head[$h][1] = $langs->trans('Headers');
	$head[$h][2] = 'metre_headers';
	$h++;
	

	$head[$h][0] = dol_buildpath('/btp/market/metre_workparts/index.php?metre_id='.$object->id,1);
	$head[$h][1] = $langs->trans('Workparts');
	$head[$h][2] = 'metre_workparts';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/attachments/index.php?metre_id='.$object->id,1);
	$head[$h][1] = $langs->trans('Attachments');
	$head[$h][2] = 'attachments';
	$h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab

    complete_head_from_modules($conf,$langs,$object,$head,$h,'marketworks');
	complete_head_from_modules($conf,$langs,$object,$head,$h,'marketworks','remove');

	return $head;
}

function market_works_metre_attachment_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/market/attachment_header/index.php?attach_id='.$object->id,1);
	$head[$h][1] = $langs->trans('Headers');
	$head[$h][2] = 'attachment_header';
	$h++;
    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'marketworks');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'marketworks','remove');

	return $head;
}

function market_construction_site_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/market/construction_site_arrangement/index.php?cid='.$object->id,1);
	$head[$h][1] = $langs->trans('const_site_diposals');
	$head[$h][2] = 'construction_site_arrangement';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/work_advancement_noslip/index.php?cid='.$object->id,1);
	$head[$h][1] = $langs->trans('AdvancementNoSlip');
	$head[$h][2] = 'work_advancement_noslip';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/consumptions_supplies/index.php?cid='.$object->id,1);
	$head[$h][1] = $langs->trans('consumptions_supplies');
	$head[$h][2] = 'consumptions_supplies';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/market/stock_const/index.php?cid='.$object->id,1);
	$head[$h][1] = $langs->trans('stock_const');
	$head[$h][2] = 'stock_const';
	$h++;

    complete_head_from_modules($conf,$langs,$object,$head,$h,'marketconstructionsite');
	complete_head_from_modules($conf,$langs,$object,$head,$h,'marketconstructionsite','remove');

	return $head;
}

function market_construction_site_arrangement_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/market/construction_disposal_affect/index.php?caid='.$object->id,1);
	$head[$h][1] = $langs->trans('const_diposals_affect');
	$head[$h][2] = 'construction_disposal_affect';
	$h++;

    complete_head_from_modules($conf,$langs,$object,$head,$h,'marketconstructionsitearrangement');
	complete_head_from_modules($conf,$langs,$object,$head,$h,'marketconstructionsitearrangement','remove');

	return $head;
}
