<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');

dol_include_once('/btp/achat/btp_sales/class/BtpSales.class.php');
dol_include_once('/btp/achat/btp_sales_products/class/BtpSalesProducts.class.php');
dol_include_once('/product/class/product.class.php');
dol_include_once('/btp/core/class/html.form.class.php');


$saleproduct 	  = new BtpSalesProducts($db);
$var = false;
$form=new Form($db);
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$action  = GETPOST('action', 'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$search_ref      			= GETPOST('search_ref');
$search_sale      	= GETPOST('search_sale');
$search_product      	= GETPOST('search_product');
$id 	  = GETPOST('id','int');
$search_qty      	= GETPOST('search_qty');
$search_discount    = GETPOST('search_discount');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref      	= "";
	$search_sale     	= "";
	$search_product    	= "";
	$search_qty    		= "";
	$search_discount    = "";
	}
$filter='';
$filter .= (!empty($search_ref) && $search_ref != -1) ? " and  rowid = ". $db->escape((int)$search_ref) ."\n" : "";
$filter .= (!empty($search_sale) && $search_sale!= -1) ? " AND  fk_sale= ".$db->escape((int)$search_sale)."\n" : "";
$filter .= (!empty($search_product) && $search_product != -1) ? " and  fk_product = ". $db->escape((int)$search_product) ."\n" : "";
$filter .= (!empty($search_qty) && $search_qty != -1) ? " AND qty = ".$db->escape((int)$search_qty)."\n" : "";
$filter .= (!empty($search_discount) && $search_discount != -1) ? " and  discount = ". $db->escape((int)$search_discount) ."\n" : "";
$getMarketList=$saleproduct->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter, $id);
if (!empty($getMarketList)  && $action == "xsl" ) {
$filename="Liste_Ventes_produits.xls";
      dol_include_once('/btp/achat/btp_sales_products/tpl/vente_produit_xsl.php');
 die();
 
}

llxHeader(array(), $langs->trans('listevents'),'','','','',$morejs,$morecss,0,0);

print '<link rel="stylesheet" href= "'.dol_buildpath('/btp/css/fontawesome.css',2).'">';

?>
<style type="text/css">
    .fiche>table:first-child td, .fiche>table[summary] td{vertical-align: middle !important;}
</style>
<?php
if ($id > 0) {
	//affichage Modification
	print_barre_liste($langs->trans("det_sale_prod"), '', '', '', '', '', "", "", "", DOL_MAIN_URL_ROOT.'/btp/img/folder_icon.png',1);
	dol_fiche_head('', 'ListOfproductsale', $langs->trans("ListOfproductsale"), 0, '');
	
	$saleproduct->fetch($id);
	print '<table class="border" width="100%">';
	// Ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Reference").'</td>';
	print '<td colspan="2">'. $saleproduct->rowid .'</td></tr>';
	//Vente
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Sale").'</td>';
	$use_u   = new BtpSales($db);
       $use_u->fetch($saleproduct->fk_sale);     

	print '<td colspan="2">'.$use_u->getNomUrl(1,$saleproduct->fk_sale,$use_u->quote_num).'</td></tr>';
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("product").'</td>';
	// Produit
    $pre  = new Product($db);
    $pre->fetch($saleproduct->fk_product);
        print '<td colspan="2">'.$pre->getNomUrl(1,$saleproduct->fk_product, $pre->label).'</td></tr>';
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Quantity").'</td>';
    //Quantité
	print '<td colspan="2">'.$saleproduct->qty.'</td></tr>';   
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("discount").'</td>';
	//Remise
	print '<td colspan="2">'.$saleproduct->discount.'%</td></tr>'; 
	 print '</table>';
	 print '<br>';
	 print '<div style="float: right; margin-top: 8px;">';
	 print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	 print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	 print'<a href="./card.php?action=delete&id='. $id .'" class="butAction butActionDelete" >'.$langs->trans('Delete').'</a>';
		
}
else {
 // Both test are required to be compatible with all browsers
	$card="card.php";
print_fiche_titre($langs->trans('ListOfproductsale'));
	print '<div style="float: right; margin-bottom: 6px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('ajt').'</a>';
		print '</div>';
		print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_ref" value="'. $search_ref .'" type="hidden" />';
print '<input name="search_sale" value="'. $search_sale .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
print '<input name="search_product" value="'. $search_product .'" type="hidden" />';
print '<input name="search_qty" value="'. $search_qty .'" type="hidden" />';
print '<input name="search_discount" value="'. $search_discount .'" type="hidden" />';
print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';
	print '<form method="GET" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	;
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Reference"),$_SERVER["PHP_SELF"], "rowid", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Sale"), $_SERVER["PHP_SELF"], 'fk_sale', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("product"), $_SERVER["PHP_SELF"], 'fk_product', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Quantite"),$_SERVER["PHP_SELF"], 'qty', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("discount"), $_SERVER["PHP_SELF"], 'discount', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder);
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';
	print '<td class="liste_titre" align="left" width="50">';    
	print '<select name="search_sale"     id="nomer"/>';
      $pa='';
        $evt   = new BtpSales($db);
        $evt->fetchall();  print '<option></option>';
        if (count($evt->rows)) {
        foreach($evt->rows as $line) {
        	if ($search_sale) {
  	 if ($line->rowid==$search_sale){ $pa=' selected="selected"';
  }}
       print '<option  value="'.$line->rowid.'"'.$pa.'>'.$line->quote_num.'</option>';
      $pa='';
        }
    }
   print '</select>';
	print '</td>';	
	// Fournisseur
	print '<td class="liste_titre" align="left" width="50">';   
	print $form->select_produits($search_product, "search_product");
print '</td>';
print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_qty" value="'.$search_qty.'">';
	print '</td>';
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="5" name="search_discount" value="'.$search_discount.'">';
	print '</td>';
    
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";
	// Lines
	if (count($saleproduct->rows)) {
		foreach($saleproduct->rows as $line) {
			$var = !$var;
			$rowid 			= $line->rowid;
			$sales 		    = $line->fk_sale;
			$prd            =$line->fk_product;
			$qty            =$line->qty;
			$rms 		    =$line->discount;
			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
				print $saleproduct->getNomUrl(1,  $line->rowid, $rowid);
			print '</td>';
			$user_u   = new BtpSales($db);
       $user_u->fetch($line->fk_sale);     
		print '<td align="center">'. $user_u->getNomUrl(1,$line->fk_sale,$user_u->quote_num).'</td>';
			$fourn   = new Product($db);
       $fourn->fetch($line->fk_product);     
		print '<td align="center">'.$fourn->getNomUrl(1,$line->fk_product,$fourn->label) .'</td>';
		print '<td align="center">'.$qty.'</td>';
		print '<td align="center">'.$rms.'%</td>';
		
		
			print '<td><div style="float: right; margin-top: 8px;">';
			print '</div></td>';
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		


}
print '</table>';
	print '</form>';
llxFooter();

$db->close();


?>