<?php 
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';

// dol_include_once('/elabration_pv/class/elabration_pv.class.php');
 

// dol_include_once('/avancementtravaux/PHPMailer/src/SMTP.php');
// dol_include_once('/avancementtravaux/PHPMailer/src/PHPMailer.php');




class elaboration_pv extends Commonobject{ 

	public $errors = array();
	public $rowid;
	public $ref;

	public $element='elabration_pv';
	public $table_element='elabration_pv';
	
	public function __construct($db){ 
		$this->db = $db;
		return 1;
    }

	public function create($echo_sql=0,$insert)
	{
		$sql  = "INSERT INTO " . MAIN_DB_PREFIX .get_class($this)." ( ";

		foreach ($insert as $column => $value) {
			$alias = (is_numeric($value)) ? "" : "'";
			if($value != ''){
				$sql_column .= " , `".$column."`";
				$sql_value .= " , ".$alias.$value.$alias;
			}
		}

		$sql .= substr($sql_column, 2)." ) VALUES ( ".substr($sql_value, 2)." )";
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			return 0;
		} 
		// return $this->db->db->insert_id;
		return $this->db->last_insert_id(MAIN_DB_PREFIX.'elabration_pv');
	}

	public function update($id, array $data,$echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

        $sql = "UPDATE " . MAIN_DB_PREFIX .get_class($this). " SET ";

        if (count($data) && is_array($data))
            foreach ($data as $key => $val) {
                $val = is_numeric($val) ? $val : "'". $val ."'";
	        	$val = ($val == '') ? 'NULL' : $val;
                $sql .= "`". $key. "` = ". $val .",";
            }

        $sql  = substr($sql, 0, -1);
        $sql .= " WHERE rowid = " . $id;
        // die($sql);

        $resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '. $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function delete($echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .get_class($this).' WHERE rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '.$this->db->lasterror();
			return -1;
		} 

		return 1;
	}

    
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX .get_class($this);

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		// die($sql);
		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
                $line->id    = $obj->rowid;
				$line->rowid 	= $obj->rowid;
				$line->objet 	=  $obj->objet;
				$line->fk_projet 	    =  $obj->fk_projet;
				$line->fk_tache 	    =  $obj->fk_tache;
				$line->date 	=  $obj->date;
				$line->localite 	=  $obj->localite;
				$line->description 	=  $obj->description;
				$line->intervenant 	=  $obj->intervenant;
                // ....

				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	public function fetch($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .get_class($this). ' WHERE rowid = ' . $id;
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 			= $this->db->fetch_object($resql);
                $this->id       = $obj->rowid;
				$this->rowid 	= $obj->rowid;
				$this->objet 	    =  $obj->objet;
				$this->fk_projet 	=  $obj->fk_projet;
				$this->fk_tache 	    =  $obj->fk_tache;
				$this->date 	=  $obj->date;
				$this->localite 	    =  $obj->localite;
				$this->description 	=  $obj->description;
				$this->intervenant 	=  $obj->intervenant;
                // ....
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}
	}

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id='',$attr=''){

	    global $conf;

	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'">';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.get_class($this);
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

    function getNomUrl($withpicto=0, $option='', $get_params='', $notooltip=0, $save_lastsearch_value=-1)
    {
        global $langs, $conf, $user;

        if (! empty($conf->dol_no_mouse_hover)) $notooltip=1;   // Force disable tooltips

        $result='';
        $label='';
        $url='';

        // if ($user->rights->propal->lire){}

        $linkclose='';
        if (empty($notooltip))
        {
            $linkclose.= ' title="'.dol_escape_htmltag($label, 1).'"';
            $linkclose.=' class="classfortooltip"';
        }
        $linkstart = "";
        $linkend = "";
        $result = "";

        if ($this->objet) {
            $linkstart = '<a href="'.$url.'"';
            $linkstart.=$linkclose.'>';
            $linkend='</a>';

            $result .= $linkstart;
            if ($withpicto) 
                $result.= '<img height="16" src="'.dol_buildpath('/avancementtravaux/elabration_pv/img/object_elabration_pv.png',2).'" >&nbsp;';
            if ($withpicto != 2) $result.= $this->objet;
        }

        $result .= $linkend;

        return $result;
    }








    public function getcountrows(){
        $tot = 0;
        $sql = "SELECT COUNT(rowid) as tot FROM ".MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);

        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
                $tot = $obj->tot;
            }
        }
        return $tot;
    }

    public function getdateformat($date,$time=true){
        
        $d = explode(' ', $date);
        $date = explode('-', $d[0]);
        $d2 = explode(':', $d[1]);
        $result = $date[2]."/".$date[1]."/".$date[0];
        if ($time) {
            $result .= " ".$d2[0].":".$d2[1];
        }
        return $result;
    }

    public function getYears($debut="debut")
    {
        $sql = 'SELECT YEAR('.$debut.') as years FROM ' . MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }


    public function getmonth($year)
    {
        $sql = 'SELECT MONTH(debut) as years FROM ' . MAIN_DB_PREFIX.get_class($this).' WHERE YEAR(debut) = '.$year;
        $resql  = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }




    public function intervenants_(){
		$sql = "SELECT * FROM ".MAIN_DB_PREFIX."intervenants";
		$intervenants=[];
    	$resql = $this->db->query($sql);
    	if ($resql) {
			$num = $this->db->num_rows($resql);
			
			while ($obj = $this->db->fetch_object($resql)) {
				$intervenants[]=$obj;
			}
			// $this->db->free($resql);
			return $intervenants;
		}
	}

	public function select_intervenant($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    
	    $objet = "label";
	    $moreforfilter.='<select style="width:100%; " onchange="select_inter(this);" class="select_fk_intervenant flat" id="select_'.$id.'" name="'.$name.'[]" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT * FROM ".MAIN_DB_PREFIX."intervenants";
    	// $sql2= "SELECT * FROM ".MAIN_DB_PREFIX."user";
    	$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			
			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" data-ref="'.$obj->$opt.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    // $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

	public function select_representant($selected=[],$name='select_',$showempty=1,$val="rowid",$opt="label",$id='',$id_inter=0){
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    
	    $objet = "label";
	    $moreforfilter.='<select style="width:100%; " class="select_representants flat" id="select_'.$id.'" name="'.$name.'['.$id_inter.'][]"  '.$nodatarole.' multiple>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT * FROM ".MAIN_DB_PREFIX."representant WHERE fk_intervenant =".$id_inter;
    	// $sql2= "SELECT * FROM ".MAIN_DB_PREFIX."user";
    	$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			
			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" data-ref="'.$obj->$opt.'"';
	            if (in_array($obj->$val,$selected)) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    // $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}



	public function send_mail($email,$name,$subject,$title="Intervenant"){
		dol_include_once('/avancementtravaux/PHPMailer/src/SMTP.php');
		dol_include_once('/avancementtravaux/PHPMailer/src/PHPMailer.php');

    	global $conf;
		// ini_set( 'display_errors', 1 );
		// error_reporting( E_ALL );
		$smtp = dolibarr_get_const($this->db,'MAIN_MAIL_SMTP_SERVER',$conf->entity);
		$smtp_id = dolibarr_get_const($this->db,'MAIN_MAIL_SMTPS_ID',$conf->entity);
		$smtp_pw = dolibarr_get_const($this->db,'MAIN_MAIL_SMTPS_PW',$conf->entity);

		$mail = new PHPMailer(true);
		//Send mail using gmail
		$mail->IsSMTP(); // telling the class to use SMTP
		$mail->SMTPAuth = true; // enable SMTP authentication
		$mail->SMTPSecure = "ssl"; // sets the prefix to the servier
		$mail->Host = $smtp; // sets GMAIL as the SMTP server
		$mail->Port = 465; // set the SMTP port for the GMAIL server
		$mail->Username = $smtp_id; // GMAIL username
		$mail->Password = $smtp_pw; // GMAIL password
		$mail->isHTML(true);
		//Typical mail data (simple data or attached data)
		$mail->AddAddress($email, $name);
		// print_r($conf->global);
		$soc = "Société";
		if($conf->global->MAIN_INFO_SOCIETE_MAIL)
			$soc = $conf->global->MAIN_INFO_SOCIETE_MAIL;

		
		$mail->SetFrom($soc,$conf->global->MAIN_INFO_SOCIETE_NOM);
		$mail->Subject = $title;
		// $mail->Body = $subject;
		$mail->Body = html_entity_decode($subject);

		// print_r('$mail');die();
		$mail->AddAttachment(dol_buildpath('/avancementtravaux/export/elaboration_pv.pdf'));
		try{
		    $mail->Send();
		    
		    // echo "Success!";
		    return 1;
		} catch(Exception $e){
		    //Something went bad
		    setEventMessage("SMTP connect() failed","errors");
		    // echo "Fail - " . $mail->ErrorInfo;
		    return 0;
		}

    }


    public function send_export($id,$mode){
    	global $langs,$mysoc;
    	require_once dol_buildpath('/avancementtravaux/elaboration_pv/pdf/pdf.lib.php');
		dol_include_once('/avancementtravaux/class/intervenants.class.php');
		dol_include_once('/avancementtravaux/class/representant.class.php');
    	require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
		require_once DOL_DOCUMENT_ROOT.'/projet/class/task.class.php';

    	$projet        = new Project($this->db);
		$tache        = new Task($this->db);
		$intervenants  = new intervenants($this->db);
		$representant  = new representant($this->db);
	    $pdf->SetFont('times', '', 9, '', true);
	    $pdf->AddPage('P');
	    $array_format = pdf_getFormat();
	    $this->fetch($id);
	    $marge_haute =isset($conf->global->MAIN_PDF_MARGIN_TOP)?$conf->global->MAIN_PDF_MARGIN_TOP:10;
	    $marge_basse =isset($conf->global->MAIN_PDF_MARGIN_BOTTOM)?$conf->global->MAIN_PDF_MARGIN_BOTTOM:10;
	    $margin = $marge_haute+$marge_basse+45;

	    $page_largeur = $formatarray['width'];
	    $page_hauteur = $formatarray['height'];
	    $format = array($page_largeur,$page_hauteur);

	    $marge_gauche=isset($conf->global->MAIN_PDF_MARGIN_LEFT)?$conf->global->MAIN_PDF_MARGIN_LEFT:10;
	    $marge_droite=isset($conf->global->MAIN_PDF_MARGIN_RIGHT)?$conf->global->MAIN_PDF_MARGIN_RIGHT:10;
	    $marge_haute =isset($conf->global->MAIN_PDF_MARGIN_TOP)?$conf->global->MAIN_PDF_MARGIN_TOP:10;
	    $marge_basse =isset($conf->global->MAIN_PDF_MARGIN_BOTTOM)?$conf->global->MAIN_PDF_MARGIN_BOTTOM:10;
	    $emetteur = $mysoc;



	    $default_font_size = pdf_getPDFFontSize($langs);

	    pdf_pagehead($pdf,$langs,$page_hauteur);

	    // // Show Draft Watermark
	    // if($this->statut==0 && (! empty($conf->global->COMMANDE_DRAFT_WATERMARK)) )
	    // {
	    //     pdf_watermark($pdf,$langs,$page_hauteur,$page_largeur,'mm',$conf->global->COMMANDE_DRAFT_WATERMARK);
	    // }

	    $pdf->SetTextColor(0,0,60);
	    $pdf->SetFont('','B', $default_font_size + 3);

	    $posy=$marge_haute;
	    $posx=$page_largeur-$marge_droite-100;

	    $pdf->SetXY($marge_gauche,$posy);

	    // Logo
	    $logo=$conf->mycompany->dir_output.'/logos/'.$emetteur->logo;

	    if ($emetteur->logo)
	    {
	        if (is_readable($logo))
	        {
	            $height=pdf_getHeightForLogo($logo);
	            $pdf->Image($logo, $marge_gauche, $posy, 0, $height); // width=0 (auto)
	        }
	        else
	        {
	            $pdf->SetTextColor(200,0,0);
	            $pdf->SetFont('','B', $default_font_size -2);
	            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorLogoFileNotFound",$logo), 0, 'L');
	            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorGoToGlobalSetup"), 0, 'L');
	        }
	    }
	    else
	    {
	        $text=$emetteur->name;
	        $pdf->MultiCell(100, 4, $langs->convToOutputCharset($text), 0, 'L');
	    }

	    $pdf->SetFont('','B', $default_font_size + 3);
	    $pdf->SetXY($posx,$posy);
	    $pdf->SetTextColor(0,0,60);
	    $title=$langs->trans("Objet")." : ".$this->objet;
	    $pdf->MultiCell(100, 3, $title, '', 'R');

	    $pdf->SetFont('','B',$default_font_size);

	    $posy+=5;
	    $pdf->SetXY($posx,$posy);
	    $pdf->SetTextColor(0,0,60);
	    // $pdf->MultiCell(100, 4, $langs->transnoentities("Objet")." : " . $langs->convToOutputCharset($this->objet), '', 'R');

	    


	    // Sender properties
	    $carac_emetteur='';
	    // Add internal contact of proposal if defined
	    $arrayidcontact=$this->getIdContact('internal','SALESREPFOLL');
	    if (count($arrayidcontact) > 0)
	    {
	        $this->fetch_user($arrayidcontact[0]);
	        $labelbeforecontactname=($langs->transnoentities("FromContactName")!='FromContactName'?$langs->transnoentities("FromContactName"):$langs->transnoentities("Name"));
	        $carac_emetteur .= ($carac_emetteur ? "\n" : '' ).$labelbeforecontactname." ".$langs->convToOutputCharset($this->user->getFullName($langs))."\n";
	    }

	    $carac_emetteur .= pdf_build_address($langs, $emetteur, $this->thirdparty, '', 0, 'source', $this);

	    // Show sender
	    $posy=42+$top_shift;
	    $posx=$marge_gauche;
	    if (! empty($conf->global->MAIN_INVERT_SENDER_RECIPIENT)) $posx=$page_largeur-$marge_droite;
	    $hautcadre=40;

	    // Show sender frame
	    $pdf->SetTextColor(0,0,0);
	    $pdf->SetFont('','', $default_font_size - 2);
	    $pdf->SetXY($posx,$posy-5);
	    // $pdf->MultiCell(66,5, $langs->transnoentities("BillFrom").":", 0, 'L');
	    $pdf->SetXY($posx,$posy);
	    $pdf->SetFillColor(230,230,230);
	    $pdf->MultiCell($page_largeur, $hautcadre, "", 0, 'R', 1);
	    $pdf->SetTextColor(0,0,60);

	    // Show sender name
	    $pdf->SetXY($posx+2,$posy+3);
	    $pdf->SetFont('','B', $default_font_size);
	    $pdf->MultiCell(80, 4, $langs->convToOutputCharset($emetteur->name), 0, 'L');
	    $posy=$pdf->getY();

	    // Show sender information
	    $pdf->SetXY($posx+2,$posy);
	    $pdf->SetFont('','', $default_font_size - 1);
	    $pdf->MultiCell($page_largeur, 4, $carac_emetteur, 0, 'L');



	    // If CUSTOMER contact defined on order, we use it
	    $usecontact=false;
	    $arrayidcontact=$this->getIdContact('external','CUSTOMER');
	    if (count($arrayidcontact) > 0)
	    {
	        $usecontact=true;
	        $result=$this->fetch_contact($arrayidcontact[0]);
	    }





	    
	    

	    $pdf->setPrintFooter(true);
	    // require template
	    $item=$this;
	    require_once dol_buildpath('/avancementtravaux/elaboration_pv/export/export_elaboration.php');
	    // echo $html;
	    // die();
	    $posy=$pdf->getY();
	    $pdf->SetXY($posx+2,$posy + 20);
	    $pdf->writeHTML($html, true, false, true, false, '');
	    ob_start();
	    if($mode =='F'){
	        $name = dol_buildpath('/avancementtravaux/export/elaboration_pv.pdf');
	    }
	    else{
	        $name = 'Elaboration_pv.pdf';
	    }
	        $pdf->Output($name,$mode);
	    // ob_end_clean();
    }

   
} 


?>