<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) <year>  <name of author>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *     \file        admin/admin.php
 *     \ingroup    nexttheme
 *     \brief        This file is an example module setup page
 *                 Put some comments here
 */
// Dolibarr environment
$res=@include("../../main.inc.php");                    // For root directory
if (! $res && file_exists($_SERVER['DOCUMENT_ROOT']."/main.inc.php"))
    $res=@include($_SERVER['DOCUMENT_ROOT']."/main.inc.php"); // Use on dev env only
if (! $res) $res=@include("../../../main.inc.php");        // For "custom" directory

// Libraries
require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';

// dol_include_once('/nexttheme/lib/nexttheme.lib.php');


// Translations
$langs->load("admin");
$langs->load("avancementtravaux@avancementtravaux");

// Access control
if (! $user->admin) accessforbidden();



/*
 * Actions
 */
$mesg="";
$action = GETPOST('action', 'alpha');


if ($action == 'settypesociete') {
    // die(); 
    $societetype = GETPOST('AVANCEMENTTRAVAUX_SOCIETE_TYPE');
    $res = dolibarr_set_const($db, "AVANCEMENTTRAVAUX_SOCIETE_TYPE", $societetype,'chaine',0,'',$conf->entity);
}

// Get settings
$societetype=$conf->global->AVANCEMENTTRAVAUX_SOCIETE_TYPE;
if(empty($societetype))
    $societetype = "BET";

/*
 * View
 */
$page_name = "avancementtravauxSetup";
llxHeader('', $langs->trans($page_name),'','','','', array(''),'' );

// Subheader
$linkback = '<a href="' . DOL_URL_ROOT . '/admin/modules.php">'    . $langs->trans("BackToModuleList") . '</a>';
print_fiche_titre($langs->trans($page_name), $linkback);

// Configuration header
// $head = nexttheme_admin_prepare_head();
// dol_fiche_head(
//     $head,
//     'settings',
//     $langs->trans("Module500500Name"),
//     0,
//     "logo@nexttheme"
// );

dol_htmloutput_mesg($mesg);


// Setup page goes here

print '<br>'."\n";

// COLORS
// print '<div class="subsetting-title">' . $langs->trans("AS_SettingsColors") . '</div>';
print '<form id="col1-form" method="post" action="admin.php">';
print '<input type="hidden" value="settypesociete" name="action">';
print '<table class="noborder as-settings-colors">';

// HEADER ROW
/*
print '<tr class="liste_titre">';
print     '<th>' . $langs->trans("Name") . '</td>';
print     '<th>' . $langs->trans("Value") . '</td>';
print "</tr>\n";
*/
print '
<tr class="liste_titre">
    <th>' . $langs->trans("Name") . '</td>
    <th>' . $langs->trans("Value") . '</td>
    <th></td>
</tr>
'."\n";

// SET PRIMARY COLOR
print '
<tr class="pair">
    <td>' . $langs->trans("Identification société") . '</td>';
    print '<td>';
    $html = '<select name="AVANCEMENTTRAVAUX_SOCIETE_TYPE">';
    $html .= '<option value="BET">BET</option>';
    $html .= '<option value="BEC">BEC</option>';
    $html .= '<option value="entreprise">entreprise</option>';
    $html .= '<option value="laboratoire">laboratoire</option>';
    $html .= '<option value="topographe">topographe</option>';
    $html .= '<option value="architecte">architecte</option>';
    $html .= '</select>';
    $html = str_replace('value="'.$societetype.'"', 'value="'.$societetype.'" selected', $html);
    echo $html;
    print '</td>';
    print '<td>';
    print '<input type="submit" value="'.$langs->trans('Validate').'">';
    print '</td>';
print '</tr>
'."\n";


print '</table>';
print '</form>';
print '
<br>
<br>
';

print '<br>';


// Page end
dol_fiche_end();
llxFooter();
$db->close();
?>