/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.office;

import com.sun.star.beans.PropertyValue;
import com.sun.star.uno.UnoRuntime;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Map;
import org.artofsolving.jodconverter.util.PlatformUtils;

public class OfficeUtils {
    public static final String SERVICE_DESKTOP = "com.sun.star.frame.Desktop";

    private OfficeUtils() {
        throw new AssertionError((Object)"utility class must not be instantiated");
    }

    public static <T> T cast(Class<T> type, Object object) {
        return (T)UnoRuntime.queryInterface(type, (Object)object);
    }

    public static PropertyValue property(String name, Object value) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = name;
        propertyValue.Value = value;
        return propertyValue;
    }

    public static PropertyValue[] toUnoProperties(Map<String, ?> properties) {
        PropertyValue[] propertyValues = new PropertyValue[properties.size()];
        int i = 0;
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map subProperties = (Map)value;
                value = OfficeUtils.toUnoProperties(subProperties);
            }
            propertyValues[i++] = OfficeUtils.property(entry.getKey(), value);
        }
        return propertyValues;
    }

    public static String toUrl(File file) {
        String path = file.toURI().getRawPath();
        String url = path.startsWith("//") ? "file:" + path : "file://" + path;
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    public static File getDefaultOfficeHome() {
        if (System.getProperty("office.home") != null) {
            return new File(System.getProperty("office.home"));
        }
        if (PlatformUtils.isWindows()) {
            String programFiles = System.getenv("ProgramFiles(x86)");
            if (programFiles == null) {
                programFiles = System.getenv("ProgramFiles");
            }
            return OfficeUtils.findOfficeHome(programFiles + File.separator + "OpenOffice.org 3", programFiles + File.separator + "OpenOffice 4", programFiles + File.separator + "LibreOffice 3", programFiles + File.separator + "LibreOffice 4");
        }
        if (PlatformUtils.isMac()) {
            File officeHome = OfficeUtils.findOfficeHome("/Applications/OpenOffice.org.app/Contents", "/Applications/LibreOffice.app/Contents");
            if (officeHome == null) {
                officeHome = OfficeUtils.locateOfficeHome();
            }
            return officeHome;
        }
        File officeHome = OfficeUtils.findOfficeHome("/opt/openoffice", "/opt/libreoffice", "/usr/bin/openoffice", "/usr/bin/libreoffice", "/usr/lib/openoffice", "/usr/lib/libreoffice", "/usr/local/lib/openoffice", "/usr/local/lib/libreoffice");
        if (officeHome == null) {
            officeHome = OfficeUtils.locateOfficeHome();
        }
        return officeHome;
    }

    private static File locateOfficeHome() {
        String s = null;
        String cmd = "locate soffice.bin";
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            int i = p.waitFor();
            if (i == 0) {
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((s = stdInput.readLine()) != null) {
                    File f = new File(s);
                    if (!f.exists() || !f.getName().equalsIgnoreCase("soffice.bin") || f.getParentFile() == null || f.getParentFile().getParentFile() == null) continue;
                    return f.getParentFile().getParentFile();
                }
            } else {
                BufferedReader stdErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((s = stdErr.readLine()) != null) {
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static File findOfficeHome(String ... knownPaths) {
        for (String path : knownPaths) {
            File home = new File(path);
            File containerPath = home.getParentFile();
            if (containerPath == null || !containerPath.isDirectory()) continue;
            for (File subDir : containerPath.listFiles()) {
                if (!subDir.isDirectory() || !subDir.getName().startsWith(home.getName()) || !OfficeUtils.getOfficeExecutable(subDir).isFile()) continue;
                return home;
            }
        }
        return null;
    }

    public static File getOfficeExecutable(File officeHome) {
        if (PlatformUtils.isMac()) {
            return new File(officeHome, "MacOS/soffice.bin");
        }
        if (PlatformUtils.isWindows()) {
            return new File(officeHome, "program/soffice.exe");
        }
        return new File(officeHome, "program/soffice.bin");
    }
}

