<?php
/* Copyright (C) ---Put here your own copyright and developer email---
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file    lib/unidadmedida.lib.php
 * \ingroup unidadmedida
 * \brief   Library files with common functions for unidadalt
 */

/**
 * Prepare array of tabs for unidadalt
 *
 * @param	unidadalt	$object		unidadalt
 * @return 	array					Array of tabs
 */
function unidadmedidaPrepareHead()
{
	global $db, $langs, $conf;

	$langs->load("unidadmedida@unidadmedida");

	$h = 0;
	$head = array();

	$head[$h][0] = dol_buildpath("/unidadmedida/admin/setup.php", 1);
	$head[$h][1] = $langs->trans("Setup");
	$head[$h][2] = 'settings';
	$h++;

	$head[$h][0] = dol_buildpath("/unidadmedida/admin/productos.php", 1);
	$head[$h][1] = $langs->trans('Productos');
	//$head[$h][1].= ' <span class="badge">'.(2).'</span>';
	$head[$h][2] = 'document';
	$h++;

	$head[$h][0] = dol_buildpath("/unidadmedida/admin/unidadesmedida.php?id=26", 1);
	$head[$h][1] = $langs->trans('Unidades de Medida');
	$head[$h][2] = 'unidades';
	$h++;


	// Show more tabs from modules
	// Entries must be declared in modules descriptor with line
	//$this->tabs = array(
	//	'entity:+tabname:Title:@unidadmedida:/unidadmedida/mypage.php?id=__ID__'
	//); // to add new tab
	//$this->tabs = array(
	//	'entity:-tabname:Title:@unidadmedida:/unidadmedida/mypage.php?id=__ID__'
	//); // to remove a tab
	complete_head_from_modules($conf, $langs, $object, $head, $h, 'unidadalt@unidadmedida');

	return $head;
}
