<?php
/* Copyright (C) 2004-2017 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2018 SuperAdmin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file    unidadmedida/admin/setup.php
 * \ingroup unidadmedida
 * \brief   UnidadMedida setup page.
 */

// Load Dolibarr environment
$res = 0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (!$res && !empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) $res = @include($_SERVER["CONTEXT_DOCUMENT_ROOT"] . "/main.inc.php");
// Try main.inc.php into web root detected using web root calculated from SCRIPT_FILENAME
$tmp = empty($_SERVER['SCRIPT_FILENAME']) ? '' : $_SERVER['SCRIPT_FILENAME'];
$tmp2 = realpath(__FILE__);
$i = strlen($tmp) - 1;
$j = strlen($tmp2) - 1;
while ($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i] == $tmp2[$j]) {
    $i--;
    $j--;
}
if (!$res && $i > 0 && file_exists(substr($tmp, 0, ($i + 1)) . "/main.inc.php")) $res = @include(substr($tmp, 0, ($i + 1)) . "/main.inc.php");
if (!$res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i + 1))) . "/main.inc.php")) $res = @include(dirname(substr($tmp, 0, ($i + 1))) . "/main.inc.php");
// Try main.inc.php using relative path
if (!$res && file_exists("../../main.inc.php")) $res = @include("../../main.inc.php");
if (!$res && file_exists("../../../main.inc.php")) $res = @include("../../../main.inc.php");
if (!$res) die("Include of main fails");

global $langs, $user, $db;

// Libraries
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
require_once '../lib/unidadmedida.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT . '/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT . '/product/class/html.formproduct.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/product.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/functions.lib.php';
require_once '../class/cunits.class.php';
require_once '../class/unidadalt.class.php';

//require_once "../class/myclass.class.php";

// Translations
$langs->loadLangs(array("admin", "unidadmedida@unidadmedida"));
$langs->loadLangs(array('products', 'other'));
// Access control
if (!$user->admin) accessforbidden();

// Parameters
$action = GETPOST('action', 'alpha');
$backtopage = GETPOST('backtopage', 'alpha');

$arrayofparameters = array(
    'UNIDADMEDIDA_MYPARAM1' => array('css' => 'minwidth200', 'enabled' => 1),
    'UNIDADMEDIDA_MYPARAM2' => array('css' => 'minwidth500', 'enabled' => 1)
);


/*
 * Actions
 */
if ((float)DOL_VERSION >= 6) {
    include DOL_DOCUMENT_ROOT . '/core/actions_setmoduleoptions.inc.php';
}


/*
 * View
 */

$page_name = "UnidadMedidaSetup";
llxHeader('', $langs->trans($page_name));

// Subheader
$linkback = '<a href="' . ($backtopage ? $backtopage : DOL_URL_ROOT . '/admin/modules.php?restore_lastsearch_values=1') . '">' . $langs->trans("BackToModuleList") . '</a>';

print load_fiche_titre($langs->trans($page_name), $linkback, 'object_unidadmedida@unidadmedida');

// Configuration header
$head = unidadmedidaPrepareHead();
dol_fiche_head($head, 'settings', '', -1, "unidadmedida@unidadmedida");

// Setup page goes here
print '<div class="info">';
print img_picto($langs->trans('Warning'), 'warning');
print ' ' . $langs->trans("Unidad de Medida x Factor= Unidad de Medida Alternativa");
//print ' (' . $suma_coeficiente . ')';
print '</div>';
$formproduct = new FormProduct($db);
$unidadessistema = new Cunits($db);
$unidadalt = new unidadalt($db);

if ($action == 'edit') {
//	print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
//	print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
//	print '<input type="hidden" name="action" value="update">';
//
//	print '<table class="noborder" width="100%">';
//	print '<tr class="liste_titre"><td class="titlefield">'.$langs->trans("Parameter").'</td><td>'.$langs->trans("Value").'</td></tr>';
//
//	foreach($arrayofparameters as $key => $val)
//	{
//		if (isset($val['enabled']) && empty($val['enabled'])) continue;
//
//		print '<tr class="oddeven"><td>';
//		print $form->textwithpicto($langs->trans($key),$langs->trans($key.'Tooltip'));
//		print '</td><td><input name="'.$key.'"  class="flat '.(empty($val['css'])?'minwidth200':$val['css']).'" value="' . $conf->global->$key . '"></td></tr>';
//	}
//
//	print '</table>';
//
//	print '<br><div class="center">';
//	print '<input class="button" type="submit" value="'.$langs->trans("Save").'">';
//	print '</div>';
//
//	print '</form>';
//	print '<br>';
} else {
//	print '<table class="noborder" width="100%">';
//	print '<tr class="liste_titre"><td class="titlefield">'.$langs->trans("Parameter").'</td><td>'.$langs->trans("Value").'</td></tr>';
//
//	foreach($arrayofparameters as $key => $val)
//	{
//		print '<tr class="oddeven"><td>';
//		print $form->textwithpicto($langs->trans($key),$langs->trans($key.'Tooltip'));
//		print '</td><td>' . $conf->global->$key . '</td></tr>';
//	}
//
//	print '</table>';


}
if ($action == 'nuevo') {
    $factor = GETPOST('factor', 'int');
    if ((float)$factor<=0){
        setEventMessages($langs->trans('El Factor debe ser mayor que 0'), null, 'errors');
    }
    else{
        $token = GETPOST('token');
        //$_SESSION['token'];
        $umf = GETPOST('umf', 'int');
        $uma = GETPOST('uma', 'int');
        $unidadalt->fk_c_units_rowid = $umf;
        $unidadalt->umalt = $uma;
        $unidadalt->amount = $factor;
        $unidadalt->new = 1;
        $unidadalt->fk_user_modif = $user->id;
        $res = $unidadalt->create($user);
        if ($res >= 0) {
            setEventMessages($langs->trans('RecordAddedSuccessfully'), null, 'mesgs');
        } else {
            setEventMessages($unidadalt->db->lasterror, null, 'errors');
        }
    }



}
elseif ($action=='delete'){
    $id=GETPOST('id');
    $id="'".$id. "'";
    $unidadalt->fetchtms($id);
    $res=$unidadalt->deletefecha($id);
    if ($res >= 0) {
        setEventMessages($langs->trans('RecordDeleteSuccessfully'), null, 'mesgs');
    } else {
        setEventMessages($unidadalt->db->lasterror, null, 'errors');
    }

}

//print '<table class="noborder" width="100%">' .
//	'<tr class="liste_titre"><td class="titlefield">'.$langs->trans("Documento").'</td>'.
//	'<td>'.$langs->trans("Value").'</td>'.
//	'<td style="width:30%">Conversion (1 Unidad x Unidad Alt)</td></tr>'.
//	'<tr class="oddeven"><td class="titlefield">'.$langs->trans("Unidad de Factura de Venta").'</td>' .
//	'<td>'.$langs->trans("Unanananaa").'</td>' .
//	 '<td colspan="2" rowspan="2"  style="text-align:center;border-style:solid;border-color:burlywood;border-width:thin"> <input type = "text" class="form-control" name = "convfv" id = "convfv" placeholder = "1 X Cantidad" ></td>'.
//	'</tr>' .
//	'<tr class="oddeven"><td class="titlefield">'.$langs->trans("Unidad Alternativa de Factura de Venta").'</td>' .
//	'<td>'.$langs->trans("Unanananaa").'</td>' .
//	'</tr>' .
//	'<tr class="oddeven"><td class="titlefield">'.$langs->trans("Unidad de Factura de Compra").'</td>' .
//	'<td>'.$langs->trans("Unanananaa").'</td>' .
//	'<td colspan="2" rowspan="2" style="text-align:center;border-style:solid;border-color:burlywood;border-width:thin"> <input type = "text" class="form-control" name = "convfc" id = "convfc" placeholder = "1 X Cantidad" ></td>'.
//	'</tr>' .
//	'<tr class="oddeven"><td class="titlefield">'.$langs->trans("Unidad Alternativa de Factura de Compra").'</td>' .
//	'<td>'.$langs->trans("Unanananaa").'</td>' .
//	'</tr>' .
//	'</table>';
//print '<div class="tabsAction">';
//print '<a class="butAction" href="'.$_SERVER["PHP_SELF"].'?action=edit">'.$langs->trans("Save").'</a>';
//print '</div>';

$unidades = $unidadessistema->fetchAll();
$unidadalt->fetchAll();
print "<table class=\"noborder\" width=\"100%\">";
print "<tr class=\"liste_titre\">";
print "<td class=\"titlefield\">" . $langs->trans("Unidad de Medida") . "</td>";
print "<td>" . $langs->trans("Unidad de Medida Alternativa") . "</td>\n";
print "<td>" . $langs->trans("Factor") . "</td>";
print "<td>" . $langs->trans("Accion") . "</td>";
print "</tr>";
$i = 0;
foreach ($unidadalt->lines as $line) {
    //print $unidadessistema->select_measuring_units("umf","all",4);
    print "<tr>";
    print "<td>";
    $result = $unidadalt->searcharray($unidades, 'id', $line['fk_c_units_rowid']);
    $resulta = $unidadalt->searcharray($unidades, 'id', $line['umalt']);
    $result1 = $result[0]->label;
    $result2 = $resulta[0]->label;
    print $langs->trans($result1);
    print "</td>";
    print "<td>";
    print $langs->trans($result2);
    print "</td>";
    print "<td>";
    print  number_format($line['amount'], 2);
    print "</td>";
    print "<td>";
if ($line['new']=="1"){
    print '<a class="butActionNew" href="'.$_SERVER["PHP_SELF"].'?action=delete&id='.$line['tms'].'"><span></span><span title="'.$langs->trans("Eliminar").'" class="fa fa-minus-circle valignmiddle"></span></a>';
}
    print "</td>";
    print "</tr>";
    $i++;
}


print "</table>";

print '<form method="POST" action="' . $_SERVER["PHP_SELF"] . '">';
print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
print '<input type="hidden" name="action" value="nuevo">';
print '<input type="hidden" name="new" value="1">';
print "<table class=\"noborder\" width=\"100%\">";
print "<tr class=\"liste_titre\">";
print "<td class=\"titlefield\">" . $langs->trans("Unidad de Medida") . "</td>";
print "<td>" . $langs->trans("Unidad de Medida Alternativa") . "</td>\n";
print "<td>" . $langs->trans("Factor") . "</td>";
print "<td>" . $langs->trans("Accion") . "</td>";
print "</tr>";
print "<tr>";
print "<td>";
print $unidadessistema->select_measuring_units("umf", "all", -1);
print "</td>";
print "<td>";
print $unidadessistema->select_measuring_units("uma", "all", -1);
print "</td>";
print '<td><input type="text" name="factor" value=""></td>';
print '<td><button class="butActionNew" type="submit"><span class="valignmiddle">' . $langs->trans("Nuevo") . '</span><span class="fa fa-plus-circle valignmiddle"></span></button></td>';
print "</tr>";
print "</table>";
print "</form>";
// Page end
dol_fiche_end();

llxFooter();
$db->close();




