<?php
/* Copyright (C) 2014-2019 Philippe Grand  <philippe.grand@atoo-net.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

/**
 *   \file       htdocs/ultimateqrcode/qrcodecontact.php
 *   \brief      Tab for contact QR-code
 *   \ingroup    ultimateqrcode
 */

$res=0;
if (! $res && file_exists("../main.inc.php")) $res=@include("../main.inc.php");
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");
if (! $res) die("Include of main fails");

require_once DOL_DOCUMENT_ROOT.'/contact/class/contact.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/contact.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
include_once("./lib/ultimateqrcode.lib.php");
require_once("./includes/phpqrcode/qrlib.php"); 

// Load translation files required by the page
$langs->loadLangs(array("companies", "contacts", "ultimateqrcode@ultimateqrcode"));

// Security check
$id		= GETPOST('id','int');
$socid  = GETPOST('socid','int');
if ($user->societe_id) $socid=$user->societe_id;
$result = restrictedArea($user, 'contact', $id, 'socpeople&societe');
$object = new Contact($db);

if (!$user->rights->ultimateqrcode->read) accessforbidden();


/*
 *	View
 */


$form = new Form($db);
llxHeader('',$langs->trans("UltimateqrcodeQrcode"));


/*
 * Affichage onglets
 */
    if ($conf->notification->enabled) $langs->load("mails");
	
	$object->fetch($id, $user);

	$head = contact_prepare_head($object);
	
	dol_fiche_head($head, 'tabqrcodecontact', $langs->trans("Contacts"), -1, 'contact');
	
	$linkback = '<a href="'.DOL_URL_ROOT.'/contact/list.php?restore_lastsearch_values=1">'.$langs->trans("BackToList").'</a>';
	
	$morehtmlref='<div class="refidno">';
    if (empty($conf->global->SOCIETE_DISABLE_CONTACTS))
    {
        $objsoc=new Societe($db);
        $objsoc->fetch($object->socid);
        // Thirdparty
        $morehtmlref.=$langs->trans('ThirdParty') . ' : ';
        if ($objsoc->id > 0) $morehtmlref.=$objsoc->getNomUrl(1);
        else $morehtmlref.=$langs->trans("ContactNotLinkedToCompany");
    }
    $morehtmlref.='</div>';

    dol_banner_tab($object, 'id', $linkback, 1, 'rowid', 'ref', $morehtmlref);
	
	$png_web_dir = 'temp/';
	$tempDir = dirname(__FILE__).DIRECTORY_SEPARATOR.$png_web_dir; 
	if (!file_exists($tempDir))
        mkdir($tempDir);  
	
	// we're building raw data
    $codeContents  = 'BEGIN:VCARD'."\n";
    $codeContents .= 'FN:'.$object->firstname."\n";
	$codeContents .= 'LN:'.$object->lastname."\n";
    $codeContents .= 'TEL;WORK;VOICE:'.$object->phone_mobile."\n";
	$codeContents .= 'ADR;TYPE=work;'.
        'LABEL="'.$addressLabel.'":'
        .$object->address.';'
		.$object->zip.';'
        .$object->town.';'       
        .$object->country."\n";
	$codeContents .= 'EMAIL:'.$object->email."\n"; 
    $codeContents .= 'END:VCARD';

	$filename = $tempDir.md5($codeContents).'.VCARD.png';
	// generating
    QRcode::png($codeContents, $filename, QR_ECLEVEL_L, 3); 
	
	print '<div class="fichecenter">';
	print '<div class="fichehalfleft">';

	print '<div class="underbanner clearboth"></div>';
	print '<table class="border tableforfield" width="100%">';	
	
    // FirstName LastName
    print '<tr><td width="25%">'.$langs->trans('ContactName').'</td>';
    print '<td colspan="3">';
    print $object->firstname.' '.$object->lastname;
    print '</td>';
    print '</tr>';
		
	// displaying QRcode
	$htmlqrcode='';
	$rowspan=5;
	$htmlqrcode.='<td rowspan="'.$rowspan.'" style="text-align: center;" width="25%">';
	if ($filename)   $htmlqrcode.='<img src="'.$png_web_dir.basename($filename).'" />';
	$htmlqrcode.='</td>';
	
	// Address
    print "<tr><td valign=\"top\">".$langs->trans('Address').'</td><td colspan="3">';
    dol_print_address($object->address,'gmap','thirdparty',$object->id);
    print '</td>';
	print $htmlqrcode; 
	print '</tr>';
	
	// Zip / Town
    print '<tr><td width="25%">'.$langs->trans('Zip').' / '.$langs->trans("Town").'</td><td colspan="3">';
    print $object->zip.($object->zip && $object->town?" / ":"").$object->town;
    print '</td></tr>';

    // Country
    print '<tr><td>'.$langs->trans("Country").'</td><td colspan="3" class="nowrap">';
    if (! empty($object->country_code))
    {
        $img=picto_from_langcode($object->country_code);
        if ($object) print $form->textwithpicto(($img?$img.' ':'').$object->country,$langs->trans("CountryIsInEEC"),1,0);
        else print ($img?$img.' ':'').$object->country;
    }
    print '</td></tr>';
	
	// Phone
    print '<tr><td width="25%">'.$langs->trans('Phone').'</td>';
    print '<td colspan="3">';
    print $object->phone_mobile;
    print '</td>';
    print '</tr>';
	
	// EMail
    print '<tr><td>'.$langs->trans('EMail').'</td><td colspan="3">';
    print dol_print_email($object->email,0,$object->id,'AC_EMAIL');
    print '</td></tr>';
	
	print '</table>';
	print '<br><br><br>';
	
	// we're building raw data
    $codeContents2 .= dirname($_SERVER['SERVER_PROTOCOL']) . "://" . $_SERVER['HTTP_HOST'] .'/contact/card.php?id='.$object->id;
	
	$filename2 = $tempDir.md5($codeContents2).'.contact_link.png';

	// generating
    QRcode::png($codeContents2, $filename2, QR_ECLEVEL_L, 3); 
	print '<table class="border" width="100%">';
	
	// displaying QRcode
	$htmlqrcode2='';
	$rowspan=4;
	$htmlqrcode2.='<td rowspan="'.$rowspan.'" style="text-align: center;" width="25%">';
	if ($filename)   $htmlqrcode2.='<img src="'.$png_web_dir.basename($filename2).'" />';
	$htmlqrcode2.='</td>';
	
	// Ref
    print '<td width="15%">'.$langs->trans("UrlContactFile").'</td><td colspan="3">';
	print $object->getNomUrl(0);
	print '</td>';
	print $htmlqrcode2;
	print '</tr>';
	print '</table>';
	
	dol_fiche_end();


llxFooter();

$db->close();
?>
