<?php

// Load Dolibase
include_once 'autoload.php';

// Load Dolibase Page class
dolibase_include_once('/core/pages/setup.php');

// Create Page using Dolibase
$page = new SetupPage("ThemeCustomizer", '$user->rights->theme_customizer->customize', true);
$page->setTitleLink(DOL_URL_ROOT.'/admin/ihm.php?mainmenu=home', 'GoToDisplaySettings');

// Get parameters
$action = GETPOST('action', 'alpha');

global $db, $conf, $user;

// Set Actions
if (preg_match('/^(set|del)_(.*)/', $action, $reg))
{
	$param = $reg[2];
	$value = (is_submitted($param) ? GETPOST($param) : ($action[0] == 's' ? 1 : 0));

	if (dol_set_user_param($db, $conf, $user, array('THEME_ELDY_ENABLE_PERSONALIZED' => '1', $param => $value)))
	{
		dolibase_redirect($_SERVER["PHP_SELF"].'?mainmenu=home');
	}
	else
	{
		dol_print_error($db);
	}
}

// Set Tabs
$page->addTab("General", "/themecustomizer/index.php?mainmenu=home");
$page->addTab("Menus", "/themecustomizer/menus.php?mainmenu=home", true);
$page->addTab("Body", "/themecustomizer/body.php?mainmenu=home");
$page->addTab("Buttons", "/themecustomizer/buttons.php?mainmenu=home");
$page->addTab("Graphs", "/themecustomizer/graphs.php?mainmenu=home");
if ($user->admin) {
	$page->addTab("LoginPage", "/themecustomizer/login_page.php?mainmenu=home");
}
$page->addTab("Advanced", "/themecustomizer/advanced.php?mainmenu=home");

$page->begin();

// Top Menu
$table_header = array(
	array('name' => 'TopMenu'),
	array('name' => '', 'attr' => 'align="center" width="100"')
);

$page->openTable($table_header);

$option_name = "HIDE_TOPMENU";
$conf->global->$option_name = isset($user->conf->HIDE_TOPMENU) ? $user->conf->HIDE_TOPMENU : ($conf->dol_hide_topmenu ? true : false);
$page->addSwitchOption("HideTopMenu", $option_name);

$option_name = "DISABLE_TOPMENU_IMAGE";
$conf->global->$option_name = isset($user->conf->DISABLE_TOPMENU_IMAGE) ? $user->conf->DISABLE_TOPMENU_IMAGE : false;
$page->addSwitchOption("HideTopIcons", $option_name);

if (compare_version(DOL_VERSION, '<' ,'7.0.0'))
{
	$option_name = "HIDE_TOPMENU_SEPARATOR";
	$conf->global->$option_name = isset($user->conf->HIDE_TOPMENU_SEPARATOR) ? $user->conf->HIDE_TOPMENU_SEPARATOR : false;
	$page->addSwitchOption("HideTopSeparator", $option_name);
}

$option_name = "THEME_ELDY_TOPMENU_BACK1";
$conf->global->$option_name = isset($user->conf->THEME_ELDY_TOPMENU_BACK1) ? $user->conf->THEME_ELDY_TOPMENU_BACK1 : '';
$page->addColorOption("TopMenuBackColor", $option_name);

$option_name = "TOPMENU_TEXT_COLOR";
$conf->global->$option_name = isset($user->conf->TOPMENU_TEXT_COLOR) ? $user->conf->TOPMENU_TEXT_COLOR : '';
$page->addColorOption("TopMenuTextColor", $option_name);

$option_name = "DISABLE_HELP_LINK";
$conf->global->$option_name = isset($user->conf->DISABLE_HELP_LINK) ? $user->conf->DISABLE_HELP_LINK : ($conf->global->MAIN_HELP_DISABLELINK ? true : false);
$page->addSwitchOption($langs->trans("DisableHelpLink", img_picto('', DOL_URL_ROOT.'/theme/'.$conf->theme.'/img/helpdoc.png', 'style="vertical-align: middle;"', 1)), $option_name);

if (compare_version(DOL_VERSION, '<' ,'10.0.0') && $conf->theme != 'md')
{
	$option_name = "PULL_LEFT_LOGIN_BLOCK";
	$conf->global->$option_name = isset($user->conf->PULL_LEFT_LOGIN_BLOCK) ? $user->conf->PULL_LEFT_LOGIN_BLOCK : false;
	$page->addSwitchOption("PullLeftLoginBlock", $option_name);
	$pull_left_login_block = $conf->global->$option_name;

	if (! $pull_left_login_block)
	{
		$option_name = "ARRANGE_LOGIN_BLOCK";
		$conf->global->$option_name = isset($user->conf->ARRANGE_LOGIN_BLOCK) ? $user->conf->ARRANGE_LOGIN_BLOCK : false;
		$page->addSwitchOption("ArrangeLoginBlock", $option_name);
	}
}

if (compare_version(DOL_VERSION, '<' ,'7.0.0') || $conf->theme == 'md')
{
	$option_name = "TOPMENU_POSITION_FIXED";
	$conf->global->$option_name = isset($user->conf->TOPMENU_POSITION_FIXED) ? $user->conf->TOPMENU_POSITION_FIXED : false;
	$page->addSwitchOption("SetPositionToFixed", $option_name);
}

if (compare_version(DOL_VERSION, '>=' ,'7.0.0') && compare_version(DOL_VERSION, '<' ,'10.0.0'))
{
	$option_name = "TOPMENU_USE_FONTAWESOME_ICONS";
	$conf->global->$option_name = isset($user->conf->TOPMENU_USE_FONTAWESOME_ICONS) ? $user->conf->TOPMENU_USE_FONTAWESOME_ICONS : false;
	$page->addSwitchOption("UseFontAwesomeIcons", $option_name);
}

$option_name = "TOPMENU_SHOW_ICONS_ONLY";
$conf->global->$option_name = isset($user->conf->TOPMENU_SHOW_ICONS_ONLY) ? $user->conf->TOPMENU_SHOW_ICONS_ONLY : false;
$page->addSwitchOption("ShowIconsOnly", $option_name);

$page->closeTable();

// Left Menu
$page->addLineBreak();

$table_header[0]['name'] = 'LeftMenu';

$page->openTable($table_header);

$option_name = "HIDE_LEFTMENU";
$conf->global->$option_name = isset($user->conf->HIDE_LEFTMENU) ? $user->conf->HIDE_LEFTMENU : ($conf->dol_hide_leftmenu ? true : false);
$page->addSwitchOption("HideLeftMenu", $option_name);

$option_name = "HIDE_COMPANY_LOGO";
$conf->global->$option_name = isset($user->conf->HIDE_COMPANY_LOGO) ? $user->conf->HIDE_COMPANY_LOGO : ($conf->global->MAIN_SHOW_LOGO ? false : true);
$page->addSwitchOption("HideCompanyLogo", $option_name);

$option_name = "HIDE_SEARCH_FORM";
$conf->global->$option_name = isset($user->conf->HIDE_SEARCH_FORM) ? $user->conf->HIDE_SEARCH_FORM : false;
$page->addSwitchOption("HideSearchBar", $option_name);

$option_name = "THEME_ELDY_VERMENU_BACK1";
$conf->global->$option_name = isset($user->conf->THEME_ELDY_VERMENU_BACK1) ? $user->conf->THEME_ELDY_VERMENU_BACK1 : '';
$page->addColorOption("LeftMenuBackColor", $option_name);

$option_name = "VERMENU_TEXT_COLOR";
$conf->global->$option_name = isset($user->conf->VERMENU_TEXT_COLOR) ? $user->conf->VERMENU_TEXT_COLOR : '';
$page->addColorOption("LeftMenuTextColor", $option_name);
/*
$option_name = "INVERT_MENU";
$conf->global->$option_name = isset($user->conf->INVERT_MENU) ? $user->conf->INVERT_MENU : ($conf->global->MAIN_MENU_INVERT ? true : false);
$page->addSwitchOption("InvertMenu", $option_name);
*/
if ($conf->theme != 'md')
{
	$option_name = "LEFTMENU_POSITION_FIXED";
	$conf->global->$option_name = isset($user->conf->LEFTMENU_POSITION_FIXED) ? $user->conf->LEFTMENU_POSITION_FIXED : false;
	$page->addSwitchOption("SetPositionToFixed", $option_name);
}

$page->closeTable();

// Other
$page->addLineBreak();

$table_header[0]['name'] = 'Other';

$page->openTable($table_header);

$option_name = "HIDE_DISABLED_MENUS";
$conf->global->$option_name = isset($user->conf->HIDE_DISABLED_MENUS) ? $user->conf->HIDE_DISABLED_MENUS : false;
$page->addSwitchOption("HideDisabledMenus", $option_name);

$page->closeTable();

// Clear Cache notice
$page->addLineBreak();

echo info_admin($langs->trans('ClearCacheNotice'));

$page->end();
