<?php

// Load Dolibase
include_once 'autoload.php';

// Load Dolibase Page class
dolibase_include_once('/core/pages/setup.php');

// Load files & images lib
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';

// Create Page using Dolibase
$page = new SetupPage("ThemeCustomizer", '$user->admin', true);
$page->setTitleLink(DOL_URL_ROOT.'/admin/ihm.php?mainmenu=home', 'GoToDisplaySettings');

// Get parameters
$action = GETPOST('action', 'alpha');

global $db, $conf, $user;

// Set Actions
if ($action == 'removebackgroundlogin' && ! empty($conf->global->MAIN_LOGIN_BACKGROUND))
{
	$logofile = $conf->mycompany->dir_output.'/logos/'.$conf->global->MAIN_LOGIN_BACKGROUND;
	dol_delete_file($logofile);
	dolibarr_del_const($db, "MAIN_LOGIN_BACKGROUND", $conf->entity);
}
else if ($action == 'set_MAIN_LOGIN_BACKGROUND')
{
	$error = 0;
	$varforimage = 'imagebackground';
	$dirforimage = $conf->mycompany->dir_output.'/logos/';
	if ($_FILES[$varforimage]["tmp_name"])
	{
		if (preg_match('/([^\\/:]+)$/i', $_FILES[$varforimage]["name"], $reg))
		{
			$original_file = $reg[1];

			$isimage = image_format_supported($original_file);
			if ($isimage >= 0)
			{
				dol_syslog("Move file ".$_FILES[$varforimage]["tmp_name"]." to ".$dirforimage.$original_file);
				if (! is_dir($dirforimage))
				{
					dol_mkdir($dirforimage);
				}
				$result = dol_move_uploaded_file($_FILES[$varforimage]["tmp_name"], $dirforimage.$original_file, 1, 0, $_FILES[$varforimage]['error']);
				if ($result > 0)
				{
					dolibarr_set_const($db, "MAIN_LOGIN_BACKGROUND", $original_file, 'chaine', 0, '', $conf->entity);
				}
				else if (preg_match('/^ErrorFileIsInfectedWithAVirus/',$result))
				{
					$error++;
					$langs->load("errors");
					$tmparray = explode(':', $result);
					setEventMessages($langs->trans('ErrorFileIsInfectedWithAVirus',$tmparray[1]), null, 'errors');
				}
				else
				{
					$error++;
					setEventMessages($langs->trans("ErrorFailedToSaveFile"), null, 'errors');
				}
			}
			else
			{
				$error++;
				$langs->load("errors");
				setEventMessages($langs->trans("ErrorBadImageFormat"), null, 'errors');
			}
		}
	}
}
else if ($action == 'removefavicon' && ! empty($conf->global->MAIN_FAVICON_URL))
{
	$favicon_url = urldecode($conf->global->MAIN_FAVICON_URL);
	$logofile = $conf->mycompany->dir_output.'/logos/'.basename($favicon_url);
	dol_delete_file($logofile);
	dolibarr_del_const($db, "MAIN_FAVICON_URL", $conf->entity);
}
else if ($action == 'set_MAIN_FAVICON_URL')
{
	$error = 0;
	$varforimage = 'favicon';
	$dirforimage = $conf->mycompany->dir_output.'/logos/';
	if ($_FILES[$varforimage]["tmp_name"])
	{
		if (preg_match('/([^\\/:]+)$/i', $_FILES[$varforimage]["name"], $reg))
		{
			$original_file = $reg[1];

			$isimage = image_format_supported($original_file);
			if ($isimage >= 0)
			{
				dol_syslog("Move file ".$_FILES[$varforimage]["tmp_name"]." to ".$dirforimage.$original_file);
				if (! is_dir($dirforimage))
				{
					dol_mkdir($dirforimage);
				}
				$result = dol_move_uploaded_file($_FILES[$varforimage]["tmp_name"], $dirforimage.$original_file, 1, 0, $_FILES[$varforimage]['error']);
				if ($result > 0)
				{
					$value = DOL_URL_ROOT.'/viewimage.php?modulepart=mycompany&amp;file='.urlencode('/'.$original_file);
					dolibarr_set_const($db, "MAIN_FAVICON_URL", $value, 'chaine', 0, '', $conf->entity);
				}
				else if (preg_match('/^ErrorFileIsInfectedWithAVirus/',$result))
				{
					$error++;
					$langs->load("errors");
					$tmparray = explode(':', $result);
					setEventMessages($langs->trans('ErrorFileIsInfectedWithAVirus',$tmparray[1]), null, 'errors');
				}
				else
				{
					$error++;
					setEventMessages($langs->trans("ErrorFailedToSaveFile"), null, 'errors');
				}
			}
			else
			{
				$error++;
				$langs->load("errors");
				setEventMessages($langs->trans("ErrorBadImageFormat"), null, 'errors');
			}
		}
	}
}
else if (preg_match('/^set_(.*)/', $action, $reg))
{
	$param = $reg[1];
	$value = (is_submitted($param) ? GETPOST($param) : 1);

	if (dolibarr_set_const($db, $param, $value, 'chaine', 0, '', $conf->entity))
	{
		dolibase_redirect($_SERVER["PHP_SELF"]);
	}
	else
	{
		dol_print_error($db);
	}
}
else if (preg_match('/^del_(.*)/', $action, $reg))
{
	$param = $reg[1];

	if (dolibarr_del_const($db, $param, $conf->entity))
	{
		dolibase_redirect($_SERVER["PHP_SELF"]);
	}
	else
	{
		dol_print_error($db);
	}
}

// Set Tabs
$page->addTab("General", "/themecustomizer/index.php?mainmenu=home");
$page->addTab("Menus", "/themecustomizer/menus.php?mainmenu=home");
$page->addTab("Body", "/themecustomizer/body.php?mainmenu=home");
$page->addTab("Buttons", "/themecustomizer/buttons.php?mainmenu=home");
$page->addTab("Graphs", "/themecustomizer/graphs.php?mainmenu=home");
$page->addTab("LoginPage", "/themecustomizer/login_page.php?mainmenu=home", true);
$page->addTab("Advanced", "/themecustomizer/advanced.php?mainmenu=home");

$page->begin();

// Styles
$table_header = array(
	array('name' => 'LoginPageStyles')
);

$page->openTable($table_header);

include_once 'tpl/login_page_styles.tpl.php';

$page->closeTable();

// Custom Style Options
if (isset($conf->global->LOGIN_PAGE_STYLE) && $conf->global->LOGIN_PAGE_STYLE == 'custom')
{
	$page->addLineBreak();

	$table_header = array(
		array('name' => 'CustomStyleOptions', 'attr' => 'colspan="2"')
	);

	$page->openTable($table_header);

	// Login Button Background Color
	$page->addColorOption('LoginButtonBackgroundColor', 'LOGIN_PAGE_CUSTOM_BUTTON_BACK_COLOR');

	// Login Button Border Color
	$page->addColorOption('LoginButtonBorderColor', 'LOGIN_PAGE_CUSTOM_BUTTON_BORDER_COLOR');

	// Login Button Text Color
	$page->addColorOption('LoginButtonTextColor', 'LOGIN_PAGE_CUSTOM_BUTTON_TEXT_COLOR');

	// Login Links Color
	$page->addColorOption('LoginLinksColor', 'LOGIN_PAGE_CUSTOM_LINKS_COLOR');

	// Login Input Hover Border Color
	$page->addColorOption('LoginInputHoverBorderColor', 'LOGIN_PAGE_CUSTOM_INPUT_HOVER_BORDER_COLOR');

	// Login Round Borders
	$page->addSwitchOption('LoginRoundBorders', 'LOGIN_PAGE_CUSTOM_ROUND_BORDERS');

	$page->closeTable();
}

// Options
$page->addLineBreak();

$table_header = array(
	array('name' => 'LoginPageOptions', 'attr' => 'colspan="2"')
);

$page->openTable($table_header);

// Favicon
$option_content = '<input type="file" class="flat" name="favicon" id="favicon">';
if (! empty($conf->global->MAIN_FAVICON_URL)) {
	$favicon_url = urldecode($conf->global->MAIN_FAVICON_URL);
	$option_content.= '<a href="'.$_SERVER["PHP_SELF"].'?action=removefavicon">'.img_delete($langs->trans("Delete")).'</a>';
	if (file_exists($conf->mycompany->dir_output.'/logos/'.basename($favicon_url))) {
		$option_content.= ' &nbsp; ';
		$option_content.= '<img class="paddingleft valignmiddle" width="32px" src="'.$conf->global->MAIN_FAVICON_URL.'">';
	}
} else {
	$favicon_url = dol_buildpath('/theme/'.$conf->theme.'/img/favicon.ico', 1);
	$option_content.= '<img class="paddingleft valignmiddle" width="32" src="'.$favicon_url.'">';
}
$page->addOption('Favicon', $option_content, 'MAIN_FAVICON_URL', '', '50%', 'multipart/form-data');

// Login Background Image
if (compare_version(DOL_VERSION, '>=' ,'6.0.0')) {
	$option_content = '<input type="file" class="flat" name="imagebackground" id="imagebackground">';
	if (! empty($conf->global->MAIN_LOGIN_BACKGROUND)) {
		$option_content.= '<a href="'.$_SERVER["PHP_SELF"].'?action=removebackgroundlogin">'.img_delete($langs->trans("Delete")).'</a>';
		if (file_exists($conf->mycompany->dir_output.'/logos/'.$conf->global->MAIN_LOGIN_BACKGROUND)) {
			$option_content.= ' &nbsp; ';
			$option_content.= '<img class="paddingleft valignmiddle" width="100px" src="'.DOL_URL_ROOT.'/viewimage.php?modulepart=mycompany&amp;file='.urlencode('/'.$conf->global->MAIN_LOGIN_BACKGROUND).'">';
		}
	} else {
		$option_content.= '<img class="paddingleft valignmiddle" width="100" src="'.DOL_URL_ROOT.'/public/theme/common/nophoto.png">';
	}
	$page->addOption('BackgroundImageLogin', $option_content, 'MAIN_LOGIN_BACKGROUND', '', '50%', 'multipart/form-data');
}

// Disable link to help center
$page->addSwitchOption('DisableLinkToHelpCenter', 'MAIN_HELPCENTER_DISABLELINK');

// Login Message
$page->addOption('MessageLogin', $page->form->textEditor('MAIN_HOME', $conf->global->MAIN_HOME).'<br>', 'MAIN_HOME', '', '70%');

$page->closeTable();

// Clear Cache notice
$page->addLineBreak();

echo info_admin($langs->trans('ClearCacheNotice'));

$page->end();
