<?php

define('NOREDIRECTBYMAINTOLOGIN', 1);

// Load Dolibarr environment
if (false === (@include '../../main.inc.php')) {  // From htdocs directory
	require '../../../main.inc.php'; // From "custom" directory
}

global $user;

header('Content-Type: application/javascript');

?>

$(document).ready(function() {

	// Export
	$("#export").on('click', function(event) {
	    $.ajax({
	            url: '<?php echo dol_buildpath('/themecustomizer/ajax/import_export.php', 1); ?>',
	            type: 'post',
	            data: {action: 'export'},
	            async: false
	    }).done(function(response) {
	            //console.log(response);
	            downloadFile(this, '<?php echo $user->login.'_themecustomizer_settings.json'; ?>', response, 'text/json;charset=utf-8', 'data:application/json;charset=utf-8,');
	    });
	});

	// Import
	$("#import").on('click', function(event) {
		$('#import-file-input').click();
	});

	$('#import-file-input').change(function() {
		readFile(this.files[0], import_settings);
	});

	function import_settings(file_content)
	{
	    $.ajax({
	            url: '<?php echo dol_buildpath('/themecustomizer/ajax/import_export.php', 1); ?>',
	            type: 'post',
	            data: {action: 'import', settings: file_content},
	            async: false
	    }).done(function(response) {
	            //console.log(response);
	            if (response == 'success') {
	            	location.reload();
		        }
		        else {
		        	alert(response);
			    }
	    });
	}
});

<?php
