<?php

// Load Dolibase
include_once 'autoload.php';

// Load Dolibase Page class
dolibase_include_once('/core/pages/setup.php');

// Load Dolibase QueryBuilder class
dolibase_include_once('/core/class/query_builder.php');

// Load Dolibase ImportExport class
dolibase_include_once('/core/class/import_export.php');

// Create Page using Dolibase
$page = new SetupPage("ThemeCustomizer", '$user->rights->theme_customizer->customize', true);
$page->setTitleLink(DOL_URL_ROOT.'/admin/ihm.php?mainmenu=home', 'GoToDisplaySettings');

// Add JS files
ImportExport::addJsFiles($page);
$page->addJsFile('import_export.js.php');

// Get parameters
$action = GETPOST('action', 'alpha');
$confirm = GETPOST('confirm', 'alpha');
$skin = GETPOST('skin', 'alpha');

include_once 'all_params.php';

global $db, $conf, $user, $langs, $all_params, $login_page_params;

// Set Actions
if ($action == 'apply')
{
	if (! empty($skin))
	{
		// Set skin settings
		$all_params['THEME_ELDY_ENABLE_PERSONALIZED'] = '1';
		if (compare_version(DOL_VERSION, '<' ,'7.0.0') && $skin != 'dark_skin') {
			$all_params['HIDE_TOPMENU_SEPARATOR'] = '1';
		}
		$all_params['TOPMENU_TEXT_COLOR'] = 'ffffff'; // white text color (because it's auto set to dark in Dolibarr 7.0.x)
		if (compare_version(DOL_VERSION, '>=' ,'7.0.0') && compare_version(DOL_VERSION, '<' ,'10.0.0')) {
			$all_params['TOPMENU_USE_FONTAWESOME_ICONS'] = '1';
		}
		$all_params['THEME_ELDY_USE_HOVER'] = '1';
		$all_params['HIDE_DISABLED_MENUS'] = '1';

		$all_params['ACTION_BUTTON_BG_FROM'] = 'ffffff';
		$all_params['ACTION_BUTTON_BG_TO'] = 'e6e6e6';
		$all_params['ACTION_BUTTON_BORDER_COLOR'] = 'bbbbbb';
		$all_params['ACTION_BUTTON_TEXT_COLOR'] = '333333';

		$all_params['DELETE_BUTTON_BG_FROM'] = 'ffffff';
		$all_params['DELETE_BUTTON_BG_TO'] = 'e6e6e6';
		$all_params['DELETE_BUTTON_BORDER_COLOR'] = 'bbbbbb';
		$all_params['DELETE_BUTTON_TEXT_COLOR'] = '880000';

		$all_params['DISABLED_BUTTON_BG_FROM'] = 'ffffff';
		$all_params['DISABLED_BUTTON_BG_TO'] = 'e6e6e6';
		$all_params['DISABLED_BUTTON_BORDER_COLOR'] = 'bbbbbb';
		$all_params['DISABLED_BUTTON_TEXT_COLOR'] = '999999';

		// Set graphs colors
		$all_params['GRAPH_COLOR_1'] = 'fe6383';
		$all_params['GRAPH_COLOR_2'] = 'ff9f40';
		$all_params['GRAPH_COLOR_3'] = 'ffcc56';
		$all_params['GRAPH_COLOR_4'] = '4ac0c0';
		$all_params['GRAPH_COLOR_5'] = '36a2eb';
		$all_params['GRAPH_COLOR_6'] = '949fb1';
		$all_params['GRAPH_COLOR_7'] = '4d5360';
		$all_params['GRAPH_COLOR_8'] = '97bbcd';
		$all_params['GRAPH_COLOR_9'] = 'dcdcdc';

		// Set login page settings
		$login_page_params['LOGIN_PAGE_STYLE'] = 'custom';
		$login_page_params['LOGIN_PAGE_CUSTOM_BUTTON_TEXT_COLOR'] = 'ffffff';
		$login_page_params['LOGIN_PAGE_CUSTOM_ROUND_BORDERS'] = '1';

		switch($skin)
		{
			case 'red_skin':
				$all_params['THEME_ELDY_TOPMENU_BACK1'] = 'd9534f';
				$all_params['TABLE_TOPBORDER_COLOR'] = 'd9534f';
				$all_params['ACTIVETAB_TOPBORDER_COLOR'] = 'd9534f';
				// Login Page
				$login_page_params['LOGIN_PAGE_CUSTOM_BUTTON_BACK_COLOR'] = 'd9534f';
				$login_page_params['LOGIN_PAGE_CUSTOM_BUTTON_BORDER_COLOR'] = 'd9534f';
				$login_page_params['LOGIN_PAGE_CUSTOM_LINKS_COLOR'] = 'd9534f';
				$login_page_params['LOGIN_PAGE_CUSTOM_INPUT_HOVER_BORDER_COLOR'] = 'd9534f';
				break;
			case 'blue_skin':
				$all_params['THEME_ELDY_TOPMENU_BACK1'] = '467fcf';
				$all_params['TABLE_TOPBORDER_COLOR'] = '467fcf';
				$all_params['ACTIVETAB_TOPBORDER_COLOR'] = '467fcf';
				// Login Page
				$login_page_params['LOGIN_PAGE_CUSTOM_BUTTON_BACK_COLOR'] = '467fcf';
				$login_page_params['LOGIN_PAGE_CUSTOM_BUTTON_BORDER_COLOR'] = '467fcf';
				$login_page_params['LOGIN_PAGE_CUSTOM_LINKS_COLOR'] = '467fcf';
				$login_page_params['LOGIN_PAGE_CUSTOM_INPUT_HOVER_BORDER_COLOR'] = '467fcf';
				break;
			case 'green_skin':
				$all_params['THEME_ELDY_TOPMENU_BACK1'] = '5cb85c';
				$all_params['TABLE_TOPBORDER_COLOR'] = '5cb85c';
				$all_params['ACTIVETAB_TOPBORDER_COLOR'] = '5cb85c';
				// Login Page
				$login_page_params['LOGIN_PAGE_CUSTOM_BUTTON_BACK_COLOR'] = '5cb85c';
				$login_page_params['LOGIN_PAGE_CUSTOM_BUTTON_BORDER_COLOR'] = '5cb85c';
				$login_page_params['LOGIN_PAGE_CUSTOM_LINKS_COLOR'] = '5cb85c';
				$login_page_params['LOGIN_PAGE_CUSTOM_INPUT_HOVER_BORDER_COLOR'] = '5cb85c';
				break;
			case 'orange_skin':
				$all_params['THEME_ELDY_TOPMENU_BACK1'] = 'ff8c00';
				$all_params['TABLE_TOPBORDER_COLOR'] = 'ff8c00';
				$all_params['ACTIVETAB_TOPBORDER_COLOR'] = 'ff8c00';
				// Login Page
				$login_page_params['LOGIN_PAGE_CUSTOM_BUTTON_BACK_COLOR'] = 'ff8c00';
				$login_page_params['LOGIN_PAGE_CUSTOM_BUTTON_BORDER_COLOR'] = 'ff8c00';
				$login_page_params['LOGIN_PAGE_CUSTOM_LINKS_COLOR'] = 'ff8c00';
				$login_page_params['LOGIN_PAGE_CUSTOM_INPUT_HOVER_BORDER_COLOR'] = 'ff8c00';
				break;
			case 'purple_skin':
				$all_params['THEME_ELDY_TOPMENU_BACK1'] = 'b45be5';
				$all_params['TABLE_TOPBORDER_COLOR'] = 'b45be5';
				$all_params['ACTIVETAB_TOPBORDER_COLOR'] = 'b45be5';
				// Login Page
				$login_page_params['LOGIN_PAGE_CUSTOM_BUTTON_BACK_COLOR'] = 'b45be5';
				$login_page_params['LOGIN_PAGE_CUSTOM_BUTTON_BORDER_COLOR'] = 'b45be5';
				$login_page_params['LOGIN_PAGE_CUSTOM_LINKS_COLOR'] = 'b45be5';
				$login_page_params['LOGIN_PAGE_CUSTOM_INPUT_HOVER_BORDER_COLOR'] = 'b45be5';
				break;
			case 'grey_skin':
				$all_params['THEME_ELDY_TOPMENU_BACK1'] = '777777';
				$all_params['TABLE_TOPBORDER_COLOR'] = '777777';
				$all_params['ACTIVETAB_TOPBORDER_COLOR'] = '777777';
				// Login Page
				$login_page_params['LOGIN_PAGE_CUSTOM_BUTTON_BACK_COLOR'] = '777777';
				$login_page_params['LOGIN_PAGE_CUSTOM_BUTTON_BORDER_COLOR'] = '777777';
				$login_page_params['LOGIN_PAGE_CUSTOM_LINKS_COLOR'] = '777777';
				$login_page_params['LOGIN_PAGE_CUSTOM_INPUT_HOVER_BORDER_COLOR'] = '777777';
				// Action button
				$all_params['ACTION_BUTTON_BG_FROM'] = '777777';
				$all_params['ACTION_BUTTON_BG_TO'] = '555555';
				$all_params['ACTION_BUTTON_BORDER_COLOR'] = '777777';
				$all_params['ACTION_BUTTON_TEXT_COLOR'] = 'ffffff';
				// Delete button
				$all_params['DELETE_BUTTON_BG_FROM'] = 'd9534f';
				$all_params['DELETE_BUTTON_BG_TO'] = 'b21f1f';
				$all_params['DELETE_BUTTON_BORDER_COLOR'] = 'd9534f';
				$all_params['DELETE_BUTTON_TEXT_COLOR'] = 'ffffff';
				break;
			case 'dark_skin':
				$all_params['THEME_ELDY_TOPMENU_BACK1'] = '333333';
				$all_params['TABLE_TOPBORDER_COLOR'] = '333333';
				$all_params['ACTIVETAB_TOPBORDER_COLOR'] = '333333';
				// Login Page
				$login_page_params['LOGIN_PAGE_CUSTOM_BUTTON_BACK_COLOR'] = '333333';
				$login_page_params['LOGIN_PAGE_CUSTOM_BUTTON_BORDER_COLOR'] = '333333';
				$login_page_params['LOGIN_PAGE_CUSTOM_LINKS_COLOR'] = '333333';
				$login_page_params['LOGIN_PAGE_CUSTOM_INPUT_HOVER_BORDER_COLOR'] = '333333';
				break;
		}

		// Apply skin
		if (dol_set_user_param($db, $conf, $user, $all_params))
		{
			$error = 0;

			if ($user->admin) { // Set login page settings only for admin user
				foreach ($login_page_params as $param => $value) {
					if (! dolibarr_set_const($db, $param, $value, 'chaine', 0, '', $conf->entity)) $error++;
				}
			}

			if (! $error)
			{
				setEventMessage($langs->trans("ApplyDone"));
				dolibase_redirect($_SERVER["PHP_SELF"]);
			}
		}
		else
		{
			dol_print_error($db);
		}
	}
	else
	{
		setEventMessage($langs->trans("SelectSkinFirst"), 'errors');
	}
}
else if ($action == 'confirm_reset' && $confirm == 'yes')
{
	if (dol_set_user_param($db, $conf, $user, $all_params))
	{
		$error = 0;

		if ($user->admin) { // Reset login page settings only for admin user
			/*foreach ($login_page_params as $param => $value) {
				if (! dolibarr_set_const($db, $param, $value, 'chaine', 0, '', $conf->entity)) $error++;
			}*/
			if (! dolibarr_del_const($db, 'LOGIN_PAGE_STYLE', $conf->entity)) $error++;
		}

		if (! $error)
		{
			setEventMessage($langs->trans("ResetDone"));
			dolibase_redirect($_SERVER["PHP_SELF"]);
		}
	}
	else
	{
		dol_print_error($db);
	}
}
else if ($action == 'reset' || js_enabled())
{
	$page->askForConfirmation($_SERVER["PHP_SELF"], 'ResetToDefaults', 'ConfirmReset', 'confirm_reset', '', 'action-reset');
}

if ($user->admin && $action == 'confirm_apply_to_all' && $confirm == 'yes') // should be an if not an else if
{
	// get current user parameters
	foreach ($all_params as $param => $value)
	{
		if (isset($user->conf->$param)) {
			$all_params[$param] = $user->conf->$param;
		}
	}

	// fetch users id
	$qb = new QueryBuilder();
	$qb->select('rowid')->from('user')->where('rowid != '.$user->id);

	// apply to all users
	$error = 0;
	$dol_user = new User($db);
	foreach ($qb->result() as $row)
	{
		$dol_user->id = $row->rowid;

		if (dol_set_user_param($db, $conf, $dol_user, $all_params) < 0)
		{
			$error++;
			break;
		}
	}

	if (! $error)
	{
		setEventMessage($langs->trans("ApplyToAllDone"));
		dolibase_redirect($_SERVER["PHP_SELF"]);
	}
	else
	{
		dol_print_error($db);
	}
}
else if ($user->admin && ($action == 'apply_to_all' || js_enabled()))
{
	$page->askForConfirmation($_SERVER["PHP_SELF"], 'ApplyToAll', 'ConfirmApplyToAll', 'confirm_apply_to_all', '', 'action-apply-to-all');
}

// Set Tabs
$page->addTab("General", "/themecustomizer/index.php?mainmenu=home", true);
$page->addTab("Menus", "/themecustomizer/menus.php?mainmenu=home");
$page->addTab("Body", "/themecustomizer/body.php?mainmenu=home");
$page->addTab("Buttons", "/themecustomizer/buttons.php?mainmenu=home");
$page->addTab("Graphs", "/themecustomizer/graphs.php?mainmenu=home");
if ($user->admin) {
	$page->addTab("LoginPage", "/themecustomizer/login_page.php?mainmenu=home");
}
$page->addTab("Advanced", "/themecustomizer/advanced.php?mainmenu=home");

$page->begin();

// Current theme
echo $langs->trans('CurrentTheme').': <strong>'.$conf->theme.'</strong>';

if ($conf->theme != 'eldy' && $conf->theme != 'md') {
	echo '&nbsp;'.img_warning().'&nbsp;'.$langs->trans('MayNotWorkWithExternalThemes');
}

// Custom skins
$page->addLineBreak(1);

$table_header = array(
	array('name' => 'CustomSkins')
);

$page->openTable($table_header);

include_once 'tpl/custom_skins.tpl.php';

$page->closeTable();

// Clear Cache notice
$page->addLineBreak();

echo info_admin($langs->trans('ClearCacheNotice'));

// Add Buttons
$page->addButton('', '#', '', 'hidden" style="display: none;'); // used only to open buttons div when $user is not admin
if ($user->admin) {
	$text = $langs->trans('ApplyToAll').' '.img_info($langs->trans('ForAdminOnly'));
	$page->addConfirmButton($text, 'action-apply-to-all', $_SERVER["PHP_SELF"].'?action=apply_to_all');
}
if ($user->rights->theme_customizer->export) {
	$text = ($user->admin ? $langs->trans('ExportButton').' '.img_info($langs->trans('ExportNotice')) : 'ExportButton');
	ImportExport::addExportButton($text, 'export');
}
if ($user->rights->theme_customizer->import) {
	ImportExport::addImportButton('ImportButton', '.json', 'import', 'import-file-input');
}
$page->addConfirmButton('ResetToDefaults', 'action-reset', $_SERVER["PHP_SELF"].'?action=reset', '', 'butActionDelete', true);

$page->end();
