<?php

//if (! defined('NOREQUIREUSER')) define('NOREQUIREUSER','1');	// Not disabled because need to load personalized language
//if (! defined('NOREQUIREDB'))   define('NOREQUIREDB','1');	// Not disabled to increase speed. Language code is found on url.
if (! defined('NOREQUIRESOC'))    define('NOREQUIRESOC','1');
if (! defined('NOREQUIRETRAN')) define('NOREQUIRETRAN','1');	// No need for translations
if (! defined('NOCSRFCHECK'))     define('NOCSRFCHECK',1);
if (! defined('NOTOKENRENEWAL'))  define('NOTOKENRENEWAL',1);
//if (! defined('NOLOGIN'))         define('NOLOGIN',1);       // File can be accessed after login + after executing hooks
if (! defined('NOREQUIREMENU'))   define('NOREQUIREMENU',1);   // No need for top menu content
if (! defined('NOREQUIREHTML'))   define('NOREQUIREHTML',1);   // No need for HTML
if (! defined('NOREQUIREAJAX'))   define('NOREQUIREAJAX','1'); // No need for AJAX

define('NOREDIRECTBYMAINTOLOGIN', 1);

// Load Dolibarr environment
if (false === (@include '../../main.inc.php')) {  // From htdocs directory
	require '../../../main.inc.php'; // From "custom" directory
}

dol_include_once('/themecustomizer/dolibase/core/lib/functions.php');

global $user, $conf, $heightforframes;

header('Content-Type: text/css');

// Hide Top icons
if (isset($user->conf->DISABLE_TOPMENU_IMAGE) && $user->conf->DISABLE_TOPMENU_IMAGE)
{
	?>
	div#id-top {
		height: 34px !important;
	}
	div.tmenusep {
		display: none !important;
	}
	div.tmenuleft {
		height: 26px !important;
	}
	div.tmenucenter {
		padding-top: 8px !important;
		height: 26px !important;
	}
	li.tmenu, li.tmenusel {
		min-width: 0px !important;
	}
	.mainmenuaspan {
		padding-left: 4px !important;
		padding-right: 2px !important;
	}
	.tmenuimage {
		display: none !important;
	}
	div.login_block {
		max-width: 100% !important;
	}
	div.login_block_user {
		min-width: 0px !important;
	}
	<?php
}

// Hide separator
if (isset($user->conf->HIDE_TOPMENU_SEPARATOR) && $user->conf->HIDE_TOPMENU_SEPARATOR)
{
	?>
	div.tmenusep {
		display: none !important;
	}
	.mainmenuaspan {
		padding-left: 4px !important;
		padding-right: 2px !important;
	}
	<?php
}

if ($conf->theme != 'md')
{
	// Pull left login block
	if (isset($user->conf->PULL_LEFT_LOGIN_BLOCK) && $user->conf->PULL_LEFT_LOGIN_BLOCK)
	{
		if (compare_version(DOL_VERSION, '<' ,'7.0.0')) {
			$width = '200px';
			$padding = '4px 0px 2px';
		}
		else {
			$width = '208px';
			$padding = '0px 0px 6px';
		}

		?>
		div#id-top {
		    margin-left: <?php echo $width; ?>;
		}
		div#tmenu_tooltip {
			padding-right: 0px !important;
		}
		div.login_block {
			border-right: 1px solid #d0d0d0;
			padding: <?php echo $padding; ?>;
			left: 0px;
			top: 0px;
			vertical-align: middle;
			width: <?php echo $width; ?>;
			<?php if (isset($user->conf->DISABLE_TOPMENU_IMAGE) && $user->conf->DISABLE_TOPMENU_IMAGE) { ?>
			height: 28px;
			<?php } else { ?>
			height: 42px;
			<?php } ?>
			max-width: 100% !important;
			text-align: center !important;
			background-color: #<?php echo isset($user->conf->THEME_ELDY_TOPMENU_BACK1) ? $user->conf->THEME_ELDY_TOPMENU_BACK1 : '505a78'; ?>;
		}
		div.login_block_user {
			<?php if (isset($user->conf->DISABLE_TOPMENU_IMAGE) && $user->conf->DISABLE_TOPMENU_IMAGE) { ?>
			min-width: 0px !important;
			<?php } else { ?>
			min-width: 100% !important;
			<?php } ?>
		}
		<?php
	}
	// Arrange login block
	else if (isset($user->conf->ARRANGE_LOGIN_BLOCK) && $user->conf->ARRANGE_LOGIN_BLOCK)
	{
		$padding = 15;

		if (compare_version(DOL_VERSION, '>=' ,'8.0.0') && $heightforframes == 48) {
			$heightforframes = 50;
			$padding = 16;
		}

		?>
		div.login_block {
			max-width: none !important;
		}
		div.login_block_user, div.login_block_other {
			padding-top: 0px! important;
			/*overflow: hidden;*/
		}
		div.login_block_elem {
			padding: 0px !important;
			/*margin-right: -3px;*/
			height: <?php echo $heightforframes.'px'; ?> !important;
			overflow: hidden;
		}
		div.login_block_user a, div.login_block_other a {
			padding: <?php echo $padding; ?>px;
			/*border-left: 1px solid #e4e7ea;*/
		}
		div.login_block_elem:hover {
			background-image: -o-linear-gradient(bottom, rgba(250,250,250,0.3) 0%, rgba(0,0,0,0.5) 100%);
			background-image: -moz-linear-gradient(bottom, rgba(0,0,0,0.5) 0%, rgba(250,250,250,0) 100%);
			background-image: -webkit-linear-gradient(bottom, rgba(0,0,0,0.5) 0%, rgba(250,250,250,0) 100%);
			background-image: -ms-linear-gradient(bottom, rgba(250,250,250,0.3) 0%, rgba(0,0,0,0.5) 100%);
			background-image: linear-gradient(bottom, rgba(250,250,250,0.3) 0%, rgba(0,0,0,0.5) 100%);
		}
		div.login_block_elem a {
			display: inline-block;
			text-decoration: none;
			color: #9aa0ac;
			font-size: 13px;
			outline: none;
		}
		<?php
	}
}

// Top menu background color (apply it without needing to refresh cache)
if (isset($user->conf->THEME_ELDY_TOPMENU_BACK1) && ! empty($user->conf->THEME_ELDY_TOPMENU_BACK1))
{
	?>
	div#id-top, div#id-top .dropdown-menu > .user-header {
		background: #<?php echo $user->conf->THEME_ELDY_TOPMENU_BACK1; ?> !important;
		background-color: #<?php echo $user->conf->THEME_ELDY_TOPMENU_BACK1; ?> !important;
	}
	<?php
}

// Left menu background color (apply to parent div also)
if (isset($user->conf->THEME_ELDY_VERMENU_BACK1) && ! empty($user->conf->THEME_ELDY_VERMENU_BACK1))
{
	?>
	div.side-nav, div.blockvmenupair, div.blockvmenuimpair, div.blockvmenubookmarks, div.blockvmenuend, div.blockvmenusearch {
		background: #<?php echo $user->conf->THEME_ELDY_VERMENU_BACK1; ?> !important;
		background-color: #<?php echo $user->conf->THEME_ELDY_VERMENU_BACK1; ?> !important;
	}
	<?php
}

// Set top menu position to fixed
if (isset($user->conf->TOPMENU_POSITION_FIXED) && $user->conf->TOPMENU_POSITION_FIXED)
{
	?>
	div.side-nav-vert {
		position: fixed;
		width: 100%;
		left: 0px;
		top: 0px;
		z-index: 90;
	}
	#id-container {
		padding-top: 50px;
	}
	<?php
}

// Top menu > Use fontawesome icons
if (isset($user->conf->TOPMENU_USE_FONTAWESOME_ICONS) && $user->conf->TOPMENU_USE_FONTAWESOME_ICONS)
{
	$menu_icons = array(
		'home' => 'f015',
		'agenda' => 'f073',
		'products' => 'f1b3',
		'companies' => 'f1ad',
		'billing' => 'f219',
		'bank' => 'f19c',
		'commercial' => 'f007',
		'accountancy' => 'f0d6',
		'cashdesk' => 'f291',
		'ecm' => 'f07c',
		'project' => 'f0e8',
		'externalsite' => 'f08e',
		'website' => 'f08e',
		'ftp' => 'f019',
		'hrm' => 'f187',
		'members' => 'f0c0',
		'menu' => 'f0c9',
		'tools' => 'f085',
		'ticket' => 'f145',
		'chat' => 'f075',
		'maintenance' => 'f0ad',
		'fileman' => 'f07c',
		'bookmarks' => 'f005'
	);

	foreach ($menu_icons as $key => $value)
	{
		?>
		div.mainmenu.<?php echo $key; ?> {
			background-image: none !important;
		}
		div.mainmenu.<?php echo $key; ?> span:before {
			font-family: FontAwesome;
			font-size: 15px;
			content: "\<?php echo $value; ?>";
			color: #<?php echo (isset($user->conf->TOPMENU_TEXT_COLOR) && ! empty($user->conf->TOPMENU_TEXT_COLOR) ? $user->conf->TOPMENU_TEXT_COLOR : 'ffffff'); ?>;
		}
		a.tmenuimage {
			text-decoration: none;
			outline: none;
		}
		<?php
	}
}

// Top menu > Show icons only
if (isset($user->conf->TOPMENU_SHOW_ICONS_ONLY) && $user->conf->TOPMENU_SHOW_ICONS_ONLY)
{
	?>
	a.tmenu, a.tmenusel {
		display: none;
	}
	div.topmenuimage span:before {
		font-size: 18px !important;
	}
	div.mainmenu {
		margin: <?php echo compare_version(DOL_VERSION, '>=' ,'8.0.0') ? '10' : '9'; ?>px !important;
	}
	<?php
}

// Set left menu position to fixed
if ($conf->theme != 'md' && isset($user->conf->LEFTMENU_POSITION_FIXED) && $user->conf->LEFTMENU_POSITION_FIXED)
{
	?>
	#id-container {
		width: 100%;
	}
	div#id-right {
		padding-left: 200px;
	}
	div.side-nav {
		position: fixed;
	    left: 0px;
	    top: 48px;
	    bottom: 0px;
	    z-index: 90;
	    overflow-x: hidden;
	    overflow-y: auto;
	}
	<?php
}

// Top menu text color
if (isset($user->conf->TOPMENU_TEXT_COLOR) && ! empty($user->conf->TOPMENU_TEXT_COLOR))
{
	$more_text_selector = ($conf->theme != 'md' ? ', div.login_block_user a.atoplogin div, div.login_block_other span.fa:before, div.login_block span.aversion' : '');
	?>
	a.tmenu, a.tmenusel<?php echo $more_text_selector; ?> {
		color: #<?php echo $user->conf->TOPMENU_TEXT_COLOR; ?> !important;
	}
	<?php
}

// Left menu text color
if (isset($user->conf->VERMENU_TEXT_COLOR) && ! empty($user->conf->VERMENU_TEXT_COLOR))
{
	?>
	a.vmenu, a.vsmenu, span.vsmenu {
		color: #<?php echo $user->conf->VERMENU_TEXT_COLOR; ?> !important;
	}
	<?php
}

// Body background color (apply it without needing to refresh cache)
if (isset($user->conf->THEME_ELDY_BACKBODY) && ! empty($user->conf->THEME_ELDY_BACKBODY))
{
	?>
	body {
		background-color: #<?php echo $user->conf->THEME_ELDY_BACKBODY; ?> !important;
	}
	<?php
}

// Body text color (apply it without needing to refresh cache)
if (isset($user->conf->THEME_ELDY_TEXT) && ! empty($user->conf->THEME_ELDY_TEXT))
{
	?>
	body {
		color: #<?php echo $user->conf->THEME_ELDY_TEXT; ?> !important;
	}
	<?php
}

// Body text size (apply it without needing to refresh cache)
if (isset($user->conf->THEME_ELDY_FONT_SIZE1) && ! empty($user->conf->THEME_ELDY_FONT_SIZE1))
{
	?>
	body {
		font-size: <?php echo $user->conf->THEME_ELDY_FONT_SIZE1; ?>px !important;
	}
	<?php
}

// Title color (apply it without needing to refresh cache)
if (isset($user->conf->THEME_ELDY_TEXTTITLENOTAB) && ! empty($user->conf->THEME_ELDY_TEXTTITLENOTAB))
{
	?>
	div.titre {
		color: #<?php echo $user->conf->THEME_ELDY_TEXTTITLENOTAB; ?> !important;
	}
	<?php
}

// Table header color (apply it without needing to refresh cache)
if (isset($user->conf->THEME_ELDY_BACKTITLE1) && ! empty($user->conf->THEME_ELDY_BACKTITLE1))
{
	?>
	tr.liste_titre {
		background-color: #<?php echo $user->conf->THEME_ELDY_BACKTITLE1; ?> !important;
	}
	<?php
}

// Table odd lines color (apply it without needing to refresh cache)
if (isset($user->conf->THEME_ELDY_LINEIMPAIR1) && ! empty($user->conf->THEME_ELDY_LINEIMPAIR1))
{
	?>
	.odd, .impair {
		background-color: #<?php echo $user->conf->THEME_ELDY_LINEIMPAIR1; ?> !important;
	}
	<?php
}

// Table even lines color (apply it without needing to refresh cache)
if (isset($user->conf->THEME_ELDY_LINEPAIR1) && ! empty($user->conf->THEME_ELDY_LINEPAIR1))
{
	?>
	.even, .pair {
		background-color: #<?php echo $user->conf->THEME_ELDY_LINEPAIR1; ?> !important;
	}
	<?php
}

// Tab background color (apply it without needing to refresh cache)
if (isset($user->conf->THEME_ELDY_BACKTABCARD1) && ! empty($user->conf->THEME_ELDY_BACKTABCARD1))
{
	?>
	div.tabBar, .tabactive, a.tab#active {
		background-color: #<?php echo $user->conf->THEME_ELDY_BACKTABCARD1; ?> !important;
	}
	<?php
}

// Table top border color
if (isset($user->conf->TABLE_TOPBORDER_COLOR) && ! empty($user->conf->TABLE_TOPBORDER_COLOR))
{
	?>
	table.liste, table.noborder {
		border-top-color: #<?php echo $user->conf->TABLE_TOPBORDER_COLOR; ?> !important;
	}
	<?php
}

// Active Tab top border color
if (isset($user->conf->ACTIVETAB_TOPBORDER_COLOR) && ! empty($user->conf->ACTIVETAB_TOPBORDER_COLOR))
{
	?>
	.tabactive, a.tab#active {
		border-top-color: #<?php echo $user->conf->ACTIVETAB_TOPBORDER_COLOR; ?> !important;
	}
	<?php
}

// Allow text overflow on lists
$is_list = preg_match('/(list|liste)\.php/', $_SERVER['HTTP_REFERER']) ? true : false;
if ($is_list && isset($user->conf->LIST_ALLOW_TEXT_OVERFLOW) && $user->conf->LIST_ALLOW_TEXT_OVERFLOW)
{
	?>
	.tdoverflowmax50, .tdoverflowmax100, .tdoverflowmax150, .tdoverflowmax200, .tdoverflowmax300 {
		max-width: none !important;
		overflow: auto !important;
	}
	<?php
}

// Action button(s) background color/gradient
if (isset($user->conf->ACTION_BUTTON_BG_FROM) && isset($user->conf->ACTION_BUTTON_BG_TO))
{
	?>
	.button, .butAction {
		background-color: #<?php echo $user->conf->ACTION_BUTTON_BG_FROM; ?> !important;
		background-image: -moz-linear-gradient(top, #<?php echo $user->conf->ACTION_BUTTON_BG_FROM; ?>, #<?php echo $user->conf->ACTION_BUTTON_BG_TO; ?>) !important;
		background-image: -webkit-gradient(linear, 0 0, 0 100%, from(#<?php echo $user->conf->ACTION_BUTTON_BG_FROM; ?>), to(#<?php echo $user->conf->ACTION_BUTTON_BG_TO; ?>)) !important;
		background-image: -webkit-linear-gradient(top, #<?php echo $user->conf->ACTION_BUTTON_BG_FROM; ?>, #<?php echo $user->conf->ACTION_BUTTON_BG_TO; ?>) !important;
		background-image: -o-linear-gradient(top, #<?php echo $user->conf->ACTION_BUTTON_BG_FROM; ?>, #<?php echo $user->conf->ACTION_BUTTON_BG_TO; ?>) !important;
		background-image: linear-gradient(to bottom, #<?php echo $user->conf->ACTION_BUTTON_BG_FROM; ?>, #<?php echo $user->conf->ACTION_BUTTON_BG_TO; ?>) !important;
	}
	<?php
}

// Action button(s) border color
if (isset($user->conf->ACTION_BUTTON_BORDER_COLOR) && ! empty($user->conf->ACTION_BUTTON_BORDER_COLOR))
{
	?>
	.button, .butAction {
		border: 1px solid #<?php echo $user->conf->ACTION_BUTTON_BORDER_COLOR; ?> !important;
	}
	<?php
}

// Action button(s) text color
if (isset($user->conf->ACTION_BUTTON_TEXT_COLOR) && ! empty($user->conf->ACTION_BUTTON_TEXT_COLOR))
{
	?>
	.button, .butAction, .button:hover, .butAction:hover {
		color: #<?php echo $user->conf->ACTION_BUTTON_TEXT_COLOR; ?> !important;
		text-shadow: none !important;
	}
	<?php
}

// Delete button(s) background color/gradient
if (isset($user->conf->DELETE_BUTTON_BG_FROM) && isset($user->conf->DELETE_BUTTON_BG_TO))
{
	?>
	.butActionDelete, .buttonDelete {
		background-color: #<?php echo $user->conf->DELETE_BUTTON_BG_FROM; ?> !important;
		background-image: -moz-linear-gradient(top, #<?php echo $user->conf->DELETE_BUTTON_BG_FROM; ?>, #<?php echo $user->conf->DELETE_BUTTON_BG_TO; ?>) !important;
		background-image: -webkit-gradient(linear, 0 0, 0 100%, from(#<?php echo $user->conf->DELETE_BUTTON_BG_FROM; ?>), to(#<?php echo $user->conf->DELETE_BUTTON_BG_TO; ?>)) !important;
		background-image: -webkit-linear-gradient(top, #<?php echo $user->conf->DELETE_BUTTON_BG_FROM; ?>, #<?php echo $user->conf->DELETE_BUTTON_BG_TO; ?>) !important;
		background-image: -o-linear-gradient(top, #<?php echo $user->conf->DELETE_BUTTON_BG_FROM; ?>, #<?php echo $user->conf->DELETE_BUTTON_BG_TO; ?>) !important;
		background-image: linear-gradient(to bottom, #<?php echo $user->conf->DELETE_BUTTON_BG_FROM; ?>, #<?php echo $user->conf->DELETE_BUTTON_BG_TO; ?>) !important;
	}
	<?php
}

// Delete button(s) border color
if (isset($user->conf->DELETE_BUTTON_BORDER_COLOR) && ! empty($user->conf->DELETE_BUTTON_BORDER_COLOR))
{
	?>
	.butActionDelete, .buttonDelete {
		border: 1px solid #<?php echo $user->conf->DELETE_BUTTON_BORDER_COLOR; ?> !important;
	}
	<?php
}

// Delete button(s) text color
if (isset($user->conf->DELETE_BUTTON_TEXT_COLOR) && ! empty($user->conf->DELETE_BUTTON_TEXT_COLOR))
{
	?>
	.buttonDelete, .buttonDelete:hover, .butActionDelete, .butActionDelete:link, .butActionDelete:visited, .butActionDelete:hover, .butActionDelete:active {
		color: #<?php echo $user->conf->DELETE_BUTTON_TEXT_COLOR; ?> !important;
		text-shadow: none !important;
	}
	<?php
}

// Disabled button(s) background color/gradient
if (isset($user->conf->DISABLED_BUTTON_BG_FROM) && isset($user->conf->DISABLED_BUTTON_BG_TO))
{
	?>
	.butActionRefused, .buttonRefused {
		background-color: #<?php echo $user->conf->DISABLED_BUTTON_BG_FROM; ?> !important;
		background-image: -moz-linear-gradient(top, #<?php echo $user->conf->DISABLED_BUTTON_BG_FROM; ?>, #<?php echo $user->conf->DISABLED_BUTTON_BG_TO; ?>) !important;
		background-image: -webkit-gradient(linear, 0 0, 0 100%, from(#<?php echo $user->conf->DISABLED_BUTTON_BG_FROM; ?>), to(#<?php echo $user->conf->DISABLED_BUTTON_BG_TO; ?>)) !important;
		background-image: -webkit-linear-gradient(top, #<?php echo $user->conf->DISABLED_BUTTON_BG_FROM; ?>, #<?php echo $user->conf->DISABLED_BUTTON_BG_TO; ?>) !important;
		background-image: -o-linear-gradient(top, #<?php echo $user->conf->DISABLED_BUTTON_BG_FROM; ?>, #<?php echo $user->conf->DISABLED_BUTTON_BG_TO; ?>) !important;
		background-image: linear-gradient(to bottom, #<?php echo $user->conf->DISABLED_BUTTON_BG_FROM; ?>, #<?php echo $user->conf->DISABLED_BUTTON_BG_TO; ?>) !important;
	}
	<?php
}

// Disabled button(s) border color
if (isset($user->conf->DISABLED_BUTTON_BORDER_COLOR) && ! empty($user->conf->DISABLED_BUTTON_BORDER_COLOR))
{
	?>
	.butActionRefused, .buttonRefused {
		border: 1px solid #<?php echo $user->conf->DISABLED_BUTTON_BORDER_COLOR; ?> !important;
	}
	<?php
}

// Disabled button(s) text color
if (isset($user->conf->DISABLED_BUTTON_TEXT_COLOR) && ! empty($user->conf->DISABLED_BUTTON_TEXT_COLOR))
{
	?>
	.butActionRefused, .buttonRefused {
		color: #<?php echo $user->conf->DISABLED_BUTTON_TEXT_COLOR; ?> !important;
		text-shadow: none !important;
	}
	<?php
}

// Custom buttons css
?>
	.button, .butAction {
		font-weight: <?php echo $user->conf->ACTION_BUTTON_FONT_BOLD ? 'bold' : 'normal'; ?> !important;
		text-transform: <?php echo $user->conf->ACTION_BUTTON_TEXT_UPPERCASE ? 'uppercase' : 'none'; ?> !important;
	}
	.butActionDelete, .buttonDelete {
		font-weight: <?php echo $user->conf->DELETE_BUTTON_FONT_BOLD ? 'bold' : 'normal'; ?> !important;
		text-transform: <?php echo $user->conf->DELETE_BUTTON_TEXT_UPPERCASE ? 'uppercase' : 'none'; ?> !important;
	}
	.butActionRefused, .buttonRefused {
		font-weight: <?php echo $user->conf->DISABLED_BUTTON_FONT_BOLD ? 'bold' : 'normal'; ?> !important;
		text-transform: <?php echo $user->conf->DISABLED_BUTTON_TEXT_UPPERCASE ? 'uppercase' : 'none'; ?> !important;
	}
	.whiteButton, .whiteButton:hover {
		background-color: #ffffff !important;
		background-image: -moz-linear-gradient(top, #ffffff, #e6e6e6) !important;
		background-image: -webkit-gradient(linear, 0 0, 0 100%, from(#ffffff), to(#e6e6e6)) !important;
		background-image: -webkit-linear-gradient(top, #ffffff, #e6e6e6) !important;
		background-image: -o-linear-gradient(top, #ffffff, #e6e6e6) !important;
		background-image: linear-gradient(to bottom, #ffffff, #e6e6e6) !important;
		border-color: #bbbbbb !important;
		color: #333333 !important;
		text-shadow: none !important;
	}
	.whiteDeleteButton, .whiteDeleteButton:hover {
		background-color: #ffffff !important;
		background-image: -moz-linear-gradient(top, #ffffff, #e6e6e6) !important;
		background-image: -webkit-gradient(linear, 0 0, 0 100%, from(#ffffff), to(#e6e6e6)) !important;
		background-image: -webkit-linear-gradient(top, #ffffff, #e6e6e6) !important;
		background-image: -o-linear-gradient(top, #ffffff, #e6e6e6) !important;
		background-image: linear-gradient(to bottom, #ffffff, #e6e6e6) !important;
		border-color: #bbbbbb !important;
		color: #880000 !important;
		text-shadow: none !important;
	}
	.blueButton, .blueButton:hover {
		background-color: #0088cc !important;
		background-image: -moz-linear-gradient(top, #0088cc, #0044cc) !important;
		background-image: -webkit-gradient(linear, 0 0, 0 100%, from(#0088cc), to(#0044cc)) !important;
		background-image: -webkit-linear-gradient(top, #0088cc, #0044cc) !important;
		background-image: -o-linear-gradient(top, #0088cc, #0044cc) !important;
		background-image: linear-gradient(to bottom, #0088cc, #0044cc) !important;
		border-color: #0044cc !important;
		color: #ffffff !important;
		text-shadow: none !important;
	}
	.greyButton, .greyButton:hover {
		background-color: #777777 !important;
		background-image: -moz-linear-gradient(top, #777777, #555555) !important;
		background-image: -webkit-gradient(linear, 0 0, 0 100%, from(#777777), to(#555555)) !important;
		background-image: -webkit-linear-gradient(top, #777777, #555555) !important;
		background-image: -o-linear-gradient(top, #777777, #555555) !important;
		background-image: linear-gradient(to bottom, #777777, #555555) !important;
		border-color: #777777 !important;
		color: #ffffff !important;
		text-shadow: none !important;
	}
	.redButton, .redButton:hover {
		background-color: #d9534f !important;
		background-image: -moz-linear-gradient(top, #d9534f, #b21f1f) !important;
		background-image: -webkit-gradient(linear, 0 0, 0 100%, from(#d9534f), to(#b21f1f)) !important;
		background-image: -webkit-linear-gradient(top, #d9534f, #b21f1f) !important;
		background-image: -o-linear-gradient(top, #d9534f, #b21f1f) !important;
		background-image: linear-gradient(to bottom, #d9534f, #b21f1f) !important;
		border-color: #d9534f !important;
		color: #ffffff !important;
		text-shadow: none !important;
	}
	.orangeButton, .orangeButton:hover {
		background-color: #cc8800 !important;
		background-image: -moz-linear-gradient(top, #cc8800, #cc4400) !important;
		background-image: -webkit-gradient(linear, 0 0, 0 100%, from(#cc8800), to(#cc4400)) !important;
		background-image: -webkit-linear-gradient(top, #cc8800, #cc4400) !important;
		background-image: -o-linear-gradient(top, #cc8800, #cc4400) !important;
		background-image: linear-gradient(to bottom, #cc8800, #cc4400) !important;
		border-color: #cc8800 !important;
		color: #ffffff !important;
		text-shadow: none !important;
	}
	.whiteRefusedButton, .whiteRefusedButton:hover {
		background-color: #ffffff !important;
		background-image: -moz-linear-gradient(top, #ffffff, #e6e6e6) !important;
		background-image: -webkit-gradient(linear, 0 0, 0 100%, from(#ffffff), to(#e6e6e6)) !important;
		background-image: -webkit-linear-gradient(top, #ffffff, #e6e6e6) !important;
		background-image: -o-linear-gradient(top, #ffffff, #e6e6e6) !important;
		background-image: linear-gradient(to bottom, #ffffff, #e6e6e6) !important;
		border-color: #bbbbbb !important;
		color: #999999 !important;
		text-shadow: none !important;
		padding: 4px 14px !important;
		margin: 0px !important;
	}
<?php

// Custom CSS
if (isset($user->conf->CUSTOM_CSS) && ! empty($user->conf->CUSTOM_CSS))
{
	$custom_css = preg_replace('/<br\\s*?\/??>/i', '', $user->conf->CUSTOM_CSS);
	echo html_entity_decode($custom_css, ENT_QUOTES);
}
