<?php

// Load Dolibase
dol_include_once('/themecustomizer/autoload.php');

// Load Dolibase Module class
dolibase_include_once('/core/class/module.php');

/**
 *	Class to describe and enable module
 */
class modThemeCustomizer extends DolibaseModule
{
	/**
	 * Function called after module configuration.
	 * 
	 */
	public function loadSettings()
	{
		// Update picto for Dolibarr 12++
		if (function_exists('version_compare') && version_compare(DOL_VERSION, '12.0.0') >= 0) {
			$this->picto = "theme_customizer_128.png@themecustomizer";
		}

		// Set permissions
		$this->addPermission("customize", "CustomizeTheme");
		$this->addPermission("export", "ExportSettings");
		$this->addPermission("import", "ImportSettings");
		
		// Set hooks
		$this->enableHook("main");
		$this->enableHook("login");
		$this->enableHook("searchform");

		// Add css files
		$this->addCssFile("custom.css.php");
		$this->addCssFile("login.css.php");

		// Add js file
		$this->addJsFile("custom.js.php");

		// Add menus
		$menu_title = compare_version(DOL_VERSION, '<' ,'7.0.0') ? "ThemeCustomizer" : "ThemeCustomizerWithIcon";
		$this->addLeftMenu($this->config['other']['top_menu_name'], "themecustomizer", $menu_title, "/themecustomizer/index.php", '$user->rights->theme_customizer->customize');
	}
}
