<?php

// Load Dolibase
include_once 'autoload.php';

// Load Dolibase Page class
dolibase_include_once('/core/pages/setup.php');

// Create Page using Dolibase
$page = new SetupPage("ThemeCustomizer", '$user->rights->theme_customizer->customize', true);
$page->setTitleLink(DOL_URL_ROOT.'/admin/ihm.php?mainmenu=home', 'GoToDisplaySettings');

// Get parameters
$action = GETPOST('action', 'alpha');
$type = GETPOST('type', 'alpha');
$button = GETPOST('button', 'alpha');

global $db, $conf, $user;

// Set Actions
if ($action == 'apply')
{
	$apply_params = array();

	if ($type == 'action')
	{
		switch ($button)
		{
			case 'white':
				$apply_params['ACTION_BUTTON_BG_FROM'] = 'ffffff';
				$apply_params['ACTION_BUTTON_BG_TO'] = 'e6e6e6';
				$apply_params['ACTION_BUTTON_BORDER_COLOR'] = 'bbbbbb';
				$apply_params['ACTION_BUTTON_TEXT_COLOR'] = '333333';
				break;
			case 'blue':
				$apply_params['ACTION_BUTTON_BG_FROM'] = '0088cc';
				$apply_params['ACTION_BUTTON_BG_TO'] = '0044cc';
				$apply_params['ACTION_BUTTON_BORDER_COLOR'] = '0088cc';
				$apply_params['ACTION_BUTTON_TEXT_COLOR'] = 'ffffff';
				break;
			case 'grey':
				$apply_params['ACTION_BUTTON_BG_FROM'] = '777777';
				$apply_params['ACTION_BUTTON_BG_TO'] = '555555';
				$apply_params['ACTION_BUTTON_BORDER_COLOR'] = '777777';
				$apply_params['ACTION_BUTTON_TEXT_COLOR'] = 'ffffff';
				break;
		}
	}
	else if ($type == 'delete')
	{
		switch ($button)
		{
			case 'white':
				$apply_params['DELETE_BUTTON_BG_FROM'] = 'ffffff';
				$apply_params['DELETE_BUTTON_BG_TO'] = 'e6e6e6';
				$apply_params['DELETE_BUTTON_BORDER_COLOR'] = 'bbbbbb';
				$apply_params['DELETE_BUTTON_TEXT_COLOR'] = '880000';
				break;
			case 'red':
				$apply_params['DELETE_BUTTON_BG_FROM'] = 'd9534f';
				$apply_params['DELETE_BUTTON_BG_TO'] = 'b21f1f';
				$apply_params['DELETE_BUTTON_BORDER_COLOR'] = 'd9534f';
				$apply_params['DELETE_BUTTON_TEXT_COLOR'] = 'ffffff';
				break;
			case 'orange':
				$apply_params['DELETE_BUTTON_BG_FROM'] = 'cc8800';
				$apply_params['DELETE_BUTTON_BG_TO'] = 'cc4400';
				$apply_params['DELETE_BUTTON_BORDER_COLOR'] = 'cc8800';
				$apply_params['DELETE_BUTTON_TEXT_COLOR'] = 'ffffff';
				break;
		}
	}
	else if ($type == 'disabled')
	{
		switch ($button)
		{
			case 'white':
				$apply_params['DISABLED_BUTTON_BG_FROM'] = 'ffffff';
				$apply_params['DISABLED_BUTTON_BG_TO'] = 'e6e6e6';
				$apply_params['DISABLED_BUTTON_BORDER_COLOR'] = 'bbbbbb';
				$apply_params['DISABLED_BUTTON_TEXT_COLOR'] = '999999';
				break;
		}
	}

	if (! empty($apply_params))
	{
		if (dol_set_user_param($db, $conf, $user, $apply_params))
		{
			dolibase_redirect($_SERVER["PHP_SELF"]);
		}
		else
		{
			dol_print_error($db);
		}
	}
}
else if ($action == 'reset')
{
	$reset_params = array();

	if ($type == 'action')
	{
		$reset_params = array('ACTION_BUTTON_BG_FROM' => '', 'ACTION_BUTTON_BG_TO' => '', 'ACTION_BUTTON_BORDER_COLOR' => '', 'ACTION_BUTTON_TEXT_COLOR' => '', 'ACTION_BUTTON_FONT_BOLD' => '', 'ACTION_BUTTON_TEXT_UPPERCASE' => '');
	}
	else if ($type == 'delete')
	{
		$reset_params = array('DELETE_BUTTON_BG_FROM' => '', 'DELETE_BUTTON_BG_TO' => '', 'DELETE_BUTTON_BORDER_COLOR' => '', 'DELETE_BUTTON_TEXT_COLOR' => '', 'DELETE_BUTTON_FONT_BOLD' => '', 'DELETE_BUTTON_TEXT_UPPERCASE' => '');
	}
	else if ($type == 'disabled')
	{
		$reset_params = array('DISABLED_BUTTON_BG_FROM' => '', 'DISABLED_BUTTON_BG_TO' => '', 'DISABLED_BUTTON_BORDER_COLOR' => '', 'DISABLED_BUTTON_TEXT_COLOR' => '', 'DISABLED_BUTTON_FONT_BOLD' => '', 'DISABLED_BUTTON_TEXT_UPPERCASE' => '');
	}

	if (! empty($reset_params))
	{
		if (dol_set_user_param($db, $conf, $user, $reset_params))
		{
			dolibase_redirect($_SERVER["PHP_SELF"]);
		}
		else
		{
			dol_print_error($db);
		}
	}
}
else if (preg_match('/^(set|del)_(.*)/', $action, $reg))
{
	$param = $reg[2];
	$value = (is_submitted($param) ? GETPOST($param) : ($action[0] == 's' ? 1 : 0));

	if (dol_set_user_param($db, $conf, $user, array('THEME_ELDY_ENABLE_PERSONALIZED' => '1', $param => $value)))
	{
		dolibase_redirect($_SERVER["PHP_SELF"].'?mainmenu=home');
	}
	else
	{
		dol_print_error($db);
	}
}

// Set Tabs
$page->addTab("General", "/themecustomizer/index.php?mainmenu=home");
$page->addTab("Menus", "/themecustomizer/menus.php?mainmenu=home");
$page->addTab("Body", "/themecustomizer/body.php?mainmenu=home");
$page->addTab("Buttons", "/themecustomizer/buttons.php?mainmenu=home", true);
$page->addTab("Graphs", "/themecustomizer/graphs.php?mainmenu=home");
if ($user->admin) {
	$page->addTab("LoginPage", "/themecustomizer/login_page.php?mainmenu=home");
}
$page->addTab("Advanced", "/themecustomizer/advanced.php?mainmenu=home");

$page->begin();

// Action buttons
$table_header = array(
	array('name' => 'ActionButtons'),
	array('name' => '<a class="buttonDelete" href="'.$_SERVER["PHP_SELF"].'?action=reset&type=action">'.$langs->trans('Reset').'</a>&nbsp;&nbsp;&nbsp;', 'attr' => 'align="right"')
);

$page->openTable($table_header);

$page->addOption('BackgroundGradient', '');

$option_name = "ACTION_BUTTON_BG_FROM";
$conf->global->$option_name = isset($user->conf->ACTION_BUTTON_BG_FROM) ? $user->conf->ACTION_BUTTON_BG_FROM : '';
$page->addColorOption("GradientFrom", $option_name);

$option_name = "ACTION_BUTTON_BG_TO";
$conf->global->$option_name = isset($user->conf->ACTION_BUTTON_BG_TO) ? $user->conf->ACTION_BUTTON_BG_TO : '';
$page->addColorOption("GradientTo", $option_name);

$option_name = "ACTION_BUTTON_BORDER_COLOR";
$conf->global->$option_name = isset($user->conf->ACTION_BUTTON_BORDER_COLOR) ? $user->conf->ACTION_BUTTON_BORDER_COLOR : '';
$page->addColorOption("ActionButtonBorderColor", $option_name);

$option_name = "ACTION_BUTTON_TEXT_COLOR";
$conf->global->$option_name = isset($user->conf->ACTION_BUTTON_TEXT_COLOR) ? $user->conf->ACTION_BUTTON_TEXT_COLOR : '';
$page->addColorOption("ActionButtonTextColor", $option_name);

$option_name = "ACTION_BUTTON_FONT_BOLD";
$conf->global->$option_name = isset($user->conf->ACTION_BUTTON_FONT_BOLD) ? $user->conf->ACTION_BUTTON_FONT_BOLD : false;
$page->addSwitchOption("ButtonFontBold", $option_name);

$option_name = "ACTION_BUTTON_TEXT_UPPERCASE";
$conf->global->$option_name = isset($user->conf->ACTION_BUTTON_TEXT_UPPERCASE) ? $user->conf->ACTION_BUTTON_TEXT_UPPERCASE : false;
$page->addSwitchOption("ButtonTextUppercase", $option_name);

$examples = $langs->trans('ButtonExamples');
$examples.= '&nbsp;&nbsp;&nbsp;';
$examples.= '<a class="button whiteButton" href="'.$_SERVER["PHP_SELF"].'?action=apply&type=action&button=white">'.$langs->trans('Button').'</a>';
$examples.= '&nbsp;&nbsp;&nbsp;';
$examples.= '<a class="button blueButton" href="'.$_SERVER["PHP_SELF"].'?action=apply&type=action&button=blue">'.$langs->trans('Button').'</a>';
$examples.= '&nbsp;&nbsp;&nbsp;';
$examples.= '<a class="button greyButton" href="'.$_SERVER["PHP_SELF"].'?action=apply&type=action&button=grey">'.$langs->trans('Button').'</a>';
$page->addOption($examples, '');

$page->closeTable();

// Delete button(s)
$page->addLineBreak();

$table_header = array(
	array('name' => 'DeleteButtons'),
	array('name' => '<a class="buttonDelete" href="'.$_SERVER["PHP_SELF"].'?action=reset&type=delete">'.$langs->trans('Reset').'</a>&nbsp;&nbsp;&nbsp;', 'attr' => 'align="right"')
);

$page->openTable($table_header);

$page->addOption('BackgroundGradient', '');

$option_name = "DELETE_BUTTON_BG_FROM";
$conf->global->$option_name = isset($user->conf->DELETE_BUTTON_BG_FROM) ? $user->conf->DELETE_BUTTON_BG_FROM : '';
$page->addColorOption("GradientFrom", $option_name);

$option_name = "DELETE_BUTTON_BG_TO";
$conf->global->$option_name = isset($user->conf->DELETE_BUTTON_BG_TO) ? $user->conf->DELETE_BUTTON_BG_TO : '';
$page->addColorOption("GradientTo", $option_name);

$option_name = "DELETE_BUTTON_BORDER_COLOR";
$conf->global->$option_name = isset($user->conf->DELETE_BUTTON_BORDER_COLOR) ? $user->conf->DELETE_BUTTON_BORDER_COLOR : '';
$page->addColorOption("DeleteButtonBorderColor", $option_name);

$option_name = "DELETE_BUTTON_TEXT_COLOR";
$conf->global->$option_name = isset($user->conf->DELETE_BUTTON_TEXT_COLOR) ? $user->conf->DELETE_BUTTON_TEXT_COLOR : '';
$page->addColorOption("DeleteButtonTextColor", $option_name);

$option_name = "DELETE_BUTTON_FONT_BOLD";
$conf->global->$option_name = isset($user->conf->DELETE_BUTTON_FONT_BOLD) ? $user->conf->DELETE_BUTTON_FONT_BOLD : false;
$page->addSwitchOption("ButtonFontBold", $option_name);

$option_name = "DELETE_BUTTON_TEXT_UPPERCASE";
$conf->global->$option_name = isset($user->conf->DELETE_BUTTON_TEXT_UPPERCASE) ? $user->conf->DELETE_BUTTON_TEXT_UPPERCASE : false;
$page->addSwitchOption("ButtonTextUppercase", $option_name);

$examples = $langs->trans('ButtonExamples');
$examples.= '&nbsp;&nbsp;&nbsp;';
$examples.= '<a class="button whiteDeleteButton" href="'.$_SERVER["PHP_SELF"].'?action=apply&type=delete&button=white">'.$langs->trans('Button').'</a>';
$examples.= '&nbsp;&nbsp;&nbsp;';
$examples.= '<a class="button redButton" href="'.$_SERVER["PHP_SELF"].'?action=apply&type=delete&button=red">'.$langs->trans('Button').'</a>';
$examples.= '&nbsp;&nbsp;&nbsp;';
$examples.= '<a class="button orangeButton" href="'.$_SERVER["PHP_SELF"].'?action=apply&type=delete&button=orange">'.$langs->trans('Button').'</a>';
$page->addOption($examples, '');

$page->closeTable();

// Disabled button(s)
$page->addLineBreak();

$table_header = array(
	array('name' => 'DisabledButtons'),
	array('name' => '<a class="buttonDelete" href="'.$_SERVER["PHP_SELF"].'?action=reset&type=disabled">'.$langs->trans('Reset').'</a>&nbsp;&nbsp;&nbsp;', 'attr' => 'align="right"')
);

$page->openTable($table_header);

$page->addOption('BackgroundGradient', '');

$option_name = "DISABLED_BUTTON_BG_FROM";
$conf->global->$option_name = isset($user->conf->DISABLED_BUTTON_BG_FROM) ? $user->conf->DISABLED_BUTTON_BG_FROM : '';
$page->addColorOption("GradientFrom", $option_name);

$option_name = "DISABLED_BUTTON_BG_TO";
$conf->global->$option_name = isset($user->conf->DISABLED_BUTTON_BG_TO) ? $user->conf->DISABLED_BUTTON_BG_TO : '';
$page->addColorOption("GradientTo", $option_name);

$option_name = "DISABLED_BUTTON_BORDER_COLOR";
$conf->global->$option_name = isset($user->conf->DISABLED_BUTTON_BORDER_COLOR) ? $user->conf->DISABLED_BUTTON_BORDER_COLOR : '';
$page->addColorOption("DisabledButtonBorderColor", $option_name);

$option_name = "DISABLED_BUTTON_TEXT_COLOR";
$conf->global->$option_name = isset($user->conf->DISABLED_BUTTON_TEXT_COLOR) ? $user->conf->DISABLED_BUTTON_TEXT_COLOR : '';
$page->addColorOption("DisabledButtonTextColor", $option_name);

$option_name = "DISABLED_BUTTON_FONT_BOLD";
$conf->global->$option_name = isset($user->conf->DISABLED_BUTTON_FONT_BOLD) ? $user->conf->DISABLED_BUTTON_FONT_BOLD : false;
$page->addSwitchOption("ButtonFontBold", $option_name);

$option_name = "DISABLED_BUTTON_TEXT_UPPERCASE";
$conf->global->$option_name = isset($user->conf->DISABLED_BUTTON_TEXT_UPPERCASE) ? $user->conf->DISABLED_BUTTON_TEXT_UPPERCASE : false;
$page->addSwitchOption("ButtonTextUppercase", $option_name);

$examples = $langs->trans('ButtonExamples');
$examples.= '&nbsp;&nbsp;&nbsp;';
$examples.= '<a class="butActionRefused whiteRefusedButton" href="'.$_SERVER["PHP_SELF"].'?action=apply&type=disabled&button=white">'.$langs->trans('Button').'</a>';
$page->addOption($examples, '');

//$test_button = '<a class="butActionRefused" href="#">'.$langs->trans('Test').'</a>';
//$page->addOption('Result', $test_button);

$page->closeTable();

// Clear Cache notice
$page->addLineBreak();

echo info_admin($langs->trans('ClearCacheNotice'));

$page->end();
