<?php

// Load Dolibase
include_once 'autoload.php';

// Load Dolibase Page class
dolibase_include_once('/core/pages/setup.php');

// Load Dolibarr functions2 lib
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';

// Create Page using Dolibase
$page = new SetupPage("ThemeCustomizer", '$user->rights->theme_customizer->customize', true);
$page->setTitleLink(DOL_URL_ROOT.'/admin/ihm.php?mainmenu=home', 'GoToDisplaySettings');

// Get parameters
$action = GETPOST('action', 'alpha');

global $db, $conf, $user, $langs;

// Set Actions
if ($action == 'save')
{
	$custom_css = GETPOST('CUSTOM_CSS');
	$custom_js = GETPOST('CUSTOM_JS');

	if (dol_set_user_param($db, $conf, $user, array('THEME_ELDY_ENABLE_PERSONALIZED' => '1', 'CUSTOM_CSS' => $custom_css, 'CUSTOM_JS' => $custom_js)))
	{
		dolibase_redirect($_SERVER["PHP_SELF"].'?mainmenu=home');
	}
	else
	{
		dol_print_error($db);
	}
}

// Set Tabs
$page->addTab("General", "/themecustomizer/index.php?mainmenu=home");
$page->addTab("Menus", "/themecustomizer/menus.php?mainmenu=home");
$page->addTab("Body", "/themecustomizer/body.php?mainmenu=home");
$page->addTab("Buttons", "/themecustomizer/buttons.php?mainmenu=home");
$page->addTab("Graphs", "/themecustomizer/graphs.php?mainmenu=home");
if ($user->admin) {
	$page->addTab("LoginPage", "/themecustomizer/login_page.php?mainmenu=home");
}
$page->addTab("Advanced", "/themecustomizer/advanced.php?mainmenu=home", true);

$page->begin();

?>

<form action="<?php echo $_SERVER["PHP_SELF"]; ?>" method="post">
	<input type="hidden" name="token" value="<?php echo $_SESSION['newtoken']; ?>" />
	<input type="hidden" name="action" value="save" />
	<?php echo $langs->trans('CustomCssNotice'); ?>
	<br><br>
	<?php echo $page->form->textEditor('CUSTOM_CSS', $user->conf->CUSTOM_CSS, 'dolibarr_readonly', '300'); ?>
	<br><br>
	<?php echo $langs->trans('CustomJsNotice'); ?>
	<br><br>
	<?php echo $page->form->textEditor('CUSTOM_JS', $user->conf->CUSTOM_JS, 'dolibarr_readonly', '300'); ?>
	<div class="tabsAction force-center">
		<input type="submit" class="button" value="<?php echo $langs->trans("Save"); ?>">
	</div>
</form>

<?php

// Clear Cache notice
echo info_admin($langs->trans('ClearCacheNotice'));

$page->end();
