<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) <year>  <name of author>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup	modThemeAdmin	modThemeAdmin module
 * 	\brief		modThemeAdmin module descriptor.
 * 	\file		core/modules/modmodThemeAdmin.class.php
 * 	\ingroup	modThemeAdmin
 * 	\brief		Description and activation file for module modThemeAdmin
 */

include_once DOL_DOCUMENT_ROOT . "/core/modules/DolibarrModules.class.php";
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';

/**
 * Description and activation class for module modThemeAdmin
 */
class modThemeAdmin extends DolibarrModules
{

	/**
	 * 	Constructor. Define names, constants, directories, boxes, permissions
	 *
	 * 	@param	DoliDB		$db	Database handler
	 */
	public function __construct($db)
	{
		global $langs, $conf;

		$this->db = $db;
		$this->numero = 688810924007;
		$this->rights_class = 'themeadmin';

		$this->family = "Next Thèmes";
		$this->name = 'themeadmin'; 
		// preg_replace('/^mod/i', '', get_class($this));
		$this->description = "themeadmindescp";
		$this->version = '12.0';
		$this->const_name = 'MAIN_MODULE_' . strtoupper($this->name);
		$this->special = 0;
		$this->picto = 'logo@themeadmin';
		
		$this->module_parts = array(
			'menus' => 1,
			'css' => array('themeadmin/css/as_style.min.css'),
			'js' => array('themeadmin/js/dol_url_root.js.php','themeadmin/js/as_code.min.js'),
			'hooks' => array('toprightmenu')
		);

		$this->dirs = array();
		$this->config_page_url = array("admin.php@themeadmin");
		$this->config_page_url = array();
		$this->hidden = false;
		$this->depends = array();
		$this->requiredby = array();
		$this->conflictwith = array();
		$this->phpmin = array(5, 3);
		$this->need_dolibarr_version = array(4, 0);
		$this->langfiles = array("themeadmin@themeadmin");

		// Dictionaries
		if (! isset($conf->themeadmin->enabled)) {
			$conf->themeadmin=new stdClass();
			$conf->themeadmin->enabled = 0;
		}
		$this->dictionaries = array();
		$this->boxes = array(); // Boxes list

		// Permissions
		$this->rights = array(); // Permission array used by this module
		$r = 0;

		// Exports
		$r = 0;

		// Constants
		$this->const = array ();
		$r = 0;
		
		$r ++;
		$this->const [$r] [0] = "MAIN_FORCETHEME";	// name
		$this->const [$r] [1] = "chaine";			// type
		$this->const [$r] [2] = 'themeadmin';		// def value
		$this->const [$r] [3] = '';					// note
		$this->const [$r] [4] = 0;					// visible
		$this->const [$r] [5] = 0;
		
		$r ++;
		$this->const [$r] [0] = "MAIN_MENU_STANDARD_FORCED";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = 'themeadmin_menu.php';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 0;
		
		$r ++;
		$this->const [$r] [0] = "MAIN_MENUFRONT_STANDARD_FORCED";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = 'themeadmin_menu.php';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 0;
		
		$r ++;
		$this->const [$r] [0] = "MAIN_MENU_SMARTPHONE_FORCED";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = 'themeadmin_menu.php';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 0;
		
		$r ++;
		$this->const [$r] [0] = "MAIN_MENUFRONT_SMARTPHONE_FORCED";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = 'themeadmin_menu.php';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 0;
		
		$r ++;
		$this->const [$r] [0] = "DOL_VERSION";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = '';
		$this->const [$r] [3] = 'Dolibarr version';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 0;

	}



	/**
	 * Function called when module is enabled.
	 * The init function add constants, boxes, permissions and menus
	 * (defined in constructor) into Dolibarr database.
	 * It also creates data directories
	 *
	 * 	@param		string	$options	Options when enabling module ('', 'noboxes')
	 * 	@return		int					1 if OK, 0 if KO
	 */
	public function init($options = '')
	{
		$sql = array();

		$result = $this->loadTables();

		$arraythems = array("modNextTheme","modOwnTheme","modTheme3d","modMenu3dResponsive","modLightTheme","modMyTheme","modBeCreative");
		global $conf;
		foreach ($arraythems as $value) {
			$keymodulelowercase=strtolower(preg_replace('/^mod/','',$value));
			if (in_array($keymodulelowercase, $conf->modules)) 
				$result=unActivateModule($value);
		}

	    // on first module activation only
	    $new = dol_buildpath('/themeadmin/inst/firstUse');
	    if (file_exists($new)) {
			if ( !file_exists(dol_buildpath('/themeadmin/css/as_style_custom.css')) ) 
				copy(dol_buildpath('/themeadmin/inst/css/as_style_custom.css'),dol_buildpath('/themeadmin/css/as_style_custom.css'));
			if ( !file_exists(dol_buildpath('/themeadmin/js/as_code_custom.js')) ) 
				copy(dol_buildpath('/themeadmin/inst/js/as_code_custom.js'),dol_buildpath('/themeadmin/js/as_code_custom.js'));

		    // set old primary and secondary colors
			$file = dol_buildpath('/themeadmin/css/as_style.min.css');
	    	$def_col1 = "#1e88e5";
	    	$def_col2 = "#1e88e5";
	    	$col1 = dolibarr_get_const($this->db,'THEMEADMIN_COL1');
	    	$col2 = dolibarr_get_const($this->db,'THEMEADMIN_COL2');

			if ( !empty($col1) || !empty($col2) )	{
				$file_contents = file_get_contents($file);
				if ( !empty($col1) ) $file_contents = str_replace($def_col1,$col1,$file_contents);
				if ( !empty($col2) ) $file_contents = str_replace($def_col2,$col2,$file_contents);
				file_put_contents($file,$file_contents);
			}
	    	if(!$col1) dolibarr_set_const($this->db,'THEMEADMIN_COL1',$def_col1,'chaine',0,'',0);
	    	if(!$col2) dolibarr_set_const($this->db,'THEMEADMIN_COL2',$def_col2,'chaine',0,'',0);

			//delete older version files
			if (file_exists(dol_buildpath('/themeadmin/js/custom.min.js'))) 
				unlink(dol_buildpath('/themeadmin/js/custom.min.js'));
			if (file_exists(dol_buildpath('/themeadmin/css/style.min.css'))) 
				unlink(dol_buildpath('/themeadmin/css/style.min.css'));


			// rmdir($new);
	    }
	    // update or create themeadmin theme folder from inst folder
		$source = dol_buildpath('/themeadmin/inst/theme');
		$dest = dol_buildpath('/theme');

		// cpy_10($source,$dest);

		$dcd = dolCopyDir($source, $dest, 0775, 1);
		

		// $dcd = 1;
		if($dcd){
			$source = dol_buildpath('/themeadmin/img/weather.new');
			$dest = dol_buildpath('/theme/themeadmin/weather');
			dolCopyDir($source, $dest, 0775, 1);
			
			// copy images from eldy theme
			$source = dol_buildpath('/theme/eldy/img');
			$dest = dol_buildpath('/theme/themeadmin/img');
			dolCopyDir($source, $dest, 0775, 1);


			$theperm = dol_buildpath('/theme/themeadmin');
			themeadminpermissionto($theperm);

	    	// update webmail file
	    	if ( dolibarr_get_const($this->db,'MAIN_MODULE_WEBMAIL') ) {
				copy(dol_buildpath('/webmail/list_messages.php'),dol_buildpath('/themeadmin/inst/webmail/list_messages.php'));
				copy(dol_buildpath('/themeadmin/inst/webmail/list_messages_modified.php'),dol_buildpath('/webmail/list_messages.php'));
			}

			$installed_ver = dolibarr_get_const($this->db,'MAIN_VERSION_LAST_INSTALL',0);
			$upgraded_ver = dolibarr_get_const($this->db,'MAIN_VERSION_LAST_UPGRADE',0);
			if ($upgraded_ver!="") {
				$dol_version = $upgraded_ver;
			} else {
				$dol_version = $installed_ver;
			}
		    // print_r($dcd);
		    // die();
			// replace weather images
			dolibarr_set_const($this->db,'DOL_VERSION',$dol_version,'chaine',0,'Dolibarr version',0);
			dolibarr_set_const($this->db,'MAIN_THEME','themeadmin','chaine',0,'Sets themeadmin Theme',0);
			dolibarr_set_const($this->db,'MAIN_MENU_STANDARD','themeadmin_menu.php','chaine',0,'',0);
			dolibarr_set_const($this->db,'MAIN_MENUFRONT_STANDARD','themeadmin_menu.php','chaine',0,'',0);
			dolibarr_set_const($this->db,'MAIN_MENU_SMARTPHONE','themeadmin_menu.php','chaine',0,'',0);
			dolibarr_set_const($this->db,'MAIN_MENUFRONT_SMARTPHONE','themeadmin_menu.php','chaine',0,'',0);

			if (!dolibarr_get_const($this->db,'THEMEADMIN_COL1',0))
				dolibarr_set_const($this->db,'THEMEADMIN_COL1',"#1e88e5",'chaine',0,'',0);
			if (!dolibarr_get_const($this->db,'THEMEADMIN_COL2',0))
				dolibarr_set_const($this->db,'THEMEADMIN_COL2',"#26c6da",'chaine',0,'',0);
			if (!dolibarr_get_const($this->db,'THEMEADMIN_COL_BODY_BCKGRD',0))
				dolibarr_set_const($this->db,'THEMEADMIN_COL_BODY_BCKGRD',"#e6eaef",'chaine',0,'',0);
			if (!dolibarr_get_const($this->db,'THEMEADMIN_COL_LOGO_BCKGRD',0))
				dolibarr_set_const($this->db,'THEMEADMIN_COL_LOGO_BCKGRD',"#1e88e5",'chaine',0,'',0);
			if (!dolibarr_get_const($this->db,'THEMEADMIN_COL_TXT_MENU',0))
				dolibarr_set_const($this->db,'THEMEADMIN_COL_TXT_MENU',"#b8c6e5",'chaine',0,'',0);
			
			if (!dolibarr_get_const($this->db,'THEMEADMIN_COL_HEADER_BCKGRD',0))
				dolibarr_set_const($this->db,'THEMEADMIN_COL_HEADER_BCKGRD',"#26a69a",'chaine',0,'',0);
			if ( !dolibarr_get_const($this->db,'THEMEADMIN_CUSTOM_CSS',0)) 
				dolibarr_set_const($this->db,'THEMEADMIN_CUSTOM_CSS',0,'yesno',0,'',0);
			if (!dolibarr_get_const($this->db,'THEMEADMIN_CUSTOM_JS',0))
				dolibarr_set_const($this->db,'THEMEADMIN_CUSTOM_JS',0,'yesno',0,'',0);
			// if (!dolibarr_get_const($this->db,'THEMEADMIN_FIXED_MENU'))
				dolibarr_set_const($this->db,'THEMEADMIN_FIXED_MENU',0,'yesno',0,'',0);
			if (!dolibarr_get_const($this->db,'THEMEADMIN_D_HEADER_FONT_SIZE',0))
				dolibarr_set_const($this->db,'THEMEADMIN_D_HEADER_FONT_SIZE','1.7rem','chaine',0,'',0);
			if (!dolibarr_get_const($this->db,'THEMEADMIN_S_HEADER_FONT_SIZE',0))
				dolibarr_set_const($this->db,'THEMEADMIN_S_HEADER_FONT_SIZE','1.6rem','chaine',0,'',0);
			if (!dolibarr_get_const($this->db,'THEMEADMIN_D_VMENU_FONT_SIZE',0))
				dolibarr_set_const($this->db,'THEMEADMIN_D_VMENU_FONT_SIZE','1.2rem','chaine',0,'',0);
			if (!dolibarr_get_const($this->db,'THEMEADMIN_S_VMENU_FONT_SIZE',0))
				dolibarr_set_const($this->db,'THEMEADMIN_S_VMENU_FONT_SIZE','1.2rem','chaine',0,'',0);

			return $this->_init($sql, $options);
		}

		return '';
	}

	/**
	 * Function called when module is disabled.
	 * Remove from database constants, boxes and permissions from Dolibarr database.
	 * Data directories are not deleted
	 *
	 * 	@param		string	$options	Options when enabling module ('', 'noboxes')
	 * 	@return		int					1 if OK, 0 if KO
	 */
	public function remove($options = '')
	{
		$sql = array();

		// dolibarr_set_const($this->db,'MAIN_THEME','eldy','chaine',0,'',0);
		// dolibarr_set_const($this->db,'MAIN_MENU_STANDARD','eldy_menu.php','chaine',0,'',0);
		// dolibarr_set_const($this->db,'MAIN_MENUFRONT_STANDARD','eldy_menu.php','chaine',0,'',0);
		// dolibarr_set_const($this->db,'MAIN_MENU_SMARTPHONE','eldy_menu.php','chaine',0,'',0);
		// dolibarr_set_const($this->db,'MAIN_MENUFRONT_SMARTPHONE','eldy_menu.php','chaine',0,'',0);
		// dolibarr_del_const($this->db,'MAIN_FORCETHEME',0);
		// dolibarr_del_const($this->db,'MAIN_MENU_STANDARD_FORCED',0);
		// dolibarr_del_const($this->db,'MAIN_MENUFRONT_STANDARD_FORCED',0);
		// dolibarr_del_const($this->db,'MAIN_MENU_SMARTPHONE_FORCED',0);
		// dolibarr_del_const($this->db,'MAIN_MENUFRONT_SMARTPHONE_FORCED',0);

		// dolibarr_del_const($this->db,'MAIN_MODULE_THEME3D_CSS');
		// dolibarr_del_const($this->db,'MAIN_MODULE_THEME3D_HOOKS');
		// dolibarr_del_const($this->db,'MAIN_MODULE_THEME3D_JS');


// 
		// dolibarr_set_const($this->db,'MAIN_THEME','eldy','chaine',0,'');
		// dolibarr_set_const($this->db,'MAIN_MENU_STANDARD','eldy_menu.php','chaine',0,'');
		// dolibarr_set_const($this->db,'MAIN_MENUFRONT_STANDARD','eldy_menu.php','chaine',0,'');
		// dolibarr_set_const($this->db,'MAIN_MENU_SMARTPHONE','eldy_menu.php','chaine',0,'');
		// dolibarr_set_const($this->db,'MAIN_MENUFRONT_SMARTPHONE','eldy_menu.php','chaine',0,'');
		// dolibarr_del_const($this->db,'MAIN_FORCETHEME');
		// dolibarr_del_const($this->db,'MAIN_MENU_STANDARD_FORCED');
		// dolibarr_del_const($this->db,'MAIN_MENUFRONT_STANDARD_FORCED');
		// dolibarr_del_const($this->db,'MAIN_MENU_SMARTPHONE_FORCED');
		// dolibarr_del_const($this->db,'MAIN_MENUFRONT_SMARTPHONE_FORCED');

		dolibarr_del_const($this->db,'MAIN_THEME');
		dolibarr_del_const($this->db,'MAIN_MENU_STANDARD');
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_STANDARD');
		dolibarr_del_const($this->db,'MAIN_MENU_SMARTPHONE');
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_SMARTPHONE');
		dolibarr_del_const($this->db,'MAIN_FORCETHEME');
		dolibarr_del_const($this->db,'MAIN_MENU_STANDARD_FORCED');
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_STANDARD_FORCED');
		dolibarr_del_const($this->db,'MAIN_MENU_SMARTPHONE_FORCED');
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_SMARTPHONE_FORCED');
		
		// Local
		dolibarr_del_const($this->db,'MAIN_MODULE_THEMEADMIN_CSS');
		dolibarr_del_const($this->db,'MAIN_MODULE_THEMEADMIN_HOOKS');
		dolibarr_del_const($this->db,'MAIN_MODULE_THEMEADMIN_JS');
		// Theme
		dolibarr_set_const($this->db,'MAIN_THEME','eldy','chaine',0,'',0);
		dolibarr_set_const($this->db,'MAIN_MENU_STANDARD','eldy_menu.php','chaine',0,'',0);
		dolibarr_set_const($this->db,'MAIN_MENUFRONT_STANDARD','eldy_menu.php','chaine',0,'',0);
		dolibarr_set_const($this->db,'MAIN_MENU_SMARTPHONE','eldy_menu.php','chaine',0,'',0);
		dolibarr_set_const($this->db,'MAIN_MENUFRONT_SMARTPHONE','eldy_menu.php','chaine',0,'',0);



		$todlt = dol_buildpath('/theme/themeadmin');
		removeDirRecursivelyThemeAdmin($todlt);

		if ( file_exists( dol_buildpath('/webmail/list_messages.php') ) ) 
			copy(dol_buildpath('/themeadmin/inst/webmail/list_messages.php'),dol_buildpath('/webmail/list_messages.php'));

		return $this->_remove($sql, $options);
	}

	/**
	 * Create tables, keys and data required by module
	 * Files llx_table1.sql, llx_table1.key.sql llx_data.sql with create table, create keys
	 * and create data commands must be stored in directory /themeadmin/sql/
	 * This function is called by this->init
	 *
	 * 	@return		int		<=0 if KO, >0 if OK
	 */
	private function loadTables()
	{
		return $this->_load_tables('/themeadmin/sql/');
	}

}


//ADEDDCODE
function removeDirRecursivelyThemeAdmin($dir){
	$count = 0;
	if (dol_is_dir($dir))
	{
		$dir_osencoded=dol_osencode($dir);
		if ($handle = opendir("$dir_osencoded"))
		{
			while (false !== ($item = readdir($handle)))
			{
				if (! utf8_check($item)) $item=utf8_encode($item);  // should be useless

				if ($item != "." && $item != "..")
				{
					if (is_dir(dol_osencode("$dir/$item")) && ! is_link(dol_osencode("$dir/$item")))
					{
						$count=removeDirRecursivelyThemeAdmin("$dir/$item");
					}
					else
					{
						@chmod("$dir/$item", octdec(777));
						$result=dol_delete_file("$dir/$item",0,1);
					}
				}
			}
			
			closedir($handle);

			// if (empty($onlysub))
			// {
			$result=dol_delete_dir($dir, $nophperrors);
			// }
		}
	}
}

function themeadminpermissionto($source){
    if(is_dir($source)) {
    	@chmod($source, 0775);
        $dir_handle=opendir($source);
        while($file=readdir($dir_handle)){
            if($file!="." && $file!=".."){
                if(is_dir($source."/".$file)){
                    @chmod($source."/".$file, 0775);
                    themeadminpermissionto($source."/".$file);
                } else {
                    @chmod($source."/".$file, 0664);
                }
            }
        }
        closedir($dir_handle);
    } else {
        @chmod($source, 0664);
    }
}


// copy recursive
// function cpy_10($source, $dest){
//     if(is_dir($source)) {
//         $dir_handle=opendir($source);
//         while($file=readdir($dir_handle)){
//             if($file!="." && $file!=".."){
//                 if(is_dir($source."/".$file)){
//                     if(!is_dir($dest."/".$file)){
//                         mkdir($dest."/".$file);
//                     }
//                     cpy_10($source."/".$file, $dest."/".$file);
//                 } else {
//                     copy($source."/".$file, $dest."/".$file);
//                 }
//             }
//         }
//         closedir($dir_handle);
//     } else {
//         copy($source, $dest);
//     }
// }

