<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) <year>  <name of author>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup	Theme3d	Theme3d module
 * 	\brief		Theme3d module descriptor.
 * 	\file		core/modules/modTheme3d.class.php
 * 	\ingroup	theme3d
 * 	\brief		Description and activation file for module Theme3d
 */

include_once DOL_DOCUMENT_ROOT . "/core/modules/DolibarrModules.class.php";
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';


/**
 * Description and activation class for module Theme3d
 */
class modTheme3d extends DolibarrModules
{

	/**
	 * 	Constructor. Define names, constants, directories, boxes, permissions
	 *
	 * 	@param	DoliDB		$db	Database handler
	 */
	public function __construct($db)
	{
		global $langs, $conf;

		$this->db = $db;
		$this->numero = 677720040;
		$this->rights_class = 'theme3d';

		$this->family = "Next Thèmes";
		$this->module_position = '44';
		$this->name = preg_replace('/^mod/i', '', get_class($this));
		$this->description = "Personnalisez les menus";
		$this->version = '12.0';
		$this->const_name = 'MAIN_MODULE_' . strtoupper($this->name);
		$this->special = 0;
		$this->picto = 'thumb@theme3d';

		// $this->module_parts = array(
		// 	'menus' => 1,
		// 	'css' => array('theme3d/css/as_style.min.css'),
		// 	'js' => array('theme3d/js/dol_url_root.js.php','theme3d/js/as_code.min.js'),
		// 	'hooks' => array('toprightmenu')
		// );
		$this->module_parts = array(
			'menus' => 1,
			'css' => array('data'=>array('theme3d/css/theme3d.css'), 'entity'=>'0'), 
			'js' => array('data'=>array("theme3d/js/theme3d.js","theme3d/js/jquery.slimscroll.min.js"), 'entity'=>'0'), 
			'hooks' => array('data'=>array('toprightmenu'), 'entity'=>'0'), 
		);

		$this->dirs = array();
		$this->config_page_url = array("admin.php@theme3d");
		// $this->config_page_url = array();
		$this->hidden = false;
		$this->depends = array();
		$this->requiredby = array();
		// $this->conflictwith = array("modNextTheme","modLightTheme","modOwnTheme","modMenu3dResponsive","modMyTheme","modBeCreative");	// List of module class names as string this module is in conflict with
		$this->conflictwith = array();
		$this->phpmin = array(5, 3);
		$this->need_dolibarr_version = array(4, 0);
		$this->langfiles = array("theme3d@theme3d");

		// Dictionaries
		if (! isset($conf->theme3d->enabled)) {
			$conf->theme3d=new stdClass();
			$conf->theme3d->enabled = 0;
		}
		$this->dictionaries = array();
		$this->boxes = array(); // Boxes list

		// Permissions
		$this->rights = array(); // Permission array used by this module
		$r = 0;

		// Exports
		$r = 0;

		// Constants
		$this->const = array ();
		$r = 0;
		
		$r ++;
		$this->const [$r] [0] = "SHOW_MENU_TOP_THEME3D";	// name
		$this->const [$r] [1] = "chaine";			// type
		$this->const [$r] [2] = '';		// def value
		$this->const [$r] [3] = '';					// note
		$this->const [$r] [4] = 0;					// visible
		$this->const [$r] [5] = 'allentities';
		
		$r ++;
		$this->const [$r] [0] = "HIDE_MENU_VERTICAL_DOLIBARR_THEME3D";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = '';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 'allentities';

		$r ++;
		$this->const [$r] [0] = "MAIN_FORCETHEME";	// name
		$this->const [$r] [1] = "chaine";			// type
		$this->const [$r] [2] = 'theme3d';		// def value
		$this->const [$r] [3] = '';					// note
		$this->const [$r] [4] = 0;					// visible
		$this->const [$r] [5] = 'allentities';
		
		$r ++;
		$this->const [$r] [0] = "MAIN_MENU_STANDARD_FORCED";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = 'theme3d_menu.php';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 'allentities';
		
		$r ++;
		$this->const [$r] [0] = "MAIN_MENUFRONT_STANDARD_FORCED";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = 'theme3d_menu.php';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 'allentities';
		
		$r ++;
		$this->const [$r] [0] = "MAIN_MENU_SMARTPHONE_FORCED";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = 'theme3d_menu.php';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 'allentities';
		
		$r ++;
		$this->const [$r] [0] = "MAIN_MENUFRONT_SMARTPHONE_FORCED";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = 'theme3d_menu.php';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 'allentities';
		
		$r ++;
		$this->const [$r] [0] = "DOL_VERSION";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = '';
		$this->const [$r] [3] = 'Dolibarr version';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 'allentities';
		
	}



	/**
	 * Function called when module is enabled.
	 * The init function add constants, boxes, permissions and menus
	 * (defined in constructor) into Dolibarr database.
	 * It also creates data directories
	 *
	 * 	@param		string	$options	Options when enabling module ('', 'noboxes')
	 * 	@return		int					1 if OK, 0 if KO
	 */
	public function init($options = '')
	{
		$sql = array();

		$result = $this->loadTables();

		$res = dolibarr_set_const($this->db, "PACKTHEMEACTIVATEDTHEME", "modTheme3d", 'chaine', 0, '', 0);
		
		$arraythems = array("modNextTheme","modLightTheme","modOwnTheme","modMenu3dResponsive","modMyTheme","modBeCreative");
		global $conf;
		foreach ($arraythems as $value) {
			$keymodulelowercase=strtolower(preg_replace('/^mod/','',$value));
			if (in_array($keymodulelowercase, $conf->modules)) 
				$result=unActivateModule($value);
		}

		// on first module activation only
	    $new = dol_buildpath('/theme3d/inst/firstUse');
	    $check = dol_buildpath('/theme/theme3d');

	    
    	$source = dol_buildpath('/theme3d/inst/theme');
		$dest = dol_buildpath('/theme');

		$dcd = dolCopyDir($source, $dest, 0775, 1);


		if($dcd){

			global $conf;

			$theperm = dol_buildpath('/theme/theme3d');
			theme3dpermissionto($theperm);

	    	// update webmail file

			dolibarr_set_const($this->db,'SHOW_MENU_TOP_THEME3D','','chaine',0,'',0);
			dolibarr_set_const($this->db,'HIDE_MENU_VERTICAL_DOLIBARR_THEME3D','','chaine',0,'',0);

			// Theme
			$installed_ver = dolibarr_get_const($this->db,'MAIN_VERSION_LAST_INSTALL',0);
			$upgraded_ver = dolibarr_get_const($this->db,'MAIN_VERSION_LAST_UPGRADE',0);
			if ($upgraded_ver!="") {
				$dol_version = $upgraded_ver;
			} else {
				$dol_version = $installed_ver;
			}
			dolibarr_set_const($this->db,'DOL_VERSION',$dol_version,'chaine',0,'Dolibarr version',0);
			dolibarr_set_const($this->db,'MAIN_THEME','theme3d','chaine',0,'Sets theme3d Theme',0);
			dolibarr_set_const($this->db,'MAIN_MENU_STANDARD','theme3d_menu.php','chaine',0,'',0);
			dolibarr_set_const($this->db,'MAIN_MENUFRONT_STANDARD','theme3d_menu.php','chaine',0,'',0);
			dolibarr_set_const($this->db,'MAIN_MENU_SMARTPHONE','theme3d_menu.php','chaine',0,'',0);
			dolibarr_set_const($this->db,'MAIN_MENUFRONT_SMARTPHONE','theme3d_menu.php','chaine',0,'',0);
			
			if (!dolibarr_get_const($this->db,'THEME3D_FIXED_MENU',0))
				dolibarr_set_const($this->db,'THEME3D_FIXED_MENU',0,'yesno',0,'',0);

			if (!dolibarr_get_const($this->db,'THEME3D_SHOW_VERTICAL_MENU',0))
				dolibarr_set_const($this->db,'THEME3D_SHOW_VERTICAL_MENU',1,'yesno',0,'',0);
			if (!dolibarr_get_const($this->db,'THEME3D_HIDE_ICONS_HORIZENTAL_MENU',0))
				dolibarr_set_const($this->db,'THEME3D_HIDE_ICONS_HORIZENTAL_MENU',0,'yesno',0,'',0);
			if (!dolibarr_get_const($this->db,'THEME3D_HIDE_TEXT_HORIZENTAL_MENU',0))
				dolibarr_set_const($this->db,'THEME3D_HIDE_TEXT_HORIZENTAL_MENU',0,'yesno',0,'',0);

			return $this->_init($sql, $options);
		}
	     

		// replace weather images
		// $source = dol_buildpath('/theme3d/img/weather.new');
		// $dest = dol_buildpath('/theme/theme3d/weather');
		// cpy6($source,$dest);
		
		// copy images from eldy theme
		// $source = dol_buildpath('/theme/eldy/img');
		// $dest = dol_buildpath('/theme/theme3d/img');
		// cpy6($source,$dest);
		return '';
	}

	/**
	 * Function called when module is disabled.
	 * Remove from database constants, boxes and permissions from Dolibarr database.
	 * Data directories are not deleted
	 *
	 * 	@param		string	$options	Options when enabling module ('', 'noboxes')
	 * 	@return		int					1 if OK, 0 if KO
	 */
	public function remove($options = '')
	{
		$sql = array();

		global $conf;
		dolibarr_del_const($this->db,'MAIN_FORCETHEME');
		dolibarr_del_const($this->db,'MAIN_MENU_STANDARD_FORCED');
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_STANDARD_FORCED');
		dolibarr_del_const($this->db,'MAIN_MENU_SMARTPHONE_FORCED');
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_SMARTPHONE_FORCED');
		dolibarr_del_const($this->db,'MAIN_THEME');
		dolibarr_del_const($this->db,'MAIN_MENU_STANDARD');
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_STANDARD');
		dolibarr_del_const($this->db,'MAIN_MENU_SMARTPHONE');
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_SMARTPHONE');
		
		// Local
		dolibarr_del_const($this->db,'MAIN_MODULE_THEME3D_CSS');
		dolibarr_del_const($this->db,'MAIN_MODULE_THEME3D_HOOKS');
		dolibarr_del_const($this->db,'MAIN_MODULE_THEME3D_JS');
		
		// Theme
		dolibarr_set_const($this->db,'MAIN_THEME','eldy','chaine',0,'',0);
		dolibarr_set_const($this->db,'MAIN_MENU_STANDARD','eldy_menu.php','chaine',0,'',0);
		dolibarr_set_const($this->db,'MAIN_MENUFRONT_STANDARD','eldy_menu.php','chaine',0,'',0);
		dolibarr_set_const($this->db,'MAIN_MENU_SMARTPHONE','eldy_menu.php','chaine',0,'',0);
		dolibarr_set_const($this->db,'MAIN_MENUFRONT_SMARTPHONE','eldy_menu.php','chaine',0,'',0);
		dolibarr_del_const($this->db,'MAIN_FORCETHEME',0);
		dolibarr_del_const($this->db,'MAIN_MENU_STANDARD_FORCED',0);
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_STANDARD_FORCED',0);
		dolibarr_del_const($this->db,'MAIN_MENU_SMARTPHONE_FORCED',0);
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_SMARTPHONE_FORCED',0);

		$todlt = dol_buildpath('/theme/theme3d');
		removeDirRecursivelyTheme3D($todlt);

		return $this->_remove($sql, $options);
	}

	/**
	 * Create tables, keys and data required by module
	 * Files llx_table1.sql, llx_table1.key.sql llx_data.sql with create table, create keys
	 * and create data commands must be stored in directory /theme3d/sql/
	 * This function is called by this->init
	 *
	 * 	@return		int		<=0 if KO, >0 if OK
	 */
	private function loadTables()
	{
		return $this->_load_tables('/theme3d/sql/');
	}

}


// copy recursive
function cpy6($source, $dest){
    if(is_dir($source)) {
        $dir_handle=opendir($source);
        while($file=readdir($dir_handle)){
            if($file!="." && $file!=".."){
                if(is_dir($source."/".$file)){
                    if(!is_dir($dest."/".$file)){
                        mkdir($dest."/".$file);
                    }
                    cpy6($source."/".$file, $dest."/".$file);
                } else {
                    copy($source."/".$file, $dest."/".$file);
                }
            }
        }
        closedir($dir_handle);
    } else {
        copy($source, $dest);
    }
}



//ADEDDCODE
function removeDirRecursivelyTheme3D($dir){
	$count = 0;
	if (dol_is_dir($dir))
	{
		$dir_osencoded=dol_osencode($dir);
		if ($handle = opendir("$dir_osencoded"))
		{
			while (false !== ($item = readdir($handle)))
			{
				if (! utf8_check($item)) $item=utf8_encode($item);  // should be useless

				if ($item != "." && $item != "..")
				{
					if (is_dir(dol_osencode("$dir/$item")) && ! is_link(dol_osencode("$dir/$item")))
					{
						$count=removeDirRecursivelyTheme3D("$dir/$item");
					}
					else
					{
						@chmod("$dir/$item", octdec(777));
						$result=dol_delete_file("$dir/$item",0,1);
					}
				}
			}
			
			closedir($handle);

			$result=dol_delete_dir($dir, $nophperrors);
		}
	}
}

function theme3dpermissionto($source){
    if(is_dir($source)) {
    	@chmod($source, 0775);
        $dir_handle=opendir($source);
        while($file=readdir($dir_handle)){
            if($file!="." && $file!=".."){
                if(is_dir($source."/".$file)){
                    @chmod($source."/".$file, 0775);
                    theme3dpermissionto($source."/".$file);
                } else {
                    @chmod($source."/".$file, 0664);
                }
            }
        }
        closedir($dir_handle);
    } else {
        @chmod($source, 0664);
    }
}