<?php 
require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/geturl.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 
require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';

class Projetmap extends CommonObject{ 

	public $errors = array();

	
	/**
     *  Constructor
     *
     *  @param      DoliDB      $db      Database handler
     */
    public function __construct($db)
    {
		$this->db = $db;
    }
	



    public function pays_projets(){
        global $langs;

        $langs->loadLangs(array('companies'));

        $this->db->begin();
    	$projects = new Project($this->db);
		$extrafields = new ExtraFields($this->db);
		$data_pays = [];
    	$sql = 'SELECT * FROM '. MAIN_DB_PREFIX.'projet';
    	$resql = $this->db->query($sql);
    	// $select = '<span><b>'.$langs->trans("Country").' : </b></span>';
        $select = '<span>'.$langs->trans("Country").' : </span>';
        if($resql){
        	$select .= '<select id="select_pays" name="pays">';
        	$select .= '<option></option>';
        	while ( $projet = $this->db->fetch_object($resql) ) {
    	        $extralabels = $extrafields->fetch_name_optionals_label('projet', true);
    	        $projects->fetch_optionals($projet->rowid, $extralabels);
        		// print_r($projects->array_options['options_map_pays']);
    	        $proj_attr = $projects->array_options;
    	        $fk_pays = $proj_attr['options_map_pays'];
    	        // print_r($proj_attr);
    	        if(!array_key_exists($fk_pays,$data_pays)){
    		        $data_pays[$fk_pays] = $fk_pays;
    	        }
        	}

            $i = 0;
        	foreach ($data_pays as $key => $value) {
                if(!empty($key)){
            		$sql = 'select * from '.MAIN_DB_PREFIX.'c_country where rowid = '.$key;
            		$resql = $this->db->query($sql);
            		$country = $this->db->fetch_object($resql);
                    $slctd = '';
                    if($i == 0) $slctd = 'selected';
            		$select .= '<option value="'.$key.'" '.$slctd.'>'.$country->label.'</option>';
                }
                $i++;
        	}
        	$select .= '</select>';
        }
    	return $select;
    }

    public function villes_projets($id_pays = 0){

        global $langs;

        $langs->loadLangs(array('companies'));

    	$projects = new Project($this->db);
		$extrafields = new ExtraFields($this->db);
		$data_villes = [];
    	$sql = 'SELECT * FROM '. MAIN_DB_PREFIX.'projet';
    	$resql = $this->db->query($sql);
    	// $select = '<span><b>'. $langs->trans('State').' : </b></span>';
        $select = '<span>'. $langs->trans('State').' : </span>';
        if($resql){
        	$select .= '<select id="select_city" name="city" onchange="citySelectChanged()">';
        	$select .= '<option></option>';
        	while ( $projet = $this->db->fetch_object($resql) ) {
    	        $extralabels = $extrafields->fetch_name_optionals_label('projet', true);
    	        $projects->fetch_optionals($projet->rowid, $extralabels);
    	        $proj_attr = $projects->array_options;
    	        $ville = $proj_attr['options_fk_departement'];

    	        if(!array_key_exists($ville,$data_villes)){
                    if(!empty($ville)){
                        $data_villes[$ville] = $ville;
                    }
    	        }
        	}
        	$arr = implode(',', $data_villes);
        	if($id_pays){
    	    	$sql = "SELECT d.*, r.nom as region FROM ";
    			$sql .= MAIN_DB_PREFIX ."c_departements as d, ".MAIN_DB_PREFIX."c_regions as r,".MAIN_DB_PREFIX."c_country as c";
    			$sql .= " WHERE d.rowid IN (".$arr.")"; 
    			$sql .= " AND d.fk_region=r.code_region and r.fk_pays=c.rowid";
    			$sql .= " AND d.active = 1 AND r.active = 1 AND c.active = 1";
    			$sql .= " AND c.rowid = ".$id_pays;
    			$sql .= " ORDER BY c.code, d.code_departement";
        	}else{
    	    	$sql = 'SELECT d.* , r.nom FROM '.MAIN_DB_PREFIX.'c_departements d, '.MAIN_DB_PREFIX.'c_regions as r, where rowid IN ('.$arr.') And d.code_region = r.fk_region';
        	}
    		$resql = $this->db->query($sql);
            if($resql){
                $j = 0;
        		while ( $villes = $this->db->fetch_object($resql) ) {
                    $slctd = '';
                    if($j == 0) $slctd = 'selected';
            		$select .= '<option data-region="'.$villes->region.'" value="'.$villes->rowid.'" '.$slctd.'>'.$villes->nom.'</option>';
                    $j++;
        		}
            }
            // $select .= '</select>';
            // $select .= '<script>';
            // $select .= '$(function(){ ';
            // $select .= '$("#select_city").change(function() {';
            // $select .= 'var country =$("#select_pays option:selected").text();';
            // $select .= 'var city =$("#select_city option:selected").text();';
            // $select .= 'var region =$("#select_city option:selected").data("region");';
            // $select .= 'var name_city = city.split(" ");';
            // $select .= 'if( name_city.length == 3){ city = name_city[2]; }';
            // $select .= 'if(name_city.length == 2){ ';
            // $select .= 'var name = name_city[1].split("d\'");';
            // $select .= 'city = name[1];';
            // $select .= '}';
            // $select .= 'var label = country+", "+region+", "+city;';
            // // $select .= 'console.log(label);';
            // $select .= 'L.esri.Geocoding.geocode().text(label).run(function (err, results, response) {';
            // $select .= 'if(results.results[0] !== undefined){';
            // $select .= 'var lat = results.results[0].latlng.lat;';
            // $select .= 'var lng = results.results[0].latlng.lng;';
            // $select .= 'mymap.setView([lat, lng], 13);';
            // $select .= '}';

            // $select .= '});';

            // $select .= '}); ';
            // $select .= '$("#select_city").select2();';
            // $select .= '$("#select_city").trigger("change")';
            // $select .= '});</script>';
        }
    	return $select;

    }
    

    public function get_data(){
        global $langs;
        $data_pays = [];
        $data_city = [];

        $returns = [];
        $firstdata = [];

        $firstdata['firstlat'] = '23.8237964';
        $firstdata['firstlan'] = '-3.0224281';
        $firstdata['firstzoom'] = '3';
                    
        $projects = new Project($this->db);
        $project2 = new Project($this->db);
        $societe = new Societe($this->db);
        $projets = "SELECT * FROM " . MAIN_DB_PREFIX . "projet";
        $rsql_proj = $this->db->query($projets);

        $i = 0;
        while ($projet = $this->db->fetch_object($rsql_proj)) {
            $extrafields = new ExtraFields($this->db);

            $societe->fetch($projet->fk_soc);

            $currentlatlan  = '';
            $currentlat     = '';
            $currentlan     = '';
            
            $extralabels = $extrafields->fetch_name_optionals_label('projet', true);
            $projects->fetch_optionals($projet->rowid, $extralabels);
            $proj_attr = $projects->array_options;
            $projetmaplatlng = $proj_attr['options_projetmaplatlng'];


            if(!empty($projetmaplatlng)){
                $currentlatlan = $projects->array_options['options_projetmaplatlng'];
                $vararr = explode(',', $currentlatlan);
                $currentlat = $vararr[0];
                $currentlan = $vararr[1];
                $returns[$projet->rowid]['lat'] = $currentlat;
                $returns[$projet->rowid]['lan'] = $currentlan;

                if($i == 0){
                    $firstdata['firstlat'] = $currentlat;
                    $firstdata['firstlan'] = $currentlan;
                    $firstdata['firstzoom'] = '13';
                    // print_r($firstdata);
                }
                $i++;
            }
            
            // $proj_attr = $projects->array_options;

            // $fk_pays = $proj_attr['options_map_pays'];
            // $ville = $proj_attr['options_fk_departement'];
            // $region = $proj_attr['options_fk_region'];
            // $adress = $proj_attr['options_adress'];


            // if(!empty($ville)){
            //     $sql = 'SELECT * FROM '.MAIN_DB_PREFIX.'c_departements WHERE rowid = '.$ville;
            //     $rsql = $this->db->query($sql);
            //     $deprt = $this->db->fetch_object($rsql);
            //     $d = explode(' ', $deprt->nom);
            //     if(count($d) > 1){
            //         if(count($d) == 2){
            //             $nv = explode("d'", $d[1])[1];
            //         }else
            //             $nv = $d[2];
            //     }else{
            //         $nv = $d[0];
            //     }

            //     $data_pays[$projet->rowid]['ville'] = $nv;
            //     if(!array_key_exists($nv, $data_city)){
            //         $data_city[$nv] = 1 ;
            //     }else{
            //         $data_city[$nv] += 1  ;
            //     }

            // }
            // if(!empty($fk_pays)){
            //     $sql_cntry = "SELECT * FROM ".MAIN_DB_PREFIX."c_country WHERE rowid = ".$fk_pays;
            //     $rsql = $this->db->query($sql_cntry);
            //     $pays = $this->db->fetch_object($rsql);
            //     $data_pays[$projet->rowid]['pays'] = $pays->label;
            //     $data_pays[$projet->rowid]['codelang'] = $pays->code_iso;
            // }

            // if(!empty($region)){
            //     $sql_regn = "SELECT * FROM ".MAIN_DB_PREFIX."c_regions WHERE code_region = ".$region;
            //     $rsql = $this->db->query($sql_regn);
            //     $regions = $this->db->fetch_object($rsql);
            //     $data_pays[$projet->rowid]['region'] = $regions->nom;
            // }

            // if(!empty($fk_pays)){
            //     $data_pays[$projet->rowid]['adress'] = $adress;
            // }

            // $projectlink = $projet->ref.'/'.addslashes($projet->title);
            $projectlink = '';
            $project2->fetch($projet->rowid);
            $projectlink = addslashes($project2->getNomUrl(1,'', 1, '', ' - ', 1));

            $returns[$projet->rowid]['title'] = $projectlink.'<b> <br>'.$langs->trans("de").': </b>'.addslashes($societe->nom).'<b> <br>'.$langs->trans("DateCreation").': </b>'.date('d/m/Y',strtotime($projet->datec));
        }

        $data = ['alldata'=> $returns, 'firstdata' => $firstdata];
        return $data;
    }


    // add maps in projetcard
    public function map_projet($id=0, $object){

        global $langs;

		$extrafields  = new ExtraFields($this->db);
        $societe = new Societe($this->db);
		$projects     = new Project($this->db);
        $project2 = new Project($this->db);

        $extralabels  = $extrafields->fetch_name_optionals_label('projet', true);
        $projects->fetch_optionals($id, $extralabels);

        $proj_attr = $projects->array_options;
        $currentlatlan = $object->array_options['options_projetmaplatlng'];

        // $fk_pays = $proj_attr['options_map_pays'];
        // $ville = $proj_attr['options_fk_departement'];
        // $region = $proj_attr['options_fk_region'];
        // $adress = $proj_attr['options_adress'];


        // if(!empty($ville)){
        //     $sql = 'SELECT * FROM '.MAIN_DB_PREFIX.'c_departements WHERE rowid = '.$ville;
        //     $rsql = $this->db->query($sql);
        //     if($rsql){
        //         $deprt = $this->db->fetch_object($rsql);
        //         $d = explode(' ', $deprt->nom);
        //         if(count($d) > 1){
        //             if(count($d) == 2){
        //                 $nv = explode("d'", $d[1])[1];
        //             }else
        //                 $nv = $d[2];
        //         }else{
        //             $nv = $d[0];
        //         }
        //         $city = $nv;
        //     }
            
        // }
        // if(!empty($fk_pays)){
        //     $sql_cntry = "SELECT * FROM ".MAIN_DB_PREFIX."c_country WHERE rowid = ".$fk_pays;
        //     $rsql = $this->db->query($sql_cntry);
        //     if($rsql){
        //         $pays = $this->db->fetch_object($rsql);
        //         $pay = $pays->label;
        //     }
        // }

        // if(!empty($region)){
        //     $sql_regn = "SELECT * FROM ".MAIN_DB_PREFIX."c_regions WHERE code_region = ".$region;
        //     $rsql = $this->db->query($sql_regn);
        //     if($rsql){
        //         $regions = $this->db->fetch_object($rsql);
        //         $region = $regions->nom;
        //     }
        // }


		print '<link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />';
		print '<script src="https://unpkg.com/leaflet/dist/leaflet-src.js"></script>';

		print '<script src="https://unpkg.com/esri-leaflet"></script>';

	    print '<link rel="stylesheet" href="https://unpkg.com/esri-leaflet-geocoder/dist/esri-leaflet-geocoder.css">';
	    print '<script src="https://unpkg.com/esri-leaflet-geocoder"></script>';

	    print '<script src="https://cdn.jsdelivr.net/npm/leaflet.locatecontrol@0.67.0/src/L.Control.Locate.min.js"></script>';
	    print '<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/leaflet.locatecontrol@0.67.0/dist/L.Control.Locate.css.map">';
	    print '<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/leaflet.locatecontrol@0.67.0/dist/L.Control.Locate.css">';

		$html = '<div class=\'div-table-responsive-no-min\'>';
		$html .= '<table class=\'liste formdoc noborder centpercent\'><tbody><tr class=\'liste_titre\'><th>Projet sur map</th></tr>';
		$html .= '<td>';
	    	$html .= '<div id=\'projetmapid\'></div>';
		$html .= '</td>';
		$html .= '</tr>';
		$html .= '</table></div>';

        $currentlatlan  = '';
        $currentlat     = '';
        $currentlan     = '';

        $idpro = GETPOST('id');
        if($object && $idpro > 0){
            $extralabels = $extrafields->fetch_name_optionals_label('projet', true);
            $projects->fetch_optionals($idpro, $extralabels);
            $proj_attr = $projects->array_options;
            $projetmaplatlng = $proj_attr['options_projetmaplatlng'];


            if(!empty($projetmaplatlng)){
                $currentlatlan = $object->array_options['options_projetmaplatlng'];
                $vararr = explode(',', $currentlatlan);
                $currentlat = $vararr[0];
                $currentlan = $vararr[1];
            }
        }

		print '<script> $(function(){';
			print '$("#builddoc_form").parent().append("'.$html.'");';
			// print 'var mymap = L.map(\'projetmapid\').setView([31.7134782, -15.483975555555554], 13);';
            if($currentlatlan != ''){
                print "var mymap = L.map('projetmapid').setView([".$currentlat.",".$currentlan."], 14);";
            }else{
                print "var mymap = L.map('projetmapid').setView([23.8237964, -3.0224281], 3);";
            }
			print 'L.tileLayer(\'https://api.tiles.mapbox.com/v4/{id}/{z}/{x}/{y}.png?access_token=pk.eyJ1IjoiaW1hbmVlbCIsImEiOiJjazFrajQ0NjEwYnRrM21wbms1dHhzemJtIn0.cki9ML4ZeiDedt6Wx7912Q\', {';
				print 'id: \'mapbox.streets\',';
				print 'accessToken: \'pk.eyJ1IjoiaW1hbmVlbCIsImEiOiJjazFrajQ0NjEwYnRrM21wbms1dHhzemJtIn0.cki9ML4ZeiDedt6Wx7912Q\'';
			print '}).addTo(mymap);';
		    print ' L.esri.basemapLayer(\'Streets\').addTo(mymap);';

            if($currentlatlan != ''){
                print 'var marker = L.marker(['.$currentlat.','.$currentlan.']).addTo(mymap);';
                print 'mymap.addLayer(marker);';
                // print 'marker.bindPopup(\'<b> \'+results.results[0].text+\'</b>\').openPopup();';

                $societe->fetch($object->socid);
                $datec = dol_print_date($object->datec, 'day');

                $projectlink = '';
                $project2->fetch($id);
                $projectlink = addslashes($project2->getNomUrl(1,'', 1, '', ' - ', 1));

                $poptext = $projectlink.'<b> <br>'.$langs->trans("de").': </b>'.addslashes($societe->nom).'<b> <br>'.$langs->trans("DateCreation").': </b>'.$datec;


                print 'marker.bindPopup("'.$poptext.'").openPopup();';
            }

            // if($adress || $city || $region){
            // 	print ' L.esri.Geocoding.geocode().address("'.$adress.'").city("'.$city.'").region("'.$region.'").run(function (err, results, response) {';
            //         // print 'console.log(results.results);';
            //         print 'if(results.results[0] !== undefined){';
            //             print '$lat = results.results[0].latlng.lat.toFixed(5);';
            //             print '$lng = results.results[0].latlng.lng.toFixed(5);';
            //             print 'mymap.setView([$lat, $lng], 12);';
            //             print 'var marker = L.marker([$lat,$lng]).addTo(mymap);';
            //             print 'marker.bindPopup(\'<b> \'+results.results[0].text+\'</b>\').openPopup();';
            //         print '}';
            // 	print '})';
            // }
		print '})</script>';
    }

	
    
} 

class projetmapcls extends Commonobject{ 
    
    public function __construct($db){ 
        $this->db = $db;
        return 1;
    }

    public function fetch()
    {
        global $conf, $mysoc, $user, $langs;
        $langs->load('projetmap@projetmap');

        dol_include_once('/projetmap/core/modules/modprojetmap.class.php');
        $modulrecrut = new modprojetmap($this->db);

        $nummodul = $modulrecrut->numero;
        $editeurmodul = 'nextgestion.com';

        if (!dolibarr_get_const($this->db,'EDITOR_MODULE_projetmap',0))
            dolibarr_set_const($this->db,'EDITOR_MODULE_projetmap','https://www.'.$editeurmodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'ID_MODULE_projetmap',0))
            dolibarr_set_const($this->db,'ID_MODULE_projetmap',$nummodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'DATE_MODULE_projetmap',0))
            dolibarr_set_const($this->db,'DATE_MODULE_projetmap',date('Y-m-d'),'chaine',0,'',0);


        $id_modul      = dolibarr_get_const($this->db,'ID_MODULE_projetmap',0);
        $date_modul    = dolibarr_get_const($this->db,'DATE_MODULE_projetmap',0);
        $editor_modul  = dolibarr_get_const($this->db,'EDITOR_MODULE_projetmap',0);

        $link = urlencode(dol_buildpath('/',2));

        if(!empty($date_modul) && $date_modul <= date('Y-m-d') && !empty($editor_modul) && !empty($id_modul) && !empty($link)){

            $id_modul = urlencode($id_modul);

            $url = $editor_modul."/suivimod/module/registeruse?mod=".$id_modul."&link=".$link;
            $urldata = getURLContent($url);
            $response = json_decode($urldata['content']);

            if($response && $response->actif == 0){
                dolibarr_set_const($this->db,'ID_MODULE_projetmap', 1, 'chaine',0,'',0);
                unActivateModule("modprojetmap");
            }elseif($response && $response->actif == 1){
                dolibarr_set_const($this->db,'DATE_MODULE_projetmap', date("Y-m-d", time() + 86400), 'chaine',0,'',0);
            }else{
                dolibarr_set_const($this->db,'DATE_MODULE_projetmap', date("Y-m-d"), 'chaine',0,'',0);
            }
        }
        return 1;
    } 
}
?>