<?php
/* Copyright (C) 2016      Garcia MICHEL <garcia@soamichel.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';
dol_include_once('/projetmap/class/projetmap.class.php');

class Actionsprojetmap{
	protected $db;
	/**
	 * @var array Hook results. Propagated to $hookmanager->resArray for later reuse
	 */
	public $results = array();


	/**
	 * @var string String displayed by executeHook() immediately after return
	 */
	public $resprints;

	/**
	 * @var array Errors
	 */
	public $errors = array();
	function Actionsprojetmap($db){
		$this->db = $db;
	}

	function doActions($parameters, &$object, &$action, $hookmanager){
		global $langs, $user, $confirm;
	}


	/**
	 * Overloading the interface function : replacing the parent's function with the one below
	 *
	 * @param   array()         $parameters     Hook metadatas (context, etc...)
	 * @param   CommonObject    &$object        The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
	 * @param   string          &$action        Current action (if set). Generally create or edit or null
	 * @param   HookManager     $hookmanager    Hook manager propagated to allow calling another hook
	 * @return  int                             < 0 on error, 0 on success, 1 to replace standard code
	 */
	public function doActionInterface($parameters, &$object, &$action, $hookmanager)
	{
	    $error = 0; // Error counter
	    global $langs, $db, $conf, $user;
	    
	    
	}


	public function formObjectOptions($parameters, &$object, &$action, $hookmanager)
	{
	    global $conf, $user, $langs, $db;
	    $projetmap = new Projetmap($db);
	    $error = 0; // Error counter
       	$context = explode(':', $parameters['context']);
		if(is_array($context) && (in_array('projectcard', $context) || in_array('projectlist', $context))){
			
		}


		if(is_array($context) && in_array('projectcard', $context) ){

		    $id = GETPOST('id');
		    $action = GETPOST('action');
		    
		    require_once dol_buildpath('/projetmap/js/projetmap.js.php');

		    if(!empty($id) && $action != 'edit' && $action != 'add'){
				print '<style>';
					print '#id-left .blockvmenulast .li_testmap .menu_end{height:110px; background-image:url('.dol_buildpath('/projetmap/img/carte.png',2).');background-repeat: no-repeat;}';
					print '#projetmapid {height: 250px;}';
				print '</style>';
			    print $projetmap->map_projet($id, $object);
		    }else{
		    	$this->scriptToDrawMapProject($parameters, $object, $action, $hookmanager);
		    }
		}
	}


	public function scriptToDrawMapProject($parameters, $object, $action, $hookmanager){
		global $conf,$langs;

		$langs->load('projetmap@projetmap');
		
			
		require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
		require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
		require_once DOL_DOCUMENT_ROOT.'/societe/class/societe.class.php';
		dol_include_once('/projetmap/class/projetmap.class.php');

	

		print '<link rel="stylesheet" href="https://unpkg.com/leaflet@1.5.1/dist/leaflet.css" integrity="sha512-xwE/Az9zrjBIphAcBb3F6JVqxf46+CDLwfLMHloNu6KEQCAWi6HcDUbeOfBIptF7tcCzusKFjFw2yuvEpDL9wQ==" crossorigin=""/>';

		print '<script src="https://unpkg.com/leaflet@1.5.1/dist/leaflet.js" integrity="sha512-GffPMF3RvMeYyc1LWMHtK8EbPv0iNZ8/oTtHPx9/cc2ILxQ+u905qIwdpULaqDkyBKgOaB57QTMg7ztg8Jm2Og==" crossorigin=""></script>';

		// <!-- Load Esri Leaflet from CDN -->
		print '<script src="https://unpkg.com/esri-leaflet"></script>';

		print '<link rel="stylesheet" href="https://unpkg.com/esri-leaflet-geocoder/dist/esri-leaflet-geocoder.css">';
		print '<script src="https://unpkg.com/esri-leaflet-geocoder"></script>';

		print '<script src="https://cdn.jsdelivr.net/npm/leaflet.locatecontrol@0.67.0/src/L.Control.Locate.min.js"></script>';
		print '<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/leaflet.locatecontrol@0.67.0/dist/L.Control.Locate.css.map">';
		print '<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/leaflet.locatecontrol@0.67.0/dist/L.Control.Locate.css">';


		$projects 		= new Project($this->db);
		$projetmap 		= new Projetmap($this->db);
		$societe 		= new Societe($this->db);
		$extrafields 	= new ExtraFields($this->db);

		$currentlatlan 	= '';
		$currentlat 	= '';
		$currentlan 	= '';

		$idpro = GETPOST('id');
		if($object && $idpro > 0){
			$extralabels = $extrafields->fetch_name_optionals_label('projet', true);
			$projects->fetch_optionals($idpro, $extralabels);
			$proj_attr = $projects->array_options;
			$projetmaplatlng = $proj_attr['options_projetmaplatlng'];


			if(!empty($projetmaplatlng)){
				$currentlatlan = $object->array_options['options_projetmaplatlng'];
				$vararr = explode(',', $currentlatlan);
				$currentlat = $vararr[0];
				$currentlan = $vararr[1];
			}
		}

		// $currcountry = $conf->global->MAIN_INFO_SOCIETE_COUNTRY;

		?>
		<script type="text/javascript">
			
		
		$(document).ready(function(){

			if($('#projetmapinproject').length > 0){


				$('#options_projetmaplatlng').prop('readonly', true);
				// var currcountry 	= '<?php echo $currcountry; ?>';

				var currentlatlan 	= '<?php echo $currentlatlan; ?>';
				var currentlat 		= '<?php echo $currentlat; ?>';
				var currentlan 		= '<?php echo $currentlan; ?>';

				// var mymap = L.map('projetmapinproject').setView([31.7134782, -15.483975555555554], 6);
				if(currentlatlan !== ''){
					var mymap = L.map('projetmapinproject').setView([currentlat, currentlan], 13);
				}else{
					// var mymap = L.map('projetmapinproject').setView([31.7134782, -15.483975555555554], 6);
					var mymap = L.map('projetmapinproject').setView([23.8237964, -3.0224281], 3);
				}

				L.tileLayer('https://api.tiles.mapbox.com/v4/{id}/{z}/{x}/{y}.png?access_token=pk.eyJ1IjoiaW1hbmVlbCIsImEiOiJjazFrajQ0NjEwYnRrM21wbms1dHhzemJtIn0.cki9ML4ZeiDedt6Wx7912Q', {
				    attribution: 'Map data &copy; <a href="https://www.openstreetmap.org/">OpenStreetMap</a> contributors, <a href="https://creativecommons.org/licenses/by-sa/2.0/">CC-BY-SA</a>, Imagery © <a href="https://www.mapbox.com/">Mapbox</a>',
				    id: 'mapbox.streets',
				    accessToken: 'pk.eyJ1IjoiaW1hbmVlbCIsImEiOiJjazFrajQ0NjEwYnRrM21wbms1dHhzemJtIn0.cki9ML4ZeiDedt6Wx7912Q'
				}).addTo(mymap);

				// // go to  your location
				// mymap.addControl(L.control.locate({
				//     locateOptions: {
				//        maxZoom: 15
				//     },
				//     strings: {
				//         title: "<?php echo $langs->trans('my_position') ?> !"
				//     }
				// }));

			    // $('#locate-position').on('click', function(){
			    //     navigator.geolocation.getCurrentPosition(function(position){
			    //         var latitude = position.coords.latitude;
			    //         var longitude = position.coords.longitude;
			    //         mymap.setView([latitude, longitude], 15);
			    //         var marker = L.marker([latitude,longitude]).addTo(mymap);
			    //         marker.bindPopup('<b> Ma position </b>');
			    //         // =======
			    //     });
			    // });
				// create the geocoding control and add it to the map
				// var searchControl = L.esri.Geocoding.geosearch().addTo(mymap);

				// create an empty layer group to store the results and add it to the mymap
				var results = L.layerGroup().addTo(mymap);
				L.esri.basemapLayer('Streets').addTo(mymap);
				// // listen for the results event and add every result to the map
				// searchControl.on("results", function(data) {
				//     // console.log(results);
				//     results.clearLayers();
				//     for (var i = data.results.length - 1; i >= 0; i--) {
				//         results.addLayer(L.marker(data.results[i].latlng));
				//     }
				// });

				var markers = new Array();

				// zoomp on click map
				mymap.on('click', function(e) {
					var latetlng = e.latlng.lat+', '+e.latlng.lng;
				    $('#options_projetmaplatlng').val(latetlng);
				  	
				  	if(markers.length > 0){
				  		markerDelAll(mymap, markers);
				  	}

				    var marker = L.marker([e.latlng.lat,e.latlng.lng]).addTo(mymap);
				    markers.push(marker);
				    mymap.addLayer(marker);

				});

					
				if(currentlatlan !== ''){
			  	
					var marker = L.marker([currentlat,currentlan]).addTo(mymap);
				    markers.push(marker);
				    mymap.addLayer(marker);
						
			  	}
			  	
				$('.leaflet-container').css('cursor','crosshair');


				
				$("#options_fk_departement").change(function() {
				    var pays = $("#options_map_pays option:selected").text();
				    var region = $("#options_fk_region option:selected").text();
				    var departement = $("#options_fk_departement option:selected").text();

				    // var label = pays+', '+region+', '+departement;
				    var label = departement+', '+pays;
				    

				    L.esri.Geocoding.geocode().text(label).run(function (err, results, response) {
				        if(results.results[0] !== undefined){
				            var lat = results.results[0].latlng.lat;
				            var lng = results.results[0].latlng.lng;
				            mymap.setView([lat, lng], 12);
				        }

				    });
				    var id = $(this).val();
				    // $.ajax({
				    //     data:{'id_pays':id,},
				    //     url: '<?php echo dol_buildpath("/projetmap/get_departement.php?data=get_villes",2)?>',
				    //     type:'POST',
				    //     success:function(data){
				    //         $('.city').html(data);
				    //     }
				    // });
				});

			    $("#options_map_pays").change(function() {
				    var label = $("#options_map_pays option:selected").text();
				    L.esri.Geocoding.geocode().text(label).run(function (err, results, response) {
				        if(results.results[0] !== undefined){
				            var lat = results.results[0].latlng.lat;
				            var lng = results.results[0].latlng.lng;
				            mymap.setView([lat, lng], 6);
				        }

				    });
			    });

			    // $("#options_fk_region").change(function() {
				   //  var pays = $("#options_map_pays option:selected").text();
				   //  var region = $("#options_fk_region option:selected").text();
				   //  L.esri.Geocoding.geocode().text(pays+', '+region).run(function (err, results, response) {
				   //      if(results.results[0] !== undefined){
				   //          var lat = results.results[0].latlng.lat;
				   //          var lng = results.results[0].latlng.lng;
				   //          mymap.setView([lat, lng], 10);
				   //      }

				   //  });
			    // });
			}
		});

		function markerDelAll(mymap, markers) {
			for(i=0;i<markers.length;i++) {
		    	mymap.removeLayer(markers[i]);
		    }  
		}

		</script>
		<style type="text/css">
			#projetmapinproject {height: 600px;z-index: 200;}
			input#options_projetmaplatlng{
			    background-color: #eaeaea;
			    cursor: not-allowed;
			}
		</style>
		<?php
	
		return 1;
	}
	
}
