<?php 
require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/geturl.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 
require_once DOL_DOCUMENT_ROOT . '/projet/class/project.class.php'; 
require_once DOL_DOCUMENT_ROOT . '/projet/class/task.class.php'; 
 
class presences extends CommonObject{ 

	public $errors = array();
	public $rowid;
	

	public $element='presences';
	public $table_element='presences';


	public function __construct($db){ 
		$this->db = $db;
		return 1;
    }


	public function create($echo_sql=0,$insert)
	{

		$sql  = "INSERT INTO " . MAIN_DB_PREFIX .get_class($this)." ( ";

		foreach ($insert as $column => $value) {
			$alias = (is_numeric($value)) ? "" : "'";
			$sql_column .= " , `".$column."`";
			$sql_value .= " , ".$alias.$value.$alias;
		}

		$sql .= substr($sql_column, 2)." ) VALUES ( ".substr($sql_value, 2)." )";
		$resql = $this->db->query($sql);
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			return 0;
		} 
		return $this->db->db->insert_id;
	}

	public function update($id, array $data,$echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

        $sql = "UPDATE " . MAIN_DB_PREFIX .get_class($this). " SET ";

        if (count($data) && is_array($data))
            foreach ($data as $key => $val) {
                $val = is_numeric($val) ? $val : "'". $val ."'";
                $sql .= "`". $key. "` = ". $val .",";
            }

        $sql  = substr($sql, 0, -1);
        $sql .= " WHERE rowid = " . $id;
        $resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '. $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function delete($echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .get_class($this).' WHERE rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '.$this->db->lasterror();
			return -1;
		} 

		return 1;
	}

    
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);
		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX .get_class($this);

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
                $line->id    		 =  $obj->rowid;
                $line->rowid         =  $obj->rowid;
				$line->user 		 =  $obj->user;
				$line->projets 	 	 =  $obj->projets;
				$line->taches 	     =  $obj->taches;
				$line->date_entre 	 =  $obj->date_entre;
				$line->date_sorte 	 =  $obj->date_sorte;

				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	public function fetch($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .get_class($this). ' WHERE rowid = ' . $id;
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 			  	  = $this->db->fetch_object($resql);
                $this->id         	  = $obj->rowid;
                $this->rowid      	  = $obj->rowid;
                $this->user 		 =  $obj->user;
				$this->projets 	 	 =  $obj->projets;
				$this->taches 	     =  $obj->taches;
				$this->date_entre 	 =  $obj->date_entre;
				$this->date_sorte 	 =  $obj->date_sorte;
                // ....
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}
	}

	public function select_with_filter($selected=0,$name='suivi_essence',$showempty=1,$val="rowid",$opt="label",$id='',$attr=''){

	    global $conf;

	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'">';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.get_class($this);
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

    function getNomUrl($withpicto=0, $option='', $get_params='', $notooltip=0, $save_lastsearch_value=-1)
    {
        global $langs, $conf, $user;

        if (! empty($conf->dol_no_mouse_hover)) $notooltip=1;   // Force disable tooltips

        $result='';
        $label='';
        $url='';

        // if ($user->rights->propal->lire){}

        $linkclose=dol_buildpath('/presences/card.php?rowid='.$this->rowid);
        if (empty($notooltip))
        {
            $linkclose.= ' title="'.dol_escape_htmltag($label, 1).'"';
            $linkclose.=' class="classfortooltip"';
        }
        $linkstart = "";
        $linkend = "";
        $result = "";
       
    	$ref=$this->rowid;
        if ($ref) {
            $linkstart = '<a href="'.$url.'"';
            $linkstart.=$linkclose.'>';
            $linkend='</a>';

            $result .= $linkstart;
            if ($withpicto) 
                $result.= '<img height="16" src="'.DOL_URL_ROOT.'/presences/img/object_presences.png" >&nbsp;';
            if ($withpicto != 2) $result.= $ref;
        }

        $result .= $linkend;

        return $result;
    }

    public function select_user($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    
	    $objet = "label";
	    $moreforfilter.='<select class="flat" id="'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql= "SELECT * FROM ".MAIN_DB_PREFIX."user";
    	$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			
			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" data-ref="'.$obj->$opt.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->lastname.' '.$obj->firstname.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

    public function projet_user($id_user,$date){

    	// $data_projet =[];
    	$sql = "SELECT ec.rowid, ec.statut as statuslink, ec.element_id as id_projet, ec.fk_socpeople as id, ec.fk_c_type_contact";    
    	// This field contains id of llx_socpeople or id of llx_user
			$sql.=", '-1' as socid, t.statut as statuscontact, t.login, t.photo";
		// if ($source == 'external' || $source == 'thirdparty') $sql.=", t.fk_soc as socid, t.statut as statuscontact";
		$sql.= ", t.civility as civility, t.lastname as lastname, t.firstname, t.email";
		$sql.= ", tc.source, tc.element, tc.code, tc.libelle";
		$sql.= " FROM ".MAIN_DB_PREFIX."c_type_contact tc";
		$sql.= ", ".MAIN_DB_PREFIX."element_contact ec";
		// if ($source == 'internal') 
			$sql.=" LEFT JOIN ".MAIN_DB_PREFIX."user t on ec.fk_socpeople = t.rowid";
		$sql.= " WHERE t.rowid=".$id_user;
		$sql.= " AND ec.fk_c_type_contact=tc.rowid";
		$sql.= " AND tc.element='project'";
		$sql.= " AND tc.source = 'internal'";
		$sql.= " AND tc.active=1";
		$sql.=" ORDER BY t.lastname ASC";

		// echo $sql;
		$resql = $this->db->query($sql);
		if($resql){
			while ($objet = $this->db->fetch_object($resql)) {
				$id_projet = $objet->id_projet;

	    		$project = new Project($this->db);
				$task = new Task($this->db);

				$project->fetch($id_projet);
			 	if($project->date_start){
					$date_s = date('Y-m-d',$project->date_start);
				}
				$date_e = '';
				if($project->date_end){
					$date_e = date('Y-m-d',$project->date_end);
				}

				if(($date >= $date_s && $date <= $date_e) || ($date >= $date_s && !$date_e)){
					$data_projet[$id_projet]['title'] = $project->ref.' '.$project->title;

					$tasksarray=$task->getTasksArray(0, 0, $id_projet);
					// print_r($tasksarray);
					foreach ($tasksarray as $key => $tache) {
						$cnt=$tache->liste_contact(-1, 'internal');
						foreach ($cnt as $key => $value) {
							if($value['id'] == $id_user){
								if($tache->date_start){
									$date_s = date('Y-m-d',$tache->date_start);
								}
								$date_e = '';
								if($tache->date_end){
									$date_e = date('Y-m-d',$tache->date_end);
								}
								if(($date >= $date_s && $date <= $date_e) || ($date >= $date_s && !$date_e)) {
									// $data_projet[$id_projet]['taches'][$tache->id]['title'] = $tache->ref.' '.$tache->label;
									$data_projet[$id_projet]['taches'][$tache->id]['title'] = $tache->ref;
									$data_projet[$id_projet]['taches'][$tache->id]['progression'] = $tache->progress;

								}
								// print_r($date_s.' '.$date_e);
							}
						}
					}
				}
			}
		}
		return $data_projet;
    }

    public function duration_task($id, $id_current=null, $date = null){
    	$sql = "SELECT sum(task_duration) as sum_duration FROM ".MAIN_DB_PREFIX."projet_task_time WHERE fk_task =".$id;
    	if($id_current){
    		$sql .= " AND rowid != ".$id_current;
    	}
    	if($date){
    		$sql .= " AND task_date = '".$date."'";
    	}
    	$resql = $this->db->query($sql);
    	if($resql){
    		if ($this->db->num_rows($resql))
			{
				$obj = $this->db->fetch_object($resql);
				return $obj->sum_duration;
			}
    	}
    }

    public function selectTimezone($zone='')
    {
    	$const_timezone = dolibarr_get_const($this->db,'MAIN_DATE_IN_MEMORY_ARE_GMT_PRESENCES',0);
		$timezone = ($const_timezone ? $const_timezone : 'Europe/Paris');

    	$array = get_tz_array();
   	
    	$data = '<select name="timezone" class="timezone">';
    		foreach ($array as $key => $value) {
    			$gmt = 'GMT';
    			if($key > 0) $gmt .= '+'.$key; elseif($key < 0) $gmt .= $key;
    			
    			$slctd = '';
    			if($timezone == $value) $slctd = 'selected';

    			$date = new DateTime();
				$date->setTimezone(new DateTimeZone($gmt));
				$result = $date->format('d/m/Y H:i:s');

    			$data .= '<option value="'.$value.'" '.$slctd.'>'.$result.' | '.$gmt.' | '.$value.'</option>';
    		}
    	$data .= '</select>';
    	// $data = str_replace('<option value="'.$gmt.'"', '<option value="'.$gmt.'" selected', $data);
    	return $data;
    }

    public function selectWeeks($selectedweek, $year, $month)
	{
		global $langs, $conf;
	    $dates = [];

	    $firstday = isset($conf->global->MAIN_START_WEEK) ? $conf->global->MAIN_START_WEEK : 1;

	 	// $dayendweek = array(
		//     0 => 'Sunday',
		//     1 => 'Monday',
		//     2 => 'Tuesday',
		//     3 => 'Wednesday',
		//     4 => 'Thursday',
		//     5 => 'Friday',
		//     6 => 'Saturday'
		// );
	    $dayendweek = array(
		    0 => 'Saturday',
		    1 => 'Sunday',
		    2 => 'Monday',
		    3 => 'Tuesday',
		    4 => 'Wednesday',
		    5 => 'Thursday',
		    6 => 'Friday',
		);
	    
	    $week = 1;
	    $date = new DateTime($year.'-'.$month.'-1');
	    $days = (int)$date->format('t'); // total number of days in the month

	    $oneDay = new DateInterval('P1D');

	    for ($day = 1; $day <= $days; $day++) {
	        $dates[$langs->trans("Week")." ".$week] []= $date->format('d');

	        $dayOfWeek = $date->format('l');
	        if ($dayOfWeek === $dayendweek[$firstday]) {
	            $week++;
	        }
	        $date->add($oneDay);
	    }

	    $select = '<select name="pweek" class="pweek">';
			$select .= '<option value="0">&nbsp;</option>';
	    foreach ($dates as $numberw => $weeks) {
	    	$slctd = '';
	    	$ft = $weeks[0].'-'.$weeks[count($weeks)-1];

	    	if($selectedweek == $ft)
	    		$slctd = 'selected';

			$select .= '<option value="'.$ft.'" '.$slctd.'>'.$numberw.'</option>';
	    }
		$select .= '</select>';

		// print_r($dates);die;
	    return $select;
	}

}

class presencescls extends Commonobject{ 
    
    public function __construct($db){ 
        $this->db = $db;
        return 1;
    }

    public function fetch()
    {
        global $conf, $mysoc, $user, $langs;
        $langs->load('presences@presences');

		dol_include_once('/presences/core/modules/modpresences.class.php');
        $modulrecrut = new modpresences($this->db);

        $nummodul = $modulrecrut->numero;
        $editeurmodul = 'nextgestion.com';

        if (!dolibarr_get_const($this->db,'EDITOR_MODULE_presences',0))
            dolibarr_set_const($this->db,'EDITOR_MODULE_presences','https://www.'.$editeurmodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'ID_MODULE_presences',0))
            dolibarr_set_const($this->db,'ID_MODULE_presences',$nummodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'DATE_MODULE_presences',0))
            dolibarr_set_const($this->db,'DATE_MODULE_presences',date('Y-m-d'),'chaine',0,'',0);


        $id_modul      = dolibarr_get_const($this->db,'ID_MODULE_presences',0);
        $date_modul    = dolibarr_get_const($this->db,'DATE_MODULE_presences',0);
        $editor_modul  = dolibarr_get_const($this->db,'EDITOR_MODULE_presences',0);

        $link = urlencode(dol_buildpath('/',2));

        if(!empty($date_modul) && $date_modul <= date('Y-m-d') && !empty($editor_modul) && !empty($id_modul) && !empty($link)){

        	$id_modul = urlencode($id_modul);

            $url = $editor_modul."/suivimod/module/registeruse?mod=".$id_modul."&link=".$link;
            $urldata = getURLContent($url);
            $response = json_decode($urldata['content']);

            if($response && $response->actif == 0){
                dolibarr_set_const($this->db,'ID_MODULE_presences', 1, 'chaine',0,'',0);
                unActivateModule("modpresences");
            }elseif($response && $response->actif == 1){
				dolibarr_set_const($this->db,'DATE_MODULE_presences', date("Y-m-d", time() + 86400), 'chaine',0,'',0);
			}else{
				dolibarr_set_const($this->db,'DATE_MODULE_presences', date("Y-m-d"), 'chaine',0,'',0);
			}
        }
        return 1;
    } 
}